/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.collaboration.ui.SimpleEventListener;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ObservableProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GithubGitHelper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\b\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J/\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020)0(H\u0007\u00a2\u0006\u0002\u0010*R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUtil;", "", "()V", "ENTERPRISE_SERVICE_DISPLAY_NAME", "", "GIT_AUTH_PASSWORD_SUBSTITUTE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SERVICE_DISPLAY_NAME", "addCancellationListener", "Ljava/util/concurrent/ScheduledFuture;", "run", "Lkotlin/Function0;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "thread", "Ljava/lang/Thread;", "findGithubRemote", "Lcom/intellij/openapi/util/Pair;", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "findGithubRemoteUrl", "getErrorTextFromException", "e", "", "getGitRepository", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGithubLikeFormattedDescriptionMessage", "Lcom/intellij/openapi/util/Couple;", "commitMessage", "isRepositoryOnGitHub", "", "runInterruptable", "T", "task", "Lcom/intellij/openapi/util/ThrowableComputable;", "Ljava/io/IOException;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "Delegates", "intellij.vcs.github"})
public final class GithubUtil {
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NlsSafe
    @NotNull
    public static final String SERVICE_DISPLAY_NAME = "GitHub";
    @NlsSafe
    @NotNull
    public static final String ENTERPRISE_SERVICE_DISPLAY_NAME = "GitHub Enterprise";
    @NotNull
    public static final String GIT_AUTH_PASSWORD_SUBSTITUTE = "x-oauth-basic";
    @NotNull
    public static final GithubUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final ScheduledFuture<?> addCancellationListener(@NotNull Function0<Unit> run2) {
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        Function0<Unit> function0 = run2;
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, 1000L, 300L, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"JobScheduler.getSchedule\u20260, TimeUnit.MILLISECONDS)");
        return scheduledFuture;
    }

    private final ScheduledFuture<?> addCancellationListener(ProgressIndicator indicator, Thread thread) {
        return GithubUtil.addCancellationListener((Function0<Unit>)((Function0)new Function0<Unit>(indicator, thread){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Thread $thread;

            public final void invoke() {
                if (this.$indicator.isCanceled()) {
                    this.$thread.interrupt();
                }
            }
            {
                this.$indicator = progressIndicator;
                this.$thread = thread;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final <T> T runInterruptable(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, IOException> task2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        ScheduledFuture<?> future2 = null;
        try {
            Thread thread;
            Thread thread2 = thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"thread");
            future2 = INSTANCE.addCancellationListener(indicator, thread2);
            Object object = task2.compute();
            return (T)object;
        }
        finally {
            ScheduledFuture<?> scheduledFuture = future2;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            Thread.interrupted();
        }
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final String getErrorTextFromException(@NotNull Throwable e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof UnknownHostException) {
            object = "Unknown host: " + e.getMessage();
        } else {
            String string = StringUtil.notNullize((String)e.getMessage(), (String)"Unknown error");
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.notNullize(e.message, \"Unknown error\")");
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Couple<String> getGithubLikeFormattedDescriptionMessage(@Nullable String commitMessage) {
        int startIndex$iv$iv;
        CharSequence $this$trim$iv;
        String string;
        block16: {
            block15: {
                string = commitMessage;
                if (string == null) break block15;
                $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) != null) break block16;
            }
            string = "";
        }
        String message = string;
        $this$trim$iv = message;
        if ($this$trim$iv.length() == 0) {
            Couple couple = Couple.of((Object)"", (Object)"");
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"Couple.of(\"\", \"\")");
            return couple;
        }
        int firstLineEnd = StringsKt.indexOf$default((CharSequence)message, (String)"\n", (int)0, (boolean)false, (int)6, null);
        String subject = null;
        String description = null;
        if (firstLineEnd > -1) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String $this$trim$iv2;
            String $i$f$trim2 = message;
            startIndex$iv$iv = 0;
            String string2 = $i$f$trim2.substring(startIndex$iv$iv, firstLineEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $i$f$trim2 = string2;
            int $i$f$trim = 0;
            CharSequence $this$trim$iv$iv = $this$trim$iv2;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            subject = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv + 1)).toString();
            $this$trim$iv2 = message;
            $i$f$trim = firstLineEnd + 1;
            String string3 = $this$trim$iv2.substring($i$f$trim);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            $this$trim$iv2 = string3;
            $i$f$trim = 0;
            $this$trim$iv$iv = $this$trim$iv2;
            $i$f$trim3 = false;
            startIndex$iv$iv2 = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            description = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv + 1)).toString();
        } else {
            subject = message;
            description = "";
        }
        Couple couple = Couple.of((Object)subject, (Object)description);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"Couple.of(subject, description)");
        return couple;
    }

    @JvmStatic
    @Deprecated(message="{@link GithubGitHelper}", replaceWith=@ReplaceWith(imports={"org.jetbrains.plugins.github.util.GithubGitHelper"}, expression="GithubGitHelper.findGitRepository(project, file)"))
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static final GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GithubGitHelper.Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @Deprecated(message="{@link GithubGitHelper}")
    private static final String findGithubRemoteUrl(GitRepository repository) {
        Pair<GitRemote, String> pair = GithubUtil.findGithubRemote(repository);
        if (pair == null) {
            return null;
        }
        Pair<GitRemote, String> remote = pair;
        return (String)remote.getSecond();
    }

    @JvmStatic
    @Deprecated(message="{@link org.jetbrains.plugins.github.api.GithubServerPath}, {@link GithubGitHelper}")
    private static final Pair<GitRemote, String> findGithubRemote(GitRepository repository) {
        GithubAuthenticationManager githubAuthenticationManager = GithubAuthenticationManager.Companion.getInstance();
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
        Object object = githubAuthenticationManager.getSingleOrDefaultAccount(project);
        if (object == null || (object = object.getServer()) == null) {
            return null;
        }
        GithubAccount server = object;
        Pair githubRemote = null;
        Iterator iterator = repository.getRemotes().iterator();
        block0: while (iterator.hasNext()) {
            GitRemote gitRemote;
            GitRemote gitRemote2 = gitRemote = (GitRemote)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)gitRemote2, (String)"gitRemote");
            for (String remoteUrl : gitRemote2.getUrls()) {
                String remoteName;
                if (!((GithubServerPath)((Object)server)).matches(remoteUrl)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)gitRemote.getName(), (String)"gitRemote.name");
                if (Intrinsics.areEqual((Object)"github", (Object)remoteName) || Intrinsics.areEqual((Object)"origin", (Object)remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @JvmStatic
    @Deprecated(message="{@link org.jetbrains.plugins.github.api.GithubServerPath}")
    @ApiStatus.ScheduledForRemoval
    public static final boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    private GithubUtil() {
    }

    static {
        GithubUtil githubUtil;
        INSTANCE = githubUtil = new GithubUtil();
        Logger logger = Logger.getInstance((String)"github");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"github\")");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUtil$Delegates;", "", "()V", "observableField", "Lkotlin/properties/ObservableProperty;", "T", "initialValue", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/collaboration/ui/SimpleEventListener;", "(Ljava/lang/Object;Lcom/intellij/util/EventDispatcher;)Lkotlin/properties/ObservableProperty;", "intellij.vcs.github"})
    public static final class Delegates {
        @NotNull
        public static final Delegates INSTANCE;

        @NotNull
        public final <T> ObservableProperty<T> observableField(T initialValue, @NotNull EventDispatcher<SimpleEventListener> dispatcher) {
            Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
            return new ObservableProperty<T>(dispatcher, initialValue, initialValue){
                final /* synthetic */ EventDispatcher $dispatcher;
                final /* synthetic */ Object $initialValue;

                protected void afterChange(@NotNull KProperty<?> property, T oldValue, T newValue) {
                    Intrinsics.checkNotNullParameter(property, (String)"property");
                    ((SimpleEventListener)this.$dispatcher.getMulticaster()).eventOccurred();
                }
                {
                    this.$dispatcher = $captured_local_variable$0;
                    this.$initialValue = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
        }

        private Delegates() {
        }

        static {
            Delegates delegates;
            INSTANCE = delegates = new Delegates();
        }
    }
}

