/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyqt;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.viewModel.extraction.ToolWindowContentExtractor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.pyqt.QtFileType;
import com.jetbrains.python.PyBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CompileQrcAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompileQrcAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null);
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        String path2 = QtFileType.findQtTool(module, "pyrcc4");
        if (path2 == null) {
            path2 = QtFileType.findQtTool(module, "pyside-rcc");
        }
        if (path2 == null) {
            Messages.showErrorDialog((Project)project, (String)PyBundle.message("qt.cannot.find.pyrcc4.or.pysidercc", new Object[0]), (String)PyBundle.message("qt.compile.qrc.file", new Object[0]));
            return;
        }
        CompileQrcDialog dialog2 = new CompileQrcDialog(project, vFiles);
        dialog2.show();
        if (dialog2.getExitCode() != 0) {
            return;
        }
        GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{path2, "-o", dialog2.getOutputPath()});
        for (VirtualFile vFile : vFiles) {
            cmdLine.addParameter(vFile.getPath());
        }
        try {
            OSProcessHandler process2 = new OSProcessHandler(cmdLine);
            ProcessTerminatedListener.attach((ProcessHandler)process2);
            process2.putUserData(ToolWindowContentExtractor.SYNC_TAB_TO_GUEST, (Object)true);
            new RunContentExecutor(project, (ProcessHandler)process2).withTitle(PyBundle.message("qt.run.tab.title.compile.qrc", new Object[0])).run();
        }
        catch (ExecutionException ex) {
            Messages.showErrorDialog((Project)project, (String)PyBundle.message("qt.run.error", path2, ex.getMessage()), (String)PyBundle.message("qt.compile.qrc.file", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CompileQrcAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompileQrcAction.$$$reportNull$$$0(2);
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        e.getPresentation().setVisible(module != null && CompileQrcAction.filesAreQrc(vFiles));
    }

    private static boolean filesAreQrc(VirtualFile[] vFiles) {
        if (vFiles == null || vFiles.length == 0) {
            return false;
        }
        for (VirtualFile vFile : vFiles) {
            if (FileUtilRt.extensionEquals((String)vFile.getName(), (String)"qrc")) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/pyqt/CompileQrcAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/pyqt/CompileQrcAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CompileQrcDialog
    extends DialogWrapper {
        private JPanel myPanel;
        private TextFieldWithBrowseButton myOutputFileField;

        protected CompileQrcDialog(Project project, VirtualFile[] vFiles) {
            super(project);
            int n = vFiles.length;
            this.$$$setupUI$$$();
            if (n == 1) {
                this.setTitle(PyBundle.message("qt.qrc.compile", vFiles[0].getName()));
            } else {
                this.setTitle(PyBundle.message("qt.qrc.compile.files", vFiles.length));
            }
            this.myOutputFileField.addBrowseFolderListener(PyBundle.message("qt.qrc.compiler.select.output.path", new Object[0]), null, project, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
            this.init();
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        public String getOutputPath() {
            return this.myOutputFileField.getText();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myOutputFileField;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyBundle", CompileQrcDialog.class).getString("form.qt.compile.qrc.output.file"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myOutputFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(400, -1), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

