/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringFormatCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final String DICT_NAME = "dict";
    private static final PatternCondition<PyReferenceExpression> FORMAT_CALL_PATTERN_CONDITION = new PatternCondition<PyReferenceExpression>("isFormatFunction"){

        public boolean accepts(@NotNull PyReferenceExpression expression, ProcessingContext context2) {
            String expressionName;
            if (expression == null) {
                1.$$$reportNull$$$0(0);
            }
            return (expressionName = expression.getName()) != null && expressionName.equals("format");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor$1", "accepts"));
        }
    };
    private static final PatternCondition<PyReferenceExpression> DICT_CALL_PATTERN_CONDITION = new PatternCondition<PyReferenceExpression>("isDictCall"){

        public boolean accepts(@NotNull PyReferenceExpression expression, ProcessingContext context2) {
            String expressionName;
            if (expression == null) {
                2.$$$reportNull$$$0(0);
            }
            return (expressionName = expression.getName()) != null && expressionName.equals(PyStringFormatCompletionContributor.DICT_NAME);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor$2", "accepts"));
        }
    };
    public static final PsiElementPattern.Capture<PyStringLiteralExpression> FORMAT_STRING_CAPTURE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyStringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyReferenceExpression.class).with(FORMAT_CALL_PATTERN_CONDITION))).withSuperParent(2, PyCallExpression.class);
    private static final PsiElementPattern.Capture<PyStringLiteralExpression> PERCENT_STRING_CAPTURE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyStringLiteralExpression.class).beforeLeaf((ElementPattern)PlatformPatterns.psiElement().withText("%"))).withParent(PyBinaryExpression.class);
    @Nullable
    private static final PatternCondition<PyBinaryExpression> PERCENT_BINARY_EXPRESSION_PATTERN = new PatternCondition<PyBinaryExpression>("isBinaryFormatExpression"){

        public boolean accepts(@NotNull PyBinaryExpression expression, ProcessingContext context2) {
            if (expression == null) {
                3.$$$reportNull$$$0(0);
            }
            return expression.isOperator("%");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor$3", "accepts"));
        }
    };
    private static final PsiElementPattern.Capture<PyKeywordArgument> DICT_FUNCTION_KEYWORD_ARGUMENT_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PyKeywordArgument.class).withSuperParent(3, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyBinaryExpression.class).withChild((ElementPattern)PlatformPatterns.psiElement(PyCallExpression.class).withChild((ElementPattern)PlatformPatterns.psiElement(PyReferenceExpression.class).with(DICT_CALL_PATTERN_CONDITION)))).with(PERCENT_BINARY_EXPRESSION_PATTERN));
    private static final PsiElementPattern.Capture<PyReferenceExpression> DICT_FUNCTION_REFERENCE_ARGUMENT_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PyReferenceExpression.class).withSuperParent(3, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyBinaryExpression.class).withChild((ElementPattern)PlatformPatterns.psiElement(PyCallExpression.class).withChild((ElementPattern)PlatformPatterns.psiElement(PyReferenceExpression.class).with(DICT_CALL_PATTERN_CONDITION)))).with(PERCENT_BINARY_EXPRESSION_PATTERN));
    private static final PsiElementPattern.Capture<PyKeywordArgument> FORMAT_FUNCTION_ARGUMENT_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PyKeywordArgument.class).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PyCallExpression.class).withChild((ElementPattern)PlatformPatterns.psiElement(PyReferenceExpression.class).with(FORMAT_CALL_PATTERN_CONDITION)));
    private static final PsiElementPattern.Capture<PyReferenceExpression> FORMAT_FUNCTION_REFERENCE_ARGUMENT_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PyReferenceExpression.class).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PyCallExpression.class).withChild((ElementPattern)PlatformPatterns.psiElement(PyReferenceExpression.class).with(FORMAT_CALL_PATTERN_CONDITION)));
    private static final PsiElementPattern.Capture<PyStringLiteralExpression> DICT_LITERAL_STRING_KEY_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PyStringLiteralExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PyKeyValueExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyDictLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyBinaryExpression.class).with(PERCENT_BINARY_EXPRESSION_PATTERN))), PlatformPatterns.psiElement(PyDictLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyBinaryExpression.class).with(PERCENT_BINARY_EXPRESSION_PATTERN))}));
    private static final PsiElementPattern.Capture<PyStringLiteralExpression> SET_LITERAL_STRING_KEY_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PyStringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PySetLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyBinaryExpression.class).with(PERCENT_BINARY_EXPRESSION_PATTERN)));

    public PyStringFormatCompletionContributor() {
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().inside(PERCENT_STRING_CAPTURE), PlatformPatterns.psiElement().inside(FORMAT_STRING_CAPTURE)}), new StringFormatCompletionProvider());
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().inside(DICT_LITERAL_STRING_KEY_CAPTURE), PlatformPatterns.psiElement().inside(DICT_FUNCTION_KEYWORD_ARGUMENT_CAPTURE), PlatformPatterns.psiElement().inside(DICT_FUNCTION_REFERENCE_ARGUMENT_CAPTURE), PlatformPatterns.psiElement().inside(SET_LITERAL_STRING_KEY_CAPTURE), PlatformPatterns.psiElement().inside(FORMAT_FUNCTION_ARGUMENT_CAPTURE), PlatformPatterns.psiElement().inside(FORMAT_FUNCTION_REFERENCE_ARGUMENT_CAPTURE)}), new StringFormatArgumentsCompletionProvider());
    }

    @NotNull
    private static LookupElement createLookUpElement(@NotNull String element) {
        if (element == null) {
            PyStringFormatCompletionContributor.$$$reportNull$$$0(0);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)element).withTypeText("arg");
        if (lookupElementBuilder == null) {
            PyStringFormatCompletionContributor.$$$reportNull$$$0(1);
        }
        return lookupElementBuilder;
    }

    @NotNull
    private static String getPrefix(int offset, @NotNull PsiFile file) {
        if (file == null) {
            PyStringFormatCompletionContributor.$$$reportNull$$$0(2);
        }
        if (offset > 0) {
            --offset;
        }
        String text2 = file.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset > 0 && Character.isLetterOrDigit(text2.charAt(offset))) {
            prefixBuilder.insert(0, text2.charAt(offset));
            --offset;
        }
        String string = prefixBuilder.toString();
        if (string == null) {
            PyStringFormatCompletionContributor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookUpElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLookUpElement";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringFormatCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private StringFormatCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result) {
            PsiElement original;
            if (parameters == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((original = parameters.getOriginalPosition()) != null) {
                PsiElement parent = original.getParent();
                result = result.withPrefixMatcher(PyStringFormatCompletionContributor.getPrefix(parameters.getOffset(), parent.getContainingFile()));
                if (parent instanceof PyStringLiteralExpression) {
                    result.addAllElements(StringFormatCompletionProvider.addCompletionsForSubstitutions(parameters, original, (PyStringLiteralExpression)parent));
                }
            }
        }

        @NotNull
        private static List<LookupElement> addCompletionsForSubstitutions(@NotNull CompletionParameters parameters, @NotNull PsiElement original, @NotNull PyStringLiteralExpression stringExpression) {
            PyBinaryExpression binExpr;
            int stringOffset;
            if (parameters == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(3);
            }
            if (original == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(4);
            }
            if (stringExpression == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(5);
            }
            if (StringFormatCompletionProvider.isInsideFormatSubstitutionChunk(stringExpression, stringOffset = StringFormatCompletionProvider.getCaretStartOffsetInsideString(parameters, stringExpression))) {
                PyExpression[] arguments = StringFormatCompletionProvider.getFormatFunctionKeyWordArguments(original);
                ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
                for (PyExpression argument : arguments) {
                    if (argument instanceof PyKeywordArgument) {
                        elements.add(StringFormatCompletionProvider.getKeywordArgument((PyKeywordArgument)argument));
                        continue;
                    }
                    if (!(argument instanceof PyStarArgument)) continue;
                    elements.addAll(StringFormatCompletionProvider.getKeysFromStarArgument((PyStarArgument)argument));
                }
                ArrayList<LookupElement> arrayList = elements;
                if (arrayList == null) {
                    StringFormatCompletionProvider.$$$reportNull$$$0(6);
                }
                return arrayList;
            }
            if (StringFormatCompletionProvider.isInsidePercentSubstitutionChunk(stringExpression, stringOffset) && (binExpr = PyUtil.as(PsiTreeUtil.getParentOfType((PsiElement)stringExpression, PyBinaryExpression.class), PyBinaryExpression.class)) != null) {
                PyExpression callee;
                PyExpression rightExpr = PyPsiUtils.flattenParens(binExpr.getRightExpression());
                PyDictLiteralExpression dict = PyUtil.as(rightExpr, PyDictLiteralExpression.class);
                if (dict != null) {
                    return StringFormatCompletionProvider.getElementsFromDict(dict);
                }
                PyCallExpression callExpression = PyUtil.as(rightExpr, PyCallExpression.class);
                if (callExpression != null && (callee = callExpression.getCallee()) != null && callee.getName() != null && callee.getName().equals(PyStringFormatCompletionContributor.DICT_NAME)) {
                    PyExpression[] arguments = callExpression.getArguments();
                    List<LookupElement> list = Arrays.stream(arguments).filter(a -> a instanceof PyKeywordArgument).map(a -> StringFormatCompletionProvider.getKeywordArgument((PyKeywordArgument)a)).filter(e -> e != null).collect(Collectors.toList());
                    if (list == null) {
                        StringFormatCompletionProvider.$$$reportNull$$$0(7);
                    }
                    return list;
                }
            }
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static int getCaretStartOffsetInsideString(@NotNull CompletionParameters parameters, @NotNull PyStringLiteralExpression parent) {
            if (parameters == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(9);
            }
            if (parent == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(10);
            }
            int caretAbsoluteOffset = parameters.getOffset();
            int stringExprStartOffset = parameters.getPosition().getTextRange().getStartOffset();
            int stringValueStartOffset = parent.getStringValueTextRange().getStartOffset();
            return caretAbsoluteOffset - stringExprStartOffset - stringValueStartOffset;
        }

        private static boolean isInsideFormatSubstitutionChunk(@NotNull PyStringLiteralExpression expression, int offset) {
            if (expression == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(11);
            }
            List<PyStringFormatParser.SubstitutionChunk> substitutions = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parseNewStyleFormat(expression.getStringValue()));
            return StringFormatCompletionProvider.isInsideSubstitutionChunk(offset, substitutions);
        }

        private static boolean isInsidePercentSubstitutionChunk(@NotNull PyStringLiteralExpression expression, int offset) {
            if (expression == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(12);
            }
            List<PyStringFormatParser.SubstitutionChunk> substitutions = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(expression.getStringValue()));
            return StringFormatCompletionProvider.isInsideSubstitutionChunk(offset, substitutions);
        }

        private static boolean isInsideSubstitutionChunk(int offset, @NotNull List<PyStringFormatParser.SubstitutionChunk> substitutions) {
            if (substitutions == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(13);
            }
            return substitutions.stream().anyMatch(s -> offset >= s.getStartIndex() && offset <= s.getEndIndex());
        }

        private static PyExpression @NotNull [] getFormatFunctionKeyWordArguments(@NotNull PsiElement original) {
            PsiElement pyReferenceExpression;
            PyArgumentList argumentList;
            if (original == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(14);
            }
            PyExpression[] pyExpressionArray = (argumentList = (PyArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)(pyReferenceExpression = PsiTreeUtil.getParentOfType((PsiElement)original, PyReferenceExpression.class)), PyArgumentList.class)) != null ? argumentList.getArguments() : PyExpression.EMPTY_ARRAY;
            if (pyExpressionArray == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(15);
            }
            return pyExpressionArray;
        }

        @NotNull
        private static List<LookupElement> getKeysFromStarArgument(@NotNull PyStarArgument arg) {
            PyDictLiteralExpression dict;
            if (arg == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(16);
            }
            List<Object> list = (dict = (PyDictLiteralExpression)ObjectUtils.chooseNotNull((Object)((PyDictLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)arg, PyDictLiteralExpression.class)), (Object)StringFormatCompletionProvider.getDictFromReference(arg))) != null ? StringFormatCompletionProvider.getElementsFromDict(dict) : Collections.emptyList();
            if (list == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(17);
            }
            return list;
        }

        @NotNull
        private static List<LookupElement> getElementsFromDict(@NotNull PyDictLiteralExpression dict) {
            if (dict == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(18);
            }
            List<LookupElement> list = Arrays.stream(dict.getElements()).map(e -> PyUtil.as(e.getKey(), PyStringLiteralExpression.class)).filter(k -> k != null).map(k -> PyStringFormatCompletionContributor.createLookUpElement(k.getStringValue())).collect(Collectors.toList());
            if (list == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(19);
            }
            return list;
        }

        @Nullable
        private static PyDictLiteralExpression getDictFromReference(@NotNull PyExpression arg) {
            PsiElement resolveResult;
            PyReferenceExpression referenceExpression;
            if (arg == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(20);
            }
            if ((referenceExpression = (PyReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)arg, PyReferenceExpression.class)) != null && (resolveResult = referenceExpression.getReference().resolve()) instanceof PyTargetExpression) {
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)resolveResult, PyAssignmentStatement.class);
                return (PyDictLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)assignmentStatement, PyDictLiteralExpression.class);
            }
            return null;
        }

        @Nullable
        private static LookupElement getKeywordArgument(@NotNull PyKeywordArgument arg) {
            String keyword;
            if (arg == null) {
                StringFormatCompletionProvider.$$$reportNull$$$0(21);
            }
            return (keyword = arg.getKeyword()) != null ? PyStringFormatCompletionContributor.createLookUpElement(keyword) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 17: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 17: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringExpression";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 17: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor$StringFormatCompletionProvider";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutions";
                    break;
                }
                case 16: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = PyStringFormatCompletionContributor.DICT_NAME;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor$StringFormatCompletionProvider";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addCompletionsForSubstitutions";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatFunctionKeyWordArguments";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeysFromStarArgument";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsFromDict";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletionsForSubstitutions";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 17: 
                case 19: {
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getCaretStartOffsetInsideString";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsideFormatSubstitutionChunk";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsidePercentSubstitutionChunk";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsideSubstitutionChunk";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getFormatFunctionKeyWordArguments";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeysFromStarArgument";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsFromDict";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getDictFromReference";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeywordArgument";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 17: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StringFormatArgumentsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private StringFormatArgumentsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result) {
            PsiElement original;
            if (parameters == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((original = parameters.getOriginalPosition()) != null) {
                result = result.withPrefixMatcher(PyStringFormatCompletionContributor.getPrefix(parameters.getOffset(), parameters.getOriginalFile()));
                PsiElement parent = original.getParent();
                if (parent.getParent() instanceof PyKeyValueExpression || parent instanceof PyStringLiteralExpression) {
                    PyStringLiteralExpression strExpr;
                    PyBinaryExpression binExpr = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PyBinaryExpression.class);
                    if (binExpr != null && (strExpr = PyUtil.as(binExpr.getLeftExpression(), PyStringLiteralExpression.class)) != null) {
                        result.addAllElements(StringFormatArgumentsCompletionProvider.getPercentLookupBuilders(strExpr));
                    }
                } else if (PsiTreeUtil.instanceOf((Object)parent, (Class[])new Class[]{PyKeywordArgument.class, PyReferenceExpression.class})) {
                    result.addAllElements(StringFormatArgumentsCompletionProvider.getElementsFromString((PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)original, PyArgumentList.class)));
                }
            }
        }

        @NotNull
        private static List<LookupElement> getElementsFromString(@Nullable PyArgumentList argumentList) {
            if (argumentList != null) {
                PyStringLiteralExpression stringLiteralExpr;
                PyReferenceExpression refExpr = (PyReferenceExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)argumentList, PyReferenceExpression.class);
                PyStringLiteralExpression strExpr = (PyStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)refExpr, PyStringLiteralExpression.class);
                if (strExpr != null) {
                    return StringFormatArgumentsCompletionProvider.getFormatLookupBuilders(strExpr);
                }
                PyBinaryExpression binExpr = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PyBinaryExpression.class);
                if (binExpr != null && (stringLiteralExpr = PyUtil.as(binExpr.getLeftExpression(), PyStringLiteralExpression.class)) != null) {
                    List<LookupElement> list = StringFormatArgumentsCompletionProvider.getPercentLookupBuilders(stringLiteralExpr);
                    if (list == null) {
                        StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(3);
                    }
                    return list;
                }
            }
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private static List<LookupElement> getFormatLookupBuilders(@NotNull PyStringLiteralExpression expression) {
            if (expression == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(5);
            }
            Map<String, PyStringFormatParser.SubstitutionChunk> chunks = PyStringFormatParser.getKeywordSubstitutions(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parseNewStyleFormat(expression.getText())));
            return StringFormatArgumentsCompletionProvider.getLookupBuilders(chunks);
        }

        private static List<LookupElement> getPercentLookupBuilders(@NotNull PyStringLiteralExpression expression) {
            if (expression == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(6);
            }
            Map<String, PyStringFormatParser.SubstitutionChunk> chunks = PyStringFormatParser.getKeywordSubstitutions(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(expression.getText())));
            return StringFormatArgumentsCompletionProvider.getLookupBuilders(chunks);
        }

        @NotNull
        private static List<LookupElement> getLookupBuilders(@NotNull Map<String, PyStringFormatParser.SubstitutionChunk> chunks) {
            if (chunks == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(7);
            }
            List<LookupElement> list = chunks.keySet().stream().map(x$0 -> PyStringFormatCompletionContributor.createLookUpElement(x$0)).collect(Collectors.toList());
            if (list == null) {
                StringFormatArgumentsCompletionProvider.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor$StringFormatArgumentsCompletionProvider";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyStringFormatCompletionContributor$StringFormatArgumentsCompletionProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsFromString";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupBuilders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFormatLookupBuilders";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPercentLookupBuilders";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupBuilders";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

