/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMapper;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PydevConsoleWithFileRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.EnvironmentController;
import com.jetbrains.python.run.PlainEnvironmentController;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.TargetedPythonPaths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory;", "Lcom/jetbrains/python/console/PythonConsoleRunnerFactory;", "()V", "createConsoleParameters", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "contextModule", "Lcom/intellij/openapi/module/Module;", "createConsoleRunner", "Lcom/jetbrains/python/console/PydevConsoleRunner;", "createConsoleRunnerWithFile", "config", "Lcom/jetbrains/python/run/PythonRunConfiguration;", "Companion", "ConsoleParameters", "ConstantConsoleParameters", "TargetedConsoleParameters", "intellij.python.community.impl"})
public class PydevConsoleRunnerFactory
extends PythonConsoleRunnerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected ConsoleParameters createConsoleParameters(@NotNull Project project, @Nullable Module contextModule) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Pair<Sdk, Module> sdkAndModule = PydevConsoleRunnerUtil.findPythonSdkAndModule(project, contextModule);
        Module module = (Module)sdkAndModule.second;
        Sdk sdk = (Sdk)sdkAndModule.first;
        PyConsoleOptions pyConsoleOptions = PyConsoleOptions.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleOptions, (String)"PyConsoleOptions.getInstance(project)");
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = pyConsoleOptions.getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"PyConsoleOptions.getInst\u2026ct).pythonConsoleSettings");
        PyConsoleOptions.PyConsoleSettings settingsProvider = pyConsoleSettings;
        PyRemotePathMapper pathMapper = PydevConsoleRunnerUtil.getPathMapper(project, sdk, settingsProvider);
        String workingDir = Companion.getWorkingDir(project, module, (PathMapper)pathMapper, settingsProvider);
        Map<String, String> map2 = settingsProvider.getEnvs();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"settingsProvider.envs");
        Map envs = MapsKt.toMutableMap(map2);
        Companion.putIPythonEnvFlag(project, envs);
        if (Registry.is((String)"python.use.targets.api")) {
            Function setupScriptFunction = PydevConsoleRunnerFactory.Companion.createSetupScriptFunction(project, module, workingDir, pathMapper, settingsProvider);
            PyConsoleType pyConsoleType = PyConsoleType.PYTHON;
            Intrinsics.checkNotNullExpressionValue((Object)pyConsoleType, (String)"PyConsoleType.PYTHON");
            return new TargetedConsoleParameters(project, sdk, workingDir, (Map<String, String>)envs, pyConsoleType, settingsProvider, setupScriptFunction);
        }
        String[] setupFragment = Companion.createSetupFragment(module, workingDir, (PathMapper)pathMapper, settingsProvider);
        PyConsoleType pyConsoleType = PyConsoleType.PYTHON;
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleType, (String)"PyConsoleType.PYTHON");
        return new ConstantConsoleParameters(project, sdk, workingDir, (Map<String, String>)envs, pyConsoleType, settingsProvider, setupFragment);
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Module contextModule) {
        PydevConsoleRunner pydevConsoleRunner;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, contextModule);
        if (consoleParameters instanceof ConstantConsoleParameters) {
            String[] stringArray = ((ConstantConsoleParameters)consoleParameters).getSetupFragment();
            pydevConsoleRunner = new PydevConsoleRunnerImpl(project, consoleParameters.getSdk(), consoleParameters.getConsoleType(), consoleParameters.getWorkingDir(), consoleParameters.getEnvs(), consoleParameters.getSettingsProvider(), Arrays.copyOf(stringArray, stringArray.length));
        } else if (consoleParameters instanceof TargetedConsoleParameters) {
            pydevConsoleRunner = new PydevConsoleRunnerImpl(project, consoleParameters.getSdk(), consoleParameters.getConsoleType(), consoleParameters.getConsoleType().getTitle(), consoleParameters.getWorkingDir(), consoleParameters.getEnvs(), consoleParameters.getSettingsProvider(), ((TargetedConsoleParameters)consoleParameters).getSetupScript());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pydevConsoleRunner;
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunnerWithFile(@NotNull Project project, @NotNull PythonRunConfiguration config) {
        PydevConsoleRunner pydevConsoleRunner;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, config.getModule());
        Sdk sdk = config.getSdk() != null ? config.getSdk() : consoleParameters.getSdk();
        String workingDir = config.getWorkingDirectory() != null ? config.getWorkingDirectory() : consoleParameters.getWorkingDir();
        Map consoleEnvs = new LinkedHashMap();
        consoleEnvs.putAll(consoleParameters.getEnvs());
        Map map2 = config.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"config.envs");
        consoleEnvs.putAll(map2);
        ConsoleParameters consoleParameters2 = consoleParameters;
        if (consoleParameters2 instanceof ConstantConsoleParameters) {
            String[] stringArray = ((ConstantConsoleParameters)consoleParameters).getSetupFragment();
            pydevConsoleRunner = new PydevConsoleWithFileRunnerImpl(project, sdk, consoleParameters.getConsoleType(), config.getName(), workingDir, (Map<String, String>)consoleEnvs, consoleParameters.getSettingsProvider(), config, Arrays.copyOf(stringArray, stringArray.length));
        } else if (consoleParameters2 instanceof TargetedConsoleParameters) {
            pydevConsoleRunner = new PydevConsoleWithFileRunnerImpl(project, sdk, consoleParameters.getConsoleType(), config.getName(), workingDir, (Map<String, String>)consoleEnvs, consoleParameters.getSettingsProvider(), config, ((TargetedConsoleParameters)consoleParameters).getSetupScript());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pydevConsoleRunner;
    }

    @JvmStatic
    public static final void putIPythonEnvFlag(@NotNull Project project, @NotNull EnvironmentController environmentController) {
        Companion.putIPythonEnvFlag(project, environmentController);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001BG\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;)V", "getConsoleType", "()Lcom/jetbrains/python/console/PyConsoleType;", "getEnvs", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSettingsProvider", "()Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "getWorkingDir", "()Ljava/lang/String;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConstantConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$TargetedConsoleParameters;", "intellij.python.community.impl"})
    protected static abstract class ConsoleParameters {
        @NotNull
        private final Project project;
        @Nullable
        private final Sdk sdk;
        @Nullable
        private final String workingDir;
        @NotNull
        private final Map<String, String> envs;
        @NotNull
        private final PyConsoleType consoleType;
        @NotNull
        private final PyConsoleOptions.PyConsoleSettings settingsProvider;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Nullable
        public final String getWorkingDir() {
            return this.workingDir;
        }

        @NotNull
        public final Map<String, String> getEnvs() {
            return this.envs;
        }

        @NotNull
        public final PyConsoleType getConsoleType() {
            return this.consoleType;
        }

        @NotNull
        public final PyConsoleOptions.PyConsoleSettings getSettingsProvider() {
            return this.settingsProvider;
        }

        private ConsoleParameters(Project project, Sdk sdk, String workingDir, Map<String, String> envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            this.project = project;
            this.sdk = sdk;
            this.workingDir = workingDir;
            this.envs = envs;
            this.consoleType = consoleType;
            this.settingsProvider = settingsProvider;
        }

        public /* synthetic */ ConsoleParameters(Project project, Sdk sdk, String workingDir, Map envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider, DefaultConstructorMarker $constructor_marker) {
            this(project, sdk, workingDir, envs, consoleType, settingsProvider);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0004\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\u0002\u0010\u0010R\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConstantConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "setupFragment", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;[Ljava/lang/String;)V", "getSetupFragment", "()[Ljava/lang/String;", "[Ljava/lang/String;", "intellij.python.community.impl"})
    protected static final class ConstantConsoleParameters
    extends ConsoleParameters {
        @NotNull
        private final String[] setupFragment;

        @NotNull
        public final String[] getSetupFragment() {
            return this.setupFragment;
        }

        public ConstantConsoleParameters(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull String[] setupFragment) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)consoleType, (String)"consoleType");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Intrinsics.checkNotNullParameter((Object)setupFragment, (String)"setupFragment");
            super(project, sdk, workingDir, envs, consoleType, settingsProvider, null);
            this.setupFragment = setupFragment;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0004\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fj\b\u0012\u0004\u0012\u00020\u0007`\u0011\u00a2\u0006\u0002\u0010\u0012R'\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fj\b\u0012\u0004\u0012\u00020\u0007`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$TargetedConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "setupScript", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;Ljava/util/function/Function;)V", "getSetupScript", "()Ljava/util/function/Function;", "intellij.python.community.impl"})
    protected static final class TargetedConsoleParameters
    extends ConsoleParameters {
        @NotNull
        private final Function<TargetEnvironment, String> setupScript;

        @NotNull
        public final Function<TargetEnvironment, String> getSetupScript() {
            return this.setupScript;
        }

        public TargetedConsoleParameters(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Function<TargetEnvironment, String> setupScript) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)consoleType, (String)"consoleType");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Intrinsics.checkNotNullParameter(setupScript, (String)"setupScript");
            super(project, sdk, workingDir, envs, consoleType, settingsProvider, null);
            this.setupScript = setupScript;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJL\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u000fj\b\u0012\u0004\u0012\u00020\u0005`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$Companion;", "", "()V", "createSetupFragment", "", "", "module", "Lcom/intellij/openapi/module/Module;", "workingDir", "pathMapper", "Lcom/intellij/util/PathMapper;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Lcom/intellij/util/PathMapper;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;)[Ljava/lang/String;", "createSetupScriptFunction", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "getWorkingDir", "putIPythonEnvFlag", "", "environmentController", "Lcom/jetbrains/python/run/EnvironmentController;", "envs", "", "intellij.python.community.impl"})
    public static final class Companion {
        public final void putIPythonEnvFlag(@NotNull Project project, @NotNull Map<String, String> envs) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            this.putIPythonEnvFlag(project, new PlainEnvironmentController(envs));
        }

        @JvmStatic
        public final void putIPythonEnvFlag(@NotNull Project project, @NotNull EnvironmentController environmentController) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)environmentController, (String)"environmentController");
            PyConsoleOptions pyConsoleOptions = PyConsoleOptions.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)pyConsoleOptions, (String)"PyConsoleOptions.getInstance(project)");
            String ipythonEnabled = pyConsoleOptions.isIpythonEnabled() ? "True" : "False";
            environmentController.putFixedValue("IPYTHONENABLE", ipythonEnabled);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final String getWorkingDir(@NotNull Project project, @Nullable Module module, @Nullable PathMapper pathMapper, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
                workingDir = settingsProvider.getWorkingDirectory();
                var6_6 = (VirtualFile[])workingDir;
                if (!(var6_6 == null || var6_6.length() == 0)) break block5;
                if (module == null) ** GOTO lbl-1000
                v0 = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ModuleRootManager.getInstance(module)");
                v1 = v0.getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ModuleRootManager.getInstance(module).contentRoots");
                var6_6 = v1;
                if (var6_6.length == 0 == false) {
                    v2 = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"ModuleRootManager.getInstance(module)");
                    v3 = v2.getContentRoots()[0];
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ModuleRootManager.getIns\u2026e(module).contentRoots[0]");
                    workingDir = v3.getPath();
                } else lbl-1000:
                // 2 sources

                {
                    v4 = ProjectRootManager.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"ProjectRootManager.getInstance(project)");
                    var9_7 = projectRoots = v4.getContentRoots();
                    var10_8 = var9_7.length;
                    for (var8_9 = 0; var8_9 < var10_8; ++var8_9) {
                        v5 = root = var9_7[var8_9];
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"root");
                        if (!(v5.getFileSystem() instanceof LocalFileSystem)) continue;
                        workingDir = root.getPath();
                        break;
                    }
                }
            }
            if ((var6_6 = (CharSequence)workingDir) == null || var6_6.length() == 0) {
                workingDir = System.getProperty("user.home");
            }
            if (pathMapper != null && workingDir != null) {
                workingDir = pathMapper.convertToRemote(workingDir);
            }
            return workingDir;
        }

        @NotNull
        public final String[] createSetupFragment(@Nullable Module module, @Nullable String workingDir, @Nullable PathMapper pathMapper, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Object customStartScript = settingsProvider.getCustomStartScript();
            String string = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customStartScript");
            CharSequence charSequence = string;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                customStartScript = "\n" + (String)customStartScript;
            }
            Collection collection = PythonCommandLineState.collectPythonPath(module, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
            Intrinsics.checkNotNullExpressionValue(collection, (String)"PythonCommandLineState.c\u2026r.shouldAddSourceRoots())");
            Collection pythonPath = collection;
            if (pathMapper != null) {
                List list = pathMapper.convertToRemote(pythonPath);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pathMapper.convertToRemote(pythonPath)");
                pythonPath = list;
            }
            Object object = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"customStartScript");
            String selfPathAppend = PydevConsoleRunnerUtil.constructPyPathAndWorkingDirCommand(pythonPath, workingDir, (String)object);
            return new String[]{selfPathAppend};
        }

        private final Function<TargetEnvironment, String> createSetupScriptFunction(Project project, Module module, String workingDir, PyRemotePathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Object customStartScript = settingsProvider.getCustomStartScript();
            String string = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customStartScript");
            CharSequence charSequence = string;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                customStartScript = "\n" + (String)customStartScript;
            }
            List pythonPathFuns = CollectionsKt.toMutableList(TargetedPythonPaths.collectPythonPath(project, module, settingsProvider.mySdkHome, pathMapper, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots(), false));
            Collection collection = pythonPathFuns;
            Object object = customStartScript;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"customStartScript");
            return PydevConsoleRunnerUtil.constructPyPathAndWorkingDirCommand(collection, workingDir, (String)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

