/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.application.options.RegistryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.Function;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonDebugConsoleCommunication
extends AbstractConsoleCommunication {
    private static final Logger LOG = Logger.getInstance(PythonDebugConsoleCommunication.class);
    private final PyDebugProcess myDebugProcess;
    private boolean myNeedsMore;
    private boolean firstExecution;
    @NotNull
    private final PythonConsoleView myConsoleView;
    private boolean isExecuting;

    public PythonDebugConsoleCommunication(@NotNull Project project, @NotNull PyDebugProcess debugProcess, @NotNull PythonConsoleView consoleView) {
        if (project == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(1);
        }
        if (consoleView == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(2);
        }
        super(project);
        this.myNeedsMore = false;
        this.firstExecution = true;
        this.isExecuting = false;
        this.myDebugProcess = debugProcess;
        this.myConsoleView = consoleView;
    }

    @Override
    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text2, String actualToken) throws Exception {
        List<PydevCompletionVariant> list = this.myDebugProcess.getCompletions(actualToken);
        if (list == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public String getDescription(String refExpression) throws Exception {
        return this.myDebugProcess.getDescription(refExpression);
    }

    @Override
    public boolean needsMore() {
        return this.myNeedsMore;
    }

    @Override
    public boolean isExecuting() {
        return this.isExecuting;
    }

    protected void exec(ConsoleCommunication.ConsoleCodeFragment command, final PyDebugCallback<Pair<String, Boolean>> callback) {
        if (this.firstExecution) {
            this.firstExecution = false;
            this.myConsoleView.addConsoleFolding(true, false);
        }
        this.myDebugProcess.consoleExec(command.getText(), new PyDebugCallback<String>(){

            @Override
            public void ok(String value) {
                callback.ok(AbstractConsoleCommunication.parseExecResponseString(value));
                if (RegistryManager.getInstance().is("python.console.CommandQueue")) {
                    ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).removeCommand((ConsoleCommunication)PythonDebugConsoleCommunication.this, false);
                }
            }

            @Override
            public void error(PyDebuggerException exception) {
                callback.error(exception);
                if (RegistryManager.getInstance().is("python.console.CommandQueue")) {
                    ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).removeCommand((ConsoleCommunication)PythonDebugConsoleCommunication.this, true);
                }
            }
        });
    }

    @Override
    public void execInterpreter(ConsoleCommunication.ConsoleCodeFragment code, final Function<InterpreterResponse, Object> callback) {
        this.isExecuting = true;
        if (this.waitingForInput) {
            OutputStream processInput = this.myDebugProcess.getProcessHandler().getProcessInput();
            if (processInput != null) {
                try {
                    Charset defaultCharset = EncodingProjectManager.getInstance((Project)this.myDebugProcess.getProject()).getDefaultCharset();
                    processInput.write(code.getText().getBytes(defaultCharset));
                    processInput.flush();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            }
            this.myNeedsMore = false;
            this.isExecuting = false;
            this.waitingForInput = false;
            this.notifyCommandExecuted(this.waitingForInput);
        } else {
            this.exec(new ConsoleCommunication.ConsoleCodeFragment(code.getText(), false), new PyDebugCallback<Pair<String, Boolean>>(){

                @Override
                public void ok(Pair<String, Boolean> executed) {
                    boolean more;
                    PythonDebugConsoleCommunication.this.myNeedsMore = more = ((Boolean)executed.second).booleanValue();
                    PythonDebugConsoleCommunication.this.isExecuting = false;
                    PythonDebugConsoleCommunication.this.notifyCommandExecuted(more);
                    callback.fun((Object)new InterpreterResponse(more, PythonDebugConsoleCommunication.this.isWaitingForInput()));
                }

                @Override
                public void error(PyDebuggerException exception) {
                    PythonDebugConsoleCommunication.this.myNeedsMore = false;
                    PythonDebugConsoleCommunication.this.isExecuting = false;
                    PythonDebugConsoleCommunication.this.notifyCommandExecuted(false);
                    callback.fun((Object)new InterpreterResponse(false, PythonDebugConsoleCommunication.this.isWaitingForInput()));
                }
            });
        }
    }

    @Override
    public void notifyInputRequested() {
        this.waitingForInput = true;
        super.notifyInputRequested();
    }

    @Override
    public void interrupt() {
        this.myDebugProcess.interruptDebugConsole();
    }

    public boolean isSuspended() {
        return this.myDebugProcess.getSession().isSuspended();
    }

    public void resume() {
        this.myDebugProcess.getSession().resume();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PythonDebugConsoleCommunication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PythonDebugConsoleCommunication";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

