/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.jetbrains.python.documentation.docstrings.DocStringBuilder;
import com.jetbrains.python.documentation.docstrings.DocStringUpdater;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringBuilder;
import com.jetbrains.python.toolbox.Substring;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagBasedDocStringUpdater
extends DocStringUpdater<TagBasedDocString> {
    private final String myTagPrefix;

    public TagBasedDocStringUpdater(@NotNull TagBasedDocString docString, @NotNull String tagPrefix, @NotNull String minContentIndent) {
        if (docString == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(0);
        }
        if (tagPrefix == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(1);
        }
        if (minContentIndent == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(2);
        }
        super(docString, minContentIndent);
        this.myTagPrefix = tagPrefix;
    }

    @NotNull
    private TagBasedDocStringBuilder createBuilder() {
        return new TagBasedDocStringBuilder(this.myTagPrefix);
    }

    @Override
    public final void addParameter(@NotNull String name2, @Nullable String type) {
        if (name2 == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(3);
        }
        if (type != null) {
            this.insertTagLine(this.createBuilder().addParameterType(name2, type));
        } else {
            this.insertTagLine(this.createBuilder().addParameterDescription(name2, ""));
        }
    }

    @Override
    public final void addReturnValue(@Nullable String type) {
        if (type != null) {
            this.insertTagLine(this.createBuilder().addReturnValueType(type));
        } else {
            this.insertTagLine(this.createBuilder().addReturnValueDescription(""));
        }
    }

    @Override
    public void removeParameter(@NotNull String name2) {
        if (name2 == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(4);
        }
        List<Substring> nameSubs = ((TagBasedDocString)this.myOriginalDocString).getParameterSubstrings();
        for (Substring sub : nameSubs) {
            if (!sub.toString().equals(name2)) continue;
            int startLine = sub.getStartLine();
            int nextAfterBlock = ((TagBasedDocString)this.myOriginalDocString).consumeIndentedBlock(startLine + 1, this.getLineIndentSize(startLine));
            this.removeLinesAndSpacesAfter(startLine, nextAfterBlock);
        }
    }

    private void insertTagLine(@NotNull DocStringBuilder lineBuilder) {
        int firstLineWithTag;
        if (lineBuilder == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(5);
        }
        if ((firstLineWithTag = this.findFirstLineWithTag()) >= 0) {
            String indent = this.getLineIndent(firstLineWithTag);
            this.insertBeforeLine(firstLineWithTag, lineBuilder.buildContent(indent, true));
            return;
        }
        int lastNonEmptyLine = this.findLastNonEmptyLine();
        String indent = this.getLineIndent(lastNonEmptyLine);
        this.insertAfterLine(lastNonEmptyLine, lineBuilder.buildContent(indent, true));
    }

    private int findFirstLineWithTag() {
        for (int i = 0; i < ((TagBasedDocString)this.myOriginalDocString).getLineCount(); ++i) {
            Substring line2 = ((TagBasedDocString)this.myOriginalDocString).getLine(i);
            if (!line2.trimLeft().startsWith(this.myTagPrefix)) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minContentIndent";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineBuilder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/documentation/docstrings/TagBasedDocStringUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParameter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insertTagLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

