/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveArgumentEqualDefaultQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentEqualDefaultInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyArgumentEqualDefaultInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyArgumentEqualDefaultInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (node.getParent() instanceof PyDecorator) {
                return;
            }
            List<PyCallable> callables = node.multiResolveCalleeFunction(this.getResolveContext());
            if (ContainerUtil.exists(callables, callable -> Visitor.hasSpecialCasedDefaults(callable, (PsiElement)node))) {
                return;
            }
            this.checkArguments(node, node.getArguments());
        }

        @Override
        public void visitPyDecorator(@NotNull PyDecorator decorator) {
            if (decorator == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (decorator.hasArgumentList()) {
                PyExpression[] arguments = decorator.getArguments();
                this.checkArguments(decorator, arguments);
            }
        }

        private static boolean hasSpecialCasedDefaults(PyCallable callable, PsiElement anchor) {
            String name2 = callable.getName();
            PyBuiltinCache cache2 = PyBuiltinCache.getInstance(anchor);
            if ("getattr".equals(name2) && cache2.isBuiltin((PsiElement)callable)) {
                return true;
            }
            if ("get".equals(name2) || "pop".equals(name2)) {
                PyFunction method = callable.asMethod();
                PyClassType dictType = cache2.getDictType();
                if (method != null && dictType != null && method.getContainingClass() == dictType.getPyClass()) {
                    return true;
                }
            }
            return false;
        }

        private void checkArguments(PyCallExpression callExpr, PyExpression[] arguments) {
            PyCallExpression.PyArgumentsMapping mapping = (PyCallExpression.PyArgumentsMapping)ContainerUtil.getFirstItem(callExpr.multiMapArguments(this.getResolveContext()));
            if (mapping == null) {
                return;
            }
            HashSet<PyExpression> problemElements = new HashSet<PyExpression>();
            for (Map.Entry<PyExpression, PyCallableParameter> e : mapping.getMappedParameters().entrySet()) {
                PyExpression defaultValue = Visitor.findDefaultValue(mapping, e.getValue());
                if (defaultValue == null) continue;
                PyExpression key = e.getKey();
                if (key instanceof PyKeywordArgument && ((PyKeywordArgument)key).getValueExpression() != null) {
                    key = ((PyKeywordArgument)key).getValueExpression();
                }
                if (!this.isEqual(key, defaultValue)) continue;
                problemElements.add(e.getKey());
            }
            boolean canDelete = true;
            for (int i = arguments.length - 1; i != -1; --i) {
                if (problemElements.contains(arguments[i])) {
                    if (canDelete) {
                        this.registerProblem((PsiElement)arguments[i], PyPsiBundle.message("INSP.argument.equals.to.default", new Object[0]), new RemoveArgumentEqualDefaultQuickFix(problemElements));
                        continue;
                    }
                    this.registerProblem((PsiElement)arguments[i], PyPsiBundle.message("INSP.argument.equals.to.default", new Object[0]));
                    continue;
                }
                if (arguments[i] instanceof PyKeywordArgument) continue;
                canDelete = false;
            }
        }

        @Nullable
        private static PyExpression findDefaultValue(@NotNull PyCallExpression.PyArgumentsMapping mapping, @NotNull PyCallableParameter parameter) {
            PyCallable originalCallable;
            PyNamedParameter originalParameter;
            if (mapping == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (parameter == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            String name2 = parameter.getName();
            PyExpression value = parameter.getDefaultValue();
            if (name2 == null || !(value instanceof PyNoneLiteralExpression) || !((PyNoneLiteralExpression)value).isEllipsis()) {
                return value;
            }
            PyCallableType callableType = mapping.getCallableType();
            if (callableType == null) {
                return value;
            }
            PyCallable callable = callableType.getCallable();
            if (callable == null) {
                return value;
            }
            if (PyiUtil.isInsideStub((PsiElement)callable) && (originalParameter = (originalCallable = PyiUtil.getOriginalElementOrLeaveAsIs(callable, PyCallable.class)).getParameterList().findParameterByName(name2)) != null) {
                return originalParameter.getDefaultValue();
            }
            return value;
        }

        private boolean isEqual(PyExpression key, PyExpression defaultValue) {
            if (Visitor.isBothInstanceOf(key, defaultValue, PyNumericLiteralExpression.class) || Visitor.isBothInstanceOf(key, defaultValue, PyPrefixExpression.class) || Visitor.isBothInstanceOf(key, defaultValue, PyBinaryExpression.class) || Visitor.isBothInstanceOf(key, defaultValue, PyNoneLiteralExpression.class) || Visitor.isBothInstanceOf(key, defaultValue, PyBoolLiteralExpression.class)) {
                if (key.getText().equals(defaultValue.getText())) {
                    return true;
                }
            } else if (key instanceof PyStringLiteralExpression && defaultValue instanceof PyStringLiteralExpression) {
                if (((PyStringLiteralExpression)key).getStringValue().equals(((PyStringLiteralExpression)defaultValue).getStringValue())) {
                    return true;
                }
            } else {
                PsiReference defRef;
                if (key instanceof PyReferenceExpression && PyUtil.isPy2ReservedWord((PyReferenceExpression)key) && key.getText().equals(defaultValue.getText())) {
                    return true;
                }
                PsiReference keyRef = key instanceof PyReferenceExpression ? ((PyReferenceExpression)key).getReference(this.getResolveContext()) : key.getReference();
                Object object = defRef = defaultValue instanceof PyReferenceExpression ? ((PyReferenceExpression)defaultValue).getReference(this.getResolveContext()) : defaultValue.getReference();
                if (keyRef != null && defRef != null) {
                    PsiElement keyResolve = keyRef.resolve();
                    PsiElement defResolve = defRef.resolve();
                    if (keyResolve != null && keyResolve.equals(defResolve)) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static boolean isBothInstanceOf(@NotNull PyExpression key, @NotNull PyExpression defaultValue, @NotNull Class clazz) {
            if (key == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (defaultValue == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (clazz == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            return clazz.isInstance(key) && clazz.isInstance(defaultValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decorator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyDecorator";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findDefaultValue";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBothInstanceOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

