/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.rename.RenamePyElementProcessor;
import com.jetbrains.python.toolbox.Maybe;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePyFunctionProcessor
extends RenamePyElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PyFunction;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(1);
        }
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(2);
        }
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(3);
        }
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(4);
        }
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION = enabled;
    }

    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor2) {
        PyTargetExpression site;
        TypeEvalContext context2;
        PyFunction function;
        PyClass containingClass;
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(5);
        }
        if ((containingClass = (function = (PyFunction)ObjectUtils.notNull((Object)PyiUtil.getImplementation((PyFunction)element, context2 = TypeEvalContext.codeInsightFallback(element.getProject())), (Object)((PyFunction)element))).getContainingClass()) == null) {
            return function;
        }
        if (PyUtil.isInitMethod(function)) {
            return containingClass;
        }
        PyFunction deepestSuperMethod = PySuperMethodsSearch.findDeepestSuperMethod(function);
        if (!deepestSuperMethod.equals(function)) {
            String message = PyBundle.message("python.rename.processor.override.message", function.getName(), containingClass.getQualifiedName(), deepestSuperMethod.getContainingClass().getQualifiedName());
            int rc = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)message, (String)PyBundle.message("refactoring.rename", new Object[0]), (Icon)Messages.getQuestionIcon());
            switch (rc) {
                case 0: {
                    return deepestSuperMethod;
                }
                case 1: {
                    return function;
                }
            }
            return null;
        }
        Property property = containingClass.findPropertyByCallable(function);
        if (property != null && (site = property.getDefinitionSite()) != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return site;
            }
            int rc = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)PyBundle.message("python.rename.processor.property", property.getName(), function.getName()), (String)PyBundle.message("refactoring.rename", new Object[0]), (Icon)Messages.getQuestionIcon());
            switch (rc) {
                case 0: {
                    return site;
                }
                case 1: {
                    return function;
                }
            }
            return null;
        }
        return function;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Property property;
        PyClass containingClass;
        PsiElement stubElement;
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(7);
        }
        if (allRenames == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(8);
        }
        PyFunction function = (PyFunction)element;
        PyOverridingMethodsSearch.search(function, true).forEach(f -> {
            allRenames.put((PsiElement)f, newName);
            return true;
        });
        PyiUtil.getOverloads(function, TypeEvalContext.codeInsightFallback(element.getProject())).forEach(overload -> allRenames.put((PsiElement)overload, newName));
        PsiElement originalElement = PyiUtil.getOriginalElement(function);
        if (originalElement != null) {
            allRenames.put(originalElement, newName);
        }
        if ((stubElement = PyiUtil.getPythonStub(function)) != null) {
            allRenames.put(stubElement, newName);
        }
        if ((containingClass = function.getContainingClass()) != null && (property = containingClass.findPropertyByCallable(function)) != null) {
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getGetter());
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getSetter());
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getDeleter());
        }
    }

    private static void addRename(@NotNull Map<PsiElement, String> renames, @NotNull String newName, @NotNull Maybe<PyCallable> accessor) {
        PyCallable callable;
        if (renames == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(10);
        }
        if (accessor == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(11);
        }
        if ((callable = accessor.valueOrNull()) instanceof PyFunction) {
            renames.put((PsiElement)callable, newName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/rename/RenamePyFunctionProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteElementToRename";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

