/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PyInterpreterInspectionQuickFixData;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.poetry.PoetryInstallQuickFix;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PyAddNewPoetryPanel;
import com.jetbrains.python.sdk.poetry.PyPoetryPackageManagementService;
import com.jetbrains.python.sdk.poetry.PyPoetrySdkAdditionalData;
import com.jetbrains.python.sdk.poetry.UsePoetryQuickFix;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J<\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetrySdkProvider;", "Lcom/jetbrains/python/sdk/PySdkProvider;", "()V", "createEnvironmentAssociationFix", "Lcom/jetbrains/python/sdk/PyInterpreterInspectionQuickFixData;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isPyCharm", "", "associatedModulePath", "", "createInstallPackagesQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "createNewEnvironmentPanel", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "newProjectPath", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "getSdkAdditionalText", "getSdkIcon", "Ljavax/swing/Icon;", "loadAdditionalDataForSdk", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "element", "Lorg/jdom/Element;", "tryCreatePackageManagementServiceForSdk", "Lcom/jetbrains/python/packaging/ui/PyPackageManagementService;", "intellij.python.community.impl"})
public final class PoetrySdkProvider
implements PySdkProvider {
    @Override
    @Nullable
    public PyInterpreterInspectionQuickFixData createEnvironmentAssociationFix(@NotNull Module module, @NotNull Sdk sdk, boolean isPyCharm, @Nullable String associatedModulePath) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (PoetryKt.isPoetry(sdk)) {
            String projectUnit = isPyCharm ? "project" : "module";
            String string = associatedModulePath != null ? PyBundle.message("python.sdk.inspection.message.poetry.interpreter.associated.with.another.project", projectUnit, associatedModulePath) : PyBundle.message("python.sdk.inspection.message.poetry.interpreter.not.associated.with.any.project", projectUnit);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when {\n        associate\u2026ct\", projectUnit)\n      }");
            String message = string;
            return new PyInterpreterInspectionQuickFixData(new UsePoetryQuickFix(sdk, module), message);
        }
        return null;
    }

    @Override
    @Nullable
    public LocalQuickFix createInstallPackagesQuickFix(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"PythonSdkUtil.findPythonSdk(module) ?: return null");
        Sdk sdk2 = sdk;
        return PoetryKt.isPoetry(sdk2) ? (LocalQuickFix)new PoetryInstallQuickFix() : null;
    }

    @Override
    @NotNull
    public PyAddNewEnvPanel createNewEnvironmentPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks2, @Nullable String newProjectPath, @NotNull UserDataHolder context2) {
        Intrinsics.checkNotNullParameter(existingSdks2, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new PyAddNewPoetryPanel(null, null, existingSdks2, newProjectPath, context2);
    }

    @Override
    @Nullable
    public String getSdkAdditionalText(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return PoetryKt.isPoetry(sdk) ? sdk.getVersionString() : null;
    }

    @Override
    @Nullable
    public Icon getSdkIcon(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return PoetryKt.isPoetry(sdk) ? PoetryKt.getPOETRY_ICON() : null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalDataForSdk(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PyPoetrySdkAdditionalData.Companion.load(element);
    }

    @Override
    @Nullable
    public PyPackageManagementService tryCreatePackageManagementServiceForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return PoetryKt.isPoetry(sdk) ? (PyPackageManagementService)new PyPoetryPackageManagementService(project, sdk) : null;
    }
}

