/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PySkeletonGenerator {
    protected static final Logger LOG = Logger.getInstance(PySkeletonGenerator.class);
    protected static final String GENERATOR3 = "generator3/__main__.py";
    @NonNls
    public static final String STATE_MARKER_FILE = ".state.json";
    @NonNls
    public static final String BLACKLIST_FILE_NAME = ".blacklist";
    private static final Gson ourGson = new GsonBuilder().create();
    @NotNull
    protected final Sdk mySdk;
    @Nullable
    protected final String myCurrentFolder;
    @NotNull
    protected final String mySkeletonsPath;

    public PySkeletonGenerator(@NotNull String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder) {
        if (skeletonPath == null) {
            PySkeletonGenerator.$$$reportNull$$$0(0);
        }
        if (pySdk == null) {
            PySkeletonGenerator.$$$reportNull$$$0(1);
        }
        this.mySkeletonsPath = StringUtil.trimTrailing((String)skeletonPath, (char)'\\');
        this.mySdk = pySdk;
        this.myCurrentFolder = currentFolder;
    }

    @NotNull
    public abstract Builder commandBuilder();

    @NotNull
    protected List<GenerationResult> runGeneration(@NotNull Builder builder, final @Nullable ProgressIndicator indicator) throws InvalidSdkException, ExecutionException {
        ArrayList<GenerationResult> results;
        LineWiseProcessOutputListener listener2;
        ProcessOutput output;
        if (builder == null) {
            PySkeletonGenerator.$$$reportNull$$$0(2);
        }
        if ((output = builder.runProcessWithLineOutputListener(listener2 = new LineWiseProcessOutputListener(results = new ArrayList<GenerationResult>()){
            final /* synthetic */ List val$results;
            {
                this.val$results = list;
            }

            @Override
            public void onStdoutLine(@NotNull String line2) {
                String trimmed;
                if (line2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if ((trimmed = line2.trim()).startsWith("{")) {
                    JsonObject controlMessage;
                    try {
                        controlMessage = (JsonObject)ourGson.fromJson(trimmed, JsonObject.class);
                    }
                    catch (JsonSyntaxException e) {
                        LOG.warn("Malformed control message: " + line2);
                        return;
                    }
                    String msgType = controlMessage.get("type").getAsString();
                    if (msgType.equals("progress") && indicator != null) {
                        JsonElement fraction;
                        JsonElement text2 = controlMessage.get("text");
                        if (text2 != null) {
                            @NlsSafe String progressText = text2.getAsString();
                            if (controlMessage.get("minor").getAsBoolean()) {
                                indicator.setText2(progressText);
                            } else {
                                indicator.setText(progressText);
                            }
                        }
                        if ((fraction = controlMessage.get("fraction")) != null) {
                            indicator.setIndeterminate(false);
                            indicator.setFraction(fraction.getAsDouble());
                        }
                    } else if (msgType.equals("log")) {
                        String level = controlMessage.get("level").getAsString();
                        String message = controlMessage.get("message").getAsString();
                        if (level.equals("info")) {
                            Run.LOG.info(message);
                        } else if (level.equals("debug")) {
                            Run.LOG.debug(message);
                        } else if (level.equals("trace")) {
                            Run.LOG.trace(message);
                        }
                    } else if (msgType.equals("generation_result")) {
                        this.val$results.add((GenerationResult)ourGson.fromJson(trimmed, GenerationResult.class));
                    }
                }
            }

            @Override
            public void onStderrLine(@NotNull String line2) {
                if (line2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                Run.LOG.info(StringUtil.trimTrailing((String)line2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStdoutLine";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStderrLine";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getExitCode() != 0) {
            throw new InvalidSdkException(this.formatGeneratorFailureMessage(output));
        }
        ArrayList<GenerationResult> arrayList = results;
        if (arrayList == null) {
            PySkeletonGenerator.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void finishSkeletonsGeneration() {
    }

    public boolean exists(@NotNull String name2) {
        if (name2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(4);
        }
        return new File(name2).exists();
    }

    public String getSkeletonsPath() {
        return this.mySkeletonsPath;
    }

    public void prepare() {
    }

    @NotNull
    @NlsSafe
    protected final String formatGeneratorFailureMessage(@NotNull ProcessOutput process2) {
        if (process2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder("failed to run ").append(GENERATOR3).append(" for ").append(this.mySdk.getHomePath());
        if (process2.isTimeout()) {
            sb.append(": timed out.");
        } else {
            sb.append(", exit code ").append(process2.getExitCode()).append(", stderr: \n-----\n");
            for (String line2 : process2.getStderrLines()) {
                sb.append(line2).append("\n");
            }
            sb.append("-----");
        }
        String string = sb.toString();
        if (string == null) {
            PySkeletonGenerator.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean deleteOrLog(@NotNull File item) {
        boolean deleted;
        if (item == null) {
            PySkeletonGenerator.$$$reportNull$$$0(7);
        }
        if (!(deleted = item.delete())) {
            LOG.warn("Failed to delete skeleton file " + item.getAbsolutePath());
        }
        return deleted;
    }

    public void refreshGeneratedSkeletons() {
        VirtualFile skeletonsVFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getSkeletonsPath());
        assert (skeletonsVFile != null);
        skeletonsVFile.refresh(false, true);
    }

    protected static void sendLineToProcessInput(@NotNull BaseProcessHandler<?> handler, @NotNull String line2) throws ExecutionException {
        OutputStream input;
        if (handler == null) {
            PySkeletonGenerator.$$$reportNull$$$0(8);
        }
        if (line2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(9);
        }
        if ((input = handler.getProcessInput()) != null) {
            try {
                PySkeletonGenerator.sendLineToStream(input, line2);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        } else {
            LOG.warn("Process " + handler.getCommandLine() + " can't accept any input");
        }
    }

    protected static void sendLineToStream(@NotNull OutputStream input, @NotNull String line2) throws IOException {
        if (input == null) {
            PySkeletonGenerator.$$$reportNull$$$0(10);
        }
        if (line2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(11);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(input, StandardCharsets.UTF_8));
        writer.write(line2);
        writer.write(10);
        writer.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pySdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runGeneration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatGeneratorFailureMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runGeneration";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatGeneratorFailureMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteOrLog";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sendLineToProcessInput";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sendLineToStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GenerationResult {
        @SerializedName(value="module_name")
        private String myModuleName;
        @SerializedName(value="module_origin")
        private String myModuleOrigin;
        @SerializedName(value="generation_status")
        private GenerationStatus myGenerationStatus;

        @NotNull
        public String getModuleName() {
            String string = this.myModuleName;
            if (string == null) {
                GenerationResult.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getModuleOrigin() {
            String string = this.myModuleOrigin;
            if (string == null) {
                GenerationResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public GenerationStatus getGenerationStatus() {
            GenerationStatus generationStatus = this.myGenerationStatus;
            if (generationStatus == null) {
                GenerationResult.$$$reportNull$$$0(2);
            }
            return generationStatus;
        }

        public boolean isBuiltin() {
            return this.myModuleOrigin.equals("(built-in)");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$GenerationResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleOrigin";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGenerationStatus";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static enum GenerationStatus {
        UP_TO_DATE,
        GENERATED,
        COPIED,
        FAILED;

    }

    public abstract class Builder {
        protected final List<String> myExtraSysPath = new ArrayList<String>();
        protected final List<String> myAssemblyRefs = new ArrayList<String>();
        protected final List<String> myExtraArgs = new ArrayList<String>();
        protected String myWorkingDir;
        protected String myTargetModuleName;
        protected String myTargetModulePath;
        protected boolean myPrebuilt = false;
        protected int myTimeout;
        protected String myStdin;

        protected Builder() {
        }

        @NotNull
        public Builder extraSysPath(@NotNull List<String> roots) {
            if (roots == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myExtraSysPath.addAll(roots);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder assemblyRefs(@NotNull List<String> assemblyRefs) {
            if (assemblyRefs == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myAssemblyRefs.addAll(assemblyRefs);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder extraArgs(@NotNull List<String> args2) {
            if (args2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myExtraArgs.addAll(args2);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder extraArgs(String ... args2) {
            if (args2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            Builder builder = this.extraArgs(Arrays.asList(args2));
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder workingDir(@NotNull String path2) {
            if (path2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myWorkingDir = path2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder inPrebuildingMode() {
            this.myPrebuilt = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder targetModule(@NotNull String name2, @Nullable String path2) {
            if (name2 == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myTargetModuleName = name2;
            this.myTargetModulePath = path2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder timeout(int timeout) {
            this.myTimeout = timeout;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder stdin(@NotNull String content2) {
            if (content2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            this.myStdin = content2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder;
        }

        @Nullable
        public String getStdin() {
            return this.myStdin;
        }

        public int getTimeout(int defaultTimeout) {
            return this.myTimeout > 0 ? this.myTimeout : defaultTimeout;
        }

        @NotNull
        public abstract ProcessOutput runProcess() throws InvalidSdkException;

        @NotNull
        public List<GenerationResult> runGeneration(@Nullable ProgressIndicator indicator) throws InvalidSdkException, ExecutionException {
            List<GenerationResult> list = PySkeletonGenerator.this.runGeneration(this, indicator);
            if (list == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return list;
        }

        @NotNull
        public abstract ProcessOutput runProcessWithLineOutputListener(@NotNull LineWiseProcessOutputListener var1) throws InvalidSdkException, ExecutionException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assemblyRefs";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extraSysPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "assemblyRefs";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extraArgs";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "workingDir";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inPrebuildingMode";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "targetModule";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "timeout";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stdin";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runGeneration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extraSysPath";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "assemblyRefs";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "extraArgs";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "workingDir";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "targetModule";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "stdin";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Run {
        static final Logger LOG = Logger.getInstance(Run.class);

        private Run() {
        }
    }
}

