/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.google.common.net.UrlEscapers;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u0000J\u0013\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\b\u0010 \u001a\u00020\u0006H\u0007J\b\u0010!\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/svn/api/Url;", "", "innerUri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "host", "", "getHost", "()Ljava/lang/String;", "path", "getPath", "port", "", "getPort", "()I", "protocol", "getProtocol", "tail", "getTail", "uri", "userInfo", "getUserInfo", "appendPath", "encoded", "", "commonAncestorWith", "url", "equals", "other", "fixFileUrlToString", "hashCode", "setUserInfo", "toDecodedString", "toString", "Companion", "intellij.vcs.svn"})
public final class Url {
    private final URI uri;
    @NotNull
    private final String protocol;
    @NotNull
    private final String host;
    private final int port;
    @Nullable
    private final String userInfo;
    @NotNull
    private final String path;
    @JvmField
    @NotNull
    public static final Url EMPTY;
    @NonNls
    private static final Map<String, Integer> DEFAULT_PORTS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getUserInfo() {
        return this.userInfo;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NlsSafe
    @NotNull
    public final String getTail() {
        return StringsKt.substringAfterLast$default((String)this.path, (char)'/', null, (int)2, null);
    }

    @Nullable
    public final Url commonAncestorWith(@NotNull Url url) {
        Url url2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)this.protocol, (Object)url.protocol) ^ true || Intrinsics.areEqual((Object)this.host, (Object)url.host) ^ true || this.port != url.port || Intrinsics.areEqual((Object)this.userInfo, (Object)url.userInfo) ^ true) {
            return null;
        }
        String string = SvnUtil.ensureStartSlash(Companion.getCommonAncestor(this.path, url.path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SvnUtil.ensureStartSlash\u2026Ancestor(path, url.path))");
        String commonPath = string;
        try {
            url2 = Url.Companion.wrap((Function0<URI>)((Function0)new Function0<URI>(this, commonPath){
                final /* synthetic */ Url this$0;
                final /* synthetic */ String $commonPath;

                @NotNull
                public final URI invoke() {
                    return new URI(Url.access$getUri$p(this.this$0).getScheme(), Url.access$getUri$p(this.this$0).getUserInfo(), Url.access$getUri$p(this.this$0).getHost(), Url.access$getUri$p(this.this$0).getPort(), this.$commonPath, Url.access$getUri$p(this.this$0).getQuery(), Url.access$getUri$p(this.this$0).getFragment());
                }
                {
                    this.this$0 = url;
                    this.$commonPath = string;
                    super(0);
                }
            }));
        }
        catch (SvnBindException e) {
            url2 = null;
        }
        return url2;
    }

    @NotNull
    public final Url appendPath(@NotNull String path, boolean encoded) throws SvnBindException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = path;
        return charSequence.length() == 0 || Intrinsics.areEqual((Object)path, (Object)"/") ? this : Url.Companion.wrap((Function0<URI>)((Function0)new Function0<URI>(this, path, encoded){
            final /* synthetic */ Url this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ boolean $encoded;

            @NotNull
            public final URI invoke() {
                URI uRI = Url.access$getUri$p(this.this$0).resolve(new URI(org.jetbrains.idea.svn.api.Url$Companion.access$prepareUri(Url.Companion, StringsKt.removePrefix((String)this.$path, (CharSequence)"/"), this.$encoded)));
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri.resolve(URI(prepareU\u2026vePrefix(\"/\"), encoded)))");
                return uRI;
            }
            {
                this.this$0 = url;
                this.$path = string;
                this.$encoded = bl;
                super(0);
            }
        }));
    }

    public static /* synthetic */ Url appendPath$default(Url url, String string, boolean bl, int n, Object object) throws SvnBindException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return url.appendPath(string, bl);
    }

    @NotNull
    public final Url setUserInfo(@Nullable String userInfo) throws SvnBindException {
        return Url.Companion.wrap((Function0<URI>)((Function0)new Function0<URI>(this, userInfo){
            final /* synthetic */ Url this$0;
            final /* synthetic */ String $userInfo;

            @NotNull
            public final URI invoke() {
                return new URI(Url.access$getUri$p(this.this$0).getScheme(), this.$userInfo, Url.access$getUri$p(this.this$0).getHost(), Url.access$getUri$p(this.this$0).getPort(), Url.access$getUri$p(this.this$0).getPath(), Url.access$getUri$p(this.this$0).getQuery(), Url.access$getUri$p(this.this$0).getFragment());
            }
            {
                this.this$0 = url;
                this.$userInfo = string;
                super(0);
            }
        }));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Url)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uri, (Object)((Url)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.uri.toASCIIString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toASCIIString()");
        return this.fixFileUrlToString(StringsKt.removeSuffix((String)string, (CharSequence)"/"));
    }

    @NlsSafe
    @NotNull
    public final String toDecodedString() {
        String string = URLUtil.unescapePercentSequences((String)this.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLUtil.unescapePercentSequences(toString())");
        return string;
    }

    private final String fixFileUrlToString(String url) {
        Object object;
        if (StringsKt.startsWith$default((String)url, (String)"file:/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
            String string = url;
            int n = "file:/".length();
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            object = "file:///" + string2;
        } else {
            object = url;
        }
        return object;
    }

    private Url(URI innerUri) {
        String string;
        this.uri = Url.Companion.fixDefaultPort(innerUri);
        String string2 = this.uri.getScheme();
        String string3 = string2;
        if (string3 == null) {
            string3 = this.protocol = "";
        }
        if ((string = (string2 = this.uri.getHost())) == null) {
            string = "";
        }
        this.host = string;
        this.port = this.uri.getPort();
        this.userInfo = this.uri.getUserInfo();
        string2 = this.uri.getPath();
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        this.path = StringsKt.removeSuffix((String)string4, (CharSequence)"/");
    }

    static {
        Companion = new Companion(null);
        EMPTY = new Url(new URI(""));
        DEFAULT_PORTS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"http", (Object)80), TuplesKt.to((Object)"https", (Object)443), TuplesKt.to((Object)"svn", (Object)3690), TuplesKt.to((Object)"svn+ssh", (Object)22)});
    }

    public static final /* synthetic */ URI access$getUri$p(Url $this) {
        return $this.uri;
    }

    public /* synthetic */ Url(URI innerUri, DefaultConstructorMarker $constructor_marker) {
        this(innerUri);
    }

    @JvmStatic
    @NotNull
    public static final Url parse(@NotNull String value, boolean encoded) throws SvnBindException {
        return Companion.parse(value, encoded);
    }

    @JvmStatic
    @NotNull
    public static final String tail(@NotNull String url) {
        return Companion.tail(url);
    }

    @JvmStatic
    @NotNull
    public static final String removeTail(@NotNull String url) {
        return Companion.removeTail(url);
    }

    @JvmStatic
    @NotNull
    public static final String append(@NotNull String url1, @NotNull String url2) {
        return Companion.append(url1, url2);
    }

    @JvmStatic
    @Nullable
    public static final String getRelative(@NotNull String parent, @NotNull String child) {
        return Companion.getRelative(parent, child);
    }

    @JvmStatic
    public static final boolean isAncestor(@NotNull String parent, @NotNull String child) {
        return Companion.isAncestor(parent, child);
    }

    @JvmStatic
    @NotNull
    public static final String getCommonAncestor(@NotNull String url1, @NotNull String url2) {
        return Companion.getCommonAncestor(url1, url2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J \u0010\f\u001a\n \r*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u001a\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u001c\u001a\n \r*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0007J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0007J\u0016\u0010 \u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\"H\u0002R\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/svn/api/Url$Companion;", "", "()V", "DEFAULT_PORTS", "", "", "", "EMPTY", "Lorg/jetbrains/idea/svn/api/Url;", "append", "url1", "url2", "encode", "kotlin.jvm.PlatformType", "value", "encoded", "", "ensureEndSlash", "fixDefaultPort", "Ljava/net/URI;", "uri", "getCommonAncestor", "getRelative", "parent", "child", "hasDefaultPort", "isAncestor", "parse", "prepareUri", "removeTail", "url", "tail", "wrap", "block", "Lkotlin/Function0;", "intellij.vcs.svn"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Url parse(@NotNull String value, boolean encoded) throws SvnBindException {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.wrap((Function0<URI>)((Function0)new Function0<URI>(value, encoded){
                final /* synthetic */ String $value;
                final /* synthetic */ boolean $encoded;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final URI invoke() {
                    void var1_1;
                    URI uri;
                    URI uRI = uri = new URI(org.jetbrains.idea.svn.api.Url$Companion.access$prepareUri(Url.Companion, this.$value, this.$encoded)).normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
                    if (!uRI.isAbsolute()) {
                        throw (Throwable)((Object)new SvnBindException(SvnBundle.message("error.url.is.not.absolute", uri)));
                    }
                    if (uri.isOpaque()) {
                        throw (Throwable)((Object)new SvnBindException(SvnBundle.message("error.url.is.not.hierarchical", uri)));
                    }
                    if (uri.getQuery() != null) {
                        throw (Throwable)((Object)new SvnBindException(SvnBundle.message("error.url.could.not.contain.query", uri)));
                    }
                    if (uri.getFragment() != null) {
                        throw (Throwable)((Object)new SvnBindException(SvnBundle.message("error.url.could.not.contain.fragment", uri)));
                    }
                    return var1_1;
                }
                {
                    this.$value = string;
                    this.$encoded = bl;
                    super(0);
                }
            }));
        }

        public static /* synthetic */ Url parse$default(Companion companion, String string, boolean bl, int n, Object object) throws SvnBindException {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.parse(string, bl);
        }

        @JvmStatic
        @NotNull
        public final String tail(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return StringsKt.substringAfterLast$default((String)StringsKt.removeSuffix((String)url, (CharSequence)"/"), (char)'/', null, (int)2, null);
        }

        @JvmStatic
        @NotNull
        public final String removeTail(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return StringsKt.substringBeforeLast((String)StringsKt.removeSuffix((String)url, (CharSequence)"/"), (char)'/', (String)"");
        }

        @JvmStatic
        @NotNull
        public final String append(@NotNull String url1, @NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url1, (String)"url1");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url2");
            String prefix = StringsKt.removeSuffix((String)url1, (CharSequence)"/");
            String suffix = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)url2, (CharSequence)"/"), (CharSequence)"/");
            CharSequence charSequence = prefix;
            String separator = charSequence.length() == 0 || (charSequence = (CharSequence)suffix).length() == 0 ? "" : "/";
            return prefix + separator + suffix;
        }

        @JvmStatic
        @Nullable
        public final String getRelative(@NotNull String parent, @NotNull String child) {
            String string;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (Intrinsics.areEqual((Object)parent, (Object)child)) {
                return "";
            }
            CharSequence charSequence = parent;
            if (charSequence.length() == 0) {
                return StringsKt.removePrefix((String)child, (CharSequence)"/");
            }
            String parentWithSlash = this.ensureEndSlash(parent);
            if (StringsKt.startsWith$default((String)child, (String)parentWithSlash, (boolean)false, (int)2, null)) {
                String string2 = child;
                int n = parentWithSlash.length();
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isAncestor(@NotNull String parent, @NotNull String child) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            CharSequence charSequence = parent;
            if (charSequence.length() == 0) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
            if (!StringsKt.startsWith$default((String)child, (String)parent, (boolean)false, (int)2, null)) return false;
            if (StringsKt.last((CharSequence)parent) == '/') return true;
            charSequence = child;
            int n = parent.length();
            if (n < 0 || n > StringsKt.getLastIndex((CharSequence)charSequence)) {
                int it = n;
                return true;
            }
            int n2 = charSequence.charAt(n);
            if (n2 != 47) return false;
            return true;
        }

        @JvmStatic
        @NotNull
        public final String getCommonAncestor(@NotNull String url1, @NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url1, (String)"url1");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url2");
            return SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.zip((Sequence)StringsKt.splitToSequence$default((CharSequence)url1, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null), (Sequence)StringsKt.splitToSequence$default((CharSequence)url2, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null)), (Function1)getCommonAncestor.1.INSTANCE), (CharSequence)"/", null, null, (int)0, null, (Function1)getCommonAncestor.2.INSTANCE, (int)30, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasDefaultPort(URI uri) {
            if (uri.getPort() < 0) return true;
            Integer n = (Integer)DEFAULT_PORTS.get(uri.getScheme());
            if (n == null) return false;
            if (uri.getPort() != n.intValue()) return false;
            return true;
        }

        private final URI fixDefaultPort(URI uri) {
            return uri.getPort() >= 0 && this.hasDefaultPort(uri) ? new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), -1, uri.getPath(), uri.getQuery(), uri.getFragment()) : uri;
        }

        private final String prepareUri(String uri, boolean encoded) {
            return this.encode(this.ensureEndSlash(uri), encoded);
        }

        private final String encode(String value, boolean encoded) {
            return encoded ? value : UrlEscapers.urlFragmentEscaper().escape(value);
        }

        private final String ensureEndSlash(String value) {
            Character c = StringsKt.lastOrNull((CharSequence)value);
            return c != null && c.charValue() == '/' ? value : value + "/";
        }

        private final Url wrap(Function0<URI> block) {
            try {
                return new Url((URI)block.invoke(), null);
            }
            catch (URISyntaxException e) {
                throw (Throwable)((Object)new SvnBindException(e));
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$prepareUri(Companion $this, String uri, boolean encoded) {
            return $this.prepareUri(uri, encoded);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

