/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi.base;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.psi.reference.EditorConfigConstantReference;
import org.editorconfig.language.psi.reference.EditorConfigDeclarationReference;
import org.editorconfig.language.psi.reference.EditorConfigIdentifierReference;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigReferenceDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.editorconfig.language.util.EditorConfigDescriptorUtil;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lorg/editorconfig/language/psi/base/EditorConfigDescribableElementBase;", "Lcom/intellij/extapi/psi/ASTWrapperPsiElement;", "Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "declarationSite", "", "getDeclarationSite", "()Ljava/lang/String;", "describableParent", "getDescribableParent", "()Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "option", "Lorg/editorconfig/language/psi/EditorConfigOption;", "getOption", "()Lorg/editorconfig/language/psi/EditorConfigOption;", "section", "Lorg/editorconfig/language/psi/EditorConfigSection;", "getSection", "()Lorg/editorconfig/language/psi/EditorConfigSection;", "getReference", "Lcom/intellij/psi/PsiReference;", "toString", "intellij.editorconfig"})
public abstract class EditorConfigDescribableElementBase
extends ASTWrapperPsiElement
implements EditorConfigDescribableElement {
    @Override
    @NotNull
    public final EditorConfigOption getOption() {
        EditorConfigDescribableElementBase $this$getParentOfType$iv = this;
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        EditorConfigOption editorConfigOption = (EditorConfigOption)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, EditorConfigOption.class, (boolean)strict$iv);
        if (editorConfigOption == null) {
            throw (Throwable)new IllegalStateException();
        }
        return editorConfigOption;
    }

    @Override
    @NotNull
    public final EditorConfigSection getSection() {
        EditorConfigDescribableElementBase $this$getParentOfType$iv = this;
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        EditorConfigSection editorConfigSection = (EditorConfigSection)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, EditorConfigSection.class, (boolean)strict$iv);
        if (editorConfigSection == null) {
            throw (Throwable)new IllegalStateException();
        }
        return editorConfigSection;
    }

    @Override
    @Nullable
    public EditorConfigDescribableElement getDescribableParent() {
        PsiElement psiElement = this.getParent();
        if (!(psiElement instanceof EditorConfigDescribableElement)) {
            psiElement = null;
        }
        return (EditorConfigDescribableElement)psiElement;
    }

    @Override
    @NotNull
    public String getDeclarationSite() {
        EditorConfigHeader editorConfigHeader = this.getSection().getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"section.header");
        String header = editorConfigHeader.getText();
        PsiFile psiFile = this.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            String string = header;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header");
            return string;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.presentableName");
        String fileName = string;
        return header + " (" + fileName + ")";
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference psiReference;
        EditorConfigDescriptor descriptor = this.getDescriptor(false);
        if (descriptor instanceof EditorConfigDeclarationDescriptor) {
            psiReference = (PsiReference)new EditorConfigDeclarationReference(this);
        } else if (descriptor instanceof EditorConfigReferenceDescriptor) {
            psiReference = (PsiReference)new EditorConfigIdentifierReference(this, ((EditorConfigReferenceDescriptor)descriptor).getId());
        } else if (descriptor instanceof EditorConfigConstantDescriptor) {
            psiReference = (PsiReference)new EditorConfigConstantReference(this);
        } else if (descriptor instanceof EditorConfigUnionDescriptor) {
            EditorConfigConstantReference editorConfigConstantReference;
            if (EditorConfigDescriptorUtil.INSTANCE.isConstant(descriptor)) {
                editorConfigConstantReference = new EditorConfigConstantReference(this);
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(EditorConfigDescribableElementBase.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Got non-constant union");
                editorConfigConstantReference = null;
            }
            psiReference = (PsiReference)editorConfigConstantReference;
        } else {
            psiReference = null;
        }
        return psiReference;
    }

    @NotNull
    public final String toString() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        return string;
    }

    public EditorConfigDescribableElementBase(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }
}

