/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentRestorer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.pty4j.unix.UnixPtyProcess;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProcessOptions;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    private static final String JEDITERM_USER_RCFILE = "JEDITERM_USER_RCFILE";
    private static final String ZDOTDIR = "ZDOTDIR";
    private static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    private static final String IJ_COMMAND_HISTORY_FILE_ENV = "__INTELLIJ_COMMAND_HISTFILE__";
    private static final String LOGIN_SHELL = "LOGIN_SHELL";
    private static final String LOGIN_CLI_OPTION = "--login";
    private static final ImmutableList<String> LOGIN_CLI_OPTIONS = ImmutableList.of((Object)"--login", (Object)"-l");
    private static final String INTERACTIVE_CLI_OPTION = "-i";
    private static final String BASH_NAME = "bash";
    private static final String SH_NAME = "sh";
    private static final String ZSH_NAME = "zsh";
    private static final String FISH_NAME = "fish";
    protected final Charset myDefaultCharset = StandardCharsets.UTF_8;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    @Nullable
    private static String findRCFile(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        String rcfile = null;
        if (BASH_NAME.equals(shellName) || SH_NAME.equals(shellName)) {
            rcfile = "jediterm-bash.in";
        } else if (ZSH_NAME.equals(shellName)) {
            rcfile = ".zshenv";
        } else if (FISH_NAME.equals(shellName)) {
            rcfile = "fish/config.fish";
        }
        if (rcfile != null) {
            try {
                return LocalTerminalDirectRunner.findAbsolutePath(rcfile);
            }
            catch (Exception e) {
                LOG.warn("Unable to find " + rcfile + " configuration file", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static String findAbsolutePath(@NotNull String relativePath) throws IOException {
        File result;
        Object jarPath;
        if (relativePath == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        if (((String)(jarPath = PathUtil.getJarPathForClass(LocalTerminalDirectRunner.class))).endsWith(".jar")) {
            File jarFile = new File((String)jarPath);
            if (!jarFile.isFile()) {
                throw new IOException("Broken installation: " + (String)jarPath + " is not a file");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            result = new File(pluginBaseDir, relativePath);
        } else {
            String srcDir;
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isInternal() && new File(srcDir = ((String)(jarPath = StringUtil.trimEnd((String)((String)jarPath).replace('\\', '/'), (char)'/') + "/")).replace("/out/classes/production/intellij.terminal/", "/community/plugins/terminal/resources/")).isDirectory()) {
                jarPath = srcDir;
            }
            result = new File((String)jarPath, relativePath);
        }
        if (!result.isFile()) {
            throw new IOException("Cannot find " + relativePath + ": " + result.getAbsolutePath() + " is not a file");
        }
        String string = result.getAbsolutePath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    private Map<String, String> getTerminalEnvironment(@Nullable String workingDir) {
        Map envs = SystemInfo.isWindows ? CollectionFactory.createCaseInsensitiveStringMap() : new HashMap();
        EnvironmentVariablesData envData = TerminalProjectOptionsProvider.getInstance(this.myProject).getEnvData();
        if (envData.isPassParentEnvs()) {
            envs.putAll(System.getenv());
            EnvironmentRestorer.restoreOverriddenVars((Map)envs);
        } else {
            LOG.info("No parent environment passed");
        }
        if (!SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        envs.put("TERMINAL_EMULATOR", "JetBrains-JediTerm");
        envs.put("TERM_SESSION_ID", UUID.randomUUID().toString());
        if (SystemInfo.isMac) {
            EnvironmentUtil.setLocaleEnv((Map)envs, (Charset)this.myDefaultCharset);
        }
        if (TrustedProjects.isTrusted((Project)this.myProject)) {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)this.myProject);
            for (Map.Entry env : envData.getEnvs().entrySet()) {
                envs.put((String)env.getKey(), macroManager.expandPath((String)env.getValue()));
            }
            if (workingDir != null && WslPath.isWslUncPath((String)workingDir)) {
                LocalTerminalDirectRunner.setupWslEnv(envData.getEnvs(), envs);
            }
        }
        return envs;
    }

    private static void setupWslEnv(@NotNull Map<String, String> userEnvs, @NotNull Map<String, String> resultEnvs) {
        String wslEnv;
        if (userEnvs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        if (resultEnvs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        if ((wslEnv = userEnvs.keySet().stream().map(name -> name + "/u").collect(Collectors.joining(":"))).isEmpty()) {
            return;
        }
        String prevValue = userEnvs.get("WSLENV");
        if (prevValue == null) {
            prevValue = System.getenv("WSLENV");
        }
        String newWslEnv = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ":" + wslEnv : wslEnv;
        resultEnvs.put("WSLENV", newWslEnv);
    }

    @Override
    public PtyProcess createProcess(@Nullable String directory) throws ExecutionException {
        return (PtyProcess)super.createProcess(directory, null);
    }

    @Override
    @NotNull
    public PtyProcess createProcess(@NotNull TerminalProcessOptions options, @Nullable JBTerminalWidget widget) throws ExecutionException {
        PtyProcess ptyProcess;
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        String workingDir = this.getWorkingDirectory(options.getWorkingDirectory());
        Map<String, String> envs = this.getTerminalEnvironment(workingDir);
        Object[] command = ArrayUtil.toStringArray(this.getInitialCommand(envs));
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                command = customizer.customizeCommandAndEnvironment(this.myProject, (String[])command, envs);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        String commandHistoryFilePath = ShellTerminalWidget.getCommandHistoryFilePath(widget);
        if (commandHistoryFilePath != null) {
            envs.put(IJ_COMMAND_HISTORY_FILE_ENV, commandHistoryFilePath);
        }
        TerminalUsageTriggerCollector.triggerLocalShellStarted(this.myProject, (String[])command);
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Starting " + Arrays.toString(command) + " in " + workingDir + " (" + (workingDir != null && new File(workingDir).isDirectory() ? "exists" : "does not exist") + ") [" + options.getInitialColumns() + "," + options.getInitialRows() + "], envs=" + envs);
            }
            long startNano = System.nanoTime();
            PtyProcessBuilder builder = new PtyProcessBuilder((String[])command).setEnvironment(envs).setDirectory(workingDir).setInitialColumns(options.getInitialColumns()).setInitialRows(options.getInitialRows()).setUseWinConPty(LocalPtyOptions.shouldUseWinConPty());
            PtyProcess process = builder.start();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started " + process.getClass().getName() + " from " + Arrays.toString(command) + " in " + workingDir + " [" + options.getInitialColumns() + "," + options.getInitialRows() + "] (" + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
            }
            ptyProcess = process;
        }
        catch (IOException e) {
            String errorMessage = "Failed to start " + Arrays.toString(command) + " in " + workingDir;
            if (workingDir != null && !new File(workingDir).isDirectory()) {
                errorMessage = "No such directory: " + workingDir;
            }
            throw new ExecutionException(errorMessage, e);
        }
        if (ptyProcess == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(6);
        }
        return ptyProcess;
    }

    @Nullable
    private String getWorkingDirectory(@Nullable String directory) {
        if (directory != null) {
            return directory;
        }
        return TerminalProjectOptionsProvider.getInstance(this.myProject).getStartingDirectory();
    }

    @Override
    protected ProcessHandler createProcessHandler(PtyProcess process) {
        return new PtyProcessHandler(process, this.getShellPath());
    }

    @Override
    @NotNull
    protected TtyConnector createTtyConnector(final @NotNull PtyProcess process) {
        if (process == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(7);
        }
        return new PtyProcessTtyConnector(process, this.myDefaultCharset){

            public void close() {
                if (process instanceof UnixPtyProcess) {
                    ((UnixPtyProcess)process).hangup();
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                        if (process.isAlive()) {
                            LOG.info("Terminal hasn't been terminated by SIGHUP, performing default termination");
                            process.destroy();
                        }
                    }, 1000L, TimeUnit.MILLISECONDS);
                } else {
                    process.destroy();
                }
            }

            public void resize(@NotNull Dimension termWinSize) {
                if (termWinSize == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resize to " + termWinSize);
                }
                super.resize(termWinSize);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termWinSize", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$1", "resize"));
            }
        };
    }

    @Override
    public String runningTargetName() {
        return "Local Terminal";
    }

    @Override
    protected String getTerminalConnectionName(PtyProcess process) {
        return "Local Terminal";
    }

    @NotNull
    public List<String> getInitialCommand(@NotNull Map<String, String> envs) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(8);
        }
        String shellPath2 = this.getShellPath();
        return LocalTerminalDirectRunner.getCommand(shellPath2, envs, TerminalOptionsProvider.getInstance().getShellIntegration());
    }

    @NotNull
    private String getShellPath() {
        String string = TerminalProjectOptionsProvider.getInstance(this.myProject).getShellPath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static List<String> getCommand(@NotNull String shellPath2, @NotNull Map<String, String> envs, boolean shellIntegration) {
        String rcFilePath;
        if (shellPath2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(10);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(11);
        }
        if (SystemInfo.isWindows) {
            List list = ParametersListUtil.parse((String)shellPath2, (boolean)false, (boolean)false);
            if (list == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(12);
            }
            return list;
        }
        List command = ParametersListUtil.parse((String)shellPath2, (boolean)false, (boolean)true);
        String shellCommand = (String)ContainerUtil.getFirstItem((List)command);
        if (shellCommand == null) {
            List list = command;
            if (list == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(13);
            }
            return list;
        }
        command.remove(0);
        String shellName = PathUtil.getFileName((String)shellCommand);
        if (!LocalTerminalDirectRunner.containsLoginOrInteractiveOption(command)) {
            if (LocalTerminalDirectRunner.isLoginOptionAvailable(shellName) && SystemInfo.isMac) {
                command.add(LOGIN_CLI_OPTION);
            }
            if (LocalTerminalDirectRunner.isInteractiveOptionAvailable(shellName)) {
                command.add(INTERACTIVE_CLI_OPTION);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(shellCommand);
        String string = rcFilePath = shellIntegration ? LocalTerminalDirectRunner.findRCFile(shellName) : null;
        if (rcFilePath != null) {
            if (shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME)) {
                LocalTerminalDirectRunner.addRcFileArgument(envs, command, result, rcFilePath, "--rcfile");
                boolean loginShell = command.removeAll((Collection<?>)LOGIN_CLI_OPTIONS);
                LocalTerminalDirectRunner.setLoginShellEnv(envs, loginShell);
            } else if (shellName.equals(ZSH_NAME)) {
                String zdotdir = envs.get(ZDOTDIR);
                if (StringUtil.isNotEmpty((String)zdotdir)) {
                    envs.put("_INTELLIJ_ORIGINAL_ZDOTDIR", zdotdir);
                }
                envs.put(ZDOTDIR, PathUtil.getParentPath((String)rcFilePath));
            } else if (shellName.equals(FISH_NAME)) {
                String xdgConfig = (String)EnvironmentUtil.getEnvironmentMap().get(XDG_CONFIG_HOME);
                if (StringUtil.isNotEmpty((String)xdgConfig)) {
                    File fishConfig = new File(new File(FileUtil.expandUserHome((String)xdgConfig), FISH_NAME), "config.fish");
                    if (fishConfig.exists()) {
                        envs.put(JEDITERM_USER_RCFILE, fishConfig.getAbsolutePath());
                    }
                    envs.put("OLD_XDG_CONFIG_HOME", xdgConfig);
                }
                envs.put(XDG_CONFIG_HOME, new File(rcFilePath).getParentFile().getParent());
            }
            LocalTerminalDirectRunner.setLoginShellEnv(envs, LocalTerminalDirectRunner.isLogin(command));
        }
        result.addAll(command);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static boolean isLoginOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(15);
        }
        return LocalTerminalDirectRunner.isBashZshFish(shellName);
    }

    private static boolean isInteractiveOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(16);
        }
        return LocalTerminalDirectRunner.isBashZshFish(shellName);
    }

    private static boolean isBashZshFish(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(17);
        }
        return shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME) || shellName.equals(ZSH_NAME) || shellName.equals(FISH_NAME);
    }

    private static void setLoginShellEnv(@NotNull Map<String, String> envs, boolean loginShell) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(18);
        }
        if (loginShell) {
            envs.put(LOGIN_SHELL, "1");
        }
    }

    private static void addRcFileArgument(Map<String, String> envs, List<String> command, List<String> result, String rcFilePath, String rcfileOption) {
        result.add(rcfileOption);
        result.add(rcFilePath);
        int idx = command.indexOf(rcfileOption);
        if (idx >= 0) {
            command.remove(idx);
            if (idx < command.size()) {
                envs.put(JEDITERM_USER_RCFILE, FileUtil.expandUserHome((String)command.get(idx)));
                command.remove(idx);
            }
        }
    }

    private static boolean containsLoginOrInteractiveOption(List<String> command) {
        return LocalTerminalDirectRunner.isLogin(command) || command.contains(INTERACTIVE_CLI_OPTION);
    }

    private static boolean isLogin(@NotNull List<String> command) {
        if (command == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(19);
        }
        return command.stream().anyMatch(arg_0 -> LOGIN_CLI_OPTIONS.contains(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userEnvs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultEnvs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAbsolutePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRCFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findAbsolutePath";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupWslEnv";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCommand";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLoginOptionAvailable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveOptionAvailable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBashZshFish";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setLoginShellEnv";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isLogin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PtyProcessHandler
    extends ProcessHandler
    implements TaskExecutor {
        private final PtyProcess myProcess;
        private final ProcessWaitFor myWaitFor;

        PtyProcessHandler(PtyProcess process, @NotNull String presentableName) {
            if (presentableName == null) {
                PtyProcessHandler.$$$reportNull$$$0(0);
            }
            this.myProcess = process;
            this.myWaitFor = new ProcessWaitFor((Process)process, (TaskExecutor)this, presentableName);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        myWaitFor.setTerminationCallback(integer -> this.notifyProcessTerminated(integer));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler$1", "startNotified"));
                }
            });
            super.startNotify();
        }

        protected void destroyProcessImpl() {
            this.myProcess.destroy();
        }

        protected void detachProcessImpl() {
            this.destroyProcessImpl();
        }

        public boolean detachIsDefault() {
            return false;
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            if (task == null) {
                PtyProcessHandler.$$$reportNull$$$0(1);
            }
            Future<?> future = AppExecutorUtil.getAppExecutorService().submit(task);
            if (future == null) {
                PtyProcessHandler.$$$reportNull$$$0(2);
            }
            return future;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "executeTask";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

