/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.dvcs.commit.AmendCommitService;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/checkin/GitAmendCommitService;", "Lcom/intellij/dvcs/commit/AmendCommitService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getCommitMessageFormatPattern", "", "Lorg/jetbrains/annotations/NonNls;", "getLastCommitMessage", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAmendCommitSupported", "", "intellij.vcs.git"})
public final class GitAmendCommitService
extends AmendCommitService {
    public boolean isAmendCommitSupported() {
        return true;
    }

    @NotNull
    public String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitLineHandler h2 = new GitLineHandler(this.getProject(), root, GitCommand.LOG);
        h2.addParameters("--max-count=1");
        h2.addParameters("--encoding=UTF-8");
        h2.addParameters("--pretty=format:" + this.getCommitMessageFormatPattern());
        String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        return string;
    }

    private final String getCommitMessageFormatPattern() {
        return GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(this.getProject()) ? "%B" : "%s%n%n%-b";
    }

    public GitAmendCommitService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }
}

