/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitMergeSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import git4idea.merge.GitMergeDialogKt;
import git4idea.merge.GitMergeOption;
import git4idea.merge.dialog.CmdLabel;
import git4idea.merge.dialog.FlatComboBoxUI;
import git4idea.merge.dialog.GitOptionsPanel;
import git4idea.merge.dialog.GitOptionsPopupBuilder;
import git4idea.merge.dialog.OptionInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitRepositoryReader;
import git4idea.ui.ComboBoxWithAutoCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComboBoxUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 b2\u00020\u0001:\u0001bB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010/\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\u00070\nH\u0002J\u0016\u00100\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\u0011H\u0002J\b\u00101\u001a\u00020\u0013H\u0014J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0013H\u0002J\b\u00105\u001a\u00020\u0013H\u0002J\u0018\u00106\u001a\u0012\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b807H\u0002J\b\u00109\u001a\u00020\u0013H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0002J\u0016\u0010;\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0'H\u0002J\b\u0010<\u001a\u00020=H\u0014J\b\u0010>\u001a\u00020?H\u0014J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u0007H\u0014J\u0013\u0010B\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\u0007H\u0002J\b\u0010C\u001a\u00020\rH\u0007J\b\u0010D\u001a\u00020\rH\u0014J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001e2\u0006\u0010F\u001a\u00020\u001dH\u0002J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007H\u0002J\u0016\u0010H\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\u0011H\u0016J\u0010\u0010I\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020\u0005H\u0002J\u000b\u0010K\u001a\u00070.\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u00020\u000bH\u0002J\u0006\u0010N\u001a\u00020\u0005J\u0010\u0010O\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u001dH\u0002J\u0010\u0010P\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u001dH\u0002J\b\u0010Q\u001a\u00020?H\u0002J\u0018\u0010R\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-2\u0006\u0010S\u001a\u00020\u000bH\u0003J\b\u0010T\u001a\u00020?H\u0002J\u0010\u0010U\u001a\u00020?2\u0006\u0010F\u001a\u00020\u001dH\u0002J\b\u0010V\u001a\u00020?H\u0002J\b\u0010W\u001a\u00020?H\u0002J\u0006\u0010X\u001a\u00020\u0018J\b\u0010Y\u001a\u00020\u0018H\u0002J&\u0010Z\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\u00072\u0011\u0010[\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\u0007H\u0002J\u000f\u0010\\\u001a\t\u0018\u00010.\u00a2\u0006\u0002\bLH\u0002J\b\u0010]\u001a\u00020?H\u0002J\b\u0010^\u001a\u00020?H\u0002J\b\u0010_\u001a\u00020?H\u0002J\b\u0010`\u001a\u00020?H\u0002J\n\u0010a\u001a\u0004\u0018\u00010AH\u0002R2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010$\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00070%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+RN\u0010,\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u00020.\u0018\u00010- \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u00020.\u0018\u00010-\u0018\u00010\n0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lgit4idea/merge/GitMergeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "defaultRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "allBranches", "", "Lgit4idea/repo/GitRepository;", "kotlin.jvm.PlatformType", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "branchField", "Lgit4idea/ui/ComboBoxWithAutoCompletion;", "commandPanel", "Ljavax/swing/JPanel;", "commitMsgField", "Lcom/intellij/ui/components/JBTextArea;", "commitMsgPanel", "isNoVerifySupported", "", "mergeSettings", "Lgit4idea/config/GitMergeSettings;", "optionInfos", "", "Lgit4idea/merge/GitMergeOption;", "Lgit4idea/merge/dialog/OptionInfo;", "optionsPanel", "Lgit4idea/merge/dialog/GitOptionsPanel;", "panel", "popupBuilder", "Lgit4idea/merge/dialog/GitOptionsPopupBuilder;", "repositories", "", "repositoryField", "Lcom/intellij/openapi/ui/ComboBox;", "selectedOptions", "", "getSelectedOptions", "()Ljava/util/Set;", "unmergedBranches", "", "Lgit4idea/GitBranch;", "collectAllBranches", "createBranchField", "createCenterPanel", "createCmdLabel", "Lgit4idea/merge/dialog/CmdLabel;", "createCommandPanel", "createCommitMsgPanel", "createOptionsDropDown", "Lcom/intellij/ui/components/DropDownLink;", "Lorg/jetbrains/annotations/Nls;", "createPanel", "createPopupBuilder", "createRepoField", "createSouthPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getBranches", "getCommitMessage", "getHelpId", "getOptionInfo", "option", "getOptions", "getPreferredFocusedComponent", "getRepository", "root", "getSelectedBranch", "Lorg/jetbrains/annotations/Nullable;", "getSelectedRepository", "getSelectedRoot", "isOptionEnabled", "isOptionSelected", "loadSettings", "loadUnmergedBranchesForRoot", "repository", "loadUnmergedBranchesInBackground", "optionChosen", "rerender", "saveSettings", "shouldCommitAfterMerge", "showRootField", "splitAndSortBranches", "branches", "tryGetSelectedBranch", "updateBranchesField", "updateCommitMessagePanel", "updateDialogTitle", "updateUi", "validateBranchField", "Companion", "intellij.vcs.git"})
public final class GitMergeDialog
extends DialogWrapper {
    @NotNull
    private final Set<GitMergeOption> selectedOptions;
    private final GitMergeSettings mergeSettings;
    private final List<GitRepository> repositories;
    private final Map<GitRepository, List<String>> allBranches;
    private final Map<GitRepository, Set<GitBranch>> unmergedBranches;
    private final Map<GitMergeOption, OptionInfo<GitMergeOption>> optionInfos;
    private final GitOptionsPopupBuilder<GitMergeOption> popupBuilder;
    private final ComboBox<GitRepository> repositoryField;
    private final ComboBoxWithAutoCompletion<String> branchField;
    private final JPanel commandPanel;
    private final GitOptionsPanel<GitMergeOption> optionsPanel;
    private final JBTextArea commitMsgField;
    private final JPanel commitMsgPanel;
    private final JPanel panel;
    private final boolean isNoVerifySupported;
    private final Project project;
    private final VirtualFile defaultRoot;
    private final List<VirtualFile> roots;
    private static final Logger LOG;
    private static final String UNMERGED_BRANCHES_FORMAT;
    private static final Pattern BRANCH_NAME_REGEX;
    @NlsSafe
    private static final String REMOTE_REF = "remotes/";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Set<GitMergeOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return this.panel;
    }

    @NotNull
    public ComboBoxWithAutoCompletion<String> getPreferredFocusedComponent() {
        return this.branchField;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object)new Function0<ValidationInfo>(this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitMergeDialog.access$validateBranchField((GitMergeDialog)((Object)this.receiver));
            }
        });
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo validationInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KFunction it = (KFunction)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)((Function0)it).invoke() == null) continue;
            ValidationInfo it$iv$iv = validationInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"super.createSouthPanel()");
        return GitMergeDialogKt.createSouthPanelWithOptionsDropDown(jComponent, this.createOptionsDropDown());
    }

    @NotNull
    protected String getHelpId() {
        return "reference.VersionControl.Git.MergeBranches";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOKAction() {
        try {
            this.saveSettings();
        }
        finally {
            super.doOKAction();
        }
    }

    @NlsSafe
    @NotNull
    public final String getCommitMessage() {
        String string = this.commitMsgField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commitMsgField.text");
        return string;
    }

    @NotNull
    public final VirtualFile getSelectedRoot() {
        Object object = this.repositoryField.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"repositoryField.item");
        VirtualFile virtualFile = ((GitRepository)object).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repositoryField.item.root");
        return virtualFile;
    }

    @NotNull
    public final GitBranch getSelectedBranch() {
        GitBranch gitBranch = this.tryGetSelectedBranch();
        if (gitBranch == null) {
            Object object = this.branchField.getText();
            Object object2 = object;
            if (object2 == null) {
                object2 = "";
            }
            object = "Unable to find branch: " + (String)object2;
            throw new IllegalStateException(object.toString());
        }
        return gitBranch;
    }

    private final GitBranch tryGetSelectedBranch() {
        GitBranchesCollection gitBranchesCollection = this.getSelectedRepository().getBranches();
        String string = this.branchField.getText();
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return gitBranchesCollection.findBranchByName(string2);
    }

    public final boolean shouldCommitAfterMerge() {
        return !this.isOptionSelected(GitMergeOption.NO_COMMIT);
    }

    private final void saveSettings() {
        this.mergeSettings.setBranch(this.branchField.getText());
        this.mergeSettings.setOptions(this.selectedOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadSettings() {
        void $this$filterTo$iv$iv;
        this.branchField.setItem(this.mergeSettings.getBranch());
        Set<GitMergeOption> set = this.mergeSettings.getOptions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mergeSettings.options");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitMergeOption option = (GitMergeOption)((Object)element$iv$iv);
            boolean bl = false;
            if (!(option != GitMergeOption.NO_VERIFY || this.isNoVerifySupported)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitMergeOption option = (GitMergeOption)((Object)element$iv);
            boolean bl = false;
            Collection collection = this.selectedOptions;
            collection.add(option);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, List<String>> collectAllBranches() {
        List<GitRepository> list2 = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
        Iterable $this$associateWith$iv = list2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void repo;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            void v1 = repo;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"repo");
            Object object = v1.getBranches();
            GitBranchesCollection it = object;
            boolean $i$a$-let-GitMergeDialog$collectAllBranches$1$22 = false;
            GitBranchesCollection gitBranchesCollection = it;
            Intrinsics.checkNotNullExpressionValue((Object)gitBranchesCollection, (String)"it");
            Collection<GitLocalBranch> collection = gitBranchesCollection.getLocalBranches();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"it.localBranches");
            Collection<GitRemoteBranch> collection2 = it.getRemoteBranches();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"it.remoteBranches");
            object = CollectionsKt.plus(collection, (Iterable)collection2);
            boolean $i$f$map = false;
            void $i$a$-let-GitMergeDialog$collectAllBranches$1$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                GitBranch gitBranch = (GitBranch)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl2 = false;
                void v5 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                String string = v5.getName();
                collection3.add(string);
            }
            List list3 = (List)destination$iv$iv;
            map2.put(t, list3);
        }
        return result$iv;
    }

    private final void loadUnmergedBranchesInBackground() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, this.project, GitBundle.message("merge.branch.loading.branches.progress", new Object[0]), true){
            final /* synthetic */ GitMergeDialog this$0;

            public void run(@NotNull ProgressIndicator indicator) {
                LinkedHashSet<VirtualFile> linkedHashSet;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                LinkedHashSet<VirtualFile> $this$apply = linkedHashSet = new LinkedHashSet<VirtualFile>(GitMergeDialog.access$getRoots$p(this.this$0).size());
                boolean bl = false;
                $this$apply.add(GitMergeDialog.access$getDefaultRoot$p(this.this$0));
                $this$apply.addAll(GitMergeDialog.access$getRoots$p(this.this$0));
                LinkedHashSet<VirtualFile> sortedRoots = linkedHashSet;
                Iterable $this$forEach$iv = sortedRoots;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Set set;
                    VirtualFile root = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    GitRepository repository = GitMergeDialog.access$getRepository(this.this$0, root);
                    if (GitMergeDialog.access$loadUnmergedBranchesForRoot(this.this$0, repository) == null) continue;
                    Set branches2 = set;
                    boolean bl3 = false;
                    Map map2 = GitMergeDialog.access$getUnmergedBranches$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"unmergedBranches");
                    map2.put(repository, branches2);
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        });
    }

    @RequiresBackgroundThread
    private final Set<GitBranch> loadUnmergedBranchesForRoot(GitRepository repository) {
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
        VirtualFile root = virtualFile;
        try {
            GitLineHandler handler = new GitLineHandler(this.project, root, GitCommand.BRANCH);
            handler.addParameters(UNMERGED_BRANCHES_FORMAT, "--no-color", "--all", "--no-merged");
            GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().runCommand(handler)");
            GitCommandResult result2 = gitCommandResult;
            result2.throwOnError(new int[0]);
            Collection<GitRemote> collection = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.remotes");
            Collection<GitRemote> remotes = collection;
            List<String> list2 = result2.getOutput();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"result.output");
            return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)loadUnmergedBranchesForRoot.1.INSTANCE), (Function1)((Function1)new Function1<String, GitBranch>(remotes){
                final /* synthetic */ Collection $remotes;

                @Nullable
                public final GitBranch invoke(@NotNull String refName) {
                    Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
                    return GitRepositoryReader.parseBranchRef(this.$remotes, refName);
                }
                {
                    this.$remotes = collection;
                    super(1);
                }
            })));
        }
        catch (Exception e) {
            LOG.warn("Failed to load unmerged branches for root: " + root, (Throwable)e);
            return null;
        }
    }

    private final ValidationInfo validateBranchField() {
        boolean selectedBranchMerged;
        String string = GitBundle.message("merge.no.branch.selected.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"merge\u2026o.branch.selected.error\")");
        ValidationInfo validationInfo = GitMergeDialogKt.validateBranchExists(this.branchField, string);
        if (validationInfo != null) {
            return validationInfo;
        }
        GitBranch gitBranch = this.tryGetSelectedBranch();
        if (gitBranch == null) {
            return new ValidationInfo(GitBundle.message("merge.no.matching.branch.error", new Object[0]));
        }
        GitBranch selectedBranch = gitBranch;
        GitRepository selectedRepository = this.getSelectedRepository();
        Set<GitBranch> set = this.unmergedBranches.get(selectedRepository);
        if (set == null) {
            return null;
        }
        Set<GitBranch> unmergedBranches = set;
        boolean bl = selectedBranchMerged = !unmergedBranches.contains(selectedBranch);
        if (selectedBranchMerged) {
            return new ValidationInfo(GitBundle.message("merge.branch.already.merged", selectedBranch), (JComponent)((Object)this.branchField));
        }
        return null;
    }

    private final void updateBranchesField() {
        String branchToSelect = (String)this.branchField.getItem();
        List<String> branches2 = this.splitAndSortBranches(this.getBranches());
        ComboBoxModel comboBoxModel = this.branchField.getModel();
        if (comboBoxModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<kotlin.String!>");
        }
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        model.update(branches2);
        if (branchToSelect == null || !branches2.contains(branchToSelect)) {
            String string;
            Object v2;
            List<String> list2;
            block6: {
                GitRepository repository = this.getSelectedRepository();
                GitBranch gitBranch = repository.getCurrentBranch();
                String currentRemoteBranch = gitBranch != null && (gitBranch = ((GitLocalBranch)gitBranch).findTrackedBranch(repository)) != null ? ((GitRemoteBranch)gitBranch).getNameForRemoteOperations() : null;
                List<String> list3 = list2 = (List<String>)branches2;
                for (Object t : list3) {
                    String branch = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)branch, (Object)currentRemoteBranch)) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            if ((string = (String)v2) == null) {
                String string2;
                int n = 0;
                list2 = branches2;
                if (n <= CollectionsKt.getLastIndex(list2)) {
                    string2 = list2.get(n);
                } else {
                    int it = n;
                    boolean bl = false;
                    string2 = "";
                }
                string = string2;
            }
            branchToSelect = string;
        }
        this.branchField.setItem(branchToSelect);
        this.branchField.selectAll();
    }

    private final List<String> splitAndSortBranches(List<String> branches2) {
        List local = new ArrayList();
        List remote = new ArrayList();
        for (String branch : branches2) {
            Collection collection;
            if (StringsKt.startsWith$default((String)branch, (String)REMOTE_REF, (boolean)false, (int)2, null)) {
                collection = remote;
                String string = branch;
                int n = REMOTE_REF.length();
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = string2;
                collection.add(string);
                continue;
            }
            collection = local;
            collection.add(branch);
        }
        List<String> list2 = GitBranchUtil.sortBranchNames(local);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"GitBranchUtil.sortBranchNames(local)");
        Collection collection = list2;
        List<String> list3 = GitBranchUtil.sortBranchNames(remote);
        Intrinsics.checkNotNullExpressionValue(list3, (String)"GitBranchUtil.sortBranchNames(remote)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list3);
    }

    private final List<String> getBranches() {
        GitRepository repository = this.getSelectedRepository();
        List list2 = this.allBranches.get(repository);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final GitRepository getRepository(VirtualFile root) {
        Object v2;
        Object object;
        block2: {
            List<GitRepository> list2 = this.repositories;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
            object = list2;
            Iterable iterable = object;
            for (Object t : iterable) {
                GitRepository repo = (GitRepository)t;
                boolean bl = false;
                GitRepository gitRepository = repo;
                Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                if (!Intrinsics.areEqual((Object)gitRepository.getRoot(), (Object)root)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        GitRepository gitRepository = v2;
        if (gitRepository == null) {
            object = "Unable to find repository for root: " + root.getPresentableUrl();
            throw new IllegalStateException(object.toString());
        }
        return gitRepository;
    }

    private final GitRepository getSelectedRepository() {
        return this.getRepository(this.getSelectedRoot());
    }

    private final void updateDialogTitle() {
        String currentBranchName = this.getSelectedRepository().getCurrentBranchName();
        CharSequence charSequence = currentBranchName;
        this.setTitle(charSequence == null || charSequence.length() == 0 ? GitBundle.message("merge.branch.title", new Object[0]) : GitBundle.message("merge.branch.into.current.title", currentBranchName));
    }

    private final JPanel createPanel() {
        JPanel jPanel;
        JPanel $this$apply = jPanel = new JPanel();
        boolean bl = false;
        $this$apply.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3), new AC().grow()));
        $this$apply.add((Component)this.commandPanel, new CC().growX());
        $this$apply.add((Component)this.optionsPanel, new CC().newline().width("100%").alignY("top"));
        $this$apply.add((Component)this.commitMsgPanel, new CC().newline().push().grow());
        return jPanel;
    }

    private final boolean showRootField() {
        return this.roots.size() > 1;
    }

    private final JPanel createCommandPanel() {
        JPanel jPanel;
        JPanel $this$apply = jPanel = new JPanel();
        boolean bl = false;
        AC colConstraints = this.showRootField() ? new AC().grow(100.0f, new int[]{0, 2}) : new AC().grow(100.0f, new int[]{1});
        $this$apply.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").gridGap("0", "0").noVisualPadding(), colConstraints));
        if (this.showRootField()) {
            $this$apply.add((Component)this.repositoryField, new CC().gapAfter("0").minWidth(JBUI.scale((int)135) + "px").growX());
        }
        $this$apply.add((Component)this.createCmdLabel(), new CC().gapAfter("0").alignY("top").minWidth(JBUI.scale((int)100) + "px"));
        $this$apply.add((Component)((Object)this.branchField), new CC().alignY("top").minWidth(JBUI.scale((int)300) + "px").growX());
        return jPanel;
    }

    private final ComboBox<GitRepository> createRepoField() {
        ComboBox<GitRepository> comboBox;
        List<GitRepository> list2 = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
        ComboBox<GitRepository> $this$apply = comboBox = GitMergeDialogKt.createRepositoryField(list2, this.defaultRoot);
        boolean bl = false;
        $this$apply.addItemListener(new ItemListener(this){
            final /* synthetic */ GitMergeDialog this$0;
            {
                this.this$0 = gitMergeDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1 && e.getItem() != null) {
                    GitMergeDialog.access$updateDialogTitle(this.this$0);
                    GitMergeDialog.access$updateBranchesField(this.this$0);
                }
            }
        });
        return comboBox;
    }

    private final CmdLabel createCmdLabel() {
        return new CmdLabel("git merge", new Insets(1, this.showRootField() ? 0 : 1, 1, 0), (Dimension)new JBDimension(JBUI.scale((int)100), this.branchField.getPreferredSize().height, true));
    }

    private final ComboBoxWithAutoCompletion<String> createBranchField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$apply = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel((List)new ArrayList()), this.project);
        boolean bl = false;
        $this$apply.setPrototypeDisplayValue("origin/long-enough-branch-name");
        String string = GitBundle.message("merge.branch.field.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"merge\u2026ranch.field.placeholder\")");
        $this$apply.setPlaceholder(string);
        Insets insets = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), DarculaUIUtil.BW.get());
        String string2 = GitBundle.message("merge.branch.popup.empty.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"merge.branch.popup.empty.text\")");
        $this$apply.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, insets, string2, null, 9, null)));
        return comboBoxWithAutoCompletion;
    }

    private final JPanel createCommitMsgPanel() {
        JPanel jPanel;
        JPanel $this$apply = jPanel = new JPanel();
        boolean bl = false;
        $this$apply.setLayout((LayoutManager)new MigLayout(new LC().insets("0").fill()));
        $this$apply.setVisible(false);
        $this$apply.add((Component)new JLabel(GitBundle.message("merge.commit.message.label", new Object[0])), new CC().alignY("top").wrap());
        $this$apply.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.commitMsgField), (int)20, (int)30), new CC().alignY("top").grow().push().minHeight(JBUI.scale((int)75) + "px"));
        return jPanel;
    }

    private final GitOptionsPopupBuilder<GitMergeOption> createPopupBuilder() {
        String string = GitBundle.message("merge.options.modify.popup.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"merge\u2026ions.modify.popup.title\")");
        return new GitOptionsPopupBuilder<GitMergeOption>(this.project, string, (Function0)new Function0<List<? extends GitMergeOption>>(this){

            @NotNull
            public final List<GitMergeOption> invoke() {
                return GitMergeDialog.access$getOptions((GitMergeDialog)((Object)this.receiver));
            }
        }, (Function1)new Function1<GitMergeOption, OptionInfo<GitMergeOption>>(this){

            @NotNull
            public final OptionInfo<GitMergeOption> invoke(@NotNull GitMergeOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitMergeDialog.access$getOptionInfo((GitMergeDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitMergeOption, Boolean>(this){

            public final boolean invoke(@NotNull GitMergeOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitMergeDialog.access$isOptionSelected((GitMergeDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitMergeOption, Boolean>(this){

            public final boolean invoke(@NotNull GitMergeOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitMergeDialog.access$isOptionEnabled((GitMergeDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitMergeOption, Unit>(this){

            public final void invoke(@NotNull GitMergeOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                GitMergeDialog.access$optionChosen((GitMergeDialog)((Object)this.receiver), p1);
            }
        }, null, 128, null);
    }

    private final DropDownLink<String> createOptionsDropDown() {
        DropDownLink dropDownLink;
        DropDownLink $this$apply = dropDownLink = new DropDownLink((Object)GitBundle.message("merge.options.modify", new Object[0]), (Function1)new Function1<DropDownLink<String>, JBPopup>(this){
            final /* synthetic */ GitMergeDialog this$0;

            @NotNull
            public final JBPopup invoke(@NotNull DropDownLink<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (JBPopup)GitMergeDialog.access$getPopupBuilder$p(this.this$0).createPopup();
            }
            {
                this.this$0 = gitMergeDialog;
                super(1);
            }
        });
        boolean bl = false;
        $this$apply.setMnemonic(77);
        return dropDownLink;
    }

    private final boolean isOptionSelected(GitMergeOption option) {
        return this.selectedOptions.contains((Object)option);
    }

    private final OptionInfo<GitMergeOption> getOptionInfo(GitMergeOption option) {
        OptionInfo<GitMergeOption> optionInfo = this.optionInfos.computeIfAbsent(option, new Function(option){
            final /* synthetic */ GitMergeOption $option;

            @NotNull
            public final OptionInfo<GitMergeOption> apply(@NotNull GitMergeOption it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return new OptionInfo<GitMergeOption>(this.$option, this.$option.getOption(), this.$option.getDescription());
            }
            {
                this.$option = gitMergeOption;
            }
        });
        Intrinsics.checkNotNullExpressionValue(optionInfo, (String)"optionInfos.computeIfAbs\u2026, option.description)\n  }");
        return optionInfo;
    }

    private final List<GitMergeOption> getOptions() {
        List list2;
        List $this$apply = list2 = ArraysKt.toMutableList((Object[])GitMergeOption.values());
        boolean bl = false;
        if (!this.isNoVerifySupported) {
            $this$apply.remove((Object)GitMergeOption.NO_VERIFY);
        }
        return list2;
    }

    private final boolean isOptionEnabled(GitMergeOption option) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.selectedOptions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GitMergeOption it = (GitMergeOption)((Object)element$iv);
                    boolean bl2 = false;
                    if (it.isOptionSuitable(option)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void optionChosen(GitMergeOption option) {
        if (!this.isOptionSelected(option)) {
            Collection collection = this.selectedOptions;
            collection.add(option);
        } else {
            Collection collection = this.selectedOptions;
            collection.remove((Object)option);
        }
        this.updateUi();
    }

    private final void updateUi() {
        this.optionsPanel.rerender(this.selectedOptions);
        this.updateCommitMessagePanel();
        this.rerender();
    }

    private final void rerender() {
        this.getWindow().pack();
        this.getWindow().revalidate();
        this.pack();
        this.repaint();
    }

    private final void updateCommitMessagePanel() {
        boolean useCommitMsg = this.isOptionSelected(GitMergeOption.COMMIT_MESSAGE);
        this.commitMsgPanel.setVisible(useCommitMsg);
        if (!useCommitMsg) {
            this.commitMsgField.setText("");
        }
    }

    public GitMergeDialog(@NotNull Project project, @NotNull VirtualFile defaultRoot, @NotNull List<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)defaultRoot, (String)"defaultRoot");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        super(project);
        this.project = project;
        this.defaultRoot = defaultRoot;
        this.roots = roots;
        this.selectedOptions = new LinkedHashSet();
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitMergeSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        this.mergeSettings = (GitMergeSettings)object;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
        this.repositories = DvcsUtil.sortRepositories((Collection)gitRepositoryManager.getRepositories());
        this.allBranches = this.collectAllBranches();
        this.unmergedBranches = Collections.synchronizedMap(new HashMap());
        this.optionInfos = new LinkedHashMap();
        this.popupBuilder = this.createPopupBuilder();
        this.repositoryField = this.createRepoField();
        this.branchField = this.createBranchField();
        this.commandPanel = this.createCommandPanel();
        this.optionsPanel = new GitOptionsPanel((Function1)new Function1<GitMergeOption, Unit>(this){

            public final void invoke(@NotNull GitMergeOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                GitMergeDialog.access$optionChosen((GitMergeDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitMergeOption, OptionInfo<GitMergeOption>>(this){

            @NotNull
            public final OptionInfo<GitMergeOption> invoke(@NotNull GitMergeOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitMergeDialog.access$getOptionInfo((GitMergeDialog)((Object)this.receiver), p1);
            }
        });
        this.commitMsgField = new JBTextArea("");
        this.commitMsgPanel = this.createCommitMsgPanel();
        this.panel = this.createPanel();
        this.isNoVerifySupported = GitVersionSpecialty.NO_VERIFY_SUPPORTED.existsIn(GitExecutableManager.getInstance().getVersion(this.project));
        this.loadUnmergedBranchesInBackground();
        this.updateDialogTitle();
        this.setOKButtonText(GitBundle.message("merge.action.name", new Object[0]));
        this.loadSettings();
        this.updateBranchesField();
        this.init();
        this.updateUi();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitMergeDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        UNMERGED_BRANCHES_FORMAT = "--format=%(refname) [%(symref)]";
        BRANCH_NAME_REGEX = Pattern.compile("(\\S+) \\[]");
    }

    public static final /* synthetic */ ValidationInfo access$validateBranchField(GitMergeDialog $this) {
        return $this.validateBranchField();
    }

    public static final /* synthetic */ List access$getRoots$p(GitMergeDialog $this) {
        return $this.roots;
    }

    public static final /* synthetic */ VirtualFile access$getDefaultRoot$p(GitMergeDialog $this) {
        return $this.defaultRoot;
    }

    public static final /* synthetic */ GitRepository access$getRepository(GitMergeDialog $this, VirtualFile root) {
        return $this.getRepository(root);
    }

    public static final /* synthetic */ Set access$loadUnmergedBranchesForRoot(GitMergeDialog $this, GitRepository repository) {
        return $this.loadUnmergedBranchesForRoot(repository);
    }

    public static final /* synthetic */ Map access$getUnmergedBranches$p(GitMergeDialog $this) {
        return $this.unmergedBranches;
    }

    public static final /* synthetic */ Pattern access$getBRANCH_NAME_REGEX$cp() {
        return BRANCH_NAME_REGEX;
    }

    public static final /* synthetic */ void access$updateDialogTitle(GitMergeDialog $this) {
        $this.updateDialogTitle();
    }

    public static final /* synthetic */ void access$updateBranchesField(GitMergeDialog $this) {
        $this.updateBranchesField();
    }

    public static final /* synthetic */ List access$getOptions(GitMergeDialog $this) {
        return $this.getOptions();
    }

    public static final /* synthetic */ OptionInfo access$getOptionInfo(GitMergeDialog $this, GitMergeOption option) {
        return $this.getOptionInfo(option);
    }

    public static final /* synthetic */ boolean access$isOptionSelected(GitMergeDialog $this, GitMergeOption option) {
        return $this.isOptionSelected(option);
    }

    public static final /* synthetic */ boolean access$isOptionEnabled(GitMergeDialog $this, GitMergeOption option) {
        return $this.isOptionEnabled(option);
    }

    public static final /* synthetic */ void access$optionChosen(GitMergeDialog $this, GitMergeOption option) {
        $this.optionChosen(option);
    }

    public static final /* synthetic */ GitOptionsPopupBuilder access$getPopupBuilder$p(GitMergeDialog $this) {
        return $this.popupBuilder;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002\u00a8\u0006\r"}, d2={"Lgit4idea/merge/GitMergeDialog$Companion;", "", "()V", "BRANCH_NAME_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REMOTE_REF", "", "UNMERGED_BRANCHES_FORMAT", "getUNMERGED_BRANCHES_FORMAT$annotations", "intellij.vcs.git"})
    public static final class Companion {
        private static /* synthetic */ void getUNMERGED_BRANCHES_FORMAT$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

