/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.uploader;

import com.google.gson.Gson;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalSendConfig;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.uploader.EventLogExternalUploader;
import com.intellij.internal.statistic.eventLog.uploader.EventLogUploadException;
import com.intellij.internal.statistic.uploader.EventLogUploaderOptions;
import com.intellij.internal.statistic.uploader.events.ExternalEventsLogger;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import com.intellij.internal.statistic.uploader.util.ExtraHTTPHeadersParser;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J(\u0010\u000f\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J9\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0007H\u0002J\u0014\u0010\u001d\u001a\u00020\u00072\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010#\u001a\u00020\u001aH\u0002J\u001e\u0010$\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010&\u001a\u00020!H\u0002J\u0014\u0010'\u001a\u00020\t2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0017J\u001e\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0017H\u0002J+\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00132\f\u0010/\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u00100J\u001c\u00101\u001a\u00020\t2\f\u00102\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u0006\u00103\u001a\u000204R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/internal/statistic/eventLog/uploader/EventLogExternalUploader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "UPLOADER_MAIN_CLASS", "", "addArgument", "", "args", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "name", "value", "addRecorderConfiguration", "config", "Lcom/intellij/internal/statistic/eventLog/EventLogSendConfig;", "createExternalUploadCommand", "", "applicationInfo", "Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "configs", "", "classpath", "tempDir", "Ljava/io/File;", "(Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;Ljava/util/List;Ljava/lang/String;Ljava/io/File;)[Ljava/lang/String;", "findJavaHome", "findLibraryByClass", "clazz", "Ljava/lang/Class;", "findUploader", "Ljava/nio/file/Path;", "getOrCreateTempDir", "getTempFile", "joinAsClasspath", "libCopies", "uploaderCopy", "logPreviousExternalUploadResult", "providers", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "logPreviousExternalUploadResultByRecorder", "recorderId", "events", "Lcom/intellij/internal/statistic/uploader/events/ExternalSystemEvent;", "prepareUploadCommand", "recorders", "(Ljava/util/List;Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;)[Ljava/lang/String;", "startExternalUpload", "recordersProviders", "isTest", "", "intellij.platform.statistics"})
public final class EventLogExternalUploader {
    private static final Logger LOG;
    private static final String UPLOADER_MAIN_CLASS = "com.intellij.internal.statistic.uploader.EventLogUploader";
    @NotNull
    public static final EventLogExternalUploader INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void logPreviousExternalUploadResult(@NotNull List<? extends StatisticsEventLoggerProvider> providers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Iterable $this$filter$iv = providers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isSendEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enabledProviders = (List)destination$iv$iv;
        if (enabledProviders.isEmpty()) {
            return;
        }
        try {
            File tempDir = this.getTempFile();
            if (tempDir.exists()) {
                List<ExternalSystemEvent> list = ExternalEventsLogger.parseEvents(tempDir);
                Intrinsics.checkNotNullExpressionValue(list, (String)"ExternalEventsLogger.parseEvents(tempDir)");
                List<ExternalSystemEvent> events = list;
                for (StatisticsEventLoggerProvider provider : enabledProviders) {
                    this.logPreviousExternalUploadResultByRecorder(provider.getRecorderId(), events);
                }
            }
            FilesKt.deleteRecursively((File)tempDir);
        }
        catch (Exception e) {
            LOG.warn("Failed reading previous upload result: " + e.getMessage());
        }
    }

    private final void logPreviousExternalUploadResultByRecorder(String recorderId, List<? extends ExternalSystemEvent> events) {
        for (ExternalSystemEvent externalSystemEvent : events) {
            String eventRecorderId;
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemEvent.getRecorderId(), (String)"event.recorderId");
            if (Intrinsics.areEqual((Object)eventRecorderId, (Object)recorderId) ^ true && Intrinsics.areEqual((Object)eventRecorderId, (Object)"ALL") ^ true) continue;
            ExternalSystemEvent externalSystemEvent2 = externalSystemEvent;
            if (externalSystemEvent2 instanceof ExternalUploadStartedEvent) {
                EventLogSystemLogger.logStartingExternalSend(recorderId, ((ExternalUploadStartedEvent)externalSystemEvent).getTimestamp());
                continue;
            }
            if (externalSystemEvent2 instanceof ExternalUploadSendEvent) {
                List<Integer> errors;
                List<String> files;
                Intrinsics.checkNotNullExpressionValue(((ExternalUploadSendEvent)externalSystemEvent).getSuccessfullySentFiles(), (String)"event.successfullySentFiles");
                Intrinsics.checkNotNullExpressionValue(((ExternalUploadSendEvent)externalSystemEvent).getErrors(), (String)"event.errors");
                EventLogSystemLogger.logFilesSend(recorderId, ((ExternalUploadSendEvent)externalSystemEvent).getTotal(), ((ExternalUploadSendEvent)externalSystemEvent).getSucceed(), ((ExternalUploadSendEvent)externalSystemEvent).getFailed(), true, files, errors);
                continue;
            }
            if (externalSystemEvent2 instanceof ExternalUploadFinishedEvent) {
                EventLogSystemLogger.logFinishedExternalSend(recorderId, ((ExternalUploadFinishedEvent)externalSystemEvent).getError(), ((ExternalUploadFinishedEvent)externalSystemEvent).getTimestamp());
                continue;
            }
            if (!(externalSystemEvent2 instanceof ExternalSystemErrorEvent)) continue;
            EventLogSystemLogger.logSystemError(recorderId, ((ExternalSystemErrorEvent)externalSystemEvent).getEvent(), ((ExternalSystemErrorEvent)externalSystemEvent).getErrorClass(), ((ExternalSystemErrorEvent)externalSystemEvent).getTimestamp());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void startExternalUpload(@NotNull List<? extends StatisticsEventLoggerProvider> recordersProviders, boolean isTest) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(recordersProviders, (String)"recordersProviders");
        Iterable $this$filter$iv = recordersProviders;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isSendEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enabledRecordersProviders = (List)destination$iv$iv;
        if (enabledRecordersProviders.isEmpty()) {
            LOG.info("Don't start external process because sending logs is disabled for all recorders");
            return;
        }
        Iterable $this$map$iv = enabledRecordersProviders;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StatisticsEventLoggerProvider bl = (StatisticsEventLoggerProvider)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.getRecorderId();
            collection.add(string);
        }
        List recorderIds = (List)destination$iv$iv2;
        EventLogSystemLogger.logCreatingExternalSendCommand(recorderIds);
        EventLogInternalApplicationInfo application = new EventLogInternalApplicationInfo(isTest);
        try {
            Object[] command = this.prepareUploadCommand(enabledRecordersProviders, application);
            EventLogSystemLogger.logFinishedCreatingExternalSendCommand(recorderIds, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting external process: '" + ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "'");
            }
            Runtime.getRuntime().exec((String[])command);
            LOG.info("Started external process for uploading event log");
        }
        catch (EventLogUploadException e) {
            EventLogSystemLogger.logFinishedCreatingExternalSendCommand(recorderIds, e.getErrorType());
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String[] prepareUploadCommand(List<? extends StatisticsEventLoggerProvider> recorders, EventLogApplicationInfo applicationInfo) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = recorders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EventLogInternalSendConfig eventLogInternalSendConfig = EventLogInternalSendConfig.createByRecorder(it.getRecorderId(), false);
            collection.add(eventLogInternalSendConfig);
        }
        List sendConfigs = (List)destination$iv$iv;
        if (sendConfigs.isEmpty()) {
            throw (Throwable)new EventLogUploadException("No available logs to send", EventLogUploadException.EventLogUploadErrorType.NO_LOGS);
        }
        File tempDir = this.getOrCreateTempDir();
        Path uploader = this.findUploader();
        ArrayList<String> libPaths = new ArrayList<String>();
        libPaths.add(this.findLibraryByClass(Continuation.class));
        libPaths.add(this.findLibraryByClass(NotNull.class));
        libPaths.add(this.findLibraryByClass(Gson.class));
        libPaths.add(this.findLibraryByClass(EventGroupsFilterRules.class));
        String classpath = this.joinAsClasspath((List<String>)libPaths, uploader);
        return this.createExternalUploadCommand(applicationInfo, sendConfigs, classpath, tempDir);
    }

    @NotNull
    public final String[] createExternalUploadCommand(@NotNull EventLogApplicationInfo applicationInfo, @NotNull List<? extends EventLogSendConfig> configs, @NotNull String classpath, @NotNull File tempDir) {
        Intrinsics.checkNotNullParameter((Object)applicationInfo, (String)"applicationInfo");
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        ArrayList<String> args = new ArrayList<String>();
        String java = this.findJavaHome();
        Collection collection = args;
        Object object = new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath();
        collection.add(object);
        this.addArgument(args, "-cp", classpath);
        Collection collection2 = args;
        object = "-Djava.io.tmpdir=" + tempDir.getPath();
        collection2.add(object);
        Collection collection3 = args;
        object = UPLOADER_MAIN_CLASS;
        collection3.add(object);
        this.addArgument(args, "--ide-token", ((Object)Paths.get(PathManager.getSystemPath(), "token").toAbsolutePath()).toString());
        this.addArgument(args, "--recorders", CollectionsKt.joinToString$default((Iterable)configs, (CharSequence)";", null, null, (int)0, null, (Function1)createExternalUploadCommand.1.INSTANCE, (int)30, null));
        for (EventLogSendConfig eventLogSendConfig : configs) {
            this.addRecorderConfiguration(args, eventLogSendConfig);
        }
        String string = applicationInfo.getTemplateUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationInfo.templateUrl");
        this.addArgument(args, "--url", string);
        String string2 = applicationInfo.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationInfo.productCode");
        this.addArgument(args, "--product", string2);
        String string3 = applicationInfo.getProductVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"applicationInfo.productVersion");
        this.addArgument(args, "--product-version", string3);
        this.addArgument(args, "--user-agent", applicationInfo.getConnectionSettings().getUserAgent());
        String string4 = ExtraHTTPHeadersParser.serialize(applicationInfo.getConnectionSettings().getExtraHeaders());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ExtraHTTPHeadersParser.s\u2026ttings.getExtraHeaders())");
        this.addArgument(args, "--extra-headers", string4);
        if (applicationInfo.isInternal()) {
            Collection collection4 = args;
            object = "--internal";
            collection4.add(object);
        }
        if (applicationInfo.isTest()) {
            Collection collection5 = args;
            object = "--test";
            collection5.add(object);
        }
        if (applicationInfo.isEAP()) {
            Collection collection6 = args;
            object = "--eap";
            collection6.add(object);
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)args);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ArrayUtil.toStringArray(args)");
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRecorderConfiguration(ArrayList<String> args, EventLogSendConfig config) {
        void $this$mapTo$iv$iv;
        String recorderIdLowerCase = Strings.toLowerCase((String)config.getRecorderId());
        this.addArgument(args, "--device-" + recorderIdLowerCase, config.getDeviceId());
        this.addArgument(args, "--bucket-" + recorderIdLowerCase, String.valueOf(config.getBucket()));
        this.addArgument(args, "--machine-" + recorderIdLowerCase, config.getMachineId().getId());
        this.addArgument(args, "--id-revision-" + recorderIdLowerCase, String.valueOf(config.getMachineId().getRevision()));
        Iterable $this$map$iv = config.getFilesToSendProvider().getFilesToSend();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EventLogFile eventLogFile = (EventLogFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.getFile();
            collection.add(file);
        }
        List filesToSend = (List)destination$iv$iv;
        String string = "--files-" + recorderIdLowerCase;
        Iterable iterable2 = filesToSend;
        String string2 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File.pathSeparator");
        this.addArgument(args, string, CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null));
    }

    private final void addArgument(ArrayList<String> args, String name, String value) {
        Collection collection = args;
        collection.add(name);
        collection = args;
        collection.add(value);
    }

    private final String joinAsClasspath(List<String> libCopies, Path uploaderCopy) {
        if (libCopies.isEmpty()) {
            return ((Object)uploaderCopy).toString();
        }
        Iterable iterable = libCopies;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.pathSeparator");
        String libClassPath = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        return libClassPath + File.pathSeparator + uploaderCopy;
    }

    private final Path findUploader() {
        Path uploader;
        Path path = uploader = PluginManagerCore.isRunningFromSources() ? Paths.get(PathManager.getHomePath(), "out/artifacts/statistics-uploader.jar") : PathManager.getJarForClass(EventLogUploaderOptions.class);
        if (uploader == null || !Files.isRegularFile(uploader, new LinkOption[0])) {
            throw (Throwable)new EventLogUploadException("Cannot find uploader jar", EventLogUploadException.EventLogUploadErrorType.NO_UPLOADER);
        }
        return uploader;
    }

    private final String findLibraryByClass(Class<?> clazz) {
        Path library = PathManager.getJarForClass(clazz);
        if (library == null || !Files.isRegularFile(library, new LinkOption[0])) {
            throw (Throwable)new EventLogUploadException("Cannot find jar for " + clazz, EventLogUploadException.EventLogUploadErrorType.NO_UPLOADER);
        }
        return ((Object)library).toString();
    }

    private final String findJavaHome() {
        String string = System.getProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"java.home\")");
        return string;
    }

    private final File getOrCreateTempDir() {
        File tempDir = this.getTempFile();
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw (Throwable)new EventLogUploadException("Cannot create temp directory: " + tempDir, EventLogUploadException.EventLogUploadErrorType.NO_TEMP_FOLDER);
        }
        return tempDir;
    }

    private final File getTempFile() {
        return new File(PathManager.getTempPath(), "statistics-uploader");
    }

    private EventLogExternalUploader() {
    }

    static {
        EventLogExternalUploader eventLogExternalUploader;
        INSTANCE = eventLogExternalUploader = new EventLogExternalUploader();
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Event\u2026ternalUploader.javaClass)");
        LOG = logger2;
    }
}

