/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class InstrumentationUtils {
    public static final String OBJECT_TYPE = "Ljava/lang/Object;";
    public static final String CLASS_INIT = "<clinit>";
    public static final String CONSTRUCTOR = "<init>";
    public static final String CONSTRUCTOR_DESCRIPTOR = "()V";

    public static void pushInt(MethodVisitor mv, int value) {
        if (value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    public static void incrementIntArrayByIndex(MethodVisitor mv) {
        mv.visitInsn(92);
        mv.visitInsn(46);
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitInsn(79);
    }

    public static int getBytecodeVersion(ClassReader cr) {
        return cr.readInt(4) & 0xFFFF;
    }
}

