/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathEntry {
    private final String myClassPathEntry;
    private static final DirectoryEntryProcessor myDirectoryProcessor = new DirectoryEntryProcessor();
    private static final ZipEntryProcessor myZipProcessor = new ZipEntryProcessor();
    private static final String CLASS_FILE_SUFFIX = ".class";

    public ClassPathEntry(String classPathEntry) {
        this.myClassPathEntry = classPathEntry;
    }

    void iterateMatchedClasses(ClassFilter filter, ClassEntry.Consumer consumer) throws IOException {
        ClassPathEntryProcessor processor = ClassPathEntry.createEntryProcessor(this.myClassPathEntry);
        if (processor == null) {
            return;
        }
        processor.setFilter(filter);
        processor.iterateMatchedClasses(this.myClassPathEntry, consumer);
    }

    private static ClassPathEntryProcessor createEntryProcessor(String entry) {
        File file = new File(entry);
        if (file.isDirectory()) {
            return myDirectoryProcessor;
        }
        if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
            return myZipProcessor;
        }
        return null;
    }

    private static String removeClassSuffix(String name) {
        return name.substring(0, name.length() - CLASS_FILE_SUFFIX.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathEntry that = (ClassPathEntry)o;
        return this.myClassPathEntry.equals(that.myClassPathEntry);
    }

    public int hashCode() {
        return this.myClassPathEntry.hashCode();
    }

    private static class ZipEntryProcessor
    extends AbstractClassPathEntryProcessor {
        private ZipEntryProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void iterateMatchedClasses(String classPathEntry, ClassEntry.Consumer consumer) throws IOException {
            final ZipFile zipFile = new ZipFile(new File(classPathEntry));
            try {
                final InputStream[] is = new InputStream[]{null};
                Enumeration<? extends ZipEntry> zenum = zipFile.entries();
                while (zenum.hasMoreElements()) {
                    String className;
                    ZipEntry ze = zenum.nextElement();
                    if (ze.isDirectory() || !ze.getName().endsWith(ClassPathEntry.CLASS_FILE_SUFFIX) || !this.shouldInclude(className = ClassNameUtil.convertToFQName(ClassPathEntry.removeClassSuffix(ze.getName())))) continue;
                    is[0] = null;
                    try {
                        final ZipEntry zipEntry = ze;
                        consumer.consume(new ClassEntry(className){

                            public InputStream getClassInputStream() throws IOException {
                                is[0] = zipFile.getInputStream(zipEntry);
                                return is[0];
                            }
                        });
                    }
                    finally {
                        CoverageIOUtil.close(is[0]);
                    }
                }
            }
            finally {
                zipFile.close();
            }
        }
    }

    private static class DirectoryEntryProcessor
    extends AbstractClassPathEntryProcessor {
        private DirectoryEntryProcessor() {
        }

        public void iterateMatchedClasses(String classPathEntry, ClassEntry.Consumer consumer) throws IOException {
            File dir = new File(classPathEntry);
            InputStream[] is = new InputStream[]{null};
            this.collectClasses("", dir, consumer, is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectClasses(String curPath, File parent, ClassEntry.Consumer consumer, final InputStream[] is) throws IOException {
            File[] files = parent.listFiles();
            if (files != null) {
                String prefix = curPath.length() == 0 ? "" : curPath + ".";
                for (final File f : files) {
                    String name = f.getName();
                    if (name.endsWith(ClassPathEntry.CLASS_FILE_SUFFIX)) {
                        String className = prefix + ClassPathEntry.removeClassSuffix(name);
                        if (!this.shouldInclude(className)) continue;
                        is[0] = null;
                        try {
                            consumer.consume(new ClassEntry(className){

                                public InputStream getClassInputStream() throws IOException {
                                    is[0] = new FileInputStream(f);
                                    return is[0];
                                }
                            });
                            continue;
                        }
                        finally {
                            CoverageIOUtil.close(is[0]);
                        }
                    }
                    if (!f.isDirectory()) continue;
                    this.collectClasses(prefix + name, f, consumer, is);
                }
            }
        }
    }

    private static interface ClassPathEntryProcessor {
        public void setFilter(ClassFilter var1);

        public void iterateMatchedClasses(String var1, ClassEntry.Consumer var2) throws IOException;
    }

    private static abstract class AbstractClassPathEntryProcessor
    implements ClassPathEntryProcessor {
        private ClassFilter myFilter;

        private AbstractClassPathEntryProcessor() {
        }

        public void setFilter(ClassFilter filter) {
            this.myFilter = filter;
        }

        protected final boolean shouldInclude(String className) {
            return this.myFilter.shouldInclude(className);
        }
    }
}

