/*
 * Decompiled with CFR 0.152.
 */
package circlet.pipelines.config.localM2;

import circlet.pipelines.config.localM2.MavenSettingsXmlParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\n\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\b"}, d2={"findLocalM2RepoPathString", "", "parseFromM2HomeConfSettings", "parseFromUserHomeM2Settings", "parseLocalRepoIfExists", "settingsXml", "Ljava/nio/file/Path;", "readFromSystemProperty", "pipelines-config-local-m2-finder"})
public final class LocalM2RepositoryFinderKt {
    private static final String findLocalM2RepoPathString() {
        String string2 = LocalM2RepositoryFinderKt.readFromSystemProperty();
        if (string2 == null && (string2 = LocalM2RepositoryFinderKt.parseFromUserHomeM2Settings()) == null) {
            String string3 = LocalM2RepositoryFinderKt.parseFromM2HomeConfSettings();
            string2 = string3 == null ? Intrinsics.stringPlus((String)System.getProperty("user.home"), (Object)"/.m2/repository") : string3;
        }
        return string2;
    }

    private static final String readFromSystemProperty() {
        String string2;
        String string3 = System.getProperty("maven.repo.local");
        if (string3 == null) {
            string2 = null;
        } else {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            string2 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
        }
        return string2;
    }

    private static final String parseFromUserHomeM2Settings() {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            return null;
        }
        String userHome = string2;
        Path path2 = Paths.get(Intrinsics.stringPlus((String)userHome, (Object)"/.m2/settings.xml"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        Path userHomeSettingsXml = path2;
        return LocalM2RepositoryFinderKt.parseLocalRepoIfExists(userHomeSettingsXml);
    }

    private static final String parseFromM2HomeConfSettings() {
        Object object;
        Object object2;
        String string2 = System.getenv("M2_HOME");
        if (string2 == null) {
            object2 = null;
        } else {
            object = string2;
            String it = object;
            boolean bl = false;
            object2 = !StringsKt.isBlank((CharSequence)it) ? object : null;
        }
        if (object2 == null) {
            return null;
        }
        Object m2Home = object2;
        object = Paths.get(Intrinsics.stringPlus(m2Home, (Object)"/conf/settings.xml"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(path)");
        Object m2HomeSettingsXml = object;
        return LocalM2RepositoryFinderKt.parseLocalRepoIfExists((Path)m2HomeSettingsXml);
    }

    private static final String parseLocalRepoIfExists(Path settingsXml) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(settingsXml, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? MavenSettingsXmlParser.Companion.parseLocalRepo(settingsXml) : (String)null;
    }

    public static final /* synthetic */ String access$findLocalM2RepoPathString() {
        return LocalM2RepositoryFinderKt.findLocalM2RepoPathString();
    }
}

