/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.changes;

import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.ui.AbstractChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.vcs.changes.SpaceChange;
import com.intellij.space.vcs.changes.SpaceChangeKt;
import com.intellij.space.vcs.changes.SpaceChangesTree;
import com.intellij.space.vcs.changes.SpaceRepository;
import com.intellij.space.vcs.review.SpaceReviewDataKeys;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.FontUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0012\u0010\u001f\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0019J\u001c\u0010#\u001a\u00020\u001d2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020&0%H\u0002J\u0014\u0010'\u001a\u00020\u001d2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ&\u0010(\u001a\u00020\u001d*\u00020)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTree;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_diffPreview", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "_selection", "Lruntime/reactive/MutableProperty;", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/space/vcs/changes/SpaceChange;", "changes", "", "diffPreview", "getDiffPreview", "()Lcom/intellij/openapi/vcs/changes/DiffPreview;", "selection", "Lruntime/reactive/Property;", "getSelection", "()Lruntime/reactive/Property;", "buildTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "getData", "", "dataId", "", "getSelectedNavigatableItems", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "installDiffPreview", "", "rebuildTree", "selectFile", "toSelect", "Lcom/intellij/openapi/vcs/FilePath;", "spaceFilePath", "selectNodeBy", "predicate", "Lkotlin/Function1;", "", "setChanges", "addChanges", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "subtreeRoot", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "SpaceChangeNode", "SpaceRepositoryNode", "intellij.space.vcs"})
public final class SpaceChangesTree
extends ChangesTree {
    private List<SpaceChange> changes;
    private final MutableProperty<ListSelection<SpaceChange>> _selection;
    @NotNull
    private final Property<ListSelection<SpaceChange>> selection;
    private DiffPreview _diffPreview;

    @NotNull
    public final Property<ListSelection<SpaceChange>> getSelection() {
        return this.selection;
    }

    @Nullable
    public final DiffPreview getDiffPreview() {
        return this._diffPreview;
    }

    public final void setChanges(@NotNull List<SpaceChange> changes2) {
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        this.changes = changes2;
        this.rebuildTree();
    }

    public final void installDiffPreview(@NotNull DiffPreview diffPreview) {
        Intrinsics.checkNotNullParameter((Object)diffPreview, (String)"diffPreview");
        this.setDoubleClickHandler(new Processor(this, diffPreview){
            final /* synthetic */ SpaceChangesTree this$0;
            final /* synthetic */ DiffPreview $diffPreview;

            public final boolean process(MouseEvent e) {
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.this$0)), (MouseEvent)e)) {
                    return false;
                }
                this.$diffPreview.performDiffAction();
                return true;
            }
            {
                this.this$0 = spaceChangesTree;
                this.$diffPreview = diffPreview;
            }
        });
        this._diffPreview = diffPreview;
    }

    public void rebuildTree() {
        this.updateTreeModel(this.buildTreeModel());
        if (this.isSelectionEmpty() && !this.isEmpty()) {
            TreeUtil.selectFirstNode((JTree)((JTree)((Object)this)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultTreeModel buildTreeModel() {
        boolean isSingleLocalRepository;
        void $this$groupByTo$iv$iv;
        if (this.changes.isEmpty()) {
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"TreeModelBuilder.buildEmpty()");
            return defaultTreeModel;
        }
        TreeModelBuilder builder = new TreeModelBuilder(this.getProject(), this.getGrouping());
        Iterable $this$groupBy$iv = this.changes;
        boolean bl = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SpaceChange it = (SpaceChange)element$iv$iv;
            boolean bl2 = false;
            SpaceRepository key$iv$iv = it.getRepository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map changesByRepositories = destination$iv$iv;
        SpaceRepository spaceRepository = (SpaceRepository)CollectionsKt.singleOrNull((Iterable)changesByRepositories.keySet());
        boolean bl3 = isSingleLocalRepository = (spaceRepository != null ? spaceRepository.getMapping() : null) != null;
        if (isSingleLocalRepository) {
            ChangesBrowserNode changesBrowserNode = builder.myRoot;
            Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"builder.myRoot");
            this.addChanges(builder, changesBrowserNode, this.changes);
        } else {
            destination$iv$iv = changesByRepositories;
            for (Map.Entry entry : destination$iv$iv.entrySet()) {
                void changeRepository;
                Object object = entry;
                destination$iv$iv = (SpaceRepository)object.getKey();
                object = entry;
                List changes2 = (List)object.getValue();
                SpaceRepositoryNode repositoryNode = new SpaceRepositoryNode(changeRepository.getName(), changeRepository.getMapping() != null);
                builder.insertSubtreeRoot((ChangesBrowserNode)repositoryNode);
                this.addChanges(builder, (ChangesBrowserNode)repositoryNode, changes2);
            }
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"builder.build()");
        return defaultTreeModel;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            object = CollectionsKt.singleOrNull(this.getSelectedNavigatableItems());
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Collection $this$toTypedArray$iv = this.getSelectedNavigatableItems();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new OpenFileDescriptor[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
        } else if (SpaceReviewDataKeys.INSTANCE.getREVIEW_CHANGES$intellij_space_vcs().is(dataId)) {
            object = VcsTreeModelData.selected((JTree)((JTree)((Object)this))).userObjects(SpaceChange.class);
        } else if (EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW.is(dataId)) {
            object = this._diffPreview;
        } else {
            object = super.getData(dataId);
            if (object == null) {
                object = VcsTreeModelData.getData((Project)this.getProject(), (JTree)((JTree)((Object)this)), (String)dataId);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OpenFileDescriptor> getSelectedNavigatableItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List list2 = VcsTreeModelData.selected((JTree)((JTree)((Object)this))).userObjects(SpaceChange.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"VcsTreeModelData.selecte\u2026(SpaceChange::class.java)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        VirtualFile virtualFile = $this$forEach$iv$iv$iv.iterator();
        while (virtualFile.hasNext()) {
            VirtualFile virtualFile2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = virtualFile.next();
            boolean bl = false;
            SpaceChange changeNode = (SpaceChange)element$iv$iv;
            boolean bl2 = false;
            SpaceChange spaceChange = changeNode;
            Intrinsics.checkNotNullExpressionValue((Object)spaceChange, (String)"changeNode");
            if (SpaceChangeKt.getFilePath(spaceChange).getVirtualFile() == null) continue;
            VirtualFile it$iv$iv = virtualFile2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.getProject(), (VirtualFile)it);
            collection.add(openFileDescriptor);
        }
        return (List)destination$iv$iv;
    }

    public void selectFile(@Nullable FilePath toSelect) {
        this.selectNodeBy((Function1<? super SpaceChange, Boolean>)((Function1)new Function1<SpaceChange, Boolean>(toSelect){
            final /* synthetic */ FilePath $toSelect;

            public final boolean invoke(@NotNull SpaceChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)SpaceChangeKt.getFilePath(it), (Object)this.$toSelect);
            }
            {
                this.$toSelect = filePath;
                super(1);
            }
        }));
    }

    public final void selectFile(@NotNull String spaceFilePath) {
        Intrinsics.checkNotNullParameter((Object)spaceFilePath, (String)"spaceFilePath");
        this.selectNodeBy((Function1<? super SpaceChange, Boolean>)((Function1)new Function1<SpaceChange, Boolean>(spaceFilePath){
            final /* synthetic */ String $spaceFilePath;

            public final boolean invoke(@NotNull SpaceChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)SpaceChangeKt.getSpaceFilePath(it), (Object)this.$spaceFilePath);
            }
            {
                this.$spaceFilePath = string2;
                super(1);
            }
        }));
    }

    private final void selectNodeBy(Function1<? super SpaceChange, Boolean> predicate) {
        TreeNode targetNode2 = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)this.getRoot())).traverse(TreeTraversal.POST_ORDER_DFS).find(new Condition(predicate){
            final /* synthetic */ Function1 $predicate;

            public final boolean value(TreeNode it) {
                SpaceChange spaceChange;
                Function1 function1;
                Object object = (SpaceChange)TreeUtil.getUserObject(SpaceChange.class, (Object)it);
                return object != null && (object = (Boolean)(function1 = this.$predicate).invoke((Object)(spaceChange = object))) != null ? (Boolean)object : false;
            }
            {
                this.$predicate = function1;
            }
        });
        if (targetNode2 != null) {
            TreeUtil.selectNode((JTree)((JTree)((Object)this)), (TreeNode)targetNode2);
        }
    }

    private final void addChanges(TreeModelBuilder $this$addChanges, ChangesBrowserNode<?> subtreeRoot, List<SpaceChange> changes2) {
        for (SpaceChange change2 : changes2) {
            $this$addChanges.insertChangeNode((Object)SpaceChangeKt.getFilePath(change2), subtreeRoot, (ChangesBrowserNode)new SpaceChangeNode(change2));
        }
    }

    public SpaceChangesTree(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, false, false);
        this.changes = CollectionsKt.emptyList();
        ListSelection listSelection = ListSelection.empty();
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"ListSelection.empty()");
        this._selection = PropertyKt.mutableProperty(listSelection);
        this.selection = this._selection;
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent it) {
                ListSelection listSelection = VcsTreeModelData.getListSelectionOrAll((JTree)((JTree)((Object)this))).map((NullableFunction)selection.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"VcsTreeModelData.getList\u2026ap { it as? SpaceChange }");
                ListSelection selection2 = listSelection;
                _selection.setValue(selection2);
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTree$SpaceChangeNode;", "Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "Lcom/intellij/space/vcs/changes/SpaceChange;", "spaceChange", "(Lcom/intellij/space/vcs/changes/SpaceChange;)V", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "userObject", "originPath", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.space.vcs"})
    private static final class SpaceChangeNode
    extends AbstractChangesBrowserFilePathNode<SpaceChange> {
        private final SpaceChange spaceChange;

        @NotNull
        protected FilePath filePath(@NotNull SpaceChange userObject) {
            Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
            return SpaceChangeKt.getFilePath(userObject);
        }

        @Nullable
        protected FilePath originPath(@NotNull SpaceChange userObject) {
            Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
            return userObject.getNewFilePath() != null ? userObject.getOldFilePath() : null;
        }

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            super.render(renderer2, selected2, expanded, hasFocus);
            if (this.spaceChange.getUnreachable()) {
                String hash = StringsKt.take((String)this.spaceChange.getGitCommitChange().getRevision(), (int)8);
                renderer2.append(FontUtil.spaceAndThinSpace());
                renderer2.append("[" + hash + "]");
            }
        }

        public SpaceChangeNode(@NotNull SpaceChange spaceChange) {
            Intrinsics.checkNotNullParameter((Object)spaceChange, (String)"spaceChange");
            super((Object)spaceChange, spaceChange.getFileStatus());
            this.spaceChange = spaceChange;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTree$SpaceRepositoryNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserStringNode;", "repositoryName", "", "inCurrentProject", "", "(Ljava/lang/String;Z)V", "getRepositoryName", "()Ljava/lang/String;", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "expanded", "hasFocus", "intellij.space.vcs"})
    private static final class SpaceRepositoryNode
    extends ChangesBrowserStringNode {
        @NotNull
        private final String repositoryName;
        private final boolean inCurrentProject;

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            SimpleTextAttributes style = this.inCurrentProject ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
            renderer2.append(this.repositoryName, style);
        }

        @NotNull
        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public SpaceRepositoryNode(@NlsSafe @NotNull String repositoryName, boolean inCurrentProject) {
            Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
            super(repositoryName);
            this.repositoryName = repositoryName;
            this.inCurrentProject = inCurrentProject;
            this.markAsHelperNode();
        }
    }
}

