/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.diff;

import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.vcs.diff.SpaceDiffModel;
import com.intellij.space.vcs.diff.SpaceDiffModelHolder;
import com.intellij.space.vcs.diff.SpaceDiffRequestProcessor;
import com.intellij.space.vcs.editor.SpaceDiffComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Property;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/space/vcs/diff/SpaceDiffFile;", "Lcom/intellij/diff/editor/DiffVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "sessionId", "", "projectHash", "fileId", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileId", "()Ljava/lang/String;", "createProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/space/vcs/editor/SpaceDiffComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "hashCode", "", "intellij.space.vcs"})
public final class SpaceDiffFile
extends DiffVirtualFile
implements VirtualFilePathWrapper {
    private final String sessionId;
    private final String projectHash;
    @NotNull
    private final String fileId;

    @NotNull
    public SpaceDiffComplexPathVirtualFileSystem getFileSystem() {
        return SpaceDiffComplexPathVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        String string2;
        try {
            string2 = this.getFileSystem().getPath(this.sessionId, this.projectHash, this.fileId);
        }
        catch (Exception e) {
            String string3 = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            string2 = string3;
        }
        return string2;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        String string2 = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return string2;
    }

    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Property<SpaceDiffModel> diffModel = SpaceDiffModelHolder.Companion.getInstance(project2).getModel(this.fileId);
        return (DiffRequestProcessor)new SpaceDiffRequestProcessor(project2, diffModel);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.space.vcs.diff.SpaceDiffFile");
        }
        SpaceDiffFile cfr_ignored_0 = (SpaceDiffFile)((Object)object2);
        return !(Intrinsics.areEqual((Object)this.fileId, (Object)((SpaceDiffFile)((Object)other)).fileId) ^ true);
    }

    public int hashCode() {
        return this.fileId.hashCode();
    }

    @NotNull
    public final String getFileId() {
        return this.fileId;
    }

    public SpaceDiffFile(@NotNull String sessionId, @NotNull String projectHash, @NotNull String fileId, @Nls @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string2 = SpaceBundle.message("review.diff.tab.title", fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceBundle.message(\"rev\u2026iff.tab.title\", fileName)");
        super(string2);
        this.sessionId = sessionId;
        this.projectHash = projectHash;
        this.fileId = fileId;
    }
}

