/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lruntime/logging/LoggingSetup;", "", "()V", "setupLogging", "", "configXml", "Ljava/io/File;", "configStream", "Ljava/io/InputStream;", "platform-runtime"})
public final class LoggingSetup {
    @NotNull
    public static final LoggingSetup INSTANCE = new LoggingSetup();

    private LoggingSetup() {
    }

    public final void setupLogging(@NotNull InputStream configStream) {
        Intrinsics.checkNotNullParameter((Object)configStream, (String)"configStream");
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (iLoggerFactory == null) {
            throw new NullPointerException("null cannot be cast to non-null type ch.qos.logback.classic.LoggerContext");
        }
        LoggerContext context2 = (LoggerContext)iLoggerFactory;
        LevelChangePropagator jul2 = new LevelChangePropagator(){

            public boolean isResetResistant() {
                return true;
            }
        };
        jul2.setContext((Context)context2);
        context2.addListener((LoggerContextListener)jul2);
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context2);
            context2.reset();
            configurator.doConfigure(configStream);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)((Context)context2));
    }

    public final void setupLogging(@NotNull File configXml) {
        Intrinsics.checkNotNullParameter((Object)configXml, (String)"configXml");
        try {
            this.setupLogging(new FileInputStream(configXml));
        }
        catch (Throwable ex) {
            LoggerFactory.getLogger(this.getClass()).warn(Intrinsics.stringPlus((String)"Failed to configure from file ", (Object)configXml), ex);
        }
    }
}

