/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.logging.ErrorInfo;
import runtime.logging.JsonLogEventsLayoutKt;
import runtime.logging.TextError;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0011H\u0002J\u0011\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lruntime/logging/SuppressedConnectionErrors;", "", "()V", "errors", "", "", "textErrors", "", "Lruntime/logging/TextError;", "addError", "", "error", "addTextError", "match", "", "event", "Lch/qos/logback/classic/spi/ILoggingEvent;", "Lruntime/logging/ErrorInfo;", "plusAssign", "that", "platform-runtime"})
public final class SuppressedConnectionErrors {
    @NotNull
    private final Set<String> errors = new LinkedHashSet();
    @NotNull
    private final Map<String, TextError> textErrors = new LinkedHashMap();

    public final void addError(@NotNull String error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        ((Collection)this.errors).add(error2);
    }

    public final void addTextError(@NotNull TextError error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        Map<String, TextError> map2 = this.textErrors;
        String string2 = error2.getError();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2;
        map2.put(string3, error2);
    }

    public final void plusAssign(@NotNull SuppressedConnectionErrors that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        CollectionsKt.addAll((Collection)this.errors, (Iterable)that.errors);
        this.textErrors.putAll(that.textErrors);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean match(@NotNull ILoggingEvent event2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!CollectionsKt.any((Iterable)this.errors)) {
            if (!MapsKt.any(this.textErrors)) return false;
        }
        Sequence $this$any$iv = JsonLogEventsLayoutKt.access$getAllCauses(event2.getThrowableProxy());
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IThrowableProxy it = (IThrowableProxy)element$iv;
            boolean bl2 = false;
            if (this.match(JsonLogEventsLayoutKt.access$getError(it))) return true;
            if (it instanceof ThrowableProxy) {
                Sequence $this$any$iv2 = JsonLogEventsLayoutKt.access$getSuperErrors((ThrowableProxy)it);
                boolean $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    ErrorInfo p0 = (ErrorInfo)element$iv2;
                    boolean bl3 = false;
                    if (!this.match(p0)) continue;
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean match(ErrorInfo error2) {
        boolean bl;
        if (this.errors.contains(error2.getClassName())) return true;
        if (error2.getMessage() == null) return false;
        TextError textError = this.textErrors.get(error2.getClassName());
        List list2 = textError == null ? null : textError.getTexts();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            String part;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            List text2 = (List)element$iv;
            boolean bl2 = false;
            Iterable $this$all$iv = text2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator3 = $this$all$iv.iterator();
            do {
                if (!iterator3.hasNext()) return true;
                Object element$iv2 = iterator3.next();
                part = (String)element$iv2;
                boolean bl3 = false;
            } while (StringsKt.contains$default((CharSequence)error2.getMessage(), (CharSequence)part, (boolean)false, (int)2, null));
            bl = false;
        } while (!bl);
        return true;
    }
}

