from typing import Any

class WebDriverException(Exception):
    msg: Any
    screen: Any
    stacktrace: Any
    def __init__(self, msg: Any | None = ..., screen: Any | None = ..., stacktrace: Any | None = ...) -> None: ...

class ErrorInResponseException(WebDriverException):
    response: Any
    def __init__(self, response, msg) -> None: ...

class InvalidSwitchToTargetException(WebDriverException): ...
class NoSuchFrameException(InvalidSwitchToTargetException): ...
class NoSuchWindowException(InvalidSwitchToTargetException): ...
class NoSuchElementException(WebDriverException): ...
class NoSuchAttributeException(WebDriverException): ...
class StaleElementReferenceException(WebDriverException): ...
class InvalidElementStateException(WebDriverException): ...

class UnexpectedAlertPresentException(WebDriverException):
    alert_text: Any
    def __init__(
        self, msg: Any | None = ..., screen: Any | None = ..., stacktrace: Any | None = ..., alert_text: Any | None = ...
    ) -> None: ...

class NoAlertPresentException(WebDriverException): ...
class ElementNotVisibleException(InvalidElementStateException): ...
class ElementNotInteractableException(InvalidElementStateException): ...
class ElementNotSelectableException(InvalidElementStateException): ...
class InvalidCookieDomainException(WebDriverException): ...
class UnableToSetCookieException(WebDriverException): ...
class RemoteDriverServerException(WebDriverException): ...
class TimeoutException(WebDriverException): ...
class MoveTargetOutOfBoundsException(WebDriverException): ...
class UnexpectedTagNameException(WebDriverException): ...
class InvalidSelectorException(NoSuchElementException): ...
class ImeNotAvailableException(WebDriverException): ...
class ImeActivationFailedException(WebDriverException): ...
class InvalidArgumentException(WebDriverException): ...
class JavascriptException(WebDriverException): ...
class NoSuchCookieException(WebDriverException): ...
class ScreenshotException(WebDriverException): ...
class ElementClickInterceptedException(WebDriverException): ...
class InsecureCertificateException(WebDriverException): ...
class InvalidCoordinatesException(WebDriverException): ...
class InvalidSessionIdException(WebDriverException): ...
class SessionNotCreatedException(WebDriverException): ...
class UnknownMethodException(WebDriverException): ...
