/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TriggerUtils {
    public static void requiredProperties(Set<String> required, Set<String> valid, String ... propertyNames) {
        required.addAll(Arrays.asList(propertyNames));
        valid.addAll(Arrays.asList(propertyNames));
    }

    public static void validProperties(Set<String> valid, String ... propertyNames) {
        valid.addAll(Arrays.asList(propertyNames));
    }

    public static void checkProperties(Map<String, Object> properties, Map<String, String> results, Set<String> required, Set<String> valid) {
        TriggerUtils.checkValidPropertyNames(properties, results, valid);
        TriggerUtils.checkRequiredPropertyNames(properties, results, required);
    }

    public static void checkValidPropertyNames(Map<String, Object> properties, Map<String, String> results, Set<String> valid) {
        HashSet<String> currentNames = new HashSet<String>(properties.keySet());
        currentNames.removeAll(valid);
        if (!currentNames.isEmpty()) {
            for (String name : currentNames) {
                results.put(name, "unknown property");
            }
        }
    }

    public static void checkRequiredPropertyNames(Map<String, Object> properties, Map<String, String> results, Set<String> required) {
        HashSet<String> requiredNames = new HashSet<String>(required);
        requiredNames.removeAll(properties.keySet());
        if (!requiredNames.isEmpty()) {
            for (String name : requiredNames) {
                results.put(name, "missing required property");
            }
        }
    }

    public static void checkProperty(Map<String, Object> properties, Map<String, String> results, String name, boolean required, Class ... acceptClasses) {
        Object value = properties.get(name);
        if (value == null) {
            if (required) {
                results.put(name, "missing required value");
            } else {
                return;
            }
        }
        if (acceptClasses == null || acceptClasses.length == 0) {
            return;
        }
        boolean accepted = false;
        for (Class clz : acceptClasses) {
            if (!clz.isAssignableFrom(value.getClass())) continue;
            accepted = true;
            break;
        }
        if (!accepted) {
            results.put(name, "value is not an expected type");
        }
    }
}

