/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.traccar.api.BaseResource;
import org.traccar.helper.LogAction;
import org.traccar.model.Permission;
import org.traccar.model.UserRestrictions;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.StorageException;

@Path(value="permissions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PermissionsResource
extends BaseResource {
    @Inject
    private CacheManager cacheManager;

    private void checkPermission(Permission permission) throws StorageException {
        if (this.permissionsService.notAdmin(this.getUserId())) {
            this.permissionsService.checkPermission(permission.getOwnerClass(), this.getUserId(), permission.getOwnerId());
            this.permissionsService.checkPermission(permission.getOwnerClass(), this.getUserId(), permission.getOwnerId());
        }
    }

    private void checkPermissionTypes(List<LinkedHashMap<String, Long>> entities) {
        Set<String> keys = null;
        for (LinkedHashMap<String, Long> entity : entities) {
            if (keys != null & !entity.keySet().equals(keys)) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            }
            keys = entity.keySet();
        }
    }

    @Path(value="bulk")
    @POST
    public Response add(List<LinkedHashMap<String, Long>> entities) throws StorageException, ClassNotFoundException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getReadonly);
        this.checkPermissionTypes(entities);
        for (LinkedHashMap<String, Long> entity : entities) {
            Permission permission = new Permission(entity);
            this.checkPermission(permission);
            this.storage.addPermission(permission);
            this.cacheManager.invalidatePermission(true, permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId());
            LogAction.link(this.getUserId(), permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId());
        }
        return Response.noContent().build();
    }

    @POST
    public Response add(LinkedHashMap<String, Long> entity) throws StorageException, ClassNotFoundException {
        return this.add(Collections.singletonList(entity));
    }

    @DELETE
    @Path(value="bulk")
    public Response remove(List<LinkedHashMap<String, Long>> entities) throws StorageException, ClassNotFoundException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getReadonly);
        this.checkPermissionTypes(entities);
        for (LinkedHashMap<String, Long> entity : entities) {
            Permission permission = new Permission(entity);
            this.checkPermission(permission);
            this.storage.removePermission(permission);
            this.cacheManager.invalidatePermission(true, permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId());
            LogAction.unlink(this.getUserId(), permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId());
        }
        return Response.noContent().build();
    }

    @DELETE
    public Response remove(LinkedHashMap<String, Long> entity) throws StorageException, ClassNotFoundException {
        return this.remove(Collections.singletonList(entity));
    }
}

