/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class MapboxGeocoder
extends JsonGeocoder {
    private static String formatUrl(String key) {
        return "https://api.mapbox.com/geocoding/v5/mapbox.places/%2$f,%1$f.json?access_token=" + key;
    }

    public MapboxGeocoder(Client client, String key, int cacheSize, AddressFormat addressFormat) {
        super(client, MapboxGeocoder.formatUrl(key), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray features = json.getJsonArray("features");
        if (!features.isEmpty()) {
            Address address = new Address();
            JsonObject mostSpecificFeature = (JsonObject)features.get(0);
            if (mostSpecificFeature.containsKey((Object)"place_name")) {
                address.setFormattedAddress(mostSpecificFeature.getString("place_name"));
            }
            if (mostSpecificFeature.containsKey((Object)"address")) {
                address.setHouse(mostSpecificFeature.getString("address"));
            }
            block19: for (JsonObject feature : features.getValuesAs(JsonObject.class)) {
                String value = feature.getString("text");
                for (JsonString type : feature.getJsonArray("place_type").getValuesAs(JsonString.class)) {
                    switch (type.getString()) {
                        case "address": {
                            address.setStreet(value);
                            continue block19;
                        }
                        case "neighborhood": {
                            address.setSuburb(value);
                            continue block19;
                        }
                        case "postcode": {
                            address.setPostcode(value);
                            continue block19;
                        }
                        case "locality": {
                            address.setSettlement(value);
                            continue block19;
                        }
                        case "district": 
                        case "place": {
                            address.setDistrict(value);
                            continue block19;
                        }
                        case "region": {
                            address.setState(value);
                            continue block19;
                        }
                        case "country": {
                            address.setCountry(value);
                            continue block19;
                        }
                    }
                }
            }
            return address;
        }
        return null;
    }
}

