/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DataConverter;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class MotorProtocolDecoder
extends BaseProtocolDecoder {
    public MotorProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(sentence));
        String id = String.format("%08x", buf.readUnsignedIntLE());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.skipBytes(2);
        position.set("status", buf.readUnsignedShortLE());
        buf.skipBytes(2);
        buf.readUnsignedMediumLE();
        short flags = buf.readUnsignedByte();
        position.setValid(BitUtil.check(flags, 7));
        if (BitUtil.check(flags, 0)) {
            position.set("alarm", "general");
        }
        position.setLatitude((double)BcdUtil.readInteger(buf, 2) + (double)BcdUtil.readInteger(buf, 6) * 1.0E-4 / 60.0);
        position.setLongitude((double)BcdUtil.readInteger(buf, 4) + (double)BcdUtil.readInteger(buf, 6) * 1.0E-4 / 60.0);
        position.setSpeed((double)BcdUtil.readInteger(buf, 4) * 0.1);
        position.setCourse((double)BcdUtil.readInteger(buf, 4) * 0.1);
        position.setTime(new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2)).getDate());
        position.set("rssi", BcdUtil.readInteger(buf, 2));
        return position;
    }
}

