/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class NavigilFrameDecoder
extends BaseFrameDecoder {
    private static final int MESSAGE_HEADER = 20;
    private static final long PREAMBLE = 611841526L;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 20) {
            return null;
        }
        boolean hasPreamble = false;
        if (buf.getUnsignedIntLE(buf.readerIndex()) == 611841526L) {
            hasPreamble = true;
        }
        int length = buf.getUnsignedShortLE(buf.readerIndex() + 6);
        if (buf.readableBytes() >= length) {
            if (hasPreamble) {
                buf.readUnsignedIntLE();
                length -= 4;
            }
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

