/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class TotemProtocolEncoder
extends StringProtocolEncoder {
    public TotemProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    public static String formatContent(Command command) {
        switch (command.getType()) {
            case "custom": {
                return String.format("%s,%s", command.getAttributes().get("devicePassword"), command.getAttributes().get("data"));
            }
            case "rebootDevice": {
                return String.format("%s,006", command.getAttributes().get("devicePassword"));
            }
            case "factoryReset": {
                return String.format("%s,007", command.getAttributes().get("devicePassword"));
            }
            case "getVersion": {
                return String.format("%s,056", command.getAttributes().get("devicePassword"));
            }
            case "positionSingle": {
                return String.format("%s,012", command.getAttributes().get("devicePassword"));
            }
            case "engineStop": {
                return String.format("%s,025,C,1", command.getAttributes().get("devicePassword"));
            }
            case "engineResume": {
                return String.format("%s,025,C,0", command.getAttributes().get("devicePassword"));
            }
        }
        return null;
    }

    @Override
    protected Object encodeCommand(Command command) {
        this.initDevicePassword(command, "000000");
        String commandString = TotemProtocolEncoder.formatContent(command);
        String builtCommand = String.format("$$%04dCF%s", 10 + commandString.getBytes().length, commandString);
        return String.format("%s%02X", builtCommand, Checksum.xor(builtCommand));
    }
}

