/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.auto.value.AutoValue;
import com.google.cloud.firestore.AutoValue_ResourcePath;
import com.google.cloud.firestore.BasePath;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.DatabaseRootName;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
abstract class ResourcePath
extends BasePath<ResourcePath> {
    ResourcePath() {
    }

    static ResourcePath create(DatabaseRootName databaseName, ImmutableList<String> segments) {
        return new AutoValue_ResourcePath(segments, databaseName);
    }

    static ResourcePath create(DatabaseRootName databaseName) {
        return new AutoValue_ResourcePath((ImmutableList<String>)ImmutableList.of(), databaseName);
    }

    static ResourcePath create(String resourceName) {
        String[] parts = resourceName.split("/");
        if (parts.length >= 5 && parts[0].equals("projects") && parts[2].equals("databases")) {
            Object[] path = Arrays.copyOfRange(parts, 5, parts.length);
            return ResourcePath.create(DatabaseRootName.of((String)parts[1], (String)parts[3]), (ImmutableList<String>)ImmutableList.builder().add(path).build());
        }
        return ResourcePath.create(DatabaseRootName.parse((String)resourceName));
    }

    abstract DatabaseRootName getDatabaseName();

    boolean isDocument() {
        int size = this.getSegments().size();
        return size > 0 && size % 2 == 0;
    }

    boolean isCollection() {
        return this.getSegments().size() % 2 == 1;
    }

    @Nullable
    String getId() {
        ImmutableList<String> parts = this.getSegments();
        if (!parts.isEmpty()) {
            return (String)parts.get(parts.size() - 1);
        }
        return null;
    }

    String getPath() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String part : this.getSegments()) {
            if (first) {
                result.append(part);
                first = false;
                continue;
            }
            result.append("/").append(part);
        }
        return result.toString();
    }

    String getName() {
        String path = this.getPath();
        if (path.isEmpty()) {
            return this.getDatabaseName() + "/documents";
        }
        return this.getDatabaseName() + "/documents/" + this.getPath();
    }

    @Override
    public int compareTo(@Nonnull ResourcePath other) {
        int cmp = this.getDatabaseName().getProject().compareTo(other.getDatabaseName().getProject());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getDatabaseName().getDatabase().compareTo(other.getDatabaseName().getDatabase());
        if (cmp != 0) {
            return cmp;
        }
        return super.compareTo(other);
    }

    ResourcePath popLast() {
        ImmutableList<String> segments = this.getSegments();
        return this.createPathWithSegments(segments.subList(0, segments.size() - 1));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    String[] splitChildPath(String name) {
        return name.split("/");
    }

    @Override
    ResourcePath createPathWithSegments(ImmutableList<String> segments) {
        return ResourcePath.create(this.getDatabaseName(), segments);
    }

    public static Comparator<ResourcePath> comparator() {
        return Comparator.naturalOrder();
    }
}

