/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.Index;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.StatementValidator;

public class CreateTableValidator
extends AbstractValidator<CreateTable> {
    @Override
    public void validate(CreateTable createTable) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.createTable);
            this.validateFeature(validationCapability, createTable.isUnlogged(), Feature.createTableUnlogged);
            this.validateOptionalFeature(validationCapability, createTable.getCreateOptionsStrings(), Feature.createTableCreateOptionStrings);
            this.validateOptionalFeature(validationCapability, createTable.getTableOptionsStrings(), Feature.createTableTableOptionStrings);
            this.validateFeature(validationCapability, createTable.isIfNotExists(), Feature.createTableIfNotExists);
            this.validateOptionalFeature(validationCapability, createTable.getRowMovement(), Feature.createTableRowMovement);
            this.validateOptionalFeature(validationCapability, createTable.getSelect(), Feature.createTableFromSelect);
            if (this.isNotEmpty(createTable.getIndexes())) {
                for (Index index : createTable.getIndexes()) {
                    this.validateName(validationCapability, NamedObject.index, index.getName());
                }
            }
            this.validateName(validationCapability, NamedObject.table, createTable.getTable().getFullyQualifiedName(), false, new NamedObject[0]);
        }
        if (createTable.getSelect() != null) {
            this.getValidator(StatementValidator.class).validate(createTable.getSelect());
        }
    }
}

