/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.collect.ImmutableList;
import com.google.firebase.FirebaseApp;
import com.google.firebase.internal.FirebaseRequestInitializer;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.RetryConfig;
import java.io.IOException;
import java.util.List;

public class ApiClientUtils {
    static final RetryConfig DEFAULT_RETRY_CONFIG = RetryConfig.builder().setMaxRetries(4).setRetryStatusCodes((List<Integer>)ImmutableList.of((Object)503)).setMaxIntervalMillis(60000).build();

    private ApiClientUtils() {
    }

    public static HttpRequestFactory newAuthorizedRequestFactory(FirebaseApp app) {
        return ApiClientUtils.newAuthorizedRequestFactory(app, DEFAULT_RETRY_CONFIG);
    }

    public static HttpRequestFactory newAuthorizedRequestFactory(FirebaseApp app, @Nullable RetryConfig retryConfig) {
        HttpTransport transport = app.getOptions().getHttpTransport();
        return transport.createRequestFactory((HttpRequestInitializer)new FirebaseRequestInitializer(app, retryConfig));
    }

    public static HttpRequestFactory newUnauthorizedRequestFactory(FirebaseApp app) {
        HttpTransport transport = app.getOptions().getHttpTransport();
        return transport.createRequestFactory();
    }

    public static void disconnectQuietly(HttpResponse response) {
        if (response != null) {
            try {
                response.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static JsonFactory getDefaultJsonFactory() {
        return JacksonFactory.getDefaultInstance();
    }

    public static HttpTransport getDefaultTransport() {
        return Utils.getDefaultTransport();
    }
}

