/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;

public class PackageNameCheck
extends AbstractFormatCheck {
    public PackageNameCheck() {
        super("^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$");
    }

    public int[] getDefaultTokens() {
        return new int[]{16};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST nameAST = (DetailAST)aAST.getFirstChild();
        FullIdent full = FullIdent.createFullIdent(nameAST);
        if (!this.getRegexp().match(full.getText())) {
            this.log(full.getLineNo(), full.getColumnNo(), "name.invalidPattern", full.getText(), this.getFormat());
        }
    }
}

