/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.ProvisionedFeatureDiffCallback;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.plugin.StateDiffPlugin;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

public class ProvisioningDiffProvider {
    private ProvisioningLayout<FeaturePackRuntimeBuilder> layout;
    private ProvisioningConfig provisionedConfig;
    private ProvisionedState provisionedState;
    private FsDiff fsDiff;
    private MessageWriter log;
    private Map<FeaturePackLocation.FPID, FeaturePackConfig.Builder> updatedDirectFps = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, FeaturePackConfig.Builder> updatedTransitiveFps = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, FeaturePackConfig.Builder> addedTransitiveFps = Collections.emptyMap();
    private Map<ConfigId, ConfigModel> updatedConfigs = new LinkedHashMap<ConfigId, ConfigModel>(1);
    private Map<ConfigId, ConfigModel> addedConfigs = Collections.emptyMap();
    private Set<ConfigId> removedConfigs = Collections.emptySet();
    private Map<ConfigId, ProvisionedFeatureDiffCallback> configPlugins = Collections.emptyMap();
    private FeatureDiff featureDiff;
    private ProvisioningConfig mergedConfig;

    public static ProvisioningDiffProvider newInstance(ProvisioningLayout<FeaturePackRuntimeBuilder> layout, ProvisionedState provisionedState, FsDiff diff, MessageWriter log) {
        ProvisioningDiffProvider diffProvider = new ProvisioningDiffProvider();
        diffProvider.layout = layout;
        diffProvider.provisionedConfig = layout.getConfig();
        diffProvider.provisionedState = provisionedState;
        diffProvider.fsDiff = diff;
        diffProvider.log = log;
        return diffProvider;
    }

    private ProvisioningDiffProvider() {
    }

    public MessageWriter getMessageWriter() {
        return this.log;
    }

    public ProvisioningLayout<FeaturePackRuntimeBuilder> getProvisioningLayout() {
        return this.layout;
    }

    public ProvisioningConfig getOriginalConfig() {
        return this.provisionedConfig;
    }

    public ProvisionedState getProvisionedState() {
        return this.provisionedState;
    }

    public FsDiff getFsDiff() {
        return this.fsDiff;
    }

    public void excludePackage(StateDiffPlugin plugin, FeaturePackLocation.FPID fpid, String name, String ... relativePaths) throws ProvisioningException {
        this.getFpcBuilder(fpid).excludePackage(name);
        this.suppressPaths(relativePaths);
    }

    public void includePackage(StateDiffPlugin plugin, FeaturePackLocation.FPID fpid, String name, String ... relativePaths) throws ProvisioningException {
        this.getFpcBuilder(fpid).includePackage(name);
        this.suppressPaths(relativePaths);
    }

    public void updateConfig(ProvisionedConfig updatedConfig, String ... relativePaths) throws ProvisioningException {
        this.updateConfig(ProvisionedFeatureDiffCallback.DEFAULT, updatedConfig, relativePaths);
    }

    public void updateConfig(ProvisionedFeatureDiffCallback featureDiffCallback, ProvisionedConfig updatedConfig, String ... relativePaths) throws ProvisioningException {
        ConfigId configId = new ConfigId(updatedConfig.getModel(), updatedConfig.getName());
        this.configPlugins = CollectionUtils.put(this.configPlugins, configId, featureDiffCallback);
        if (this.featureDiff == null) {
            this.featureDiff = new FeatureDiff(this.log);
        }
        this.featureDiff.init(ProvisioningDiffProvider.getRequiredProvisionedConfig(this.provisionedState.getConfigs(), updatedConfig.getModel(), updatedConfig.getName()));
        this.featureDiff.diff(featureDiffCallback, updatedConfig);
        ConfigModel mergedConfig = this.featureDiff.getMergedConfig(this.layout);
        if (mergedConfig == null) {
            this.log.verbose("%s has not changed", updatedConfig.getName());
        } else {
            this.updatedConfigs.put(configId, mergedConfig);
        }
        this.featureDiff.reset();
        this.suppressPaths(relativePaths);
    }

    public void addConfig(ProvisionedConfig config, String ... relativePaths) throws ProvisioningException {
        this.addConfig(ProvisionedFeatureDiffCallback.DEFAULT, config, relativePaths);
    }

    public void addConfig(ProvisionedFeatureDiffCallback featureDiffCallback, ProvisionedConfig config, String ... relativePaths) throws ProvisioningException {
        if (this.featureDiff == null) {
            this.featureDiff = new FeatureDiff(this.log);
        }
        this.featureDiff.reset();
        this.featureDiff.model = config.getModel();
        this.featureDiff.name = config.getName();
        this.featureDiff.diff(featureDiffCallback, config);
        ConfigModel mergedConfig = this.featureDiff.getMergedConfig(this.layout);
        if (mergedConfig == null) {
            this.log.verbose("%s is meaningless", config.getName());
        } else {
            this.addedConfigs = CollectionUtils.putLinked(this.addedConfigs, new ConfigId(config.getModel(), config.getName()), mergedConfig);
        }
        this.featureDiff.reset();
        this.suppressPaths(relativePaths);
    }

    public void removeConfig(ConfigId configId, String ... relativePaths) throws ProvisioningException {
        this.removedConfigs = CollectionUtils.add(this.removedConfigs, configId);
        this.suppressPaths(relativePaths);
    }

    public boolean hasConfigChanges() {
        return !this.updatedDirectFps.isEmpty() || !this.updatedTransitiveFps.isEmpty() || !this.addedTransitiveFps.isEmpty() || !this.updatedConfigs.isEmpty() || !this.addedConfigs.isEmpty() || !this.removedConfigs.isEmpty();
    }

    public ProvisioningConfig getMergedConfig() throws ProvisioningException {
        if (this.mergedConfig != null) {
            return this.mergedConfig;
        }
        if (!this.hasConfigChanges()) {
            this.mergedConfig = this.provisionedConfig;
            return this.provisionedConfig;
        }
        ProvisioningConfig.Builder configBuilder = this.initProvisioningConfig();
        Collection<ConfigModel> definedConfigs = this.provisionedConfig.getDefinedConfigs();
        if (!definedConfigs.isEmpty()) {
            for (ConfigModel originalConfig : definedConfigs) {
                ConfigModel updatedConfig = this.updatedConfigs.remove(originalConfig.getId());
                if (updatedConfig != null) {
                    configBuilder.addConfig(updatedConfig);
                    continue;
                }
                if (this.removedConfigs.contains(originalConfig.getId())) continue;
                configBuilder.addConfig(originalConfig);
            }
        }
        if (!this.updatedConfigs.isEmpty()) {
            for (ConfigModel updatedConfig : this.updatedConfigs.values()) {
                configBuilder.addConfig(updatedConfig);
            }
        }
        if (!this.addedConfigs.isEmpty()) {
            for (ConfigModel addedConfig : this.addedConfigs.values()) {
                configBuilder.addConfig(addedConfig);
            }
        }
        if (!this.removedConfigs.isEmpty()) {
            List<ProvisionedConfig> baseConfigs = null;
            for (ConfigId configId : this.removedConfigs) {
                if (this.provisionedConfig.hasDefinedConfig(configId)) {
                    if (baseConfigs == null) {
                        ProvisioningConfig.Builder baseBuilder = this.initProvisioningConfig();
                        for (ProvisionedConfig config : this.provisionedState.getConfigs()) {
                            ConfigId provisionedId = new ConfigId(config.getModel(), config.getName());
                            if (this.provisionedConfig.hasDefinedConfig(provisionedId)) continue;
                            baseBuilder.excludeDefaultConfig(provisionedId);
                        }
                        try (ProvisioningRuntime baseRt = ProvisioningRuntimeBuilder.newInstance(this.log).initLayout(this.layout.getFactory(), baseBuilder.build()).build();){
                            baseConfigs = baseRt.getConfigs();
                        }
                    }
                    if (ProvisioningDiffProvider.getProvisionedConfig(baseConfigs, configId.getModel(), configId.getName()) == null) continue;
                    if (this.provisionedConfig.isInheritConfigs(true)) {
                        if (this.provisionedConfig.isConfigModelExcluded(configId)) continue;
                        configBuilder.excludeDefaultConfig(configId);
                        continue;
                    }
                    if (!this.provisionedConfig.isConfigModelIncluded(configId)) continue;
                    configBuilder.excludeDefaultConfig(configId);
                    continue;
                }
                if (this.provisionedConfig.isInheritConfigs(true)) {
                    if (this.provisionedConfig.isConfigModelExcluded(configId)) continue;
                    configBuilder.excludeDefaultConfig(configId);
                    continue;
                }
                if (!this.provisionedConfig.isConfigModelIncluded(configId)) continue;
                configBuilder.excludeDefaultConfig(configId);
            }
        }
        this.mergedConfig = configBuilder.build();
        return this.mergedConfig;
    }

    private ProvisioningConfig.Builder initProvisioningConfig() throws ProvisioningDescriptionException {
        ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder();
        configBuilder.initUniverses(this.provisionedConfig);
        if (this.provisionedConfig.hasOptions()) {
            configBuilder.addOptions(this.provisionedConfig.getOptions());
        }
        for (FeaturePackConfig fp : this.provisionedConfig.getFeaturePackDeps()) {
            FeaturePackConfig.Builder builder = this.updatedDirectFps.get(fp.getLocation().getFPID());
            if (builder == null) {
                configBuilder.addFeaturePackDep(this.provisionedConfig.originOf(fp.getLocation().getProducer()), fp);
                continue;
            }
            configBuilder.addFeaturePackDep(this.provisionedConfig.originOf(fp.getLocation().getProducer()), builder.build());
        }
        for (FeaturePackConfig fp : this.provisionedConfig.getTransitiveDeps()) {
            FeaturePackConfig.Builder builder = this.updatedTransitiveFps.get(fp.getLocation().getFPID());
            if (builder == null) {
                configBuilder.addFeaturePackDep(this.provisionedConfig.originOf(fp.getLocation().getProducer()), fp);
                continue;
            }
            configBuilder.addFeaturePackDep(this.provisionedConfig.originOf(fp.getLocation().getProducer()), builder.build());
        }
        for (FeaturePackConfig.Builder fpcBuilder2 : this.addedTransitiveFps.values()) {
            configBuilder.addFeaturePackDep(fpcBuilder2.build());
        }
        Boolean inheritConfigs = this.provisionedConfig.getInheritConfigs();
        if (inheritConfigs != null) {
            configBuilder.setInheritConfigs(inheritConfigs);
        }
        configBuilder.setInheritModelOnlyConfigs(this.provisionedConfig.isInheritModelOnlyConfigs());
        if (this.provisionedConfig.hasFullModelsExcluded()) {
            for (Map.Entry entry : this.provisionedConfig.getFullModelsExcluded().entrySet()) {
                configBuilder.excludeConfigModel((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        if (this.provisionedConfig.hasFullModelsIncluded()) {
            for (String string : this.provisionedConfig.getFullModelsIncluded()) {
                configBuilder.includeConfigModel(string);
            }
        }
        return configBuilder;
    }

    private void suppressPaths(String ... relativePaths) throws ProvisioningException {
        for (String relativePath : relativePaths) {
            this.fsDiff.suppress(relativePath);
        }
    }

    private FeaturePackConfig.Builder getFpcBuilder(FeaturePackLocation.FPID fpid) {
        FeaturePackConfig.Builder fpcBuilder = this.updatedDirectFps.get(fpid);
        if (fpcBuilder != null) {
            return fpcBuilder;
        }
        fpcBuilder = this.updatedTransitiveFps.get(fpid);
        if (fpcBuilder != null) {
            return fpcBuilder;
        }
        fpcBuilder = this.addedTransitiveFps.get(fpid);
        if (fpcBuilder != null) {
            return fpcBuilder;
        }
        FeaturePackConfig fpc = this.provisionedConfig.getFeaturePackDep(fpid.getProducer());
        if (fpc != null) {
            fpcBuilder = FeaturePackConfig.builder(fpc);
            this.updatedDirectFps = CollectionUtils.put(this.updatedDirectFps, fpid, fpcBuilder);
            return fpcBuilder;
        }
        fpc = this.provisionedConfig.getTransitiveDep(fpid.getProducer());
        if (fpc != null) {
            fpcBuilder = FeaturePackConfig.builder(fpc);
            this.updatedTransitiveFps = CollectionUtils.put(this.updatedTransitiveFps, fpid, fpcBuilder);
            return fpcBuilder;
        }
        fpcBuilder = FeaturePackConfig.transitiveBuilder(fpid.getLocation());
        this.addedTransitiveFps = CollectionUtils.putLinked(this.addedTransitiveFps, fpid, fpcBuilder);
        return fpcBuilder;
    }

    private static ConfigModel getBaseConfig(ConfigModel definedConfig) throws ProvisioningDescriptionException {
        ConfigModel.Builder baseConfig = ConfigModel.builder(definedConfig.getModel(), definedConfig.getName());
        baseConfig.setInheritLayers(definedConfig.isInheritLayers());
        if (definedConfig.hasIncludedLayers()) {
            for (String layer : definedConfig.getIncludedLayers()) {
                baseConfig.includeLayer(layer);
            }
        }
        if (definedConfig.hasExcludedLayers()) {
            for (String layer : definedConfig.getExcludedLayers()) {
                baseConfig.excludeLayer(layer);
            }
        }
        return baseConfig.build();
    }

    private static ProvisionedConfig getRequiredProvisionedConfig(List<ProvisionedConfig> list, String model, String name) throws ProvisioningException {
        ProvisionedConfig config = ProvisioningDiffProvider.getProvisionedConfig(list, model, name);
        if (config == null) {
            throw new ProvisioningException("Failed to locate provisioned config " + model + "/" + name);
        }
        return config;
    }

    private static ProvisionedConfig getProvisionedConfig(List<ProvisionedConfig> list, String model, String name) throws ProvisioningException {
        for (ProvisionedConfig config : list) {
            if ((config.getModel() != null || model != null) && !config.getModel().equals(model) || (config.getName() != null || name != null) && !config.getName().equals(name)) continue;
            return config;
        }
        return null;
    }

    private static FeatureId getFeatureId(ProvisionedFeature feature) throws ProvisioningDescriptionException, ProvisioningException {
        FeatureId.Builder id = FeatureId.builder(feature.getSpecId().getName());
        ResolvedFeatureId resolvedId = feature.getId();
        for (String name : resolvedId.getParams().keySet()) {
            id.setParam(name, feature.getConfigParam(name));
        }
        return id.build();
    }

    private static class FeatureDiff
    implements ProvisionedConfigHandler {
        private MessageWriter log;
        private String model;
        private String name;
        Map<ResolvedFeatureId, ProvisionedFeature> original = new HashMap<ResolvedFeatureId, ProvisionedFeature>();
        Map<ResolvedFeatureId, ProvisionedFeature> added = Collections.emptyMap();
        Map<ResolvedFeatureId, ProvisionedFeature[]> modified = Collections.emptyMap();
        List<ProvisionedFeature> originalWoIds = Collections.emptyList();
        List<ProvisionedFeature> addedWoIds = Collections.emptyList();
        private boolean init;
        private ProvisionedFeatureDiffCallback featureCallback;
        private ProvisionedConfig provisionedConfig;

        FeatureDiff(MessageWriter log) {
            this.log = log;
        }

        public void reset() {
            this.original.clear();
            this.added = Collections.emptyMap();
            this.modified = Collections.emptyMap();
            this.originalWoIds = Collections.emptyList();
            this.addedWoIds = Collections.emptyList();
            this.featureCallback = null;
            this.model = null;
            this.name = null;
            this.provisionedConfig = null;
        }

        public void init(ProvisionedConfig config) throws ProvisioningException {
            this.reset();
            this.model = config.getModel();
            this.name = config.getName();
            this.init = true;
            config.handle(this);
            this.init = false;
        }

        public void diff(ProvisionedFeatureDiffCallback featureDiffCallback, ProvisionedConfig config) throws ProvisioningException {
            Iterator<Object> i;
            this.featureCallback = featureDiffCallback;
            this.provisionedConfig = config;
            config.handle(this);
            if (!this.original.isEmpty()) {
                i = this.original.entrySet().iterator();
                while (i.hasNext()) {
                    if (this.featureCallback.removed(i.next().getValue())) continue;
                    i.remove();
                }
            }
            if (!this.originalWoIds.isEmpty()) {
                if (this.originalWoIds.size() == 1) {
                    if (!this.featureCallback.removed(this.originalWoIds.get(0))) {
                        this.originalWoIds = Collections.emptyList();
                    }
                } else {
                    i = this.originalWoIds.iterator();
                    while (i.hasNext()) {
                        if (this.featureCallback.removed((ProvisionedFeature)i.next())) continue;
                        i.remove();
                    }
                }
            }
        }

        public ConfigModel getMergedConfig(ProvisioningLayout<FeaturePackRuntimeBuilder> layout) throws ProvisioningException {
            if (this.isEmpty()) {
                return null;
            }
            ProvisioningConfig provisionedConfig = layout.getConfig();
            ConfigModel definedConfig = provisionedConfig.getDefinedConfig(new ConfigId(this.model, this.name));
            ConfigModel.Builder configBuilder = ConfigModel.builder(this.model, this.name);
            if (definedConfig != null) {
                ProvisionedFeatureDiffCallback originalCallback = this.featureCallback;
                ProvisionedConfig provisionedConfig2 = this.provisionedConfig;
                this.init(this.getDefaultProvisionedConfig(layout, definedConfig));
                this.diff(originalCallback, provisionedConfig2);
                configBuilder.setInheritFeatures(definedConfig.isInheritFeatures());
                configBuilder.setInheritLayers(definedConfig.isInheritLayers());
                if (definedConfig.hasIncludedLayers()) {
                    for (String string : definedConfig.getIncludedLayers()) {
                        configBuilder.includeLayer(string);
                    }
                }
                if (definedConfig.hasExcludedLayers()) {
                    for (String string : definedConfig.getExcludedLayers()) {
                        configBuilder.excludeLayer(string);
                    }
                }
                if (definedConfig.hasIncludedSpecs()) {
                    for (SpecId specId : definedConfig.getIncludedSpecs()) {
                        configBuilder.includeSpec(specId.getName());
                    }
                }
                if (definedConfig.hasExcludedSpecs()) {
                    for (SpecId specId : definedConfig.getExcludedSpecs()) {
                        configBuilder.excludeSpec(specId.getName());
                    }
                }
                if (definedConfig.hasExternalFeatureGroups()) {
                    for (Map.Entry entry : definedConfig.getExternalFeatureGroups().entrySet()) {
                        FeatureGroup fg = (FeatureGroup)entry.getValue();
                        if (fg.hasIncludedSpecs()) {
                            for (SpecId specId : fg.getIncludedSpecs()) {
                                configBuilder.includeSpec((String)entry.getKey(), specId.getName());
                            }
                        }
                        if (!fg.hasExcludedSpecs()) continue;
                        for (SpecId specId : fg.getExcludedSpecs()) {
                            configBuilder.excludeSpec((String)entry.getKey(), specId.getName());
                        }
                    }
                }
            }
            if (this.isEmpty()) {
                return configBuilder.build();
            }
            if (!this.original.isEmpty()) {
                for (ProvisionedFeature provisionedFeature : this.original.values()) {
                    String origin = provisionedConfig.originOf(provisionedFeature.getSpecId().getProducer());
                    if (FeatureDiff.isExcluded(origin, provisionedFeature, definedConfig)) continue;
                    configBuilder.excludeFeature(origin, ProvisioningDiffProvider.getFeatureId(provisionedFeature));
                }
            }
            if (!this.modified.isEmpty()) {
                for (ProvisionedFeature[] provisionedFeatureArray : this.modified.values()) {
                    ProvisionedFeature original = provisionedFeatureArray[0];
                    ProvisionedFeature provisionedFeature = provisionedFeatureArray[1];
                    FeatureSpec fSpec = layout.getFeaturePack(provisionedFeature.getSpecId().getProducer()).getFeatureSpec(provisionedFeature.getSpecId().getName()).getSpec();
                    FeatureConfig config = new FeatureConfig(fSpec.getName());
                    config.setOrigin(provisionedConfig.originOf(provisionedFeature.getSpecId().getProducer()));
                    HashSet<String> actualParams = new HashSet<String>(provisionedFeature.getParamNames());
                    for (String paramName : original.getParamNames()) {
                        FeatureParameterSpec pSpec = fSpec.getParam(paramName);
                        if (!actualParams.remove(paramName)) {
                            if (!pSpec.isNillable() || !pSpec.hasDefaultValue() || "GLN_UNDEFINED".equals(pSpec.getDefaultValue())) continue;
                            config.unsetParam(paramName);
                            continue;
                        }
                        String actualValue = provisionedFeature.getConfigParam(paramName);
                        String originalValue = original.getConfigParam(paramName);
                        if (actualValue != null) {
                            if (pSpec.isFeatureId() || actualValue.equals(originalValue) || actualValue.equals(pSpec.getDefaultValue())) continue;
                            config.setParam(paramName, actualValue);
                            continue;
                        }
                        if (!pSpec.hasDefaultValue() || "GLN_UNDEFINED".equals(pSpec.getDefaultValue())) continue;
                        config.unsetParam(paramName);
                    }
                    if (!actualParams.isEmpty()) {
                        for (String paramName : actualParams) {
                            config.setParam(paramName, provisionedFeature.getConfigParam(paramName));
                        }
                    }
                    configBuilder.includeFeature(ProvisioningDiffProvider.getFeatureId(provisionedFeature), config);
                }
            }
            if (!this.added.isEmpty()) {
                for (ProvisionedFeature provisionedFeature : this.added.values()) {
                    FeatureConfig config = new FeatureConfig(provisionedFeature.getSpecId().getName());
                    for (String name : provisionedFeature.getParamNames()) {
                        config.setParam(name, provisionedFeature.getConfigParam(name));
                    }
                    configBuilder.addConfigItem(config);
                }
            }
            return configBuilder.build();
        }

        private static boolean isExcluded(String origin, ProvisionedFeature feature, ConfigModel definedConfig) throws ProvisioningDescriptionException {
            if (definedConfig == null) {
                return false;
            }
            if (definedConfig.isInheritFeatures()) {
                Set<Object> specs = Collections.emptySet();
                if (origin == null) {
                    specs = definedConfig.getExcludedSpecs();
                } else {
                    FeatureGroup featureGroup = definedConfig.getExternalFeatureGroups().get(origin);
                    if (featureGroup != null) {
                        specs = featureGroup.getExcludedSpecs();
                    }
                }
                return specs.contains(SpecId.fromString(feature.getSpecId().getName()));
            }
            Set<Object> specs = Collections.emptySet();
            if (origin == null) {
                specs = definedConfig.getIncludedSpecs();
            } else {
                FeatureGroup featureGroup = definedConfig.getExternalFeatureGroups().get(origin);
                if (featureGroup != null) {
                    specs = featureGroup.getIncludedSpecs();
                }
            }
            return !specs.contains(SpecId.fromString(feature.getSpecId().getName()));
        }

        boolean isEmpty() {
            return this.original.isEmpty() && this.added.isEmpty() && this.modified.isEmpty() && this.originalWoIds.isEmpty() && this.addedWoIds.isEmpty();
        }

        @Override
        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            if (this.init) {
                if (feature.getId() == null) {
                    this.originalWoIds = CollectionUtils.add(this.originalWoIds, feature);
                    return;
                }
                this.original.put(feature.getId(), feature);
                return;
            }
            if (feature.getId() == null) {
                int i = 0;
                boolean matchesOriginal = false;
                while (i < this.originalWoIds.size() && !matchesOriginal) {
                    ProvisionedFeature original;
                    if (!(original = this.originalWoIds.get(i++)).getSpecId().equals(feature.getSpecId())) continue;
                    matchesOriginal = this.featureCallback.matches(original, feature);
                }
                if (matchesOriginal) {
                    this.originalWoIds = CollectionUtils.remove(this.originalWoIds, --i);
                } else if (this.featureCallback.added(feature)) {
                    this.addedWoIds = CollectionUtils.add(this.addedWoIds, feature);
                }
                return;
            }
            ProvisionedFeature originalFeature = this.original.remove(feature.getId());
            if (originalFeature == null) {
                if (this.featureCallback.added(feature)) {
                    this.added = CollectionUtils.putLinked(this.added, feature.getId(), feature);
                }
                return;
            }
            if (!this.featureCallback.matches(originalFeature, feature)) {
                this.modified = CollectionUtils.putLinked(this.modified, feature.getId(), new ProvisionedFeature[]{originalFeature, feature});
            }
        }

        private ProvisionedConfig getDefaultProvisionedConfig(ProvisioningLayout<?> layout, ConfigModel definedConfig) throws ProvisioningException {
            ProvisioningConfig originalConfig = layout.getConfig();
            ProvisioningConfig.Builder baseBuilder = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().initUniverses(originalConfig)).addOptions(originalConfig.getOptions());
            if (originalConfig.hasTransitiveDeps()) {
                for (FeaturePackConfig fp : originalConfig.getTransitiveDeps()) {
                    baseBuilder.addFeaturePackDep(originalConfig.originOf(fp.getLocation().getProducer()), fp);
                }
            }
            for (FeaturePackConfig fp : originalConfig.getFeaturePackDeps()) {
                baseBuilder.addFeaturePackDep(originalConfig.originOf(fp.getLocation().getProducer()), fp);
            }
            baseBuilder.setInheritConfigs(false);
            baseBuilder.includeDefaultConfig(this.model, this.name);
            baseBuilder.addConfig(ProvisioningDiffProvider.getBaseConfig(definedConfig));
            ProvisioningConfig baseC = baseBuilder.build();
            try (ProvisioningRuntime baseRt = ProvisioningRuntimeBuilder.newInstance(this.log).initLayout(layout.getFactory(), baseC).build();){
                ProvisionedConfig provisionedConfig = ProvisioningDiffProvider.getRequiredProvisionedConfig(baseRt.getConfigs(), this.model, this.name);
                return provisionedConfig;
            }
        }
    }
}

