/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.usergroup;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.EntityMapper;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectMapper;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectService;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.UserGroupPermissionMapper;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.usergroup.ModeledUserGroup;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupMapper;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupModel;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;

public class UserGroupService
extends ModeledDirectoryObjectService<ModeledUserGroup, UserGroup, UserGroupModel> {
    @Inject
    private EntityMapper entityMapper;
    @Inject
    private UserGroupMapper userGroupMapper;
    @Inject
    private UserGroupPermissionMapper userGroupPermissionMapper;
    @Inject
    private Provider<ModeledUserGroup> userGroupProvider;

    @Override
    protected ModeledDirectoryObjectMapper<UserGroupModel> getObjectMapper() {
        return this.userGroupMapper;
    }

    @Override
    protected ObjectPermissionMapper getPermissionMapper() {
        return this.userGroupPermissionMapper;
    }

    @Override
    protected ModeledUserGroup getObjectInstance(ModeledAuthenticatedUser currentUser, UserGroupModel model) throws GuacamoleException {
        boolean exposeRestrictedAttributes = model.getObjectID() == null ? true : this.hasObjectPermission(currentUser, model.getIdentifier(), ObjectPermission.Type.ADMINISTER);
        ModeledUserGroup group = this.userGroupProvider.get();
        group.init(currentUser, model, exposeRestrictedAttributes);
        return group;
    }

    @Override
    protected UserGroupModel getModelInstance(ModeledAuthenticatedUser currentUser, UserGroup object) throws GuacamoleException {
        UserGroupModel model = new UserGroupModel();
        ModeledUserGroup group = this.getObjectInstance(currentUser, model);
        group.setIdentifier(object.getIdentifier());
        group.setAttributes(object.getAttributes());
        return model;
    }

    @Override
    protected boolean hasCreatePermission(ModeledAuthenticatedUser user) throws GuacamoleException {
        SystemPermissionSet permissionSet = user.getUser().getEffectivePermissions().getSystemPermissions();
        return permissionSet.hasPermission(SystemPermission.Type.CREATE_USER);
    }

    @Override
    protected ObjectPermissionSet getEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getUserGroupPermissions();
    }

    @Override
    protected void beforeCreate(ModeledAuthenticatedUser user, UserGroup object, UserGroupModel model) throws GuacamoleException {
        super.beforeCreate(user, object, model);
        if (model.getIdentifier() == null || model.getIdentifier().trim().isEmpty()) {
            throw new GuacamoleClientException("The group name must not be blank.");
        }
        UserGroupModel existing = this.userGroupMapper.selectOne(model.getIdentifier());
        if (existing != null) {
            throw new GuacamoleClientException("Group \"" + model.getIdentifier() + "\" already exists.");
        }
        this.entityMapper.insert(model);
    }

    @Override
    protected void beforeUpdate(ModeledAuthenticatedUser user, ModeledUserGroup object, UserGroupModel model) throws GuacamoleException {
        super.beforeUpdate(user, object, model);
        if (model.getIdentifier() == null || model.getIdentifier().trim().isEmpty()) {
            throw new GuacamoleClientException("The group name must not be blank.");
        }
        UserGroupModel existing = this.userGroupMapper.selectOne(model.getIdentifier());
        if (existing != null && !existing.getObjectID().equals(model.getObjectID())) {
            throw new GuacamoleClientException("Group \"" + model.getIdentifier() + "\" already exists.");
        }
    }

    @Override
    protected boolean isValidIdentifier(String identifier) {
        return true;
    }
}

