/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.parts.extensions;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.BasePainter;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.ErrorPainter;
import net.sourceforge.jnlp.splashscreen.parts.extensions.SplashExtension;

public class ChristmasExtension
implements SplashExtension {
    private static final Random seed = new Random();
    private static final int avarege_star_width = 10;
    private final int avarege_fall_speed = 4;
    private final int avarege_rotation_speed = 2;
    private int w;
    private int h;
    private List<Star> stars = new ArrayList<Star>(50);

    @Override
    public Color getBackground() {
        return Color.black;
    }

    @Override
    public Color getTextColor() {
        return Color.DARK_GRAY;
    }

    @Override
    public Color getPluginTextColor() {
        return new Color(30, 30, 30);
    }

    ChristmasExtension() {
        this(0, 0);
    }

    ChristmasExtension(int w, int h) {
        this.adjustForSize(w, h);
    }

    @Override
    public void paint(Graphics g, BasePainter b) {
        for (Star star : this.stars) {
            Color forceColor1 = null;
            Color forceColor2 = null;
            if (b instanceof ErrorPainter) {
                forceColor1 = b.getBackgroundColor();
                forceColor2 = b.getWaterColor();
            }
            star.paint(g, forceColor1, forceColor2);
        }
    }

    @Override
    public void animate() {
        for (Star star : this.stars) {
            star.animate();
        }
    }

    @Override
    public final void adjustForSize(int w, int h) {
        this.w = w;
        this.h = h;
        int count = w / 22;
        while (this.stars.size() > count) {
            this.stars.remove(this.stars.size() - 1);
        }
        while (this.stars.size() < count) {
            this.stars.add(new Star());
        }
    }

    private class Star {
        private int radiusX;
        private int radiusY;
        private int maxRadiusX;
        private int maxRadiusY;
        private int centerX;
        private int centerY;
        private final int fallSpeed;
        private final boolean orientation;
        private final int[] originalColor = new int[3];
        private final int[] color = new int[this.originalColor.length];
        private int direction;
        private final boolean haveEight;

        public Star() {
            this.createRadiuses();
            this.haveEight = seed.nextBoolean();
            this.centerX = seed.nextInt(ChristmasExtension.this.w + 1);
            this.centerY = seed.nextInt(ChristmasExtension.this.h + 1);
            this.fallSpeed = 2 + seed.nextInt(2);
            this.orientation = seed.nextBoolean();
            this.direction = -(1 + seed.nextInt(1));
            if (seed.nextInt(4) == 0) {
                this.originalColor[0] = Color.yellow.getRed();
                this.originalColor[1] = Color.yellow.getGreen();
                this.originalColor[2] = Color.yellow.getBlue();
            } else {
                this.originalColor[0] = BasePainter.WATER_LIVE_COLOR.getRed();
                this.originalColor[1] = BasePainter.WATER_LIVE_COLOR.getGreen();
                this.originalColor[2] = BasePainter.WATER_LIVE_COLOR.getBlue();
            }
        }

        public void paint(Graphics g, Color forceColor1, Color forceColor2) {
            Color c = g.getColor();
            if (forceColor1 == null || forceColor2 == null) {
                g.setColor(new Color(this.color[0], this.color[1], this.color[2]));
            } else {
                g.setColor(ErrorPainter.interpolateColor(ChristmasExtension.this.h, this.centerY, forceColor1, forceColor2));
            }
            Polygon p = this.createPolygon();
            if (this.haveEight) {
                int min1 = Math.min(this.radiusX, this.radiusY);
                int min2 = min1 / 2;
                g.fillRect(this.centerX - min2, this.centerY - min2, min1, min1);
            }
            g.fillPolygon(p);
            g.setColor(c);
        }

        private void animate() {
            this.centerY += this.fallSpeed;
            if (this.orientation) {
                this.radiusX += this.direction;
                if (this.radiusX <= -this.direction) {
                    this.radiusX = this.direction = -this.direction;
                }
                if (this.radiusX >= this.maxRadiusX) {
                    this.direction = -this.direction;
                    this.radiusX = this.maxRadiusX;
                }
                this.interpolateColors(this.radiusX, this.maxRadiusX);
            } else {
                this.radiusY += this.direction;
                if (this.radiusY <= -this.direction) {
                    this.radiusY = this.direction = -this.direction;
                }
                if (this.radiusY >= this.maxRadiusY) {
                    this.direction = -this.direction;
                    this.radiusY = this.maxRadiusY;
                }
                this.interpolateColors(this.radiusY, this.maxRadiusY);
            }
            if (this.centerY > ChristmasExtension.this.h + this.radiusX * 2 || this.centerY > ChristmasExtension.this.h + this.radiusY * 2) {
                this.createRadiuses();
                this.centerX = seed.nextInt(ChristmasExtension.this.w + 1);
                this.centerY = -this.radiusY * 2;
            }
        }

        private int createRadius() {
            return 5 + seed.nextInt(10);
        }

        private Polygon createPolygon() {
            int min = Math.min(this.radiusX, this.radiusY) / 3;
            Polygon p = new Polygon();
            p.addPoint(this.centerX - this.radiusX, this.centerY);
            p.addPoint(this.centerX - min, this.centerY - min);
            p.addPoint(this.centerX, this.centerY - this.radiusY);
            p.addPoint(this.centerX + min, this.centerY - min);
            p.addPoint(this.centerX + this.radiusX, this.centerY);
            p.addPoint(this.centerX + min, this.centerY + min);
            p.addPoint(this.centerX, this.centerY + this.radiusY);
            p.addPoint(this.centerX - min, this.centerY + min);
            return p;
        }

        private void interpolateColors(int is, int max) {
            for (int i = 0; i < this.originalColor.length; ++i) {
                int fadeMin = this.centerY < 0 ? 0 : (this.centerY > ChristmasExtension.this.h ? 255 : (int)ErrorPainter.interpol(ChristmasExtension.this.h, this.centerY, 255.0, 0.0));
                int fadeMax = this.centerY < 0 ? 0 : (this.centerY > ChristmasExtension.this.h ? this.originalColor[i] : (int)ErrorPainter.interpol(ChristmasExtension.this.h, this.centerY, this.originalColor[i], 0.0));
                this.color[i] = (int)ErrorPainter.interpol(max, is, fadeMin, fadeMax);
            }
        }

        private void createRadiuses() {
            this.radiusY = this.radiusX = this.createRadius();
            switch (seed.nextInt(3)) {
                case 0: {
                    this.radiusX += 2 * this.radiusX / 3;
                    break;
                }
                case 1: {
                    this.radiusY += 2 * this.radiusY / 3;
                    break;
                }
            }
            this.maxRadiusX = this.radiusX;
            this.maxRadiusY = this.radiusY;
        }
    }
}

