/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.nb;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_nb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "sentralafrikansk tid",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskva normaltid",
               "MST",
               "Moskva sommertid",
               "MST",
               "Moskva tid",
               "MT",
            };
        final String[] Japan = new String[] {
               "japansk standardtid",
               "JST",
               "japansk sommertid",
               "JDT",
               "japansk tid",
               "JT",
            };
        final String[] Argentina = new String[] {
               "Argentinsk normaltid",
               "AST",
               "Argentinsk sommertid",
               "AST",
               "Argentinsk tid",
               "AT",
            };
        final String[] Hovd = new String[] {
               "Mongolsk (Khovd) normaltid",
               "HST",
               "Mongolsk (Khovd) sommertid",
               "HST",
               "Mongolsk (Khovd) tid",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Russisk (Magadan) normaltid",
               "MST",
               "Russisk (Magadan) sommertid",
               "MST",
               "Russisk (Magadan) tid",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "vest-sentralaustralsk standardtid",
               "ACWST",
               "vest-sentralaustralsk sommertid",
               "ACWDT",
               "vest-sentralaustralsk tid",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "sentraleuropeisk normaltid",
               "CET",
               "sentraleuropeisk sommertid",
               "CEST",
               "sentraleuropeisk tid",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Russisk (Sakhalin) normaltid",
               "SST",
               "Russisk (Sakhalin) sommertid",
               "SST",
               "Russisk (Sakhalin) tid",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "Australsk (Macquarie) tid",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "Normaltid for den nordamerikanske \u00f8stkysten",
               "EST",
               "Sommertid for den nordamerikanske \u00f8stkysten",
               "EDT",
               "Tidssone for den nordamerikanske \u00f8stkysten",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Normaltid for Hawaii og Aleutene",
               "HAST",
               "Sommertid for Hawaii og Aleutene",
               "HADT",
               "Tidssone for Hawaii og Aleutene",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "sentralaustralsk standardtid",
               "ACST",
               "sentralaustralsk sommertid",
               "ACDT",
               "sentralaustralsk tid",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "Australsk (Lord Howe-\u00f8ya) normaltid",
               "LHST",
               "Australsk (Lord Howe-\u00f8ya) sommertid",
               "LHDT",
               "Australsk (Lord Howe-\u00f8ya) tid",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "newzealandsk standardtid",
               "NZST",
               "newzealandsk sommertid",
               "NZDT",
               "newzealandsk tid",
               "NZT",
            };
        final String[] Yakutsk = new String[] {
               "Russisk (Jakutsk) normaltid",
               "YST",
               "Russisk (Jakutsk) sommertid",
               "YST",
               "Russisk (Jakutsk) tid",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "Normaltid for Stillehavskysten",
               "PST",
               "Sommertid for Stillehavskysten",
               "PDT",
               "Tidssone for Stillehavskysten",
               "PT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00f8stafrikansk tid",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Western = new String[] {
               "vesteuropeisk normaltid",
               "WEST",
               "vesteuropeisk sommertid",
               "WEST",
               "vesteuropeisk tid",
               "WET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00f8steuropeisk normaltid",
               "EEST",
               "\u00f8steuropeisk sommertid",
               "EEST",
               "\u00f8steuropeisk tid",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Kanadisk (Newfoundland) normaltid",
               "NST",
               "Kanadisk (Newfoundland) sommertid",
               "NDT",
               "Kanadisk (Newfoundland) tid",
               "NT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong-normaltid",
               "HKST",
               "Hong Kong-sommertid",
               "HKST",
               "Hong Kong-tid",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Argentinsk normaltid (vest)",
               "WAST",
               "Argentinsk sommertid (vest)",
               "WAST",
               "Argentinsk tid (vest)",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "atlanterhavskystlig standardtid",
               "AST",
               "atlanterhavskystlig sommertid",
               "ADT",
               "atlanterhavskystlig tid",
               "AT",
            };
        final String[] Africa_Western = new String[] {
               "vestafrikansk normaltid",
               "WAST",
               "vestafrikansk sommertid",
               "WAST",
               "vestafrikansk tid",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwich middeltid",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Indochina = new String[] {
               "indokinesisk tid",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "Russisk (Jekaterinburg) normaltid",
               "YST",
               "Russisk (Jekaterinburg) sommertid",
               "YST",
               "Russisk (Jekaterinburg) tid",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "Russisk (Volgograd) normaltid",
               "VST",
               "Russisk (Volgograd) sommertid",
               "VST",
               "Russisk (Volgograd) tid",
               "VT",
            };
        final String[] Israel = new String[] {
               "israelsk standardtid",
               "IST",
               "israelsk sommertid",
               "IDT",
               "israelsk tid",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "sentralindonesisk tid",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "s\u00f8rafrikansk tid",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00f8stindonesisk tid",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "koreansk standardtid",
               "KST",
               "koreansk sommertid",
               "KDT",
               "koreansk tid",
               "KT",
            };
        final String[] Omsk = new String[] {
               "Russisk (Omsk) normaltid",
               "OST",
               "Russisk (Omsk) sommertid",
               "OST",
               "Russisk (Omsk) tid",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "vestaustralsk standardtid",
               "AWST",
               "vestaustralsk sommertid",
               "AWDT",
               "vestaustralsk tid",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "vestindonesisk tid",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "Mongolsk (Ulan Bator) normaltid",
               "UBST",
               "Mongolsk (Ulan Bator) sommertid",
               "UBST",
               "Mongolsk (Ulan Bator) tid",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Nordamerikansk (Midtvesten) normaltid",
               "CST",
               "Nordamerikansk (Midtvesten) sommertid",
               "CDT",
               "Nordamerikansk (Midtvesten) tid",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00f8staustralsk standardtid",
               "AEST",
               "\u00f8staustralsk sommertid",
               "AEDT",
               "\u00f8staustralsk tid",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "Normaltid for Rocky Mountains (USA)",
               "MST",
               "Sommertid for Rocky Mountains (USA)",
               "MDT",
               "Tidssone for Rocky Mountains (USA)",
               "MT",
            };
        final String[] Arabian = new String[] {
               "arabisk standardtid",
               "AST",
               "arabisk sommertid",
               "ADT",
               "arabisk tid",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaskisk normaltid",
               "AKST",
               "Alaskisk sommertid",
               "AKDT",
               "Alaskisk tid",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "Russisk (Novisibirsk) normaltid",
               "NST",
               "Russisk (Novosibirsk) sommertid",
               "NST",
               "Russisk (Novisibirsk) tid",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "Russisk (Vladivostok) normaltid",
               "VST",
               "Russisk (Vladivostok) sommertid",
               "VST",
               "Russisk (Vladivostok) tid",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Russisk (Irkutsk) normaltid",
               "IST",
               "Russisk (Irkutsk) sommertid",
               "IST",
               "Russisk (Irkutsk) tid",
               "IT",
            };
        final String[] Noronha = new String[] {
               "Brasiliansk (Fernando de Noronha) normaltid",
               "FNST",
               "Brasiliansk (Fernando de Noronha) sommertid",
               "FNST",
               "Brasiliansk (Fernando de Noronha) tid",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Mongolsk (Tsjoibalsan) tid",
               "CST",
               "Mongolsk (Tsjoibalsan) sommertid",
               "CST",
               "Mongolsk (Tsjoibalsan) tid",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Brasilia normaltid",
               "BST",
               "Brasilia sommertid",
               "BST",
               "Brasilia-tid",
               "BT",
            };
        final String[] China = new String[] {
               "kinesisk standardtid",
               "CST",
               "kinesisk sommertid",
               "CDT",
               "kinesisk tid",
               "CT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Russisk (Krasnojarsk) normaltid",
               "KST",
               "Russisk (Krasnojarsk) sommertid",
               "KST",
               "Russisk (Krasnojarsk) tid",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Kasakhstansk tid (vest)",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] India = new String[] {
               "indisk standardtid",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Amazon = new String[] {
               "Amazonas normaltid",
               "AST",
               "Amazonas sommertid",
               "AST",
               "Amazonas-tid",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Kasakhstansk tid (\u00f8st)",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Libreville", Africa_Western },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Atlantic/St_Helena", GMT },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Europe/Guernsey", GMT },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Asia/Phnom_Penh", Indochina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Asia/Vientiane", Indochina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Riyadh", Arabian },
            { "Africa/Windhoek", Africa_Western },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Lome", GMT },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "Africa/Bamako", GMT },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Colombo", India },
            { "Asia/Omsk", Omsk },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Yakutsk", Yakutsk },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "Asia/Saigon", Indochina },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Africa/Niamey", Africa_Western },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "Asia/Pyongyang", Korea },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Yakutat", Alaska },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "Africa/Monrovia", GMT },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Africa/Accra", GMT },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
