/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference.colibri.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.codec.CodecUtil;
import org.jitsi.jicofo.conference.colibri.v2.Colibri2Session;
import org.jitsi.jicofo.conference.colibri.v2.Colibri2SessionKt;
import org.jitsi.jicofo.conference.colibri.v2.ColibriV2SessionManager;
import org.jitsi.jicofo.conference.colibri.v2.ExtensionsKt;
import org.jitsi.jicofo.conference.colibri.v2.ParticipantInfo;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceEntity;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.packet.IQ;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001XB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001a2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b+J\u0017\u0010,\u001a\u00070-\u00a2\u0006\u0002\b.2\b\b\u0002\u0010/\u001a\u00020\u000eH\u0002J\r\u00100\u001a\u00020&H\u0000\u00a2\u0006\u0002\b1J\u001b\u00100\u001a\u00020&2\f\u00102\u001a\b\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0002\b1J\u0015\u00100\u001a\u00020&2\u0006\u00103\u001a\u00020)H\u0000\u00a2\u0006\u0002\b1J\r\u00104\u001a\u00020&H\u0000\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b7J\u0016\u00108\u001a\u00020&2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001a0(H\u0002J#\u0010:\u001a\u00020&2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u001e\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b<J+\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020)2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0(2\u0006\u0010B\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\bCJ\u0018\u0010D\u001a\u00020&2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u001aH\u0002J\u001d\u0010H\u001a\u00020&2\u0006\u0010I\u001a\u00020J2\u0006\u0010\u001e\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\bKJ\u0006\u0010L\u001a\u00020MJ\b\u0010N\u001a\u00020\u001aH\u0016J\u001b\u0010O\u001a\u00020&2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020)0PH\u0000\u00a2\u0006\u0002\bQJ)\u0010R\u001a\u00020&2\u0006\u0010?\u001a\u00020)2\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010S\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\bTJ%\u0010U\u001a\u00020&2\u0006\u0010V\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\bWR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u00060\"R\u00020\u00000!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/jitsi/jicofo/conference/colibri/v2/Colibri2Session;", "", "colibriSessionManager", "Lorg/jitsi/jicofo/conference/colibri/v2/ColibriV2SessionManager;", "bridge", "Lorg/jitsi/jicofo/bridge/Bridge;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/jicofo/conference/colibri/v2/ColibriV2SessionManager;Lorg/jitsi/jicofo/bridge/Bridge;Lorg/jitsi/utils/logging2/Logger;)V", "getBridge", "()Lorg/jitsi/jicofo/bridge/Bridge;", "getColibriSessionManager", "()Lorg/jitsi/jicofo/conference/colibri/v2/ColibriV2SessionManager;", "created", "", "getCreated", "()Z", "setCreated", "(Z)V", "feedbackSources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "getFeedbackSources$jicofo", "()Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "setFeedbackSources$jicofo", "(Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;)V", "id", "", "getId", "()Ljava/lang/String;", "logger", "relayId", "getRelayId", "relays", "", "Lorg/jitsi/jicofo/conference/colibri/v2/Colibri2Session$Relay;", "xmppConnection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "createRelay", "", "initialParticipants", "", "Lorg/jitsi/jicofo/conference/colibri/v2/ParticipantInfo;", "initiator", "createRelay$jicofo", "createRequest", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ$Builder;", "Lorg/jetbrains/annotations/NotNull;", "create", "expire", "expire$jicofo", "participantsToExpire", "participantToExpire", "expireAllRelays", "expireAllRelays$jicofo", "expireRelay", "expireRelay$jicofo", "expireRelays", "relayIds", "expireRemoteParticipants", "participants", "expireRemoteParticipants$jicofo", "sendAllocationRequest", "Lorg/jivesoftware/smack/StanzaCollector;", "participant", "contents", "Lorg/jitsi/xmpp/extensions/jingle/ContentPacketExtension;", "useSctp", "sendAllocationRequest$jicofo", "sendRequest", "iq", "Lorg/jivesoftware/smack/packet/IQ;", "name", "setRelayTransport", "transport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "setRelayTransport$jicofo", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "toString", "updateForceMute", "", "updateForceMute$jicofo", "updateParticipant", "sources", "updateParticipant$jicofo", "updateRemoteParticipant", "participantInfo", "updateRemoteParticipant$jicofo", "Relay", "jicofo"})
public final class Colibri2Session {
    @NotNull
    private final ColibriV2SessionManager colibriSessionManager;
    @NotNull
    private final Bridge bridge;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AbstractXMPPConnection xmppConnection;
    @NotNull
    private final String id;
    @Nullable
    private final String relayId;
    private boolean created;
    @NotNull
    private ConferenceSourceMap feedbackSources;
    @NotNull
    private final Map<String, Relay> relays;

    /*
     * WARNING - void declaration
     */
    public Colibri2Session(@NotNull ColibriV2SessionManager colibriSessionManager, @NotNull Bridge bridge2, @NotNull Logger parentLogger) {
        Logger logger;
        Intrinsics.checkNotNullParameter(colibriSessionManager, "colibriSessionManager");
        Intrinsics.checkNotNullParameter(bridge2, "bridge");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.colibriSessionManager = colibriSessionManager;
        this.bridge = bridge2;
        Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        Colibri2Session colibri2Session = this;
        boolean bl = false;
        CharSequence charSequence = this.bridge.getJid().getResourceOrNull();
        if (charSequence != null && (charSequence = charSequence.toString()) != null) {
            void $this$logger_u24lambda_u2d1;
            CharSequence it = charSequence;
            boolean bl2 = false;
            $this$logger_u24lambda_u2d1.addContext("bridge", (String)it);
        }
        colibri2Session.logger = logger;
        this.xmppConnection = this.colibriSessionManager.getXmppConnection$jicofo();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "randomUUID().toString()");
        this.id = string;
        this.relayId = this.bridge.getRelayId();
        this.feedbackSources = new ConferenceSourceMap(null, 1, null);
        this.relays = new LinkedHashMap();
    }

    @NotNull
    public final ColibriV2SessionManager getColibriSessionManager() {
        return this.colibriSessionManager;
    }

    @NotNull
    public final Bridge getBridge() {
        return this.bridge;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getRelayId() {
        return this.relayId;
    }

    public final boolean getCreated() {
        return this.created;
    }

    public final void setCreated(boolean bl) {
        this.created = bl;
    }

    @NotNull
    public final ConferenceSourceMap getFeedbackSources$jicofo() {
        return this.feedbackSources;
    }

    public final void setFeedbackSources$jicofo(@NotNull ConferenceSourceMap conferenceSourceMap) {
        Intrinsics.checkNotNullParameter(conferenceSourceMap, "<set-?>");
        this.feedbackSources = conferenceSourceMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StanzaCollector sendAllocationRequest$jicofo(@NotNull ParticipantInfo participant, @NotNull List<? extends ContentPacketExtension> contents, boolean useSctp) {
        void $this$sendAllocationRequest_u24lambda_u2d3_u24lambda_u2d2;
        Transport.Builder builder;
        Colibri2Endpoint.Builder builder2;
        Intrinsics.checkNotNullParameter(participant, "participant");
        Intrinsics.checkNotNullParameter(contents, "contents");
        ConferenceModifyIQ.Builder request = this.createRequest(!this.created);
        Colibri2Endpoint.Builder $this$sendAllocationRequest_u24lambda_u2d3 = builder2 = Colibri2Endpoint.getBuilder();
        boolean bl = false;
        $this$sendAllocationRequest_u24lambda_u2d3.setId(participant.getId());
        $this$sendAllocationRequest_u24lambda_u2d3.setCreate(true);
        if (!((Map)participant.getSources()).isEmpty()) {
            $this$sendAllocationRequest_u24lambda_u2d3.setSources(ExtensionsKt.toColibriMediaSources(participant.getSources()));
        }
        $this$sendAllocationRequest_u24lambda_u2d3.setStatsId(participant.getStatsId());
        if (participant.getSupportsSourceNames()) {
            $this$sendAllocationRequest_u24lambda_u2d3.addCapability("source-names");
        }
        if (participant.getAudioMuted() || participant.getVideoMuted()) {
            $this$sendAllocationRequest_u24lambda_u2d3.setForceMute(participant.getAudioMuted(), participant.getVideoMuted());
        }
        Transport.Builder builder3 = builder = Transport.getBuilder();
        Colibri2Endpoint.Builder builder4 = $this$sendAllocationRequest_u24lambda_u2d3;
        boolean bl2 = false;
        $this$sendAllocationRequest_u24lambda_u2d3_u24lambda_u2d2.setIceControlling(true);
        if (useSctp) {
            $this$sendAllocationRequest_u24lambda_u2d3_u24lambda_u2d2.setSctp(new Sctp.Builder().build());
        }
        builder4.setTransport(builder.build());
        Colibri2Endpoint.Builder builder5 = builder2;
        Intrinsics.checkNotNullExpressionValue(builder5, "getBuilder().apply {\n   \u2026)\n            )\n        }");
        Colibri2Endpoint.Builder endpoint = builder5;
        Iterable $this$forEach$iv = contents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Media media;
            ContentPacketExtension it = (ContentPacketExtension)element$iv;
            boolean bl3 = false;
            if (ExtensionsKt.toMedia(it) == null) continue;
            boolean bl4 = false;
            endpoint.addMedia(media);
        }
        request.addEndpoint(endpoint.build());
        this.logger.trace(() -> Colibri2Session.sendAllocationRequest$lambda-6(participant, request));
        this.created = true;
        StanzaCollector stanzaCollector = this.xmppConnection.createStanzaCollectorAndSend(request.build());
        Intrinsics.checkNotNullExpressionValue(stanzaCollector, "xmppConnection.createSta\u2026rAndSend(request.build())");
        return stanzaCollector;
    }

    public final void updateParticipant$jicofo(@NotNull ParticipantInfo participant, @Nullable IceUdpTransportPacketExtension transport, @Nullable ConferenceSourceMap sources) {
        Colibri2Endpoint.Builder builder;
        Intrinsics.checkNotNullParameter(participant, "participant");
        if (transport == null && sources == null) {
            this.logger.info("Nothing to update.");
            return;
        }
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Colibri2Endpoint.Builder $this$updateParticipant_u24lambda_u2d7 = builder = Colibri2Endpoint.getBuilder();
        boolean bl = false;
        $this$updateParticipant_u24lambda_u2d7.setId(participant.getId());
        $this$updateParticipant_u24lambda_u2d7.setStatsId(participant.getStatsId());
        Colibri2Endpoint.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder().apply {\n   \u2026cipant.statsId)\n        }");
        Colibri2Endpoint.Builder endpoint = builder2;
        if (transport != null) {
            endpoint.setTransport(Transport.getBuilder().setIceUdpExtension(transport).build());
        }
        if (sources != null) {
            endpoint.setSources(ExtensionsKt.toColibriMediaSources(sources));
        }
        request.addEndpoint(endpoint.build());
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
        this.sendRequest(conferenceModifyIQ, "updateParticipant");
    }

    /*
     * WARNING - void declaration
     */
    public final void updateForceMute$jicofo(@NotNull Set<ParticipantInfo> participants) {
        Intrinsics.checkNotNullParameter(participants, "participants");
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = participants;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$updateForceMute_u24lambda_u2d9_u24lambda_u2d8;
            Colibri2Endpoint.Builder builder;
            ParticipantInfo participant = (ParticipantInfo)element$iv;
            boolean bl = false;
            Colibri2Endpoint.Builder builder2 = builder = Colibri2Endpoint.getBuilder();
            ConferenceModifyIQ.Builder builder3 = request;
            boolean bl2 = false;
            $this$updateForceMute_u24lambda_u2d9_u24lambda_u2d8.setId(participant.getId());
            $this$updateForceMute_u24lambda_u2d9_u24lambda_u2d8.setForceMute(participant.getAudioMuted(), participant.getVideoMuted());
            builder3.addEndpoint(builder.build());
        }
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
        this.sendRequest(conferenceModifyIQ, "updateForceMute");
    }

    public final void expire$jicofo() {
        this.relays.clear();
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null).setExpire(true);
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
        this.sendRequest(conferenceModifyIQ, "expire");
    }

    public final void expire$jicofo(@NotNull ParticipantInfo participantToExpire) {
        Intrinsics.checkNotNullParameter(participantToExpire, "participantToExpire");
        List<ParticipantInfo> list = Collections.singletonList(participantToExpire);
        Intrinsics.checkNotNullExpressionValue(list, "singletonList(participantToExpire)");
        this.expire$jicofo(list);
    }

    public final void expire$jicofo(@NotNull List<ParticipantInfo> participantsToExpire) {
        Intrinsics.checkNotNullParameter(participantsToExpire, "participantsToExpire");
        if (participantsToExpire.isEmpty()) {
            this.logger.debug(Colibri2Session::expire$lambda-10);
            return;
        }
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = participantsToExpire;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticipantInfo it = (ParticipantInfo)element$iv;
            boolean bl = false;
            Colibri2SessionKt.access$addExpire(request, it.getId());
        }
        this.logger.debug(() -> Colibri2Session.expire$lambda-13(participantsToExpire));
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
        this.sendRequest(conferenceModifyIQ, "expire(participantsToExpire)");
    }

    private final ConferenceModifyIQ.Builder createRequest(boolean create) {
        ConferenceModifyIQ.Builder builder;
        ConferenceModifyIQ.Builder $this$createRequest_u24lambda_u2d14 = builder = ConferenceModifyIQ.builder(this.xmppConnection);
        boolean bl = false;
        $this$createRequest_u24lambda_u2d14.to(this.bridge.getJid());
        $this$createRequest_u24lambda_u2d14.setMeetingId(this.colibriSessionManager.getMeetingId$jicofo());
        if (create) {
            $this$createRequest_u24lambda_u2d14.setCreate(true);
            $this$createRequest_u24lambda_u2d14.setConferenceName(this.colibriSessionManager.getConferenceName$jicofo());
            $this$createRequest_u24lambda_u2d14.setCallstatsEnabled(this.colibriSessionManager.getCallstatsEnabled$jicofo());
            $this$createRequest_u24lambda_u2d14.setRtcstatsEnabled(this.colibriSessionManager.getRtcStatsEnabled$jicofo());
        }
        ConferenceModifyIQ.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue(builder2, "builder(xmppConnection).\u2026sEnabled)\n        }\n    }");
        return builder2;
    }

    static /* synthetic */ ConferenceModifyIQ.Builder createRequest$default(Colibri2Session colibri2Session, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return colibri2Session.createRequest(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createRelay$jicofo(@NotNull String relayId, @NotNull List<ParticipantInfo> initialParticipants, boolean initiator) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        Intrinsics.checkNotNullParameter(initialParticipants, "initialParticipants");
        Iterable iterable = initialParticipants;
        boolean bl = initiator;
        String string = relayId;
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        collection = (List)destination$iv$iv;
        logger.info("Creating relay " + string + " (initiator=" + bl + "), initial participants: " + (List)collection);
        if (this.relays.containsKey(relayId)) {
            throw new IllegalStateException("Relay " + relayId + " already exists");
        }
        Relay relay = new Relay(relayId, initiator);
        this.relays.put(relayId, relay);
        relay.start(initialParticipants);
    }

    public final void updateRemoteParticipant$jicofo(@NotNull ParticipantInfo participantInfo, @NotNull String relayId, boolean create) {
        Unit unit;
        Intrinsics.checkNotNullParameter(participantInfo, "participantInfo");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.logger.debug(() -> Colibri2Session.updateRemoteParticipant$lambda-16(participantInfo, relayId));
        Relay relay = this.relays.get(relayId);
        if (relay != null) {
            relay.updateParticipant(participantInfo, create);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist.");
        }
    }

    public final void expireRemoteParticipants$jicofo(@NotNull List<ParticipantInfo> participants, @NotNull String relayId) {
        Unit unit;
        Intrinsics.checkNotNullParameter(participants, "participants");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.logger.debug(() -> Colibri2Session.expireRemoteParticipants$lambda-18(relayId, participants));
        Relay relay = this.relays.get(relayId);
        if (relay != null) {
            relay.expireParticipants(participants);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist.");
        }
    }

    public final void setRelayTransport$jicofo(@NotNull IceUdpTransportPacketExtension transport, @NotNull String relayId) {
        Unit unit;
        Intrinsics.checkNotNullParameter(transport, "transport");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.logger.info("Setting relay transport for " + relayId);
        this.logger.debug(() -> Colibri2Session.setRelayTransport$lambda-19(relayId, transport));
        Relay relay = this.relays.get(relayId);
        if (relay != null) {
            relay.setTransport(transport);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist.");
        }
    }

    public final void expireAllRelays$jicofo() {
        this.expireRelays(CollectionsKt.toList((Iterable)this.relays.keySet()));
    }

    public final void expireRelay$jicofo(@NotNull String relayId) {
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.expireRelays(CollectionsKt.listOf(relayId));
    }

    /*
     * WARNING - void declaration
     */
    private final void expireRelays(List<String> relayIds) {
        String it;
        if (relayIds.isEmpty()) {
            this.logger.debug("No relays to expire.");
            return;
        }
        this.logger.info("Expiring relays: " + relayIds);
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = relayIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$expireRelays_u24lambda_u2d21_u24lambda_u2d20;
            Colibri2Relay.Builder builder;
            it = (String)element$iv;
            boolean bl = false;
            Colibri2Relay.Builder builder2 = builder = Colibri2Relay.getBuilder();
            ConferenceModifyIQ.Builder builder3 = request;
            boolean bl2 = false;
            $this$expireRelays_u24lambda_u2d21_u24lambda_u2d20.setId(it);
            $this$expireRelays_u24lambda_u2d21_u24lambda_u2d20.setExpire(true);
            builder3.addRelay(builder.build());
        }
        $this$forEach$iv = relayIds;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.relays.remove(it);
        }
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
        this.sendRequest(conferenceModifyIQ, "expireRelays");
    }

    private final void sendRequest(IQ iq, String name) {
        this.logger.debug(() -> Colibri2Session.sendRequest$lambda-23(name, iq));
        ExtensionsKt.sendIqAndHandleResponseAsync(this.xmppConnection, iq, (Function1<? super IQ, Unit>)new Function1<IQ, Unit>(this, name){
            final /* synthetic */ Colibri2Session this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(1);
            }

            public final void invoke(@Nullable IQ it) {
                IQ iQ = it;
                if (iQ instanceof ConferenceModifiedIQ) {
                    Colibri2Session.access$getLogger$p(this.this$0).debug(() -> sendRequest.2.invoke$lambda-0(this.$name, it));
                } else if (iQ == null) {
                    Colibri2Session.access$getLogger$p(this.this$0).info(this.$name + " request timed out. Ignoring.");
                } else {
                    Colibri2Session.access$getLogger$p(this.this$0).error("Received error response for " + this.$name + ", session failed: " + it.toXML());
                    this.this$0.getColibriSessionManager().sessionFailed$jicofo(this.this$0);
                }
            }

            private static final String invoke$lambda-0(String $name, IQ $it) {
                Intrinsics.checkNotNullParameter($name, "$name");
                return "Received " + $name + " response: " + ((ConferenceModifiedIQ)$it).toXML();
            }
        });
    }

    @NotNull
    public String toString() {
        return "Colibri2Session[bridge=" + this.bridge.getJid().getResourceOrNull() + ", id=" + this.id + "]";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OrderedJsonObject toJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject orderedJsonObject2;
        OrderedJsonObject $this$toJson_u24lambda_u2d26 = orderedJsonObject2 = new OrderedJsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u2d26.put("bridge", this.bridge.getDebugState());
        $this$toJson_u24lambda_u2d26.put("id", this.id);
        $this$toJson_u24lambda_u2d26.put("feedback_sources", this.feedbackSources.toJson());
        $this$toJson_u24lambda_u2d26.put("created", (Object)this.created);
        OrderedJsonObject orderedJsonObject3 = orderedJsonObject = new OrderedJsonObject();
        String string = "relays";
        OrderedJsonObject orderedJsonObject4 = $this$toJson_u24lambda_u2d26;
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.relays.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$toJson_u24lambda_u2d26_u24lambda_u2d25;
            Relay it = (Relay)element$iv;
            boolean bl3 = false;
            $this$toJson_u24lambda_u2d26_u24lambda_u2d25.put(it.getId(), it.toJson());
        }
        Unit unit = Unit.INSTANCE;
        orderedJsonObject4.put(string, orderedJsonObject);
        return orderedJsonObject2;
    }

    private static final String sendAllocationRequest$lambda-6(ParticipantInfo $participant, ConferenceModifyIQ.Builder $request) {
        Intrinsics.checkNotNullParameter($participant, "$participant");
        Intrinsics.checkNotNullParameter($request, "$request");
        return "Sending allocation request for " + $participant.getId() + ": " + $request.build().toXML();
    }

    private static final String expire$lambda-10() {
        return "No participants to expire.";
    }

    /*
     * WARNING - void declaration
     */
    private static final String expire$lambda-13(List $participantsToExpire) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($participantsToExpire, "$participantsToExpire");
        Iterable $this$map$iv = $participantsToExpire;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return "Expiring endpoint: " + (List)destination$iv$iv;
    }

    private static final String updateRemoteParticipant$lambda-16(ParticipantInfo $participantInfo, String $relayId) {
        Intrinsics.checkNotNullParameter($participantInfo, "$participantInfo");
        Intrinsics.checkNotNullParameter($relayId, "$relayId");
        return "Updating remote participant " + $participantInfo.getId() + " on " + $relayId;
    }

    /*
     * WARNING - void declaration
     */
    private static final String expireRemoteParticipants$lambda-18(String $relayId, List $participants) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($relayId, "$relayId");
        Intrinsics.checkNotNullParameter($participants, "$participants");
        Iterable iterable = $participants;
        String string = $relayId;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return "Expiring remote participants on " + string + ": " + (List)destination$iv$iv;
    }

    private static final String setRelayTransport$lambda-19(String $relayId, IceUdpTransportPacketExtension $transport) {
        Intrinsics.checkNotNullParameter($relayId, "$relayId");
        Intrinsics.checkNotNullParameter($transport, "$transport");
        return "Setting relay transport for " + $relayId + ": " + $transport.toXML();
    }

    private static final String sendRequest$lambda-23(String $name, IQ $iq) {
        Intrinsics.checkNotNullParameter($name, "$name");
        Intrinsics.checkNotNullParameter($iq, "$iq");
        return "Sending " + $name + " request: " + $iq.toXML();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jitsi/jicofo/conference/colibri/v2/Colibri2Session$Relay;", "", "id", "", "initiator", "", "(Lorg/jitsi/jicofo/conference/colibri/v2/Colibri2Session;Ljava/lang/String;Z)V", "dtlsSetup", "iceControlling", "getId", "()Ljava/lang/String;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "useUniquePort", "websocketActive", "buildCreateRelayRequest", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "participants", "", "Lorg/jitsi/jicofo/conference/colibri/v2/ParticipantInfo;", "expireParticipants", "", "", "setTransport", "transport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "start", "initialParticipants", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "updateParticipant", "participant", "create", "jicofo"})
    private final class Relay {
        @NotNull
        private final String id;
        private final boolean useUniquePort;
        private final boolean iceControlling;
        @NotNull
        private final String dtlsSetup;
        private final boolean websocketActive;
        @NotNull
        private final Logger logger;

        /*
         * WARNING - void declaration
         */
        public Relay(String id, boolean initiator) {
            void $this$logger_u24lambda_u2d0;
            Logger logger;
            Intrinsics.checkNotNullParameter(id, "id");
            this.id = id;
            this.useUniquePort = initiator;
            this.iceControlling = initiator;
            this.dtlsSetup = initiator ? "active" : "passive";
            this.websocketActive = initiator;
            Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default(this, Colibri2Session.this.logger, null, 2, null);
            Relay relay = this;
            boolean bl = false;
            $this$logger_u24lambda_u2d0.addContext("relay", this.id);
            relay.logger = logger;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final void start(@NotNull List<ParticipantInfo> initialParticipants) {
            Intrinsics.checkNotNullParameter(initialParticipants, "initialParticipants");
            ConferenceModifyIQ request = this.buildCreateRelayRequest((Collection<ParticipantInfo>)initialParticipants);
            this.logger.trace(() -> Relay.start$lambda-1(request));
            ExtensionsKt.sendIqAndHandleResponseAsync(Colibri2Session.this.xmppConnection, request, (Function1<? super IQ, Unit>)new Function1<IQ, Unit>(this, Colibri2Session.this){
                final /* synthetic */ Relay this$0;
                final /* synthetic */ Colibri2Session this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@Nullable IQ response) {
                    Relay.access$getLogger$p(this.this$0).trace(() -> start.2.invoke$lambda-0(response));
                    if (!(response instanceof ConferenceModifiedIQ)) {
                        Logger logger = Relay.access$getLogger$p(this.this$0);
                        IQ iQ = response;
                        CharSequence charSequence = iQ != null ? iQ.toXML() : null;
                        if (charSequence == null) {
                            charSequence = "timeout";
                        }
                        logger.error("Received error: " + charSequence);
                        this.this$1.getColibriSessionManager().sessionFailed$jicofo(this.this$1);
                        return;
                    }
                    List<Colibri2Relay> list = ((ConferenceModifiedIQ)response).getRelays();
                    Intrinsics.checkNotNullExpressionValue(list, "response.relays");
                    AbstractPacketExtension abstractPacketExtension = CollectionsKt.firstOrNull(list);
                    if (abstractPacketExtension == null || (abstractPacketExtension = ((AbstractConferenceEntity)abstractPacketExtension).getTransport()) == null) {
                        Relay relay = this.this$0;
                        Colibri2Session colibri2Session = this.this$1;
                        Relay $this$invoke_u24lambda_u2d1 = relay;
                        boolean bl = false;
                        Relay.access$getLogger$p($this$invoke_u24lambda_u2d1).error("No transport in response: " + ((ConferenceModifiedIQ)response).toXML());
                        colibri2Session.getColibriSessionManager().sessionFailed$jicofo(colibri2Session);
                        return;
                    }
                    AbstractPacketExtension transport = abstractPacketExtension;
                    IceUdpTransportPacketExtension iceUdpTransport = ((Transport)transport).getIceUdpTransport();
                    if (iceUdpTransport == null) {
                        Relay.access$getLogger$p(this.this$0).error("Response has no iceUdpTransport");
                        this.this$1.getColibriSessionManager().sessionFailed$jicofo(this.this$1);
                        return;
                    }
                    this.this$1.getColibriSessionManager().setRelayTransport$jicofo(this.this$1, iceUdpTransport, this.this$0.getId());
                }

                private static final String invoke$lambda-0(IQ $response) {
                    IQ iQ = $response;
                    return "Received response: " + (iQ != null ? iQ.toXML() : null);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void setTransport(@NotNull IceUdpTransportPacketExtension transport) {
            void $this$setTransport_u24lambda_u2d5;
            AbstractPacketExtension it;
            Object element$iv2;
            Intrinsics.checkNotNullParameter(transport, "transport");
            List<DtlsFingerprintPacketExtension> list = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            Intrinsics.checkNotNullExpressionValue(list, "transport.getChildExtens\u2026ketExtension::class.java)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (DtlsFingerprintPacketExtension)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSetup(), "actpass")) {
                    this.logger.error("Response has an unexpected dtls setup field: " + it.getSetup());
                    return;
                }
                this.logger.info("Setting setup=" + this.dtlsSetup + " for " + this.id);
                it.setSetup(this.dtlsSetup);
            }
            if (!this.websocketActive) {
                List<WebSocketPacketExtension> list2 = transport.getChildExtensionsOfType(WebSocketPacketExtension.class);
                Intrinsics.checkNotNullExpressionValue(list2, "transport.getChildExtens\u2026ketExtension::class.java)");
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    it = (WebSocketPacketExtension)element$iv2;
                    boolean bl = false;
                    transport.removeChildExtension(it);
                }
            }
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(Colibri2Session.this, false, 1, null);
            element$iv2 = Colibri2Relay.getBuilder();
            Object $this$setTransport_u24lambda_u2d4 = element$iv2;
            boolean bl = false;
            ((AbstractConferenceEntity.Builder)$this$setTransport_u24lambda_u2d4).setId(this.id);
            ((AbstractConferenceEntity.Builder)$this$setTransport_u24lambda_u2d4).setCreate(false);
            Object t = element$iv2;
            Intrinsics.checkNotNullExpressionValue(t, "getBuilder().apply {\n   \u2026eate(false)\n            }");
            Object relay = t;
            Transport.Builder builder = Transport.getBuilder();
            element$iv2 = builder;
            Object t2 = relay;
            boolean bl2 = false;
            $this$setTransport_u24lambda_u2d5.setIceUdpExtension(transport);
            ((AbstractConferenceEntity.Builder)t2).setTransport(builder.build());
            request.addRelay(((Colibri2Relay.Builder)relay).build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
            Colibri2Session.this.sendRequest(conferenceModifyIQ, "Relay.setTransport");
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u2d6 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u2d6.put("id", this.id);
            $this$toJson_u24lambda_u2d6.put("use_unique_port", (Object)this.useUniquePort);
            $this$toJson_u24lambda_u2d6.put("ice_controlling", (Object)this.iceControlling);
            $this$toJson_u24lambda_u2d6.put("dtls_setup", this.dtlsSetup);
            $this$toJson_u24lambda_u2d6.put("websocket_active", (Object)this.websocketActive);
            return orderedJsonObject;
        }

        public final void updateParticipant(@NotNull ParticipantInfo participant, boolean create) {
            Colibri2Relay.Builder builder;
            Intrinsics.checkNotNullParameter(participant, "participant");
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(Colibri2Session.this, false, 1, null);
            Colibri2Relay.Builder $this$updateParticipant_u24lambda_u2d7 = builder = Colibri2Relay.getBuilder();
            boolean bl = false;
            $this$updateParticipant_u24lambda_u2d7.setId(this.id);
            Colibri2Relay.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder().apply {\n   \u2026  setId(id)\n            }");
            Colibri2Relay.Builder relay = builder2;
            Endpoints.Builder builder3 = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder3, "getBuilder()");
            Endpoints.Builder endpoints = builder3;
            endpoints.addEndpoint(ExtensionsKt.toEndpoint(participant, create, false));
            relay.setEndpoints(endpoints.build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
            Colibri2Session.this.sendRequest(conferenceModifyIQ, "Relay.updateParticipant");
        }

        public final void expireParticipants(@NotNull List<ParticipantInfo> participants) {
            Colibri2Relay.Builder builder;
            Intrinsics.checkNotNullParameter(participants, "participants");
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(Colibri2Session.this, false, 1, null);
            Colibri2Relay.Builder $this$expireParticipants_u24lambda_u2d8 = builder = Colibri2Relay.getBuilder();
            boolean bl = false;
            $this$expireParticipants_u24lambda_u2d8.setId(this.id);
            Colibri2Relay.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder().apply { setId(id) }");
            Colibri2Relay.Builder relay = builder2;
            Endpoints.Builder builder3 = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder3, "getBuilder()");
            Endpoints.Builder endpoints = builder3;
            Iterable $this$forEach$iv = participants;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParticipantInfo it = (ParticipantInfo)element$iv;
                boolean bl2 = false;
                endpoints.addEndpoint(ExtensionsKt.toEndpoint(it, false, true));
            }
            relay.setEndpoints(endpoints.build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
            Colibri2Session.this.sendRequest(conferenceModifyIQ, "Relay.expireParticipants");
        }

        /*
         * WARNING - void declaration
         */
        private final ConferenceModifyIQ buildCreateRelayRequest(Collection<ParticipantInfo> participants) {
            void $this$buildCreateRelayRequest_u24lambda_u2d18;
            void $this$buildCreateRelayRequest_u24lambda_u2d16;
            AbstractPacketExtension it;
            Object element$iv;
            Media.Builder $this$buildCreateRelayRequest_u24lambda_u2d13;
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(Colibri2Session.this, false, 1, null);
            Object object = Colibri2Relay.getBuilder();
            Colibri2Relay.Builder $this$buildCreateRelayRequest_u24lambda_u2d10 = object;
            boolean bl = false;
            $this$buildCreateRelayRequest_u24lambda_u2d10.setId(this.id);
            $this$buildCreateRelayRequest_u24lambda_u2d10.setCreate(true);
            Colibri2Relay.Builder builder = object;
            Intrinsics.checkNotNullExpressionValue(builder, "getBuilder().apply {\n   \u2026reate(true)\n            }");
            Colibri2Relay.Builder relay = builder;
            Media.Builder builder2 = Media.getBuilder();
            object = builder2;
            Colibri2Relay.Builder builder3 = relay;
            boolean bl2 = false;
            $this$buildCreateRelayRequest_u24lambda_u2d13.setType(MediaType.AUDIO);
            Object $this$forEach$iv = CodecUtil.Companion.createAudioPayloadTypeExtensions$default(CodecUtil.Companion, null, 1, null);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (PayloadTypePacketExtension)element$iv;
                boolean bl3 = false;
                $this$buildCreateRelayRequest_u24lambda_u2d13.addPayloadType((PayloadTypePacketExtension)it);
            }
            $this$forEach$iv = CodecUtil.Companion.createAudioRtpHdrExtExtensions$default(CodecUtil.Companion, null, 1, null);
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (RTPHdrExtPacketExtension)element$iv;
                boolean bl4 = false;
                $this$buildCreateRelayRequest_u24lambda_u2d13.addRtpHdrExt((RTPHdrExtPacketExtension)it);
            }
            builder3.addMedia(builder2.build());
            $this$buildCreateRelayRequest_u24lambda_u2d13 = builder2 = Media.getBuilder();
            builder3 = relay;
            boolean bl5 = false;
            $this$buildCreateRelayRequest_u24lambda_u2d16.setType(MediaType.VIDEO);
            $this$forEach$iv = CodecUtil.Companion.createVideoPayloadTypeExtensions$default(CodecUtil.Companion, null, 1, null);
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (PayloadTypePacketExtension)element$iv;
                boolean bl6 = false;
                $this$buildCreateRelayRequest_u24lambda_u2d16.addPayloadType((PayloadTypePacketExtension)it);
            }
            $this$forEach$iv = CodecUtil.Companion.createVideoRtpHdrExtExtensions$default(CodecUtil.Companion, null, 1, null);
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (RTPHdrExtPacketExtension)element$iv;
                boolean bl7 = false;
                $this$buildCreateRelayRequest_u24lambda_u2d16.addRtpHdrExt((RTPHdrExtPacketExtension)it);
            }
            builder3.addMedia(builder2.build());
            Endpoints.Builder builder4 = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder4, "getBuilder()");
            Endpoints.Builder endpoints = builder4;
            Iterable $this$forEach$iv2 = participants;
            boolean $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ParticipantInfo it2 = (ParticipantInfo)element$iv2;
                boolean bl8 = false;
                endpoints.addEndpoint(ExtensionsKt.toEndpoint(it2, true, false));
            }
            relay.setEndpoints(endpoints.build());
            Object $i$f$forEach22 = object = Transport.getBuilder();
            builder3 = relay;
            boolean bl9 = false;
            $this$buildCreateRelayRequest_u24lambda_u2d18.setUseUniquePort(this.useUniquePort);
            $this$buildCreateRelayRequest_u24lambda_u2d18.setIceControlling(this.iceControlling);
            builder3.setTransport(((Transport.Builder)object).build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "request.build()");
            return conferenceModifyIQ;
        }

        private static final String start$lambda-1(ConferenceModifyIQ $request) {
            Intrinsics.checkNotNullParameter($request, "$request");
            return "Sending create relay: " + $request.toXML();
        }

        public static final /* synthetic */ Logger access$getLogger$p(Relay $this) {
            return $this.logger;
        }
    }
}

