"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var geometries_1 = require("./geometries");
function getCurrentPointerStates(state) {
    return state.interactions.pointer;
}
exports.getBrushedHighlightedShapesSelector = re_reselect_1.default([geometries_1.geometries, getCurrentPointerStates], function (geoms, pointerStates) {
    if (!pointerStates.dragging || !pointerStates.down) {
        return null;
    }
    var _a = pointerStates.down.position, startX = _a.x, startY = _a.y, _b = pointerStates.current.position, endX = _b.x, endY = _b.y;
    var shape = geoms.pickDragShape([
        { x: startX, y: startY },
        { x: endX, y: endY },
    ]);
    return shape;
})({
    keySelector: get_chart_id_1.getChartIdSelector,
});
//# sourceMappingURL=get_brushed_highlighted_shapes.js.map