"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
// eslint-disable-next-line import/no-default-export
function _default(Client, config, components) {
  const ca = components.clientAction.factory;

  if (!Client.prototype.opensearch_security) {
    Client.prototype.opensearch_security = components.clientAction.namespaceFactory();
  }
  /**
   * Gets auth info.
   */


  Client.prototype.opensearch_security.prototype.authinfo = ca({
    url: {
      fmt: '/_plugins/_security/authinfo'
    }
  });
  /**
   * Gets tenant info and opensearch-dashboards server info.
   *
   * e.g.
   * {
   *   "user_name": "admin",
   *   "not_fail_on_forbidden_enabled": false,
   *   "opensearch_dashboards_mt_enabled": true,
   *   "opensearch_dashboards_index": ".opensearch_dashboards",
   *   "opensearch_dashboards_server_user": "kibanaserver"
   * }
   */

  Client.prototype.opensearch_security.prototype.multitenancyinfo = ca({
    url: {
      fmt: '/_plugins/_security/dashboardsinfo'
    }
  });
  /**
   * Gets tenant info. The output looks like:
   * {
   *   ".opensearch_dashboards_92668751_admin":"__private__"
   * }
   */

  Client.prototype.opensearch_security.prototype.tenantinfo = ca({
    url: {
      fmt: '/_plugins/_security/tenantinfo'
    }
  });
  /**
   * Gets SAML token.
   */

  Client.prototype.opensearch_security.prototype.authtoken = ca({
    method: 'POST',
    needBody: true,
    url: {
      fmt: '/_plugins/_security/api/authtoken'
    }
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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