/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 % ivec3(36, 32, 88)) => ivec3(12, 12, 12)
 * (12 % ivec3(59, 77, 68)) => ivec3(12, 12, 12)
 * (76 % ivec3(36, 32, 88)) => ivec3(4, 12, 76)
 * (76 % ivec3(59, 77, 68)) => ivec3(17, 76, 8)
 * (0 % ivec3(36, 32, 88)) => ivec3(0, 0, 0)
 * (0 % ivec3(59, 77, 68)) => ivec3(0, 0, 0)
 */
#version 150

void main()
{
  float[all(equal((12 % ivec3(36, 32, 88)), ivec3(12, 12, 12))) ? 1 : -1] array0;
  float[all(equal((12 % ivec3(59, 77, 68)), ivec3(12, 12, 12))) ? 1 : -1] array1;
  float[all(equal((76 % ivec3(36, 32, 88)), ivec3(4, 12, 76))) ? 1 : -1] array2;
  float[all(equal((76 % ivec3(59, 77, 68)), ivec3(17, 76, 8))) ? 1 : -1] array3;
  float[all(equal((0 % ivec3(36, 32, 88)), ivec3(0, 0, 0))) ? 1 : -1] array4;
  float[all(equal((0 % ivec3(59, 77, 68)), ivec3(0, 0, 0))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
