# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2022 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_vmc_app.model.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ActionMessage(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'message': 'message',
                            }

    def __init__(self,
                 message=None,
                ):
        """
        :type  message: :class:`str` or ``None``
        :param message: Optional message for action
        """
        self.message = message
        VapiStruct.__init__(self)


ActionMessage._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.action_message', {
        'message': type.OptionalType(type.StringType()),
    },
    ActionMessage,
    False,
    None))



class AdvertisedRoute(VapiStruct):
    """
    Advertised BGP route

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ADVERTISEMENT_STATE_SUCCESS = "SUCCESS"
    """


    """
    ADVERTISEMENT_STATE_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'advertisement_state': 'advertisement_state',
                            'ipv4_cidr': 'ipv4_cidr',
                            }

    def __init__(self,
                 advertisement_state=None,
                 ipv4_cidr=None,
                ):
        """
        :type  advertisement_state: :class:`str` or ``None``
        :param advertisement_state: Possible values are: 
            
            * :attr:`AdvertisedRoute.ADVERTISEMENT_STATE_SUCCESS`
            * :attr:`AdvertisedRoute.ADVERTISEMENT_STATE_FAILED`
            
             State of advertisement
        :type  ipv4_cidr: :class:`str` or ``None``
        :param ipv4_cidr: The route that is advertised to on-premise datacenter via Direct
            Connect format: ipv4-cidr-block
        """
        self.advertisement_state = advertisement_state
        self.ipv4_cidr = ipv4_cidr
        VapiStruct.__init__(self)


AdvertisedRoute._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.advertised_route', {
        'advertisement_state': type.OptionalType(type.StringType()),
        'ipv4_cidr': type.OptionalType(type.StringType()),
    },
    AdvertisedRoute,
    False,
    None))



class AggregationRouteConfigInfo(VapiStruct):
    """
    AggregationrouteConfigInfo object.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'advertise_always': 'advertise_always',
                            'aggregation_path': 'aggregation_path',
                            }

    def __init__(self,
                 advertise_always=None,
                 aggregation_path=None,
                ):
        """
        :type  advertise_always: :class:`bool` or ``None``
        :param advertise_always: Flag set to true implies that the customer provided CIDRs along
            with the VMC segments will be advertised irrespective of any
            match/un-match found
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  aggregation_path: :class:`str` or ``None``
        :param aggregation_path: RouteAggregationConfig path information.
        """
        self.advertise_always = advertise_always
        self.aggregation_path = aggregation_path
        VapiStruct.__init__(self)


AggregationRouteConfigInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.aggregation_route_config_info', {
        'advertise_always': type.OptionalType(type.BooleanType()),
        'aggregation_path': type.OptionalType(type.StringType()),
    },
    AggregationRouteConfigInfo,
    False,
    None))



class ApiError(VapiStruct):
    """
    Detailed information about an API Error

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'error_code': 'error_code',
                            'error_data': 'error_data',
                            'error_message': 'error_message',
                            'module_name': 'module_name',
                            'related_errors': 'related_errors',
                            }

    def __init__(self,
                 details=None,
                 error_code=None,
                 error_data=None,
                 error_message=None,
                 module_name=None,
                 related_errors=None,
                ):
        """
        :type  details: :class:`str` or ``None``
        :param details: Further details about the error
        :type  error_code: :class:`long` or ``None``
        :param error_code: A numeric error code format: int64
        :type  error_data: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param error_data: Additional data about the error
        :type  error_message: :class:`str` or ``None``
        :param error_message: A description of the error
        :type  module_name: :class:`str` or ``None``
        :param module_name: The module name where the error occurred
        :type  related_errors: :class:`list` of :class:`RelatedApiError` or ``None``
        :param related_errors: Other errors related to this error
        """
        self.details = details
        self.error_code = error_code
        self.error_data = error_data
        self.error_message = error_message
        self.module_name = module_name
        self.related_errors = related_errors
        VapiStruct.__init__(self)


ApiError._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.api_error', {
        'details': type.OptionalType(type.StringType()),
        'error_code': type.OptionalType(type.IntegerType()),
        'error_data': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'error_message': type.OptionalType(type.StringType()),
        'module_name': type.OptionalType(type.StringType()),
        'related_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RelatedApiError'))),
    },
    ApiError,
    False,
    None))



class AssociatedBaseGroupConnectionInfo(VapiStruct):
    """
    Base abstract associated Group connection infomation for the local SDDC.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssociatedBaseGroupConnectionInfo"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFO = "AssociatedTgwGroupConnectionInfo"
    """


    """
    RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFOVERSION2 = "AssociatedTgwGroupConnectionInfoVersion2"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'name': 'name',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='AssociatedBaseGroupConnectionInfo',
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 name=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: SDDC Group description
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: SDDC Group ID
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`AssociatedBaseGroupConnectionInfo.RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFO`
            *
              :attr:`AssociatedBaseGroupConnectionInfo.RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFOVERSION2`
            
             Group connection type
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  name: :class:`str` or ``None``
        :param name: SDDC Group name
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.name = name
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssociatedBaseGroupConnectionInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.associated_base_group_connection_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    AssociatedBaseGroupConnectionInfo,
    False,
    None))



class AssociatedGroupConnectionInfosListResult(VapiStruct):
    """
    Associated Group connection list result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`AssociatedBaseGroupConnectionInfo`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`AssociatedBaseGroupConnectionInfo`.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AssociatedGroupConnectionInfosListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.associated_group_connection_infos_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'AssociatedBaseGroupConnectionInfo')]))),
    },
    AssociatedGroupConnectionInfosListResult,
    False,
    None))



class AssociatedTgwGroupConnectionInfo(VapiStruct):
    """
    Associated Group connection infomation for the local SDDC by using AWS TGW
    as a connector.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssociatedTgwGroupConnectionInfo"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    STATE_CONNECTED = "CONNECTED"
    """


    """
    STATE_DISCONNECTED = "DISCONNECTED"
    """


    """



    _canonical_to_pep_names = {
                            'external_route_table_id': 'external_route_table_id',
                            'sddcs_route_table_id': 'sddcs_route_table_id',
                            'state': 'state',
                            'tgw_attachment_id': 'tgw_attachment_id',
                            'tgw_id': 'tgw_id',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'name': 'name',
                            }

    def __init__(self,
                 external_route_table_id=None,
                 sddcs_route_table_id=None,
                 state=None,
                 tgw_attachment_id=None,
                 tgw_id=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='AssociatedTgwGroupConnectionInfo',
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 name=None,
                ):
        """
        :type  external_route_table_id: :class:`str` or ``None``
        :param external_route_table_id: TGW external route table ID used for external customers VPCs
            association
        :type  sddcs_route_table_id: :class:`str` or ``None``
        :param sddcs_route_table_id: TGW SDDCs route table ID used for SDDCs association
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`AssociatedTgwGroupConnectionInfo.STATE_CONNECTED`
            * :attr:`AssociatedTgwGroupConnectionInfo.STATE_DISCONNECTED`
            
             The TGW attachment state of the SDDC in the Group
        :type  tgw_attachment_id: :class:`str` or ``None``
        :param tgw_attachment_id: TGW attachment ID for the local SDDC in the Group
        :type  tgw_id: :class:`str` or ``None``
        :param tgw_id: TGW ID for the local SDDC in the Group
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: SDDC Group description
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: SDDC Group ID
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`AssociatedBaseGroupConnectionInfo.RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFO`
            *
              :attr:`AssociatedBaseGroupConnectionInfo.RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFOVERSION2`
            
             Group connection type
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  name: :class:`str` or ``None``
        :param name: SDDC Group name
        """
        self.external_route_table_id = external_route_table_id
        self.sddcs_route_table_id = sddcs_route_table_id
        self.state = state
        self.tgw_attachment_id = tgw_attachment_id
        self.tgw_id = tgw_id
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.name = name
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssociatedTgwGroupConnectionInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.associated_tgw_group_connection_info', {
        'external_route_table_id': type.OptionalType(type.StringType()),
        'sddcs_route_table_id': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
        'tgw_attachment_id': type.OptionalType(type.StringType()),
        'tgw_id': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    AssociatedTgwGroupConnectionInfo,
    False,
    None))



class AssociatedTgwGroupConnectionInfoVersion2(VapiStruct):
    """
    Associated Group connection infomation for the local SDDC by using AWS TGW
    as a connector and AWS prefix list as route management.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssociatedTgwGroupConnectionInfoVersion2"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    STATE_CONNECTED = "CONNECTED"
    """


    """
    STATE_DISCONNECTED = "DISCONNECTED"
    """


    """



    _canonical_to_pep_names = {
                            'associated_route_table': 'associated_route_table',
                            'region': 'region',
                            'sddc_advertise_route_config': 'sddc_advertise_route_config',
                            'state': 'state',
                            'tgw_attachment_id': 'tgw_attachment_id',
                            'tgw_id': 'tgw_id',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'name': 'name',
                            }

    def __init__(self,
                 associated_route_table=None,
                 region=None,
                 sddc_advertise_route_config=None,
                 state=None,
                 tgw_attachment_id=None,
                 tgw_id=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='AssociatedTgwGroupConnectionInfoVersion2',
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 name=None,
                ):
        """
        :type  associated_route_table: :class:`str` or ``None``
        :param associated_route_table: TGW SDDCs route table ID used for SDDCs association
        :type  region: :class:`str` or ``None``
        :param region: AWS region in which SDDC is residing
        :type  sddc_advertise_route_config: :class:`SddcAdvertiseRouteConfig` or ``None``
        :param sddc_advertise_route_config: 
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`AssociatedTgwGroupConnectionInfoVersion2.STATE_CONNECTED`
            *
              :attr:`AssociatedTgwGroupConnectionInfoVersion2.STATE_DISCONNECTED`
            
             The TGW attachment state of the SDDC in the Group
        :type  tgw_attachment_id: :class:`str` or ``None``
        :param tgw_attachment_id: TGW attachment ID for the local SDDC in the Group
        :type  tgw_id: :class:`str` or ``None``
        :param tgw_id: TGW ID for the local SDDC in the Group
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: SDDC Group description
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: SDDC Group ID
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`AssociatedBaseGroupConnectionInfo.RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFO`
            *
              :attr:`AssociatedBaseGroupConnectionInfo.RESOURCE_TYPE_ASSOCIATEDTGWGROUPCONNECTIONINFOVERSION2`
            
             Group connection type
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  name: :class:`str` or ``None``
        :param name: SDDC Group name
        """
        self.associated_route_table = associated_route_table
        self.region = region
        self.sddc_advertise_route_config = sddc_advertise_route_config
        self.state = state
        self.tgw_attachment_id = tgw_attachment_id
        self.tgw_id = tgw_id
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.name = name
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssociatedTgwGroupConnectionInfoVersion2._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.associated_tgw_group_connection_info_version2', {
        'associated_route_table': type.OptionalType(type.StringType()),
        'region': type.OptionalType(type.StringType()),
        'sddc_advertise_route_config': type.OptionalType(type.ReferenceType(__name__, 'SddcAdvertiseRouteConfig')),
        'state': type.OptionalType(type.StringType()),
        'tgw_attachment_id': type.OptionalType(type.StringType()),
        'tgw_id': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    AssociatedTgwGroupConnectionInfoVersion2,
    False,
    None))



class AwsPrefixInfo(VapiStruct):
    """
    AWS prefix entry

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'name': 'name',
                            'region': 'region',
                            'size': 'size',
                            }

    def __init__(self,
                 id=None,
                 name=None,
                 region=None,
                 size=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Prefix ID
        :type  name: :class:`str` or ``None``
        :param name: Prefix Name
        :type  region: :class:`str` or ``None``
        :param region: AWS region
        :type  size: :class:`long` or ``None``
        :param size: Prefix max entries format: int32
        """
        self.id = id
        self.name = name
        self.region = region
        self.size = size
        VapiStruct.__init__(self)


AwsPrefixInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.aws_prefix_info', {
        'id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'region': type.OptionalType(type.StringType()),
        'size': type.OptionalType(type.IntegerType()),
    },
    AwsPrefixInfo,
    False,
    None))



class AwsResourceShareInfo(VapiStruct):
    """
    Information related to AWS resource share that is shared with linked VPC
    account.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    AWS_RESOURCE_SHARE_STATE_ACTIVE = "ACTIVE"
    """


    """
    AWS_RESOURCE_SHARE_STATE_PENDING = "PENDING"
    """


    """
    AWS_RESOURCE_SHARE_STATE_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'aws_resource_share_arn': 'aws_resource_share_arn',
                            'aws_resource_share_name': 'aws_resource_share_name',
                            'aws_resource_share_state': 'aws_resource_share_state',
                            }

    def __init__(self,
                 aws_resource_share_arn=None,
                 aws_resource_share_name=None,
                 aws_resource_share_state=None,
                ):
        """
        :type  aws_resource_share_arn: :class:`str` or ``None``
        :param aws_resource_share_arn: Amazon Resource Name (ARN) of AWS resource share.
        :type  aws_resource_share_name: :class:`str` or ``None``
        :param aws_resource_share_name: Name of AWS resource share.
        :type  aws_resource_share_state: :class:`str` or ``None``
        :param aws_resource_share_state: Possible values are: 
            
            * :attr:`AwsResourceShareInfo.AWS_RESOURCE_SHARE_STATE_ACTIVE`
            * :attr:`AwsResourceShareInfo.AWS_RESOURCE_SHARE_STATE_PENDING`
            * :attr:`AwsResourceShareInfo.AWS_RESOURCE_SHARE_STATE_FAILED`
            
             State of AWS resource share.
        """
        self.aws_resource_share_arn = aws_resource_share_arn
        self.aws_resource_share_name = aws_resource_share_name
        self.aws_resource_share_state = aws_resource_share_state
        VapiStruct.__init__(self)


AwsResourceShareInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.aws_resource_share_info', {
        'aws_resource_share_arn': type.OptionalType(type.StringType()),
        'aws_resource_share_name': type.OptionalType(type.StringType()),
        'aws_resource_share_state': type.OptionalType(type.StringType()),
    },
    AwsResourceShareInfo,
    False,
    None))



class BGPAdvertisedRoutes(VapiStruct):
    """
    Advertised bgp routes

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'advertised_routes': 'advertised_routes',
                            'failed_advertised_routes': 'failed_advertised_routes',
                            }

    def __init__(self,
                 advertised_routes=None,
                 failed_advertised_routes=None,
                ):
        """
        :type  advertised_routes: :class:`list` of :class:`AdvertisedRoute` or ``None``
        :param advertised_routes: Routes advertised to on-premise datacenter via Direct Connect
        :type  failed_advertised_routes: :class:`long` or ``None``
        :param failed_advertised_routes: Number of routes failed to advertise format: int32
        """
        self.advertised_routes = advertised_routes
        self.failed_advertised_routes = failed_advertised_routes
        VapiStruct.__init__(self)


BGPAdvertisedRoutes._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.BGP_advertised_routes', {
        'advertised_routes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AdvertisedRoute'))),
        'failed_advertised_routes': type.OptionalType(type.IntegerType()),
    },
    BGPAdvertisedRoutes,
    False,
    None))



class BGPLearnedRoutes(VapiStruct):
    """
    Learned bgp routes

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ipv4_cidr': 'ipv4_cidr',
                            }

    def __init__(self,
                 ipv4_cidr=None,
                ):
        """
        :type  ipv4_cidr: :class:`list` of :class:`str` or ``None``
        :param ipv4_cidr: The route that is learned from BGP via Direct Connect format:
            ipv4-cidr-block
        """
        self.ipv4_cidr = ipv4_cidr
        VapiStruct.__init__(self)


BGPLearnedRoutes._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.BGP_learned_routes', {
        'ipv4_cidr': type.OptionalType(type.ListType(type.StringType())),
    },
    BGPLearnedRoutes,
    False,
    None))



class ConnectedServiceListResult(VapiStruct):
    """
    A list of status of 'Enabled/Disabled' for a service connected to a linked
    vpc

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ConnectedServiceStatus` or ``None``
        :param results: Connected service status list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ConnectedServiceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.connected_service_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConnectedServiceStatus'))),
    },
    ConnectedServiceListResult,
    False,
    None))



class ConnectedServiceStatus(VapiStruct):
    """
    Status of 'Enabled/Disabled' for a service connected to a linked vpc

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'enabled': 'enabled',
                            'name': 'name',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 enabled=None,
                 name=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: status of service
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  name: :class:`str` or ``None``
        :param name: service name
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.enabled = enabled
        self.name = name
        VapiStruct.__init__(self)


ConnectedServiceStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.connected_service_status', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'name': type.OptionalType(type.StringType()),
    },
    ConnectedServiceStatus,
    False,
    None))



class ConnectivityEndpointConfig(VapiStruct):
    """
    Connectivity Endpoint object.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of the connectivityEndpointConfig.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Name of the connectivityEndpointConfig.
        :type  id: :class:`str` or ``None``
        :param id: Id for the connectivityEndpointConfig.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        VapiStruct.__init__(self)


ConnectivityEndpointConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.connectivity_endpoint_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
    },
    ConnectivityEndpointConfig,
    False,
    None))



class ConnectivityEndpointListResult(VapiStruct):
    """
    List of connectivityEndpoint objects.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ConnectivityEndpointConfig` or ``None``
        :param results: Items of connectivityEndpointConfig object
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ConnectivityEndpointListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.connectivity_endpoint_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConnectivityEndpointConfig'))),
    },
    ConnectivityEndpointListResult,
    False,
    None))



class CsvListResult(VapiStruct):
    """
    Base type for CSV result.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'file_name': 'file_name',
                            }

    def __init__(self,
                 file_name=None,
                ):
        """
        :type  file_name: :class:`str` or ``None``
        :param file_name: File name set by HTTP server if API returns CSV result as a file.
        """
        self.file_name = file_name
        VapiStruct.__init__(self)


CsvListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.csv_list_result', {
        'file_name': type.OptionalType(type.StringType()),
    },
    CsvListResult,
    False,
    None))



class CsvRecord(VapiStruct):
    """
    Base type for CSV records.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                ):
        """
        """
        VapiStruct.__init__(self)


CsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.csv_record', {
    },
    CsvRecord,
    False,
    None))



class DirectConnectBgpInfo(VapiStruct):
    """
    Direct Connect BGP related information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ROUTE_PREFERENCE_DIRECT_CONNECT_PREFERRED_OVER_VPN = "DIRECT_CONNECT_PREFERRED_OVER_VPN"
    """


    """
    ROUTE_PREFERENCE_VPN_PREFERRED_OVER_DIRECT_CONNECT = "VPN_PREFERRED_OVER_DIRECT_CONNECT"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'local_as_num': 'local_as_num',
                            'mtu': 'mtu',
                            'route_preference': 'route_preference',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 local_as_num=None,
                 mtu=None,
                 route_preference=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  local_as_num: :class:`str` or ``None``
        :param local_as_num: The ASN paired with the VGW attached to the VPC. AWS allowed
            private BGP ASN range - [64512, 65534] and [4200000000,
            4294967294]. If omitted in the payload, BGP ASN will not be
            modified.
        :type  mtu: :class:`long` or ``None``
        :param mtu: Maximum transmission unit allowed by the VIF format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  route_preference: :class:`str` or ``None``
        :param route_preference: Possible values are: 
            
            *
              :attr:`DirectConnectBgpInfo.ROUTE_PREFERENCE_DIRECT_CONNECT_PREFERRED_OVER_VPN`
            *
              :attr:`DirectConnectBgpInfo.ROUTE_PREFERENCE_VPN_PREFERRED_OVER_DIRECT_CONNECT`
            
            Direct connect route preference over VPN routes. If omitted in the
            payload, route preference will not be modified.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.local_as_num = local_as_num
        self.mtu = mtu
        self.route_preference = route_preference
        VapiStruct.__init__(self)


DirectConnectBgpInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.direct_connect_bgp_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'local_as_num': type.OptionalType(type.StringType()),
        'mtu': type.OptionalType(type.IntegerType()),
        'route_preference': type.OptionalType(type.StringType()),
    },
    DirectConnectBgpInfo,
    False,
    None))



class ExternalConnectivityConfig(VapiStruct):
    """
    External Connectivity configuration for north-south traffic. For eg., in
    AWS case, this would refer to Direct Connect config. For Dimension, this
    would refer to the config at Upstream Intranet interface to Tor.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'internet_interface': 'internet_interface',
                            'internet_mtu': 'internet_mtu',
                            'intranet_interface': 'intranet_interface',
                            'intranet_mtu': 'intranet_mtu',
                            'services_interface': 'services_interface',
                            'services_mtu': 'services_mtu',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 internet_interface=None,
                 internet_mtu=None,
                 intranet_interface=None,
                 intranet_mtu=None,
                 services_interface=None,
                 services_mtu=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  internet_interface: :class:`InterfaceConfig` or ``None``
        :param internet_interface: 
        :type  internet_mtu: :class:`long` or ``None``
        :param internet_mtu: Uplink MTU of internet traffic in edge tier-0 router port. format:
            int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  intranet_interface: :class:`InterfaceConfig` or ``None``
        :param intranet_interface: 
        :type  intranet_mtu: :class:`long` or ``None``
        :param intranet_mtu: Uplink MTU of direct connect, sddc-grouping and outposts traffic in
            edge tier-0 router port. format: int32
        :type  services_interface: :class:`InterfaceConfig` or ``None``
        :param services_interface: 
        :type  services_mtu: :class:`long` or ``None``
        :param services_mtu: Uplink MTU of connected VPC traffic in edge tier-0 router port.
            format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.internet_interface = internet_interface
        self.internet_mtu = internet_mtu
        self.intranet_interface = intranet_interface
        self.intranet_mtu = intranet_mtu
        self.services_interface = services_interface
        self.services_mtu = services_mtu
        VapiStruct.__init__(self)


ExternalConnectivityConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_connectivity_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'internet_interface': type.OptionalType(type.ReferenceType(__name__, 'InterfaceConfig')),
        'internet_mtu': type.OptionalType(type.IntegerType()),
        'intranet_interface': type.OptionalType(type.ReferenceType(__name__, 'InterfaceConfig')),
        'intranet_mtu': type.OptionalType(type.IntegerType()),
        'services_interface': type.OptionalType(type.ReferenceType(__name__, 'InterfaceConfig')),
        'services_mtu': type.OptionalType(type.IntegerType()),
    },
    ExternalConnectivityConfig,
    False,
    None))



class ExternalConnectivityInfo(VapiStruct):
    """
    External Connectivity Information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'connectivities': 'connectivities',
                            'endpoint_type': 'endpoint_type',
                            }

    def __init__(self,
                 connectivities=None,
                 endpoint_type=None,
                ):
        """
        :type  connectivities: :class:`list` of :class:`str` or ``None``
        :param connectivities: Object to hold all connectivity endpoints
        :type  endpoint_type: :class:`str` or ``None``
        :param endpoint_type: External Endpoint Type
        """
        self.connectivities = connectivities
        self.endpoint_type = endpoint_type
        VapiStruct.__init__(self)


ExternalConnectivityInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_connectivity_info', {
        'connectivities': type.OptionalType(type.ListType(type.StringType())),
        'endpoint_type': type.OptionalType(type.StringType()),
    },
    ExternalConnectivityInfo,
    False,
    None))



class ExternalConnectivityStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_CONNECTED = "CONNECTED"
    """


    """
    STATUS_DISCONNECTED = "DISCONNECTED"
    """


    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            'type': 'type',
                            }

    def __init__(self,
                 status=None,
                 type=None,
                ):
        """
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ExternalConnectivityStatus.STATUS_CONNECTED`
            * :attr:`ExternalConnectivityStatus.STATUS_DISCONNECTED`
            
            Indicates whether connectivity is established for a connectivity
            type.
        :type  type: :class:`str` or ``None``
        :param type: Connectivity endpoint
        """
        self.status = status
        self.type = type
        VapiStruct.__init__(self)


ExternalConnectivityStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_connectivity_status', {
        'status': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    ExternalConnectivityStatus,
    False,
    None))



class ExternalConnectivityStatusList(VapiStruct):
    """
    External connectivity list

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'connectivities': 'connectivities',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 connectivities=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connectivities: :class:`list` of :class:`ExternalConnectivityStatus` or ``None``
        :param connectivities: External connectivity list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.connectivities = connectivities
        VapiStruct.__init__(self)


ExternalConnectivityStatusList._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_connectivity_status_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'connectivities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ExternalConnectivityStatus'))),
    },
    ExternalConnectivityStatusList,
    False,
    None))



class ExternalSddcConnectivity(VapiStruct):
    """
    External SDDC connectivity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTIVITY_TYPE_DIRECT_CONNECT = "DIRECT_CONNECT"
    """


    """
    CONNECTIVITY_TYPE_DEPLOYMENT_CONNECTIVITY_GROUP = "DEPLOYMENT_CONNECTIVITY_GROUP"
    """


    """
    CONNECTIVITY_TYPE_LGW = "LGW"
    """


    """
    STATUS_SUCCEEDED = "SUCCEEDED"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_PENDING = "PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'connectivity_type': 'connectivity_type',
                            'regions': 'regions',
                            'source': 'source',
                            'status': 'status',
                            'status_message': 'status_message',
                            }

    def __init__(self,
                 connectivity_type=None,
                 regions=None,
                 source=None,
                 status=None,
                 status_message=None,
                ):
        """
        :type  connectivity_type: :class:`str` or ``None``
        :param connectivity_type: Possible values are: 
            
            * :attr:`ExternalSddcConnectivity.CONNECTIVITY_TYPE_DIRECT_CONNECT`
            *
              :attr:`ExternalSddcConnectivity.CONNECTIVITY_TYPE_DEPLOYMENT_CONNECTIVITY_GROUP`
            * :attr:`ExternalSddcConnectivity.CONNECTIVITY_TYPE_LGW`
            
            The external SDDC connectivity type is used by the SDDC for the L3
            connectivity. DIRECT_CONNECT means that the external SDDC
            connectivity is through AWS Direct Connect.
            DEPLOYMENT_CONNECTIVITY_GROUP means that the external SDDC
            connectivity is through AWS TGW. LGW means that the external SDDC
            connectivity is through AWS local gateway.
        :type  regions: :class:`list` of :class:`str` or ``None``
        :param regions: The list of regions of the route for the connectivity
        :type  source: :class:`str` or ``None``
        :param source: The source of the route for the connectivity
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ExternalSddcConnectivity.STATUS_SUCCEEDED`
            * :attr:`ExternalSddcConnectivity.STATUS_FAILED`
            * :attr:`ExternalSddcConnectivity.STATUS_PENDING`
            
             The status of the route for the connectivity
        :type  status_message: :class:`str` or ``None``
        :param status_message: The error message if the status is FAILED, the optional warning
            message if the status is SUCCEEDED.
        """
        self.connectivity_type = connectivity_type
        self.regions = regions
        self.source = source
        self.status = status
        self.status_message = status_message
        VapiStruct.__init__(self)


ExternalSddcConnectivity._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_sddc_connectivity', {
        'connectivity_type': type.OptionalType(type.StringType()),
        'regions': type.OptionalType(type.ListType(type.StringType())),
        'source': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'status_message': type.OptionalType(type.StringType()),
    },
    ExternalSddcConnectivity,
    False,
    None))



class ExternalSddcRoute(VapiStruct):
    """
    External SDDC route

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'connectivities': 'connectivities',
                            'destination': 'destination',
                            'source_path': 'source_path',
                            'summarized': 'summarized',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 connectivities=None,
                 destination=None,
                 source_path=None,
                 summarized=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connectivities: :class:`list` of :class:`ExternalSddcConnectivity` or ``None``
        :param connectivities: The route used for what kind of connectivities
        :type  destination: :class:`str` or ``None``
        :param destination: Destination IP CIDR Block format: ipv4-cidr-block
        :type  source_path: :class:`str` or ``None``
        :param source_path: Source Path of CIDR
        :type  summarized: :class:`bool` or ``None``
        :param summarized: Path is summarised or not.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.connectivities = connectivities
        self.destination = destination
        self.source_path = source_path
        self.summarized = summarized
        VapiStruct.__init__(self)


ExternalSddcRoute._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_sddc_route', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'connectivities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ExternalSddcConnectivity'))),
        'destination': type.OptionalType(type.StringType()),
        'source_path': type.OptionalType(type.StringType()),
        'summarized': type.OptionalType(type.BooleanType()),
    },
    ExternalSddcRoute,
    False,
    None))



class ExternalSddcRouteCsvRecord(VapiStruct):
    """
    CSV record for External SDDC route

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'connectivity_details': 'connectivity_details',
                            'destination': 'destination',
                            }

    def __init__(self,
                 connectivity_details=None,
                 destination=None,
                ):
        """
        :type  connectivity_details: :class:`str` or ``None``
        :param connectivity_details: The connectivity datails contains status of route, source of the
            route, connectivity type
        :type  destination: :class:`str` or ``None``
        :param destination: Destination IP CIDR Block format: ipv4-cidr-block
        """
        self.connectivity_details = connectivity_details
        self.destination = destination
        VapiStruct.__init__(self)


ExternalSddcRouteCsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_sddc_route_csv_record', {
        'connectivity_details': type.OptionalType(type.StringType()),
        'destination': type.OptionalType(type.StringType()),
    },
    ExternalSddcRouteCsvRecord,
    False,
    None))



class ExternalSddcRoutesListResult(VapiStruct):
    """
    External SDDC routes list result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'routes': 'routes',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 routes=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  routes: :class:`list` of :class:`ExternalSddcRoute` or ``None``
        :param routes: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.routes = routes
        VapiStruct.__init__(self)


ExternalSddcRoutesListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_sddc_routes_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'routes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ExternalSddcRoute'))),
    },
    ExternalSddcRoutesListResult,
    False,
    None))



class ExternalSddcRoutesListResultInCsvFormat(VapiStruct):
    """
    External SDDC routes list result in CSV format

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'file_name': 'file_name',
                            'results': 'results',
                            }

    def __init__(self,
                 file_name=None,
                 results=None,
                ):
        """
        :type  file_name: :class:`str` or ``None``
        :param file_name: File name set by HTTP server if API returns CSV result as a file.
        :type  results: :class:`list` of :class:`ExternalSddcRouteCsvRecord` or ``None``
        :param results: 
        """
        self.file_name = file_name
        self.results = results
        VapiStruct.__init__(self)


ExternalSddcRoutesListResultInCsvFormat._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.external_sddc_routes_list_result_in_csv_format', {
        'file_name': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ExternalSddcRouteCsvRecord'))),
    },
    ExternalSddcRoutesListResultInCsvFormat,
    False,
    None))



class IncludedFieldsParameters(VapiStruct):
    """
    A list of fields to include in query results

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'included_fields': 'included_fields',
                            }

    def __init__(self,
                 included_fields=None,
                ):
        """
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Note - this parameter currently only works when used with the
            search APIs /policy/api/v1/search/query and
            /policy/api/v1/search/dsl. It is ignored for other list APIs.
        """
        self.included_fields = included_fields
        VapiStruct.__init__(self)


IncludedFieldsParameters._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.included_fields_parameters', {
        'included_fields': type.OptionalType(type.StringType()),
    },
    IncludedFieldsParameters,
    False,
    None))



class InterfaceConfig(VapiStruct):
    """
    Interface configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    URPF_MODE_STRICT = "STRICT"
    """


    """
    URPF_MODE_NONE = "NONE"
    """


    """



    _canonical_to_pep_names = {
                            'urpf_mode': 'urpf_mode',
                            }

    def __init__(self,
                 urpf_mode=None,
                ):
        """
        :type  urpf_mode: :class:`str` or ``None``
        :param urpf_mode: Possible values are: 
            
            * :attr:`InterfaceConfig.URPF_MODE_STRICT`
            * :attr:`InterfaceConfig.URPF_MODE_NONE`
            
             Unicast Reverse Path Forwarding mode of interface.
        """
        self.urpf_mode = urpf_mode
        VapiStruct.__init__(self)


InterfaceConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.interface_config', {
        'urpf_mode': type.OptionalType(type.StringType()),
    },
    InterfaceConfig,
    False,
    None))



class IpAttachmentPair(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'attachment_id': 'attachment_id',
                            'ip': 'ip',
                            }

    def __init__(self,
                 attachment_id=None,
                 ip=None,
                ):
        """
        :type  attachment_id: :class:`str` or ``None``
        :param attachment_id: Attachment id which maps to management VM IP
        :type  ip: :class:`str` or ``None``
        :param ip: Management VM IP Address format: ipv4
        """
        self.attachment_id = attachment_id
        self.ip = ip
        VapiStruct.__init__(self)


IpAttachmentPair._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.ip_attachment_pair', {
        'attachment_id': type.OptionalType(type.StringType()),
        'ip': type.OptionalType(type.StringType()),
    },
    IpAttachmentPair,
    False,
    None))



class LinkedSubnetInfo(VapiStruct):
    """
    Infromation related to a subnet where linked ENIs were created.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'availability_zone': 'availability_zone',
                            'cidr': 'cidr',
                            'id': 'id',
                            }

    def __init__(self,
                 availability_zone=None,
                 cidr=None,
                 id=None,
                ):
        """
        :type  availability_zone: :class:`str` or ``None``
        :param availability_zone: Linked subnet availability zone
        :type  cidr: :class:`str` or ``None``
        :param cidr: Linked subnet CIDR format: ipv4-cidr-block
        :type  id: :class:`str` or ``None``
        :param id: Linked subnet identifier
        """
        self.availability_zone = availability_zone
        self.cidr = cidr
        self.id = id
        VapiStruct.__init__(self)


LinkedSubnetInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.linked_subnet_info', {
        'availability_zone': type.OptionalType(type.StringType()),
        'cidr': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
    },
    LinkedSubnetInfo,
    False,
    None))



class LinkedVpcInfo(VapiStruct):
    """
    Linked VPC info

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'active_eni': 'active_eni',
                            'arn_role': 'arn_role',
                            'external_id': 'external_id',
                            'linked_account': 'linked_account',
                            'linked_vpc_addresses': 'linked_vpc_addresses',
                            'linked_vpc_id': 'linked_vpc_id',
                            'linked_vpc_managed_prefix_list_info': 'linked_vpc_managed_prefix_list_info',
                            'linked_vpc_nat_ips': 'linked_vpc_nat_ips',
                            'linked_vpc_subnets': 'linked_vpc_subnets',
                            'route_table_ids': 'route_table_ids',
                            'service_arn_role': 'service_arn_role',
                            'traffic_group_eni_mappings': 'traffic_group_eni_mappings',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 active_eni=None,
                 arn_role=None,
                 external_id=None,
                 linked_account=None,
                 linked_vpc_addresses=None,
                 linked_vpc_id=None,
                 linked_vpc_managed_prefix_list_info=None,
                 linked_vpc_nat_ips=None,
                 linked_vpc_subnets=None,
                 route_table_ids=None,
                 service_arn_role=None,
                 traffic_group_eni_mappings=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  active_eni: :class:`str` or ``None``
        :param active_eni: Active network interface used for linked vpc traffic
        :type  arn_role: :class:`str` or ``None``
        :param arn_role: ARN role for linked VPC operations
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier for ARN role
        :type  linked_account: :class:`str` or ``None``
        :param linked_account: Linked VPC account number
        :type  linked_vpc_addresses: :class:`list` of :class:`str` or ``None``
        :param linked_vpc_addresses: Linked VPC CIDRs format: ipv4-cidr-block
        :type  linked_vpc_id: :class:`str` or ``None``
        :param linked_vpc_id: Linked VPC identifier
        :type  linked_vpc_managed_prefix_list_info: :class:`LinkedVpcManagedPrefixListSupportInfo` or ``None``
        :param linked_vpc_managed_prefix_list_info: 
        :type  linked_vpc_nat_ips: :class:`list` of :class:`str` or ``None``
        :param linked_vpc_nat_ips: The IPs of linked VPC NAT rule for service access. format: ipv4
        :type  linked_vpc_subnets: :class:`list` of :class:`LinkedSubnetInfo` or ``None``
        :param linked_vpc_subnets: Infromation related to the subnets where linked ENIs were created.
        :type  route_table_ids: :class:`list` of :class:`str` or ``None``
        :param route_table_ids: The identifiers of route tables to be dynamically updated with SDDC
            networks
        :type  service_arn_role: :class:`str` or ``None``
        :param service_arn_role: service ARN role
        :type  traffic_group_eni_mappings: :class:`list` of :class:`TrafficGroupEniMappingInfo` or ``None``
        :param traffic_group_eni_mappings: Description of mapping between the traffic group name and
            corresponding Elastic Network Interface (ENI).
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.active_eni = active_eni
        self.arn_role = arn_role
        self.external_id = external_id
        self.linked_account = linked_account
        self.linked_vpc_addresses = linked_vpc_addresses
        self.linked_vpc_id = linked_vpc_id
        self.linked_vpc_managed_prefix_list_info = linked_vpc_managed_prefix_list_info
        self.linked_vpc_nat_ips = linked_vpc_nat_ips
        self.linked_vpc_subnets = linked_vpc_subnets
        self.route_table_ids = route_table_ids
        self.service_arn_role = service_arn_role
        self.traffic_group_eni_mappings = traffic_group_eni_mappings
        VapiStruct.__init__(self)


LinkedVpcInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.linked_vpc_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'active_eni': type.OptionalType(type.StringType()),
        'arn_role': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'linked_account': type.OptionalType(type.StringType()),
        'linked_vpc_addresses': type.OptionalType(type.ListType(type.StringType())),
        'linked_vpc_id': type.OptionalType(type.StringType()),
        'linked_vpc_managed_prefix_list_info': type.OptionalType(type.ReferenceType(__name__, 'LinkedVpcManagedPrefixListSupportInfo')),
        'linked_vpc_nat_ips': type.OptionalType(type.ListType(type.StringType())),
        'linked_vpc_subnets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'LinkedSubnetInfo'))),
        'route_table_ids': type.OptionalType(type.ListType(type.StringType())),
        'service_arn_role': type.OptionalType(type.StringType()),
        'traffic_group_eni_mappings': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'TrafficGroupEniMappingInfo'))),
    },
    LinkedVpcInfo,
    False,
    None))



class LinkedVpcManagedPrefixListSupportInfo(VapiStruct):
    """
    Information related to linked VPC managed prefix list support including
    prefix list mode state, resource share information and managed prefix list
    information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MANAGED_PREFIX_LIST_MODE_ENABLED = "ENABLED"
    """


    """
    MANAGED_PREFIX_LIST_MODE_DISABLED = "DISABLED"
    """


    """
    MANAGED_PREFIX_LIST_MODE_PENDING = "PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'aws_resource_share_info': 'aws_resource_share_info',
                            'managed_prefix_list_mode': 'managed_prefix_list_mode',
                            'managed_prefix_lists': 'managed_prefix_lists',
                            }

    def __init__(self,
                 aws_resource_share_info=None,
                 managed_prefix_list_mode=None,
                 managed_prefix_lists=None,
                ):
        """
        :type  aws_resource_share_info: :class:`AwsResourceShareInfo` or ``None``
        :param aws_resource_share_info: 
        :type  managed_prefix_list_mode: :class:`str` or ``None``
        :param managed_prefix_list_mode: Possible values are: 
            
            *
              :attr:`LinkedVpcManagedPrefixListSupportInfo.MANAGED_PREFIX_LIST_MODE_ENABLED`
            *
              :attr:`LinkedVpcManagedPrefixListSupportInfo.MANAGED_PREFIX_LIST_MODE_DISABLED`
            *
              :attr:`LinkedVpcManagedPrefixListSupportInfo.MANAGED_PREFIX_LIST_MODE_PENDING`
            
             Current state of managed prefix list mode
        :type  managed_prefix_lists: :class:`list` of :class:`LinkedVpcSharedManagedPrefixListInfo` or ``None``
        :param managed_prefix_lists: Information of managed prefix list shared with current linked VPC
        """
        self.aws_resource_share_info = aws_resource_share_info
        self.managed_prefix_list_mode = managed_prefix_list_mode
        self.managed_prefix_lists = managed_prefix_lists
        VapiStruct.__init__(self)


LinkedVpcManagedPrefixListSupportInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.linked_vpc_managed_prefix_list_support_info', {
        'aws_resource_share_info': type.OptionalType(type.ReferenceType(__name__, 'AwsResourceShareInfo')),
        'managed_prefix_list_mode': type.OptionalType(type.StringType()),
        'managed_prefix_lists': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'LinkedVpcSharedManagedPrefixListInfo'))),
    },
    LinkedVpcManagedPrefixListSupportInfo,
    False,
    None))



class LinkedVpcSharedManagedPrefixListInfo(VapiStruct):
    """
    Information of managed prefix lists which are shared with linked VPC
    account.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'in_use': 'in_use',
                            'name': 'name',
                            'programming_info': 'programming_info',
                            }

    def __init__(self,
                 id=None,
                 in_use=None,
                 name=None,
                 programming_info=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: ID of managed prefix list.
        :type  in_use: :class:`bool` or ``None``
        :param in_use: Indicate that whether managed prefix list is currently in use or
            not.
        :type  name: :class:`str` or ``None``
        :param name: Name of managed prefix list.
        :type  programming_info: :class:`ManagedPrefixListProgrammingInfo` or ``None``
        :param programming_info: 
        """
        self.id = id
        self.in_use = in_use
        self.name = name
        self.programming_info = programming_info
        VapiStruct.__init__(self)


LinkedVpcSharedManagedPrefixListInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.linked_vpc_shared_managed_prefix_list_info', {
        'id': type.OptionalType(type.StringType()),
        'in_use': type.OptionalType(type.BooleanType()),
        'name': type.OptionalType(type.StringType()),
        'programming_info': type.OptionalType(type.ReferenceType(__name__, 'ManagedPrefixListProgrammingInfo')),
    },
    LinkedVpcSharedManagedPrefixListInfo,
    False,
    None))



class LinkedVpcsListResult(VapiStruct):
    """
    Linked VPC list query result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`LinkedVpcInfo` or ``None``
        :param results: Linked VPCs list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


LinkedVpcsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.linked_vpcs_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'LinkedVpcInfo'))),
    },
    LinkedVpcsListResult,
    False,
    None))



class ListResult(VapiStruct):
    """
    Base class for list results from collections

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        VapiStruct.__init__(self)


ListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
    },
    ListResult,
    False,
    None))



class ManagedPrefixListProgrammingInfo(VapiStruct):
    """
    Route programming related information of managed prefix lists which are
    shared with linked VPC account.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'active_eni': 'active_eni',
                            'expected_entries': 'expected_entries',
                            'route_table_ids': 'route_table_ids',
                            }

    def __init__(self,
                 active_eni=None,
                 expected_entries=None,
                 route_table_ids=None,
                ):
        """
        :type  active_eni: :class:`str` or ``None``
        :param active_eni: Name of active ENI that current managed prefix list should point
            to.
        :type  expected_entries: :class:`list` of :class:`str` or ``None``
        :param expected_entries: Prefixes to be present in AWS managed prefix list.
        :type  route_table_ids: :class:`list` of :class:`str` or ``None``
        :param route_table_ids: IDs of route tables that current managed prefix list is associated
            with.
        """
        self.active_eni = active_eni
        self.expected_entries = expected_entries
        self.route_table_ids = route_table_ids
        VapiStruct.__init__(self)


ManagedPrefixListProgrammingInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.managed_prefix_list_programming_info', {
        'active_eni': type.OptionalType(type.StringType()),
        'expected_entries': type.OptionalType(type.ListType(type.StringType())),
        'route_table_ids': type.OptionalType(type.ListType(type.StringType())),
    },
    ManagedPrefixListProgrammingInfo,
    False,
    None))



class ManagedPrefixListRuntimeInfo(VapiStruct):
    """
    Attributes and state information of a particular managed prefix list.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ManagedPrefixListRuntimeInfo"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ADDRESS_FAMILY_IPV4 = "IPv4"
    """


    """
    ADDRESS_FAMILY_IPV6 = "IPv6"
    """


    """



    _canonical_to_pep_names = {
                            'address_family': 'address_family',
                            'arn': 'arn',
                            'entries': 'entries',
                            'issues': 'issues',
                            'max_entries': 'max_entries',
                            'name': 'name',
                            'state': 'state',
                            'state_message': 'state_message',
                            'tags': 'tags',
                            'version': 'version',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 address_family=None,
                 arn=None,
                 entries=None,
                 issues=None,
                 max_entries=None,
                 name=None,
                 state=None,
                 state_message=None,
                 tags=None,
                 version=None,
                 id=None,
                 resource_type='ManagedPrefixListRuntimeInfo',
                ):
        """
        :type  address_family: :class:`str` or ``None``
        :param address_family: Possible values are: 
            
            * :attr:`ManagedPrefixListRuntimeInfo.ADDRESS_FAMILY_IPV4`
            * :attr:`ManagedPrefixListRuntimeInfo.ADDRESS_FAMILY_IPV6`
            
             Address family of managed prefix list
        :type  arn: :class:`str` or ``None``
        :param arn: Amazon Resource Name (ARN) of managed prefix list
        :type  entries: :class:`list` of :class:`str` or ``None``
        :param entries: Entries of managed prefix list
        :type  issues: :class:`list` of :class:`str` or ``None``
        :param issues: Known issues found related to prefix list
        :type  max_entries: :class:`long` or ``None``
        :param max_entries: Maximum number of entries of managed prefix list format: int32
        :type  name: :class:`str` or ``None``
        :param name: Name of managed prefix list
        :type  state: :class:`str` or ``None``
        :param state: Current state of managed prefix list
        :type  state_message: :class:`str` or ``None``
        :param state_message: State message of managed prefix list
        :type  tags: :class:`list` of :class:`ManagedPrefixListTag` or ``None``
        :param tags: Tags of managed prefix list
        :type  version: :class:`long` or ``None``
        :param version: Current version of managed prefix list format: int64
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of current AWS resource.
        :type  resource_type: :class:`str`
        :param resource_type: Type identifier of current AWS resource.
        """
        self.address_family = address_family
        self.arn = arn
        self.entries = entries
        self.issues = issues
        self.max_entries = max_entries
        self.name = name
        self.state = state
        self.state_message = state_message
        self.tags = tags
        self.version = version
        self.id = id
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ManagedPrefixListRuntimeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.managed_prefix_list_runtime_info', {
        'address_family': type.OptionalType(type.StringType()),
        'arn': type.OptionalType(type.StringType()),
        'entries': type.OptionalType(type.ListType(type.StringType())),
        'issues': type.OptionalType(type.ListType(type.StringType())),
        'max_entries': type.OptionalType(type.IntegerType()),
        'name': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
        'state_message': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ManagedPrefixListTag'))),
        'version': type.OptionalType(type.IntegerType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    ManagedPrefixListRuntimeInfo,
    False,
    None))



class ManagedPrefixListTag(VapiStruct):
    """
    Tag that is attached with managed prefix list, as key-value pair.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'key': 'key',
                            'value': 'value',
                            }

    def __init__(self,
                 key=None,
                 value=None,
                ):
        """
        :type  key: :class:`str` or ``None``
        :param key: Tag key
        :type  value: :class:`str` or ``None``
        :param value: Tag value
        """
        self.key = key
        self.value = value
        VapiStruct.__init__(self)


ManagedPrefixListTag._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.managed_prefix_list_tag', {
        'key': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
    },
    ManagedPrefixListTag,
    False,
    None))



class ManagedResource(VapiStruct):
    """
    Base type for resources that are managed by API clients

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)


ManagedResource._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.managed_resource', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ManagedResource,
    False,
    None))



class MgmtServiceEntry(VapiStruct):
    """
    A service entry describes the detail of a network service.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'display_name': 'display_name',
                            'path': 'path',
                            }

    def __init__(self,
                 display_name=None,
                 path=None,
                ):
        """
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name for this service
        :type  path: :class:`str` or ``None``
        :param path: Service path should refer to a valid service in the system. Service
            can be system defined or user defined.
        """
        self.display_name = display_name
        self.path = path
        VapiStruct.__init__(self)


MgmtServiceEntry._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.mgmt_service_entry', {
        'display_name': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
    },
    MgmtServiceEntry,
    False,
    None))



class MgmtVmInfo(VapiStruct):
    """
    Management VM access information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'group_path': 'group_path',
                            'ip_attachment_pairs': 'ip_attachment_pairs',
                            'ips': 'ips',
                            'services': 'services',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 group_path=None,
                 ip_attachment_pairs=None,
                 ips=None,
                 services=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Management VM name
        :type  id: :class:`str` or ``None``
        :param id: Management VM identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  group_path: :class:`str` or ``None``
        :param group_path: For each management VM, a dedicated policy group will be created.
            This property will reflect its group path.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  ip_attachment_pairs: :class:`list` of :class:`IpAttachmentPair` or ``None``
        :param ip_attachment_pairs: IP address and attachment id pairs for tagging managment VM
        :type  ips: :class:`list` of :class:`str` or ``None``
        :param ips: Local IPs of a management VM format: address-or-block-or-range
        :type  services: :class:`list` of :class:`MgmtServiceEntry` or ``None``
        :param services: Details services path and display name.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.group_path = group_path
        self.ip_attachment_pairs = ip_attachment_pairs
        self.ips = ips
        self.services = services
        VapiStruct.__init__(self)


MgmtVmInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.mgmt_vm_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'group_path': type.OptionalType(type.StringType()),
        'ip_attachment_pairs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'IpAttachmentPair'))),
        'ips': type.OptionalType(type.ListType(type.StringType())),
        'services': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'MgmtServiceEntry'))),
    },
    MgmtVmInfo,
    False,
    None))



class MgmtVmsListResult(VapiStruct):
    """
    Management VM list query result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`MgmtVmInfo` or ``None``
        :param results: Management VMs list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


MgmtVmsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.mgmt_vms_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'MgmtVmInfo'))),
    },
    MgmtVmsListResult,
    False,
    None))



class ModelInterface(VapiStruct):
    """
    Interface information (Label)

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'name': 'name',
                            }

    def __init__(self,
                 id=None,
                 name=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Identifier of the Interface label
        :type  name: :class:`str` or ``None``
        :param name: Name of the Interface label
        """
        self.id = id
        self.name = name
        VapiStruct.__init__(self)


ModelInterface._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.model_interface', {
        'id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    ModelInterface,
    False,
    None))



class OtherRegionConnectionInfo(VapiStruct):
    """
    Other region TGW connection info

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'region': 'region',
                            'tgw_id': 'tgw_id',
                            'tgw_peering_id': 'tgw_peering_id',
                            }

    def __init__(self,
                 region=None,
                 tgw_id=None,
                 tgw_peering_id=None,
                ):
        """
        :type  region: :class:`str` or ``None``
        :param region: AWS region
        :type  tgw_id: :class:`str` or ``None``
        :param tgw_id: TGW ID
        :type  tgw_peering_id: :class:`str` or ``None``
        :param tgw_peering_id: TGW peering id
        """
        self.region = region
        self.tgw_id = tgw_id
        self.tgw_peering_id = tgw_peering_id
        VapiStruct.__init__(self)


OtherRegionConnectionInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.other_region_connection_info', {
        'region': type.OptionalType(type.StringType()),
        'tgw_id': type.OptionalType(type.StringType()),
        'tgw_peering_id': type.OptionalType(type.StringType()),
    },
    OtherRegionConnectionInfo,
    False,
    None))



class OutpostInfo(VapiStruct):
    """
    Outpost related information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'lgw_id': 'lgw_id',
                            'lgw_route_table_id': 'lgw_route_table_id',
                            'lgw_route_table_vpc_association_id': 'lgw_route_table_vpc_association_id',
                            'lgw_route_table_vpc_association_state': 'lgw_route_table_vpc_association_state',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 lgw_id=None,
                 lgw_route_table_id=None,
                 lgw_route_table_vpc_association_id=None,
                 lgw_route_table_vpc_association_state=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  lgw_id: :class:`str` or ``None``
        :param lgw_id: Local gateway ID
        :type  lgw_route_table_id: :class:`str` or ``None``
        :param lgw_route_table_id: Local gateway route table ID
        :type  lgw_route_table_vpc_association_id: :class:`str` or ``None``
        :param lgw_route_table_vpc_association_id: Local gateway route table VPC association ID
        :type  lgw_route_table_vpc_association_state: :class:`str` or ``None``
        :param lgw_route_table_vpc_association_state: State of local gateway route table VPC association
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.lgw_id = lgw_id
        self.lgw_route_table_id = lgw_route_table_id
        self.lgw_route_table_vpc_association_id = lgw_route_table_vpc_association_id
        self.lgw_route_table_vpc_association_state = lgw_route_table_vpc_association_state
        VapiStruct.__init__(self)


OutpostInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.outpost_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'lgw_id': type.OptionalType(type.StringType()),
        'lgw_route_table_id': type.OptionalType(type.StringType()),
        'lgw_route_table_vpc_association_id': type.OptionalType(type.StringType()),
        'lgw_route_table_vpc_association_state': type.OptionalType(type.StringType()),
    },
    OutpostInfo,
    False,
    None))



class PrefixListInfo(VapiStruct):
    """
    Prefix lists used by certain features, like Intranet NAT.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'path': 'path',
                            'url': 'url',
                            }

    def __init__(self,
                 name=None,
                 path=None,
                 url=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Prefix List name
        :type  path: :class:`str` or ``None``
        :param path: Relative Prefix List path
        :type  url: :class:`str` or ``None``
        :param url: Prefix List URL
        """
        self.name = name
        self.path = path
        self.url = url
        VapiStruct.__init__(self)


PrefixListInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.prefix_list_info', {
        'name': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'url': type.OptionalType(type.StringType()),
    },
    PrefixListInfo,
    False,
    None))



class ProviderGatewayKeyValuePairs(VapiStruct):
    """
    A list for provider gateways

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'key': 'key',
                            'value': 'value',
                            }

    def __init__(self,
                 key=None,
                 value=None,
                ):
        """
        :type  key: :class:`str` or ``None``
        :param key: Key
        :type  value: :class:`list` of :class:`ProviderObject` or ``None``
        :param value: Value
        """
        self.key = key
        self.value = value
        VapiStruct.__init__(self)


ProviderGatewayKeyValuePairs._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.provider_gateway_key_value_pairs', {
        'key': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProviderObject'))),
    },
    ProviderGatewayKeyValuePairs,
    False,
    None))



class ProviderObject(VapiStruct):
    """
    Basic properties of SDDC User Config.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'display_name': 'display_name',
                            'id': 'id',
                            'path': 'path',
                            'type': 'type',
                            'url': 'url',
                            }

    def __init__(self,
                 display_name=None,
                 id=None,
                 path=None,
                 type=None,
                 url=None,
                ):
        """
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  id: :class:`str` or ``None``
        :param id: ID
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Path
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  type: :class:`str` or ``None``
        :param type: Optional field, used to identify the object.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  url: :class:`str` or ``None``
        :param url: Should start with \"/policy/api/v1/\".
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.display_name = display_name
        self.id = id
        self.path = path
        self.type = type
        self.url = url
        VapiStruct.__init__(self)


ProviderObject._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.provider_object', {
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
        'url': type.OptionalType(type.StringType()),
    },
    ProviderObject,
    False,
    None))



class PublicIp(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'ip': 'ip',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 ip=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: 
        :type  id: :class:`str` or ``None``
        :param id: Public IP identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  ip: :class:`str` or ``None``
        :param ip: IPv4 address format: ipv4
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.ip = ip
        VapiStruct.__init__(self)


PublicIp._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.public_ip', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'ip': type.OptionalType(type.StringType()),
    },
    PublicIp,
    False,
    None))



class PublicIpsListResult(VapiStruct):
    """
    Public IP list

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`PublicIp` or ``None``
        :param results: Public IP list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


PublicIpsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.public_ips_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'PublicIp'))),
    },
    PublicIpsListResult,
    False,
    None))



class RelatedApiError(VapiStruct):
    """
    Detailed information about a related API error

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'error_code': 'error_code',
                            'error_data': 'error_data',
                            'error_message': 'error_message',
                            'module_name': 'module_name',
                            }

    def __init__(self,
                 details=None,
                 error_code=None,
                 error_data=None,
                 error_message=None,
                 module_name=None,
                ):
        """
        :type  details: :class:`str` or ``None``
        :param details: Further details about the error
        :type  error_code: :class:`long` or ``None``
        :param error_code: A numeric error code format: int64
        :type  error_data: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param error_data: Additional data about the error
        :type  error_message: :class:`str` or ``None``
        :param error_message: A description of the error
        :type  module_name: :class:`str` or ``None``
        :param module_name: The module name where the error occurred
        """
        self.details = details
        self.error_code = error_code
        self.error_data = error_data
        self.error_message = error_message
        self.module_name = module_name
        VapiStruct.__init__(self)


RelatedApiError._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.related_api_error', {
        'details': type.OptionalType(type.StringType()),
        'error_code': type.OptionalType(type.IntegerType()),
        'error_data': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'error_message': type.OptionalType(type.StringType()),
        'module_name': type.OptionalType(type.StringType()),
    },
    RelatedApiError,
    False,
    None))



class ReservedCIDRBlock(VapiStruct):
    """
    This model contains CIDR blocks which are reserved for second party
    services like WCP and HCX. Default CGW segments can not overlap with any
    reserved CIDR blocks.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'cidr': 'cidr',
                            'prefixes': 'prefixes',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 cidr=None,
                 prefixes=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cidr: :class:`str` or ``None``
        :param cidr: Single CIDR block of the object, will be deprecated soon, please
            use prefixes going forward. format: ipv4-cidr-block
        :type  prefixes: :class:`list` of :class:`ReservedCIDRBlockPrefix` or ``None``
        :param prefixes: List of CIDR blocks
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.cidr = cidr
        self.prefixes = prefixes
        VapiStruct.__init__(self)


ReservedCIDRBlock._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.reserved_CIDR_block', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'cidr': type.OptionalType(type.StringType()),
        'prefixes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ReservedCIDRBlockPrefix'))),
    },
    ReservedCIDRBlock,
    False,
    None))



class ReservedCIDRBlockPrefix(VapiStruct):
    """
    This model contains CIDR block prefixes which are reserved for second party
    services like WCP and HCX. Default CGW segments can not overlap with any
    reserved CIDR blocks.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'description': 'description',
                            'prefix': 'prefix',
                            }

    def __init__(self,
                 description=None,
                 prefix=None,
                ):
        """
        :type  description: :class:`str` or ``None``
        :param description: Description about the prefix to be reserved
        :type  prefix: :class:`str` or ``None``
        :param prefix: Prefix to be reserved format: ipv4-cidr-block
        """
        self.description = description
        self.prefix = prefix
        VapiStruct.__init__(self)


ReservedCIDRBlockPrefix._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.reserved_CIDR_block_prefix', {
        'description': type.OptionalType(type.StringType()),
        'prefix': type.OptionalType(type.StringType()),
    },
    ReservedCIDRBlockPrefix,
    False,
    None))



class ReservedCIDRBlocksListResult(VapiStruct):
    """
    Reserved CIDR blocks list

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ReservedCIDRBlock` or ``None``
        :param results: Reserved CIDR blocks list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ReservedCIDRBlocksListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.reserved_CIDR_blocks_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ReservedCIDRBlock'))),
    },
    ReservedCIDRBlocksListResult,
    False,
    None))



class Resource(VapiStruct):
    """
    Base class for resources

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        VapiStruct.__init__(self)


Resource._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.resource', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
    },
    Resource,
    False,
    None))



class ResourceLink(VapiStruct):
    """
    A link to a related resource

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'href': 'href',
                            'rel': 'rel',
                            }

    def __init__(self,
                 action=None,
                 href=None,
                 rel=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Optional action
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  href: :class:`str` or ``None``
        :param href: Link to resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rel: :class:`str` or ``None``
        :param rel: Custom relation type (follows RFC 5988 where appropriate
            definitions exist)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.action = action
        self.href = href
        self.rel = rel
        VapiStruct.__init__(self)


ResourceLink._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.resource_link', {
        'action': type.OptionalType(type.StringType()),
        'href': type.OptionalType(type.StringType()),
        'rel': type.OptionalType(type.StringType()),
    },
    ResourceLink,
    False,
    None))



class ResourceRuntimeInfo(VapiStruct):
    """
    Base abstract runtime status information for a AWS resource.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ResourceRuntimeInfo"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 id=None,
                 resource_type='ResourceRuntimeInfo',
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of current AWS resource.
        :type  resource_type: :class:`str`
        :param resource_type: Type identifier of current AWS resource.
        """
        self.id = id
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ResourceRuntimeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.resource_runtime_info', {
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    ResourceRuntimeInfo,
    False,
    None))



class ResourceRuntimeInfoListResult(VapiStruct):
    """
    List result of AWS managed resource(s) runtime information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: AWS managed resources runtime information list
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ResourceRuntimeInfo`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`ResourceRuntimeInfo`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ResourceRuntimeInfoListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.resource_runtime_info_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ResourceRuntimeInfo')]))),
    },
    ResourceRuntimeInfoListResult,
    False,
    None))



class RevisionedResource(VapiStruct):
    """
    A base class for types that track revisions

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        VapiStruct.__init__(self)


RevisionedResource._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.revisioned_resource', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
    },
    RevisionedResource,
    False,
    None))



class RouteAggregationConfig(VapiStruct):
    """
    Route Aggregation object information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'prefixes': 'prefixes',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 prefixes=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Route Aggregation object name
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  prefixes: :class:`list` of :class:`RouteAggregationConfigPrefix` or ``None``
        :param prefixes: List of prefix that user wants to aggregate with the VMC segments
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.prefixes = prefixes
        VapiStruct.__init__(self)


RouteAggregationConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.route_aggregation_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'prefixes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RouteAggregationConfigPrefix'))),
    },
    RouteAggregationConfig,
    False,
    None))



class RouteAggregationConfigListResult(VapiStruct):
    """
    Route aggregation object list

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`RouteAggregationConfig` or ``None``
        :param results: Route aggregation prefixes
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


RouteAggregationConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.route_aggregation_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RouteAggregationConfig'))),
    },
    RouteAggregationConfigListResult,
    False,
    None))



class RouteAggregationConfigPrefix(VapiStruct):
    """
    Prefix object that users provide to aggregate.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'description': 'description',
                            'prefix': 'prefix',
                            'summary_only': 'summary_only',
                            }

    def __init__(self,
                 description=None,
                 prefix=None,
                 summary_only=None,
                ):
        """
        :type  description: :class:`str` or ``None``
        :param description: Description about the prefix that has to be aggregated
        :type  prefix: :class:`str` or ``None``
        :param prefix: Prefix that belong to users workload VM's format: ipv4-cidr-block
        :type  summary_only: :class:`bool` or ``None``
        :param summary_only: Flag to identify whether to advertise this prefix or not
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.description = description
        self.prefix = prefix
        self.summary_only = summary_only
        VapiStruct.__init__(self)


RouteAggregationConfigPrefix._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.route_aggregation_config_prefix', {
        'description': type.OptionalType(type.StringType()),
        'prefix': type.OptionalType(type.StringType()),
        'summary_only': type.OptionalType(type.BooleanType()),
    },
    RouteAggregationConfigPrefix,
    False,
    None))



class RouteConfig(VapiStruct):
    """
    RouteConfig object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'aggregation_route_config': 'aggregation_route_config',
                            'connectivity_endpoint_path': 'connectivity_endpoint_path',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 aggregation_route_config=None,
                 connectivity_endpoint_path=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Name of the routeConfig object.
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  aggregation_route_config: :class:`AggregationRouteConfigInfo` or ``None``
        :param aggregation_route_config: 
        :type  connectivity_endpoint_path: :class:`str` or ``None``
        :param connectivity_endpoint_path: Scope where routeAggregationConfig has to be applied.Existing
            connectivity endpoint object path to be given as valid values
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.aggregation_route_config = aggregation_route_config
        self.connectivity_endpoint_path = connectivity_endpoint_path
        VapiStruct.__init__(self)


RouteConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.route_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'aggregation_route_config': type.OptionalType(type.ReferenceType(__name__, 'AggregationRouteConfigInfo')),
        'connectivity_endpoint_path': type.OptionalType(type.StringType()),
    },
    RouteConfig,
    False,
    None))



class RouteConfigListResult(VapiStruct):
    """
    List of routeConfig object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`RouteConfig` or ``None``
        :param results: Object to hold all the routeConfig objects
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


RouteConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.route_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RouteConfig'))),
    },
    RouteConfigListResult,
    False,
    None))



class SddcAdvertiseRouteConfig(VapiStruct):
    """
    SDDC advertise route configuration with AWS prefix list and other region
    TGW connections.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'aws_prefix_list': 'aws_prefix_list',
                            'other_region_connections': 'other_region_connections',
                            }

    def __init__(self,
                 aws_prefix_list=None,
                 other_region_connections=None,
                ):
        """
        :type  aws_prefix_list: :class:`list` of :class:`AwsPrefixInfo` or ``None``
        :param aws_prefix_list: AWS prefix list for managing TGW routes
        :type  other_region_connections: :class:`list` of :class:`OtherRegionConnectionInfo` or ``None``
        :param other_region_connections: List of TGW connection information from other regions to local
            region TGW
        """
        self.aws_prefix_list = aws_prefix_list
        self.other_region_connections = other_region_connections
        VapiStruct.__init__(self)


SddcAdvertiseRouteConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.sddc_advertise_route_config', {
        'aws_prefix_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AwsPrefixInfo'))),
        'other_region_connections': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'OtherRegionConnectionInfo'))),
    },
    SddcAdvertiseRouteConfig,
    False,
    None))



class SddcTransportNodeInfo(VapiStruct):
    """
    Transport Node details for ESO edge vm deployment.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    APPLIANCE_CONFIGURATION_LARGE = "large"
    """


    """
    APPLIANCE_CONFIGURATION_MEDIUM = "medium"
    """


    """
    HARDWARE_PLATFORM_TYPE_I3 = "i3"
    """


    """
    HARDWARE_PLATFORM_TYPE_I3EN = "i3en"
    """


    """
    HARDWARE_PLATFORM_TYPE_NA = "NA"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'appliance_configuration': 'appliance_configuration',
                            'hardware_platform_type': 'hardware_platform_type',
                            'queue_num_per_port': 'queue_num_per_port',
                            'reservation_info': 'reservation_info',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 appliance_configuration=None,
                 hardware_platform_type=None,
                 queue_num_per_port=None,
                 reservation_info=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  appliance_configuration: :class:`str` or ``None``
        :param appliance_configuration: Possible values are: 
            
            * :attr:`SddcTransportNodeInfo.APPLIANCE_CONFIGURATION_LARGE`
            * :attr:`SddcTransportNodeInfo.APPLIANCE_CONFIGURATION_MEDIUM`
            
             Form factor of the compute server.
        :type  hardware_platform_type: :class:`str` or ``None``
        :param hardware_platform_type: Possible values are: 
            
            * :attr:`SddcTransportNodeInfo.HARDWARE_PLATFORM_TYPE_I3`
            * :attr:`SddcTransportNodeInfo.HARDWARE_PLATFORM_TYPE_I3EN`
            * :attr:`SddcTransportNodeInfo.HARDWARE_PLATFORM_TYPE_NA`
            
             Hardware platform type of the compute server.
        :type  queue_num_per_port: :class:`long` or ``None``
        :param queue_num_per_port: No of queues to be set on the scaled out edge nodes. format: int64
        :type  reservation_info: :class:`TransportNodeReservationInfo` or ``None``
        :param reservation_info: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.appliance_configuration = appliance_configuration
        self.hardware_platform_type = hardware_platform_type
        self.queue_num_per_port = queue_num_per_port
        self.reservation_info = reservation_info
        VapiStruct.__init__(self)


SddcTransportNodeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.sddc_transport_node_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'appliance_configuration': type.OptionalType(type.StringType()),
        'hardware_platform_type': type.OptionalType(type.StringType()),
        'queue_num_per_port': type.OptionalType(type.IntegerType()),
        'reservation_info': type.OptionalType(type.ReferenceType(__name__, 'TransportNodeReservationInfo')),
    },
    SddcTransportNodeInfo,
    False,
    None))



class SddcUserConfiguration(VapiStruct):
    """
    SDDC configuration parameters for users. User-level addresses/CIDRs are
    provided.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SECURITY_CLASSIFICATION_TOP_SECRET = "TOP_SECRET"
    """


    """
    SECURITY_CLASSIFICATION_SECRET = "SECRET"
    """


    """
    SECURITY_CLASSIFICATION_TOP_SECRET_SCI = "TOP_SECRET_SCI"
    """


    """
    SECURITY_CLASSIFICATION_UNCLASSIFIED = "UNCLASSIFIED"
    """


    """
    SECURITY_CLASSIFICATION_CONFIDENTIAL = "CONFIDENTIAL"
    """


    """
    SECURITY_CLASSIFICATION_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'all_uplink_interface_label': 'all_uplink_interface_label',
                            'all_vpn_interface_label': 'all_vpn_interface_label',
                            'cgw_snat_ip': 'cgw_snat_ip',
                            'compute_domain': 'compute_domain',
                            'compute_gateway': 'compute_gateway',
                            'domains': 'domains',
                            'dx_interface_label': 'dx_interface_label',
                            'enforcement_points': 'enforcement_points',
                            'external_connectivities': 'external_connectivities',
                            'gateways': 'gateways',
                            'infra_subnets': 'infra_subnets',
                            'interfaces': 'interfaces',
                            'labels': 'labels',
                            'linked_vpc_interface_label': 'linked_vpc_interface_label',
                            'management_domain': 'management_domain',
                            'management_gateway': 'management_gateway',
                            'management_gateway_default_dns_zone': 'management_gateway_default_dns_zone',
                            'management_gateway_label': 'management_gateway_label',
                            'mgmt_subnet': 'mgmt_subnet',
                            'mgmt_subnets': 'mgmt_subnets',
                            'mgw_snat_ip': 'mgw_snat_ip',
                            'provider_gateways': 'provider_gateways',
                            'provider_name': 'provider_name',
                            'provider_prefix_lists': 'provider_prefix_lists',
                            'public_interface_label': 'public_interface_label',
                            'sddc_infra_subnet': 'sddc_infra_subnet',
                            'sddc_name': 'sddc_name',
                            'sddc_region': 'sddc_region',
                            'security_classification': 'security_classification',
                            'vpn_dx_ips': 'vpn_dx_ips',
                            'vpn_endpoints': 'vpn_endpoints',
                            'vpn_internet_ips': 'vpn_internet_ips',
                            }

    def __init__(self,
                 all_uplink_interface_label=None,
                 all_vpn_interface_label=None,
                 cgw_snat_ip=None,
                 compute_domain=None,
                 compute_gateway=None,
                 domains=None,
                 dx_interface_label=None,
                 enforcement_points=None,
                 external_connectivities=None,
                 gateways=None,
                 infra_subnets=None,
                 interfaces=None,
                 labels=None,
                 linked_vpc_interface_label=None,
                 management_domain=None,
                 management_gateway=None,
                 management_gateway_default_dns_zone=None,
                 management_gateway_label=None,
                 mgmt_subnet=None,
                 mgmt_subnets=None,
                 mgw_snat_ip=None,
                 provider_gateways=None,
                 provider_name=None,
                 provider_prefix_lists=None,
                 public_interface_label=None,
                 sddc_infra_subnet=None,
                 sddc_name=None,
                 sddc_region=None,
                 security_classification=None,
                 vpn_dx_ips=None,
                 vpn_endpoints=None,
                 vpn_internet_ips=None,
                ):
        """
        :type  all_uplink_interface_label: :class:`str` or ``None``
        :param all_uplink_interface_label: All uplink interfaces label name. Only presents in AWS environment
            now. Deprecated, please use labels.
        :type  all_vpn_interface_label: :class:`str` or ``None``
        :param all_vpn_interface_label: All VPN interfaces label name. Only presents in AWS environment
            now. Deprecated, please use labels.
        :type  cgw_snat_ip: :class:`str` or ``None``
        :param cgw_snat_ip: Compute gateway SNAT IP address. format: ipv4
        :type  compute_domain: :class:`str` or ``None``
        :param compute_domain: Compute domain ID. Only presents in AWS environment now.
            Deprecated, please use domains.
        :type  compute_gateway: :class:`str` or ``None``
        :param compute_gateway: Compute gateway name. Only presents in AWS environment now.
            Deprecated, please use gateways.
        :type  domains: :class:`list` of :class:`ProviderObject` or ``None``
        :param domains: Domain information for management gateway and compute gateway.
        :type  dx_interface_label: :class:`str` or ``None``
        :param dx_interface_label: DirectConnect interface label name. Only presents in AWS
            environment now. Deprecated, please use labels.
        :type  enforcement_points: :class:`list` of :class:`ProviderObject` or ``None``
        :param enforcement_points: Policy enforcement point object paths.
        :type  external_connectivities: :class:`list` of :class:`ExternalConnectivityInfo` or ``None``
        :param external_connectivities: List of applicable SDDC connectivities to external endpoints.
        :type  gateways: :class:`list` of :class:`ProviderGatewayKeyValuePairs` or ``None``
        :param gateways: Provider gateway list. Including both tier-0 gateways and tier-1
            gateways.
        :type  infra_subnets: :class:`list` of :class:`str` or ``None``
        :param infra_subnets: SDDC infra subnet CIDRs. format: ipv4-cidr-block
        :type  interfaces: :class:`list` of :class:`ModelInterface` or ``None``
        :param interfaces: Interfaces (labels) including public interface, direct connect
            interface, linked vpc interface, etc. Only presents in AWS
            environment now. Deprecated, please use labels.
        :type  labels: :class:`list` of :class:`ProviderObject` or ``None``
        :param labels: Interfaces (labels) including internet, intranet and services.
        :type  linked_vpc_interface_label: :class:`str` or ``None``
        :param linked_vpc_interface_label: Linked VPC interface label name. Only presents in AWS environment
            now. Deprecated, please use labels.
        :type  management_domain: :class:`str` or ``None``
        :param management_domain: Management domain ID. Only presents in AWS environment now.
            Deprecated, please use domains.
        :type  management_gateway: :class:`str` or ``None``
        :param management_gateway: Management gateway name. Only presents in AWS environment now.
            Deprecated, please use gateways.
        :type  management_gateway_default_dns_zone: :class:`ProviderObject` or ``None``
        :param management_gateway_default_dns_zone: 
        :type  management_gateway_label: :class:`str` or ``None``
        :param management_gateway_label: Management gateway label name. Only presents in AWS environment
            now. Deprecated, please use labels.
        :type  mgmt_subnet: :class:`list` of :class:`str` or ``None``
        :param mgmt_subnet: Management subnet CIDRs. Only presents in AWS environment now.
            Deprecated, please use mgmt_subnets. format: ipv4-cidr-block
        :type  mgmt_subnets: :class:`list` of :class:`str` or ``None``
        :param mgmt_subnets: Management subnet CIDRs. format: ipv4-cidr-block
        :type  mgw_snat_ip: :class:`str` or ``None``
        :param mgw_snat_ip: Management gateway SNAT IP address. format: ipv4
        :type  provider_gateways: :class:`list` of :class:`ProviderGatewayKeyValuePairs` or ``None``
        :param provider_gateways: Provider gateway list. Including both tier-0 gateways and tier-1
            gateways. Only presents in AWS environment now. Deprecated, please
            use gateways.
        :type  provider_name: :class:`str` or ``None``
        :param provider_name: Service provider name. Only presents in AWS environment now.
            Deprecated, please use gateways.
        :type  provider_prefix_lists: :class:`list` of :class:`PrefixListInfo` or ``None``
        :param provider_prefix_lists: Prefix lists used by certain features, like Intranet NAT.
        :type  public_interface_label: :class:`str` or ``None``
        :param public_interface_label: Public interface label name. Only presents in AWS environment now.
            Deprecated, please use labels.
        :type  sddc_infra_subnet: :class:`list` of :class:`str` or ``None``
        :param sddc_infra_subnet: SDDC infra subnet CIDRs. Only presents in AWS environment now.
            Deprecated, please use infra_subnets. format: ipv4-cidr-block
        :type  sddc_name: :class:`str` or ``None``
        :param sddc_name: The name of SDDC.
        :type  sddc_region: :class:`str` or ``None``
        :param sddc_region: Region of the SDDC deployment.
        :type  security_classification: :class:`str` or ``None``
        :param security_classification: Possible values are: 
            
            * :attr:`SddcUserConfiguration.SECURITY_CLASSIFICATION_TOP_SECRET`
            * :attr:`SddcUserConfiguration.SECURITY_CLASSIFICATION_SECRET`
            *
              :attr:`SddcUserConfiguration.SECURITY_CLASSIFICATION_TOP_SECRET_SCI`
            *
              :attr:`SddcUserConfiguration.SECURITY_CLASSIFICATION_UNCLASSIFIED`
            *
              :attr:`SddcUserConfiguration.SECURITY_CLASSIFICATION_CONFIDENTIAL`
            * :attr:`SddcUserConfiguration.SECURITY_CLASSIFICATION_UNKNOWN`
            
             Security classification
        :type  vpn_dx_ips: :class:`list` of :class:`str` or ``None``
        :param vpn_dx_ips: Local IPs for VPN tunnel over Direct Connect. Only presents in AWS
            environment now. Deprecated, please use vpn_endpoints instead of
            vpn_dx_ips. format: ipv4
        :type  vpn_endpoints: :class:`list` of :class:`VpnEndpoint` or ``None``
        :param vpn_endpoints: VPN tunnel endpoints. Currently containing public IPs for VPN over
            internet and local IPs for VPN over intranet.
        :type  vpn_internet_ips: :class:`list` of :class:`str` or ``None``
        :param vpn_internet_ips: Public IPs for VPN tunnel over internet. Only presents in AWS
            environment now. Deprecated, please use vpn_endpoints instead of
            vpn_internet_ips. format: ipv4
        """
        self.all_uplink_interface_label = all_uplink_interface_label
        self.all_vpn_interface_label = all_vpn_interface_label
        self.cgw_snat_ip = cgw_snat_ip
        self.compute_domain = compute_domain
        self.compute_gateway = compute_gateway
        self.domains = domains
        self.dx_interface_label = dx_interface_label
        self.enforcement_points = enforcement_points
        self.external_connectivities = external_connectivities
        self.gateways = gateways
        self.infra_subnets = infra_subnets
        self.interfaces = interfaces
        self.labels = labels
        self.linked_vpc_interface_label = linked_vpc_interface_label
        self.management_domain = management_domain
        self.management_gateway = management_gateway
        self.management_gateway_default_dns_zone = management_gateway_default_dns_zone
        self.management_gateway_label = management_gateway_label
        self.mgmt_subnet = mgmt_subnet
        self.mgmt_subnets = mgmt_subnets
        self.mgw_snat_ip = mgw_snat_ip
        self.provider_gateways = provider_gateways
        self.provider_name = provider_name
        self.provider_prefix_lists = provider_prefix_lists
        self.public_interface_label = public_interface_label
        self.sddc_infra_subnet = sddc_infra_subnet
        self.sddc_name = sddc_name
        self.sddc_region = sddc_region
        self.security_classification = security_classification
        self.vpn_dx_ips = vpn_dx_ips
        self.vpn_endpoints = vpn_endpoints
        self.vpn_internet_ips = vpn_internet_ips
        VapiStruct.__init__(self)


SddcUserConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.sddc_user_configuration', {
        'all_uplink_interface_label': type.OptionalType(type.StringType()),
        'all_vpn_interface_label': type.OptionalType(type.StringType()),
        'cgw_snat_ip': type.OptionalType(type.StringType()),
        'compute_domain': type.OptionalType(type.StringType()),
        'compute_gateway': type.OptionalType(type.StringType()),
        'domains': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProviderObject'))),
        'dx_interface_label': type.OptionalType(type.StringType()),
        'enforcement_points': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProviderObject'))),
        'external_connectivities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ExternalConnectivityInfo'))),
        'gateways': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProviderGatewayKeyValuePairs'))),
        'infra_subnets': type.OptionalType(type.ListType(type.StringType())),
        'interfaces': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ModelInterface'))),
        'labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProviderObject'))),
        'linked_vpc_interface_label': type.OptionalType(type.StringType()),
        'management_domain': type.OptionalType(type.StringType()),
        'management_gateway': type.OptionalType(type.StringType()),
        'management_gateway_default_dns_zone': type.OptionalType(type.ReferenceType(__name__, 'ProviderObject')),
        'management_gateway_label': type.OptionalType(type.StringType()),
        'mgmt_subnet': type.OptionalType(type.ListType(type.StringType())),
        'mgmt_subnets': type.OptionalType(type.ListType(type.StringType())),
        'mgw_snat_ip': type.OptionalType(type.StringType()),
        'provider_gateways': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProviderGatewayKeyValuePairs'))),
        'provider_name': type.OptionalType(type.StringType()),
        'provider_prefix_lists': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'PrefixListInfo'))),
        'public_interface_label': type.OptionalType(type.StringType()),
        'sddc_infra_subnet': type.OptionalType(type.ListType(type.StringType())),
        'sddc_name': type.OptionalType(type.StringType()),
        'sddc_region': type.OptionalType(type.StringType()),
        'security_classification': type.OptionalType(type.StringType()),
        'vpn_dx_ips': type.OptionalType(type.ListType(type.StringType())),
        'vpn_endpoints': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VpnEndpoint'))),
        'vpn_internet_ips': type.OptionalType(type.ListType(type.StringType())),
    },
    SddcUserConfiguration,
    False,
    None))



class SelfResourceLink(VapiStruct):
    """
    The server will populate this field when returing the resource. Ignored on
    PUT and POST.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'href': 'href',
                            'rel': 'rel',
                            }

    def __init__(self,
                 action=None,
                 href=None,
                 rel=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Optional action
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  href: :class:`str` or ``None``
        :param href: Link to resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rel: :class:`str` or ``None``
        :param rel: Custom relation type (follows RFC 5988 where appropriate
            definitions exist)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.action = action
        self.href = href
        self.rel = rel
        VapiStruct.__init__(self)


SelfResourceLink._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.self_resource_link', {
        'action': type.OptionalType(type.StringType()),
        'href': type.OptionalType(type.StringType()),
        'rel': type.OptionalType(type.StringType()),
    },
    SelfResourceLink,
    False,
    None))



class Tag(VapiStruct):
    """
    Arbitrary key-value pairs that may be attached to an entity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'scope': 'scope',
                            'tag': 'tag',
                            }

    def __init__(self,
                 scope=None,
                 tag=None,
                ):
        """
        :type  scope: :class:`str` or ``None``
        :param scope: Tag searches may optionally be restricted by scope
        :type  tag: :class:`str` or ``None``
        :param tag: Identifier meaningful to user with maximum length of 256 characters
        """
        self.scope = scope
        self.tag = tag
        VapiStruct.__init__(self)


Tag._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.tag', {
        'scope': type.OptionalType(type.StringType()),
        'tag': type.OptionalType(type.StringType()),
    },
    Tag,
    False,
    None))



class TrafficGroup(VapiStruct):
    """
    Traffic group configuration. A traffic group indicates dedicated bandwidth
    and computation for a given list of subnets. Creating a traffic group will
    reserve resources and associating it with desired prefix lists will use the
    resources for the traffic of the prefix lists. Besides traffic group ID and
    name, realized state and detailed association maps info of this traffic
    group are included if verbose info is requested.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATE_SUCCESS = "SUCCESS"
    """


    """
    STATE_FAILURE = "FAILURE"
    """


    """
    STATE_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    STATE_PENDING = "PENDING"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'association_maps': 'association_maps',
                            'resource_id': 'resource_id',
                            'state': 'state',
                            'state_message': 'state_message',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 association_maps=None,
                 resource_id=None,
                 state=None,
                 state_message=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: A description field for the traffic group.
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier for a traffic group.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  association_maps: :class:`list` of :class:`TrafficGroupAssociationMap` or ``None``
        :param association_maps: Association maps in the traffic group.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_id: :class:`long` or ``None``
        :param resource_id: Unique resource identifier for a traffic group. This identifier is
            used in the traffic group's related resource allocation and naming.
            format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`TrafficGroup.STATE_IN_PROGRESS`
            * :attr:`TrafficGroup.STATE_SUCCESS`
            * :attr:`TrafficGroup.STATE_FAILURE`
            * :attr:`TrafficGroup.STATE_UNAVAILABLE`
            * :attr:`TrafficGroup.STATE_PENDING`
            
            Realized state of the traffic group. This matches the realized
            state (VmcConsolidatedStatus) of the traffic group.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state_message: :class:`str` or ``None``
        :param state_message: Information on the current state. Mostly error messages on failure
            states.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.association_maps = association_maps
        self.resource_id = resource_id
        self.state = state
        self.state_message = state_message
        VapiStruct.__init__(self)


TrafficGroup._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.traffic_group', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'association_maps': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'TrafficGroupAssociationMap'))),
        'resource_id': type.OptionalType(type.IntegerType()),
        'state': type.OptionalType(type.StringType()),
        'state_message': type.OptionalType(type.StringType()),
    },
    TrafficGroup,
    False,
    None))



class TrafficGroupAssociationMap(VapiStruct):
    """
    An association map of a traffic group. It describes the association of
    prefix lists and logical routers with the traffic group. To make use of
    dedicated traffic resources through traffic groups, prefix lists need to be
    linked to the desired traffic group and an association with the target
    logical router (scope) is required. The scope is for declaring which
    logical router the prefix lists are associated under a particular traffic
    group. The scope is not required input.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SCOPE_1S_CGW = "/infra/tier-1s/cgw"
    """


    """
    SCOPE_0S_VMC = "/infra/tier-0s/vmc"
    """


    """
    STATE_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATE_SUCCESS = "SUCCESS"
    """


    """
    STATE_FAILURE = "FAILURE"
    """


    """
    STATE_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    STATE_PENDING = "PENDING"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'prefix_lists': 'prefix_lists',
                            'scope': 'scope',
                            'state': 'state',
                            'state_message': 'state_message',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 prefix_lists=None,
                 scope=None,
                 state=None,
                 state_message=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: A description field for Traffic group association map。
        :type  id: :class:`str` or ``None``
        :param id: The association map id.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  prefix_lists: :class:`list` of :class:`str` or ``None``
        :param prefix_lists: The list of prefix lists to be associated.
        :type  scope: :class:`str` or ``None``
        :param scope: Possible values are: 
            
            * :attr:`TrafficGroupAssociationMap.SCOPE__1S_CGW`
            * :attr:`TrafficGroupAssociationMap.SCOPE__0S_VMC`
            
            The targeted logical router (scope) of prefix lists. Non admin
            users are not allowed to create, update, delete an association map
            with scope as /infra/tier-0s/vmc.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`TrafficGroupAssociationMap.STATE_IN_PROGRESS`
            * :attr:`TrafficGroupAssociationMap.STATE_SUCCESS`
            * :attr:`TrafficGroupAssociationMap.STATE_FAILURE`
            * :attr:`TrafficGroupAssociationMap.STATE_UNAVAILABLE`
            * :attr:`TrafficGroupAssociationMap.STATE_PENDING`
            
            Realized state of the traffic group. This matches the realized
            state (VmcConsolidatedStatus) of the traffic group.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state_message: :class:`str` or ``None``
        :param state_message: Information on the current state. Mostly error messages on failure
            states.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.prefix_lists = prefix_lists
        self.scope = scope
        self.state = state
        self.state_message = state_message
        VapiStruct.__init__(self)


TrafficGroupAssociationMap._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.traffic_group_association_map', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'prefix_lists': type.OptionalType(type.ListType(type.StringType())),
        'scope': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
        'state_message': type.OptionalType(type.StringType()),
    },
    TrafficGroupAssociationMap,
    False,
    None))



class TrafficGroupAssociationMapsListResult(VapiStruct):
    """
    List result for traffic group association maps.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`TrafficGroupAssociationMap` or ``None``
        :param results: Traffic group association map list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


TrafficGroupAssociationMapsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.traffic_group_association_maps_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'TrafficGroupAssociationMap'))),
    },
    TrafficGroupAssociationMapsListResult,
    False,
    None))



class TrafficGroupEniMappingInfo(VapiStruct):
    """
    Information of mapping between traffic group and corresponding active
    edge's Virtual Distributed Router Elastic Network Interface.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'eni': 'eni',
                            'traffic_group_id': 'traffic_group_id',
                            'traffic_group_name': 'traffic_group_name',
                            }

    def __init__(self,
                 eni=None,
                 traffic_group_id=None,
                 traffic_group_name=None,
                ):
        """
        :type  eni: :class:`str` or ``None``
        :param eni: Elastic Network Interface of Virtual Distributed Router for linked
            VPC connectivity.
        :type  traffic_group_id: :class:`str` or ``None``
        :param traffic_group_id: ID of the traffic group
        :type  traffic_group_name: :class:`str` or ``None``
        :param traffic_group_name: Name of the traffic group
        """
        self.eni = eni
        self.traffic_group_id = traffic_group_id
        self.traffic_group_name = traffic_group_name
        VapiStruct.__init__(self)


TrafficGroupEniMappingInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.traffic_group_eni_mapping_info', {
        'eni': type.OptionalType(type.StringType()),
        'traffic_group_id': type.OptionalType(type.StringType()),
        'traffic_group_name': type.OptionalType(type.StringType()),
    },
    TrafficGroupEniMappingInfo,
    False,
    None))



class TrafficGroupsListResult(VapiStruct):
    """
    List result for traffic groups.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`TrafficGroup` or ``None``
        :param results: Traffic group list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


TrafficGroupsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.traffic_groups_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'TrafficGroup'))),
    },
    TrafficGroupsListResult,
    False,
    None))



class TransportNodeCpuReservation(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'reservation_in_mhz': 'reservation_in_mhz',
                            'reservation_in_shares': 'reservation_in_shares',
                            }

    def __init__(self,
                 reservation_in_mhz=None,
                 reservation_in_shares=None,
                ):
        """
        :type  reservation_in_mhz: :class:`long` or ``None``
        :param reservation_in_mhz: Reservation in mHz format: int64
        :type  reservation_in_shares: :class:`str` or ``None``
        :param reservation_in_shares: Reservation in shares
        """
        self.reservation_in_mhz = reservation_in_mhz
        self.reservation_in_shares = reservation_in_shares
        VapiStruct.__init__(self)


TransportNodeCpuReservation._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.transport_node_cpu_reservation', {
        'reservation_in_mhz': type.OptionalType(type.IntegerType()),
        'reservation_in_shares': type.OptionalType(type.StringType()),
    },
    TransportNodeCpuReservation,
    False,
    None))



class TransportNodeMemoryReservation(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'reservation_percentage': 'reservation_percentage',
                            }

    def __init__(self,
                 reservation_percentage=None,
                ):
        """
        :type  reservation_percentage: :class:`long` or ``None``
        :param reservation_percentage: Reservation percentage format: int64
        """
        self.reservation_percentage = reservation_percentage
        VapiStruct.__init__(self)


TransportNodeMemoryReservation._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.transport_node_memory_reservation', {
        'reservation_percentage': type.OptionalType(type.IntegerType()),
    },
    TransportNodeMemoryReservation,
    False,
    None))



class TransportNodeReservationInfo(VapiStruct):
    """
    CPU and memory reservation info for ESO edge nodes.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cpu_reservation': 'cpu_reservation',
                            'memory_reservation': 'memory_reservation',
                            }

    def __init__(self,
                 cpu_reservation=None,
                 memory_reservation=None,
                ):
        """
        :type  cpu_reservation: :class:`TransportNodeCpuReservation` or ``None``
        :param cpu_reservation: 
        :type  memory_reservation: :class:`TransportNodeMemoryReservation` or ``None``
        :param memory_reservation: 
        """
        self.cpu_reservation = cpu_reservation
        self.memory_reservation = memory_reservation
        VapiStruct.__init__(self)


TransportNodeReservationInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.transport_node_reservation_info', {
        'cpu_reservation': type.OptionalType(type.ReferenceType(__name__, 'TransportNodeCpuReservation')),
        'memory_reservation': type.OptionalType(type.ReferenceType(__name__, 'TransportNodeMemoryReservation')),
    },
    TransportNodeReservationInfo,
    False,
    None))



class VMCAccounts(VapiStruct):
    """
    Shadow account and linked VPC account

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'linked_vpc_account': 'linked_vpc_account',
                            'shadow_account': 'shadow_account',
                            }

    def __init__(self,
                 linked_vpc_account=None,
                 shadow_account=None,
                ):
        """
        :type  linked_vpc_account: :class:`str` or ``None``
        :param linked_vpc_account: linked VPC account number
        :type  shadow_account: :class:`str` or ``None``
        :param shadow_account: Shadow VPC account number
        """
        self.linked_vpc_account = linked_vpc_account
        self.shadow_account = shadow_account
        VapiStruct.__init__(self)


VMCAccounts._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.VMC_accounts', {
        'linked_vpc_account': type.OptionalType(type.StringType()),
        'shadow_account': type.OptionalType(type.StringType()),
    },
    VMCAccounts,
    False,
    None))



class VifsListResult(VapiStruct):
    """
    Direct Connect VIFs (Virtual Interface) list query result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`VirtualInterface` or ``None``
        :param results: VIFs list
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


VifsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vifs_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VirtualInterface'))),
    },
    VifsListResult,
    False,
    None))



class VirtualInterface(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    BGP_STATUS_UP = "UP"
    """


    """
    BGP_STATUS_DOWN = "DOWN"
    """


    """
    STATE_CONFIRMING = "CONFIRMING"
    """


    """
    STATE_VERIFYING = "VERIFYING"
    """


    """
    STATE_PENDING = "PENDING"
    """


    """
    STATE_AVAILABLE = "AVAILABLE"
    """


    """
    STATE_DOWN = "DOWN"
    """


    """
    STATE_DELETING = "DELETING"
    """


    """
    STATE_DELETED = "DELETED"
    """


    """
    STATE_REJECTED = "REJECTED"
    """


    """
    STATE_ATTACHED = "ATTACHED"
    """


    """
    STATE_ATTACHING = "ATTACHING"
    """


    """
    STATE_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'bgp_status': 'bgp_status',
                            'direct_connect_id': 'direct_connect_id',
                            'id': 'id',
                            'local_ip': 'local_ip',
                            'mtu': 'mtu',
                            'name': 'name',
                            'remote_asn': 'remote_asn',
                            'remote_ip': 'remote_ip',
                            'state': 'state',
                            }

    def __init__(self,
                 bgp_status=None,
                 direct_connect_id=None,
                 id=None,
                 local_ip=None,
                 mtu=None,
                 name=None,
                 remote_asn=None,
                 remote_ip=None,
                 state=None,
                ):
        """
        :type  bgp_status: :class:`str` or ``None``
        :param bgp_status: Possible values are: 
            
            * :attr:`VirtualInterface.BGP_STATUS_UP`
            * :attr:`VirtualInterface.BGP_STATUS_DOWN`
            
             BGP status
        :type  direct_connect_id: :class:`str` or ``None``
        :param direct_connect_id: Identifier for the Direct Connect
        :type  id: :class:`str` or ``None``
        :param id: Identifier for the virtual interface
        :type  local_ip: :class:`str` or ``None``
        :param local_ip: amazon side address format: ipv4
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  mtu: :class:`long` or ``None``
        :param mtu: Maximum transmission unit allowed by the VIF format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  name: :class:`str` or ``None``
        :param name: VIF name
        :type  remote_asn: :class:`str` or ``None``
        :param remote_asn: Remote autonomous system number of vif
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_ip: :class:`str` or ``None``
        :param remote_ip: customer address format: ipv4
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`VirtualInterface.STATE_CONFIRMING`
            * :attr:`VirtualInterface.STATE_VERIFYING`
            * :attr:`VirtualInterface.STATE_PENDING`
            * :attr:`VirtualInterface.STATE_AVAILABLE`
            * :attr:`VirtualInterface.STATE_DOWN`
            * :attr:`VirtualInterface.STATE_DELETING`
            * :attr:`VirtualInterface.STATE_DELETED`
            * :attr:`VirtualInterface.STATE_REJECTED`
            * :attr:`VirtualInterface.STATE_ATTACHED`
            * :attr:`VirtualInterface.STATE_ATTACHING`
            * :attr:`VirtualInterface.STATE_ERROR`
            
             VIF State
        """
        self.bgp_status = bgp_status
        self.direct_connect_id = direct_connect_id
        self.id = id
        self.local_ip = local_ip
        self.mtu = mtu
        self.name = name
        self.remote_asn = remote_asn
        self.remote_ip = remote_ip
        self.state = state
        VapiStruct.__init__(self)


VirtualInterface._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.virtual_interface', {
        'bgp_status': type.OptionalType(type.StringType()),
        'direct_connect_id': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'local_ip': type.OptionalType(type.StringType()),
        'mtu': type.OptionalType(type.IntegerType()),
        'name': type.OptionalType(type.StringType()),
        'remote_asn': type.OptionalType(type.StringType()),
        'remote_ip': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    VirtualInterface,
    False,
    None))



class VmcAppBaseInfo(VapiStruct):
    """
    Abstract base class for all the VmcApp objects.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        VapiStruct.__init__(self)


VmcAppBaseInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_app_base_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
    },
    VmcAppBaseInfo,
    False,
    None))



class VmcConsolidatedRealizedStatus(VapiStruct):
    """
    Represents aggregated realized status for intent entity across associated
    realized entities.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'consolidated_status': 'consolidated_status',
                            'consolidated_status_per_object': 'consolidated_status_per_object',
                            'intent_path': 'intent_path',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 consolidated_status=None,
                 consolidated_status_per_object=None,
                 intent_path=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  consolidated_status: :class:`VmcConsolidatedStatus` or ``None``
        :param consolidated_status: 
        :type  consolidated_status_per_object: :class:`list` of :class:`VmcConsolidatedStatusPerObject` or ``None``
        :param consolidated_status_per_object: Aggregated consolidated status by enforcement point.
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of the object representing this consolidated state.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.consolidated_status = consolidated_status
        self.consolidated_status_per_object = consolidated_status_per_object
        self.intent_path = intent_path
        VapiStruct.__init__(self)


VmcConsolidatedRealizedStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_consolidated_realized_status', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'consolidated_status': type.OptionalType(type.ReferenceType(__name__, 'VmcConsolidatedStatus')),
        'consolidated_status_per_object': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VmcConsolidatedStatusPerObject'))),
        'intent_path': type.OptionalType(type.StringType()),
    },
    VmcConsolidatedRealizedStatus,
    False,
    None))



class VmcConsolidatedStatus(VapiStruct):
    """
    Consolidated status of an object.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONSOLIDATED_STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    CONSOLIDATED_STATUS_SUCCESS = "SUCCESS"
    """


    """
    CONSOLIDATED_STATUS_FAILURE = "FAILURE"
    """


    """
    CONSOLIDATED_STATUS_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    CONSOLIDATED_STATUS_PENDING = "PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'consolidated_status': 'consolidated_status',
                            'status_message': 'status_message',
                            }

    def __init__(self,
                 consolidated_status=None,
                 status_message=None,
                ):
        """
        :type  consolidated_status: :class:`str` or ``None``
        :param consolidated_status: Possible values are: 
            
            * :attr:`VmcConsolidatedStatus.CONSOLIDATED_STATUS_IN_PROGRESS`
            * :attr:`VmcConsolidatedStatus.CONSOLIDATED_STATUS_SUCCESS`
            * :attr:`VmcConsolidatedStatus.CONSOLIDATED_STATUS_FAILURE`
            * :attr:`VmcConsolidatedStatus.CONSOLIDATED_STATUS_UNAVAILABLE`
            * :attr:`VmcConsolidatedStatus.CONSOLIDATED_STATUS_PENDING`
            
             Realized state of consolidation.
        :type  status_message: :class:`str` or ``None``
        :param status_message: Help message for the current status regarding an object, providing
            information for each state.
        """
        self.consolidated_status = consolidated_status
        self.status_message = status_message
        VapiStruct.__init__(self)


VmcConsolidatedStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_consolidated_status', {
        'consolidated_status': type.OptionalType(type.StringType()),
        'status_message': type.OptionalType(type.StringType()),
    },
    VmcConsolidatedStatus,
    False,
    None))



class VmcConsolidatedStatusPerObject(VapiStruct):
    """
    Realized status consolidated by individual objects.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'consolidated_status': 'consolidated_status',
                            'object_id': 'object_id',
                            }

    def __init__(self,
                 consolidated_status=None,
                 object_id=None,
                ):
        """
        :type  consolidated_status: :class:`VmcConsolidatedStatus` or ``None``
        :param consolidated_status: 
        :type  object_id: :class:`str` or ``None``
        :param object_id: Object id used to consolidate state. This can be a particular
            backend task/job, etc.
        """
        self.consolidated_status = consolidated_status
        self.object_id = object_id
        VapiStruct.__init__(self)


VmcConsolidatedStatusPerObject._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_consolidated_status_per_object', {
        'consolidated_status': type.OptionalType(type.ReferenceType(__name__, 'VmcConsolidatedStatus')),
        'object_id': type.OptionalType(type.StringType()),
    },
    VmcConsolidatedStatusPerObject,
    False,
    None))



class VmcFeatureFlagInfo(VapiStruct):
    """
    VMC Feature Flag

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_ENABLED = "enabled"
    """


    """
    STATE_DISABLED = "disabled"
    """


    """
    STATE_INACTIVE = "inactive"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'marked_for_delete': 'marked_for_delete',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'relative_path': 'relative_path',
                            'internal_name': 'internal_name',
                            'message': 'message',
                            'name': 'name',
                            'state': 'state',
                            'unlicensed_message': 'unlicensed_message',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 marked_for_delete=None,
                 parent_path=None,
                 path=None,
                 relative_path=None,
                 internal_name=None,
                 message=None,
                 name=None,
                 state=None,
                 unlicensed_message=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display Name
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: marked for delete identifier
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  internal_name: :class:`str` or ``None``
        :param internal_name: Internal Name
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  message: :class:`str` or ``None``
        :param message: Message
        :type  name: :class:`str` or ``None``
        :param name: Feature Name
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`VmcFeatureFlagInfo.STATE_ENABLED`
            * :attr:`VmcFeatureFlagInfo.STATE_DISABLED`
            * :attr:`VmcFeatureFlagInfo.STATE_INACTIVE`
            
             state
        :type  unlicensed_message: :class:`str` or ``None``
        :param unlicensed_message: Unlicensed Message
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.marked_for_delete = marked_for_delete
        self.parent_path = parent_path
        self.path = path
        self.relative_path = relative_path
        self.internal_name = internal_name
        self.message = message
        self.name = name
        self.state = state
        self.unlicensed_message = unlicensed_message
        VapiStruct.__init__(self)


VmcFeatureFlagInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_feature_flag_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'internal_name': type.OptionalType(type.StringType()),
        'message': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
        'unlicensed_message': type.OptionalType(type.StringType()),
    },
    VmcFeatureFlagInfo,
    False,
    None))



class VmcFeatureFlags(VapiStruct):
    """
    VMC Feature flags

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'features': 'features',
                            }

    def __init__(self,
                 features=None,
                ):
        """
        :type  features: :class:`list` of :class:`VmcFeatureFlagInfo` or ``None``
        :param features: 
        """
        self.features = features
        VapiStruct.__init__(self)


VmcFeatureFlags._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_feature_flags', {
        'features': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VmcFeatureFlagInfo'))),
    },
    VmcFeatureFlags,
    False,
    None))



class VmcRealizedEntities(VapiStruct):
    """
    A consolidated object of realized entities given an intent path. This
    accounts for resources / entities which are realized under the intent path.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    REALIZED_STATE_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    REALIZED_STATE_SUCCESS = "SUCCESS"
    """


    """
    REALIZED_STATE_FAILURE = "FAILURE"
    """


    """
    REALIZED_STATE_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    REALIZED_STATE_PENDING = "PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'realized_entities': 'realized_entities',
                            'realized_entities_id': 'realized_entities_id',
                            'realized_state': 'realized_state',
                            }

    def __init__(self,
                 intent_path=None,
                 realized_entities=None,
                 realized_entities_id=None,
                 realized_state=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realized_entities: :class:`list` of :class:`VmcRealizedEntity` or ``None``
        :param realized_entities: Detailed realized entities list.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realized_entities_id: :class:`str` or ``None``
        :param realized_entities_id: Realized entities id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realized_state: :class:`str` or ``None``
        :param realized_state: Possible values are: 
            
            * :attr:`VmcRealizedEntities.REALIZED_STATE_IN_PROGRESS`
            * :attr:`VmcRealizedEntities.REALIZED_STATE_SUCCESS`
            * :attr:`VmcRealizedEntities.REALIZED_STATE_FAILURE`
            * :attr:`VmcRealizedEntities.REALIZED_STATE_UNAVAILABLE`
            * :attr:`VmcRealizedEntities.REALIZED_STATE_PENDING`
            
             Realized state
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.realized_entities = realized_entities
        self.realized_entities_id = realized_entities_id
        self.realized_state = realized_state
        VapiStruct.__init__(self)


VmcRealizedEntities._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_realized_entities', {
        'intent_path': type.OptionalType(type.StringType()),
        'realized_entities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VmcRealizedEntity'))),
        'realized_entities_id': type.OptionalType(type.StringType()),
        'realized_state': type.OptionalType(type.StringType()),
    },
    VmcRealizedEntities,
    False,
    None))



class VmcRealizedEntity(VapiStruct):
    """
    Realized entity object. This accounts for an resource / entity which is
    realized within cloud service.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    REALIZED_STATE_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    REALIZED_STATE_SUCCESS = "SUCCESS"
    """


    """
    REALIZED_STATE_FAILURE = "FAILURE"
    """


    """
    REALIZED_STATE_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    REALIZED_STATE_PENDING = "PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'realization_api': 'realization_api',
                            'realization_id': 'realization_id',
                            'realization_path': 'realization_path',
                            'realized_entity_id': 'realized_entity_id',
                            'realized_entity_type': 'realized_entity_type',
                            'realized_state': 'realized_state',
                            }

    def __init__(self,
                 realization_api=None,
                 realization_id=None,
                 realization_path=None,
                 realized_entity_id=None,
                 realized_entity_type=None,
                 realized_state=None,
                ):
        """
        :type  realization_api: :class:`str` or ``None``
        :param realization_api: Resource realization API path
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: Resource realization id. This can differ from realized_entity_id as
            this can be an external id.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_path: :class:`str` or ``None``
        :param realization_path: The path for the realization of an entity. This can be an URI, etc.
            Some resources are identified by their paths.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realized_entity_id: :class:`str` or ``None``
        :param realized_entity_id: Realized entity id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realized_entity_type: :class:`str` or ``None``
        :param realized_entity_type: Realized entity type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realized_state: :class:`str` or ``None``
        :param realized_state: Possible values are: 
            
            * :attr:`VmcRealizedEntity.REALIZED_STATE_IN_PROGRESS`
            * :attr:`VmcRealizedEntity.REALIZED_STATE_SUCCESS`
            * :attr:`VmcRealizedEntity.REALIZED_STATE_FAILURE`
            * :attr:`VmcRealizedEntity.REALIZED_STATE_UNAVAILABLE`
            * :attr:`VmcRealizedEntity.REALIZED_STATE_PENDING`
            
             Realized state
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.realization_api = realization_api
        self.realization_id = realization_id
        self.realization_path = realization_path
        self.realized_entity_id = realized_entity_id
        self.realized_entity_type = realized_entity_type
        self.realized_state = realized_state
        VapiStruct.__init__(self)


VmcRealizedEntity._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vmc_realized_entity', {
        'realization_api': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'realization_path': type.OptionalType(type.StringType()),
        'realized_entity_id': type.OptionalType(type.StringType()),
        'realized_entity_type': type.OptionalType(type.StringType()),
        'realized_state': type.OptionalType(type.StringType()),
    },
    VmcRealizedEntity,
    False,
    None))



class VpnEndpoint(VapiStruct):
    """
    VPN endpoint information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'interface_label': 'interface_label',
                            'ip': 'ip',
                            'name': 'name',
                            'type': 'type',
                            }

    def __init__(self,
                 interface_label=None,
                 ip=None,
                 name=None,
                 type=None,
                ):
        """
        :type  interface_label: :class:`str` or ``None``
        :param interface_label: Interface label of the VPN endpoint
        :type  ip: :class:`str` or ``None``
        :param ip: IP address of the VPN endpoint format: ipv4
        :type  name: :class:`str` or ``None``
        :param name: Name of the VPN endpoint
        :type  type: :class:`str` or ``None``
        :param type: Type of the VPN endpoint
        """
        self.interface_label = interface_label
        self.ip = ip
        self.name = name
        self.type = type
        VapiStruct.__init__(self)


VpnEndpoint._set_binding_type(type.StructType(
    'com.vmware.nsx_vmc_app.model.vpn_endpoint', {
        'interface_label': type.OptionalType(type.StringType()),
        'ip': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    VpnEndpoint,
    False,
    None))




class StubFactory(StubFactoryBase):
    _attrs = {
    }

