/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class MxtProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_ACK = 2;
    public static final int MSG_NACK = 3;
    public static final int MSG_POSITION = 49;

    public MxtProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static void sendResponse(Channel channel, int device, long id, int crc) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(device);
            response.writeByte(2);
            response.writeIntLE((int)id);
            response.writeShortLE(crc);
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_XMODEM, response.nioBuffer()));
            ByteBuf encoded = Unpooled.buffer();
            encoded.writeByte(1);
            while (response.isReadable()) {
                int b = response.readByte();
                if (b == 1 || b == 4 || b == 16 || b == 17 || b == 19) {
                    encoded.writeByte(16);
                    b += 32;
                }
                encoded.writeByte(b);
            }
            response.release();
            encoded.writeByte(4);
            channel.writeAndFlush((Object)new NetworkMessage(encoded, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        short device = buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        long id = buf.readUnsignedIntLE();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
        if (deviceSession == null) {
            return null;
        }
        if (type == 49) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            buf.readUnsignedByte();
            short infoGroups = buf.readUnsignedByte();
            position.set("index", buf.readUnsignedShortLE());
            DateBuilder dateBuilder = new DateBuilder().setDate(2000, 1, 1);
            long date = buf.readUnsignedIntLE();
            long days = BitUtil.from(date, 17);
            if (days < 5460L) {
                days += 7168L;
            }
            long hours = BitUtil.between(date, 12, 17);
            long minutes = BitUtil.between(date, 6, 12);
            long seconds = BitUtil.to(date, 6);
            dateBuilder.addMillis((((days * 24L + hours) * 60L + minutes) * 60L + seconds) * 1000L);
            position.setTime(dateBuilder.getDate());
            position.setValid(true);
            position.setLatitude((double)buf.readIntLE() / 1000000.0);
            position.setLongitude((double)buf.readIntLE() / 1000000.0);
            long flags = buf.readUnsignedIntLE();
            position.set("ignition", BitUtil.check(flags, 0));
            if (BitUtil.check(flags, 1)) {
                position.set("alarm", "general");
            }
            position.set("input", BitUtil.between(flags, 2, 7));
            position.set("output", BitUtil.between(flags, 7, 10));
            position.setCourse(BitUtil.between(flags, 10, 13) * 45L);
            position.set("charge", BitUtil.check(flags, 20));
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            buf.readUnsignedByte();
            if (BitUtil.check(infoGroups, 0)) {
                buf.skipBytes(8);
            }
            if (BitUtil.check(infoGroups, 1)) {
                buf.skipBytes(8);
            }
            if (BitUtil.check(infoGroups, 2)) {
                position.set("sat", buf.readUnsignedByte());
                position.set("hdop", buf.readUnsignedByte());
                position.setAccuracy(buf.readUnsignedByte());
                position.set("rssi", buf.readUnsignedByte());
                buf.readUnsignedShortLE();
                position.set("power", buf.readUnsignedByte());
                position.set("temp1", buf.readByte());
            }
            if (BitUtil.check(infoGroups, 3)) {
                position.set("odometer", buf.readUnsignedIntLE());
            }
            if (BitUtil.check(infoGroups, 4)) {
                position.set("hours", UnitsConverter.msFromMinutes(buf.readUnsignedIntLE()));
            }
            if (BitUtil.check(infoGroups, 5)) {
                buf.readUnsignedIntLE();
            }
            if (BitUtil.check(infoGroups, 6)) {
                position.set("power", (double)buf.readUnsignedShortLE() * 0.001);
                position.set("battery", buf.readUnsignedShortLE());
            }
            if (BitUtil.check(infoGroups, 7)) {
                position.set("driverUniqueId", String.valueOf(buf.readUnsignedIntLE()));
            }
            buf.readerIndex(buf.writerIndex() - 3);
            MxtProtocolDecoder.sendResponse(channel, device, id, buf.readUnsignedShortLE());
            return position;
        }
        return null;
    }
}

