/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panelsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zaproxy.zap.view.panelsearch.ComponentSearchProvider;
import org.zaproxy.zap.view.panelsearch.FoundComponent;
import org.zaproxy.zap.view.panelsearch.SearchQuery;
import org.zaproxy.zap.view.panelsearch.items.ButtonSearch;
import org.zaproxy.zap.view.panelsearch.items.ComboBoxElementSearch;
import org.zaproxy.zap.view.panelsearch.items.ComboBoxSearch;
import org.zaproxy.zap.view.panelsearch.items.ComponentSearch;
import org.zaproxy.zap.view.panelsearch.items.ContainerSearch;
import org.zaproxy.zap.view.panelsearch.items.JComponentSearch;
import org.zaproxy.zap.view.panelsearch.items.JxLabelSearch;
import org.zaproxy.zap.view.panelsearch.items.LabelSearch;
import org.zaproxy.zap.view.panelsearch.items.SpinnerSearch;
import org.zaproxy.zap.view.panelsearch.items.TabbedPaneElementSearch;
import org.zaproxy.zap.view.panelsearch.items.TabbedPaneSearch;
import org.zaproxy.zap.view.panelsearch.items.TableCellElementSearch;
import org.zaproxy.zap.view.panelsearch.items.TableSearch;
import org.zaproxy.zap.view.panelsearch.items.TextFieldSearch;
import org.zaproxy.zap.view.panelsearch.items.TitledBorderSearch;
import org.zaproxy.zap.view.panelsearch.items.TreeNodeElementSearch;
import org.zaproxy.zap.view.panelsearch.items.TreeSearch;

public class Search {
    public static final List<ComponentSearch> DefaultComponentSearchItems = Arrays.asList(new TreeSearch(), new ButtonSearch(), new TreeNodeElementSearch(), new JxLabelSearch(), new LabelSearch(), new SpinnerSearch(), new TextFieldSearch(), new ComboBoxSearch(), new ComboBoxElementSearch(), new TableSearch(), new TableCellElementSearch(), new TabbedPaneSearch(), new TabbedPaneElementSearch(), new TitledBorderSearch(), new JComponentSearch(), new ContainerSearch());
    private final List<ComponentSearch> componentSearchItems;

    public Search(List<ComponentSearch> componentSearchItems) {
        if (componentSearchItems == null) {
            throw new IllegalArgumentException("componentSearchItems is null");
        }
        this.componentSearchItems = new ArrayList<ComponentSearch>(componentSearchItems);
    }

    public ArrayList<FoundComponent> searchFor(Object component, SearchQuery query) {
        return this.searchFor(new Object[]{component}, query);
    }

    public ArrayList<FoundComponent> searchFor(Object[] components, SearchQuery query) {
        ArrayList<FoundComponent> foundComponents = new ArrayList<FoundComponent>();
        for (Object component : components) {
            for (ComponentSearch componentSearchItem : this.componentSearchItems) {
                if (!componentSearchItem.isResponsible(component)) continue;
                if (componentSearchItem.isSearchMatching(component, query)) {
                    foundComponents.add(new FoundComponent(component));
                }
                Object[] childComponents = componentSearchItem.getComponents(component);
                ArrayList<FoundComponent> foundChildComponents = this.searchFor(childComponents, query);
                for (FoundComponent foundChildComponent : foundChildComponents) {
                    foundChildComponent.addParent(component);
                    foundComponents.add(foundChildComponent);
                }
            }
        }
        return foundComponents;
    }

    public void registerComponentSearch(ComponentSearch componentSearch) {
        this.componentSearchItems.add(0, componentSearch);
    }

    public void registerComponentSearch(ComponentSearchProvider componentSearchProvider) {
        List<ComponentSearch> componentSearches = componentSearchProvider.getComponentSearch();
        if (componentSearches != null) {
            for (ComponentSearch componentSearch : componentSearches) {
                this.registerComponentSearch(componentSearch);
            }
        }
    }

    public void removeComponentSearch(ComponentSearch componentSearch) {
        this.componentSearchItems.remove(componentSearch);
    }

    public void removeComponentSearch(ComponentSearchProvider componentSearchProvider) {
        List<ComponentSearch> componentSearches = componentSearchProvider.getComponentSearch();
        if (componentSearches != null) {
            for (ComponentSearch componentSearch : componentSearches) {
                this.removeComponentSearch(componentSearch);
            }
        }
    }
}

