/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.configuration;

import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.name.Named;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.mybatis.guice.configuration.settings.ConfigurationSetting;
import org.mybatis.guice.configuration.settings.MapperConfigurationSetting;

@Singleton
public class ConfigurationProvider
implements Provider<Configuration> {
    private final Environment environment;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.lazyLoadingEnabled")
    private boolean lazyLoadingEnabled = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.aggressiveLazyLoading")
    private boolean aggressiveLazyLoading = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.multipleResultSetsEnabled")
    private boolean multipleResultSetsEnabled = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.useGeneratedKeys")
    private boolean useGeneratedKeys = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.useColumnLabel")
    private boolean useColumnLabel = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.cacheEnabled")
    private boolean cacheEnabled = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.defaultExecutorType")
    private ExecutorType defaultExecutorType = ExecutorType.SIMPLE;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.autoMappingBehavior")
    private AutoMappingBehavior autoMappingBehavior = AutoMappingBehavior.PARTIAL;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.callSettersOnNulls")
    private boolean callSettersOnNulls = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.defaultStatementTimeout")
    @Nullable
    private Integer defaultStatementTimeout;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.mapUnderscoreToCamelCase")
    private boolean mapUnderscoreToCamelCase = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.failFast")
    private boolean failFast = false;
    @Inject(optional=true)
    private DatabaseIdProvider databaseIdProvider;
    @Inject
    private DataSource dataSource;
    private Set<ConfigurationSetting> configurationSettings = new HashSet<ConfigurationSetting>();
    private Set<MapperConfigurationSetting> mapperConfigurationSettings = new HashSet<MapperConfigurationSetting>();

    @Inject
    public ConfigurationProvider(Environment environment) {
        this.environment = environment;
    }

    @Deprecated
    public void setEnvironment(Environment environment) {
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void addConfigurationSetting(ConfigurationSetting configurationSetting) {
        this.configurationSettings.add(configurationSetting);
    }

    public void addMapperConfigurationSetting(MapperConfigurationSetting mapperConfigurationSetting) {
        this.mapperConfigurationSettings.add(mapperConfigurationSetting);
    }

    protected Configuration newConfiguration(Environment environment) {
        return new Configuration(environment);
    }

    @Override
    public Configuration get() {
        Configuration configuration = this.newConfiguration(this.environment);
        configuration.setLazyLoadingEnabled(this.lazyLoadingEnabled);
        configuration.setAggressiveLazyLoading(this.aggressiveLazyLoading);
        configuration.setMultipleResultSetsEnabled(this.multipleResultSetsEnabled);
        configuration.setUseGeneratedKeys(this.useGeneratedKeys);
        configuration.setUseColumnLabel(this.useColumnLabel);
        configuration.setCacheEnabled(this.cacheEnabled);
        configuration.setDefaultExecutorType(this.defaultExecutorType);
        configuration.setAutoMappingBehavior(this.autoMappingBehavior);
        configuration.setCallSettersOnNulls(this.callSettersOnNulls);
        configuration.setDefaultStatementTimeout(this.defaultStatementTimeout);
        configuration.setMapUnderscoreToCamelCase(this.mapUnderscoreToCamelCase);
        for (ConfigurationSetting configurationSetting : this.configurationSettings) {
            configurationSetting.applyConfigurationSetting(configuration);
        }
        try {
            if (this.databaseIdProvider != null) {
                configuration.setDatabaseId(this.databaseIdProvider.getDatabaseId(this.dataSource));
            }
            for (MapperConfigurationSetting mapperConfigurationSetting : this.mapperConfigurationSettings) {
                mapperConfigurationSetting.applyConfigurationSetting(configuration);
            }
            if (this.failFast) {
                configuration.getMappedStatementNames();
            }
        }
        catch (Throwable cause) {
            throw new ProvisionException("An error occurred while building the org.apache.ibatis.session.Configuration", cause);
        }
        finally {
            ErrorContext.instance().reset();
        }
        return configuration;
    }
}

