/*
  Copyright 1999-2021 ImageMagick Studio LLC, a non-profit organization
  dedicated to making software imaging solutions freely available.
  
  You may not use this file except in compliance with the License.  You may
  obtain a copy of the License at
  
    https://imagemagick.org/script/license.php
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  MagickCore API methods prefix.

  nm -p magick/.libs/libMagickCore-6.Q16.a | grep ' T ' | \
     egrep -v '(MagickError)|(MagickFatalError)|(MagickWarning)|(ThrowException)' | \
    awk '{ printf("#define %s  PrependMagickMethod(%s)\n", $3, $3); }' | sort
*/
#ifndef MAGICKCORE_METHOD_H
#define MAGICKCORE_METHOD_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#if defined(MAGICKCORE_NAMESPACE_PREFIX)

#if defined(__STDC__)
#define PrescanMagickPrefix(prefix,method)  prefix ## method
#else
#define PrescanMagickPrefix(prefix,method)  prefix(method)
#endif
#define EvaluateMagickPrefix(prefix,method)  PrescanMagickPrefix(prefix,method)
#define PrependMagickMethod(method) \
  EvaluateMagickPrefix(MAGICKCORE_NAMESPACE_PREFIX,method)

#define AcquireAlignedMemory  PrependMagickMethod(AcquireAlignedMemory)
#define AcquireAuthenticCacheView  PrependMagickMethod(AcquireAuthenticCacheView)
#define AcquireCacheViewIndexes  PrependMagickMethod(AcquireCacheViewIndexes)
#define AcquireCacheViewPixels  PrependMagickMethod(AcquireCacheViewPixels)
#define AcquireCacheView  PrependMagickMethod(AcquireCacheView)
#define AcquireCriticalMemory  PrependMagickMethod(AcquireCriticalMemory)
#define AcquireDistributeCacheInfo  PrependMagickMethod(AcquireDistributeCacheInfo)
#define AcquireDrawInfo  PrependMagickMethod(AcquireDrawInfo)
#define AcquireExceptionInfo  PrependMagickMethod(AcquireExceptionInfo)
#define AcquireFxInfo  PrependMagickMethod(AcquireFxInfo)
#define AcquireImageColormap  PrependMagickMethod(AcquireImageColormap)
#define AcquireImageInfo  PrependMagickMethod(AcquireImageInfo)
#define AcquireImagePixels  PrependMagickMethod(AcquireImagePixels)
#define AcquireImage  PrependMagickMethod(AcquireImage)
#define AcquireIndexes  PrependMagickMethod(AcquireIndexes)
#define AcquireKernelBuiltIn  PrependMagickMethod(AcquireKernelBuiltIn)
#define AcquireKernelInfo  PrependMagickMethod(AcquireKernelInfo)
#define AcquireMagickMatrix  PrependMagickMethod(AcquireMagickMatrix)
#define AcquireMagickMemory  PrependMagickMethod(AcquireMagickMemory)
#define AcquireMagickResource  PrependMagickMethod(AcquireMagickResource)
#define AcquireMatrixInfo  PrependMagickMethod(AcquireMatrixInfo)
#define AcquireMemory  PrependMagickMethod(AcquireMemory)
#define AcquireNextImage  PrependMagickMethod(AcquireNextImage)
#define AcquireOneCacheViewPixel  PrependMagickMethod(AcquireOneCacheViewPixel)
#define AcquireOneCacheViewVirtualPixel  PrependMagickMethod(AcquireOneCacheViewVirtualPixel)
#define AcquireOneMagickPixel  PrependMagickMethod(AcquireOneMagickPixel)
#define AcquireOnePixel  PrependMagickMethod(AcquireOnePixel)
#define AcquireOneVirtualPixel  PrependMagickMethod(AcquireOneVirtualPixel)
#define AcquirePixelCacheNexus  PrependMagickMethod(AcquirePixelCacheNexus)
#define AcquirePixelCachePixels  PrependMagickMethod(AcquirePixelCachePixels)
#define AcquirePixelCache  PrependMagickMethod(AcquirePixelCache)
#define AcquirePixels  PrependMagickMethod(AcquirePixels)
#define AcquireQuantizeInfo  PrependMagickMethod(AcquireQuantizeInfo)
#define AcquireQuantumInfo  PrependMagickMethod(AcquireQuantumInfo)
#define AcquireQuantumMemory  PrependMagickMethod(AcquireQuantumMemory)
#define AcquireRandomInfo  PrependMagickMethod(AcquireRandomInfo)
#define AcquireResampleFilter  PrependMagickMethod(AcquireResampleFilter)
#define AcquireResizeFilter  PrependMagickMethod(AcquireResizeFilter)
#define AcquireSemaphoreInfo  PrependMagickMethod(AcquireSemaphoreInfo)
#define AcquireSignatureInfo  PrependMagickMethod(AcquireSignatureInfo)
#define AcquireStreamInfo  PrependMagickMethod(AcquireStreamInfo)
#define AcquireStringInfo  PrependMagickMethod(AcquireStringInfo)
#define AcquireString  PrependMagickMethod(AcquireString)
#define AcquireTimerInfo  PrependMagickMethod(AcquireTimerInfo)
#define AcquireTokenInfo  PrependMagickMethod(AcquireTokenInfo)
#define AcquireUniqueFilename  PrependMagickMethod(AcquireUniqueFilename)
#define AcquireUniqueFileResource  PrependMagickMethod(AcquireUniqueFileResource)
#define AcquireUniqueSymbolicLink  PrependMagickMethod(AcquireUniqueSymbolicLink)
#define AcquireVirtualCacheView  PrependMagickMethod(AcquireVirtualCacheView)
#define AcquireVirtualMemory  PrependMagickMethod(AcquireVirtualMemory)
#define ActivateSemaphoreInfo  PrependMagickMethod(ActivateSemaphoreInfo)
#define AdaptiveBlurImageChannel  PrependMagickMethod(AdaptiveBlurImageChannel)
#define AdaptiveBlurImage  PrependMagickMethod(AdaptiveBlurImage)
#define AdaptiveResizeImage  PrependMagickMethod(AdaptiveResizeImage)
#define AdaptiveSharpenImageChannel  PrependMagickMethod(AdaptiveSharpenImageChannel)
#define AdaptiveSharpenImage  PrependMagickMethod(AdaptiveSharpenImage)
#define AdaptiveThresholdImage  PrependMagickMethod(AdaptiveThresholdImage)
#define AddChildToXMLTree  PrependMagickMethod(AddChildToXMLTree)
#define AddNoiseImageChannel  PrependMagickMethod(AddNoiseImageChannel)
#define AddNoiseImage  PrependMagickMethod(AddNoiseImage)
#define AddPathToXMLTree  PrependMagickMethod(AddPathToXMLTree)
#define AddValueToSplayTree  PrependMagickMethod(AddValueToSplayTree)
#define AffineTransformImage  PrependMagickMethod(AffineTransformImage)
#define AffinityImage  PrependMagickMethod(AffinityImage)
#define AffinityImages  PrependMagickMethod(AffinityImages)
#define AllocateImageColormap  PrependMagickMethod(AllocateImageColormap)
#define AllocateImage  PrependMagickMethod(AllocateImage)
#define AllocateNextImage  PrependMagickMethod(AllocateNextImage)
#define AllocateSemaphoreInfo  PrependMagickMethod(AllocateSemaphoreInfo)
#define AllocateString  PrependMagickMethod(AllocateString)
#define analyzeImage  PrependMagickMethod(analyzeImage)
#define AnimateImages  PrependMagickMethod(AnimateImages)
#define AnnotateComponentGenesis  PrependMagickMethod(AnnotateComponentGenesis)
#define AnnotateComponentTerminus  PrependMagickMethod(AnnotateComponentTerminus)
#define AnnotateImage  PrependMagickMethod(AnnotateImage)
#define AppendImageFormat  PrependMagickMethod(AppendImageFormat)
#define AppendImages  PrependMagickMethod(AppendImages)
#define AppendImageToList  PrependMagickMethod(AppendImageToList)
#define AppendValueToLinkedList  PrependMagickMethod(AppendValueToLinkedList)
#define Ascii85Encode  PrependMagickMethod(Ascii85Encode)
#define Ascii85Flush  PrependMagickMethod(Ascii85Flush)
#define Ascii85Initialize  PrependMagickMethod(Ascii85Initialize)
#define AsynchronousResourceComponentTerminus  PrependMagickMethod(AsynchronousResourceComponentTerminus)
#define AttachBlob  PrependMagickMethod(AttachBlob)
#define AutoGammaImageChannel  PrependMagickMethod(AutoGammaImageChannel)
#define AutoGammaImage  PrependMagickMethod(AutoGammaImage)
#define AutoLevelImageChannel  PrependMagickMethod(AutoLevelImageChannel)
#define AutoLevelImage  PrependMagickMethod(AutoLevelImage)
#define AutoOrientImage  PrependMagickMethod(AutoOrientImage)
#define AutoThresholdImage  PrependMagickMethod(AutoThresholdImage)
#define AverageImages  PrependMagickMethod(AverageImages)
#define Base64Decode  PrependMagickMethod(Base64Decode)
#define Base64Encode  PrependMagickMethod(Base64Encode)
#define BilevelImageChannel  PrependMagickMethod(BilevelImageChannel)
#define BilevelImage  PrependMagickMethod(BilevelImage)
#define BlackThresholdImageChannel  PrependMagickMethod(BlackThresholdImageChannel)
#define BlackThresholdImage  PrependMagickMethod(BlackThresholdImage)
#define BlobToFile  PrependMagickMethod(BlobToFile)
#define BlobToImage  PrependMagickMethod(BlobToImage)
#define BlobToStringInfo  PrependMagickMethod(BlobToStringInfo)
#define BlueShiftImage  PrependMagickMethod(BlueShiftImage)
#define BlurImageChannel  PrependMagickMethod(BlurImageChannel)
#define BlurImage  PrependMagickMethod(BlurImage)
#define BorderImage  PrependMagickMethod(BorderImage)
#define BrightnessContrastImageChannel  PrependMagickMethod(BrightnessContrastImageChannel)
#define BrightnessContrastImage  PrependMagickMethod(BrightnessContrastImage)
#define CacheComponentGenesis  PrependMagickMethod(CacheComponentGenesis)
#define CacheComponentTerminus  PrependMagickMethod(CacheComponentTerminus)
#define CannyEdgeImage  PrependMagickMethod(CannyEdgeImage)
#define CanonicalXMLContent  PrependMagickMethod(CanonicalXMLContent)
#define CatchException  PrependMagickMethod(CatchException)
#define CatchImageException  PrependMagickMethod(CatchImageException)
#define ChannelImage  PrependMagickMethod(ChannelImage)
#define ChannelThresholdImage  PrependMagickMethod(ChannelThresholdImage)
#define CharcoalImage  PrependMagickMethod(CharcoalImage)
#define ChopImage  PrependMagickMethod(ChopImage)
#define ChopPathComponents  PrependMagickMethod(ChopPathComponents)
#define ClampImageChannel  PrependMagickMethod(ClampImageChannel)
#define ClampImage  PrependMagickMethod(ClampImage)
#define ClearExceptionInfo  PrependMagickMethod(ClearExceptionInfo)
#define ClearLinkedList  PrependMagickMethod(ClearLinkedList)
#define ClearMagickException  PrependMagickMethod(ClearMagickException)
#define ClipImagePath  PrependMagickMethod(ClipImagePath)
#define ClipImage  PrependMagickMethod(ClipImage)
#define ClipPathImage  PrependMagickMethod(ClipPathImage)
#define CloneBlobInfo  PrependMagickMethod(CloneBlobInfo)
#define CloneCacheView  PrependMagickMethod(CloneCacheView)
#define CloneDrawInfo  PrependMagickMethod(CloneDrawInfo)
#define CloneExceptionInfo  PrependMagickMethod(CloneExceptionInfo)
#define CloneImageArtifacts  PrependMagickMethod(CloneImageArtifacts)
#define CloneImageAttributes  PrependMagickMethod(CloneImageAttributes)
#define CloneImageInfo  PrependMagickMethod(CloneImageInfo)
#define CloneImageList  PrependMagickMethod(CloneImageList)
#define CloneImageOptions  PrependMagickMethod(CloneImageOptions)
#define CloneImage  PrependMagickMethod(CloneImage)
#define CloneImageProfiles  PrependMagickMethod(CloneImageProfiles)
#define CloneImageProperties  PrependMagickMethod(CloneImageProperties)
#define CloneImages  PrependMagickMethod(CloneImages)
#define CloneImageView  PrependMagickMethod(CloneImageView)
#define CloneKernelInfo  PrependMagickMethod(CloneKernelInfo)
#define CloneMagickPixelPacket  PrependMagickMethod(CloneMagickPixelPacket)
#define CloneMemory  PrependMagickMethod(CloneMemory)
#define CloneMontageInfo  PrependMagickMethod(CloneMontageInfo)
#define ClonePixelCacheMethods  PrependMagickMethod(ClonePixelCacheMethods)
#define ClonePixelCache  PrependMagickMethod(ClonePixelCache)
#define CloneQuantizeInfo  PrependMagickMethod(CloneQuantizeInfo)
#define CloneSplayTree  PrependMagickMethod(CloneSplayTree)
#define CloneStringInfo  PrependMagickMethod(CloneStringInfo)
#define CloneString  PrependMagickMethod(CloneString)
#define CloseBlob  PrependMagickMethod(CloseBlob)
#define CloseCacheView  PrependMagickMethod(CloseCacheView)
#define CloseMagickLog  PrependMagickMethod(CloseMagickLog)
#define ClutImageChannel  PrependMagickMethod(ClutImageChannel)
#define ClutImage  PrependMagickMethod(ClutImage)
#define CoalesceImages  PrependMagickMethod(CoalesceImages)
#define CoderComponentGenesis  PrependMagickMethod(CoderComponentGenesis)
#define CoderComponentTerminus  PrependMagickMethod(CoderComponentTerminus)
#define ColorComponentGenesis  PrependMagickMethod(ColorComponentGenesis)
#define ColorComponentTerminus  PrependMagickMethod(ColorComponentTerminus)
#define ColorDecisionListImage  PrependMagickMethod(ColorDecisionListImage)
#define ColorFloodfillImage  PrependMagickMethod(ColorFloodfillImage)
#define ColorizeImage  PrependMagickMethod(ColorizeImage)
#define ColorMatrixImage  PrependMagickMethod(ColorMatrixImage)
#define CombineImages  PrependMagickMethod(CombineImages)
#define CommandOptionToMnemonic  PrependMagickMethod(CommandOptionToMnemonic)
#define CompareHashmapStringInfo  PrependMagickMethod(CompareHashmapStringInfo)
#define CompareHashmapString  PrependMagickMethod(CompareHashmapString)
#define CompareImageChannels  PrependMagickMethod(CompareImageChannels)
#define CompareImageLayers  PrependMagickMethod(CompareImageLayers)
#define CompareImages  PrependMagickMethod(CompareImages)
#define CompareSplayTreeStringInfo  PrependMagickMethod(CompareSplayTreeStringInfo)
#define CompareSplayTreeString  PrependMagickMethod(CompareSplayTreeString)
#define CompareStringInfo  PrependMagickMethod(CompareStringInfo)
#define ComplexImages  PrependMagickMethod(ComplexImages)
#define CompositeImageChannel  PrependMagickMethod(CompositeImageChannel)
#define CompositeImage  PrependMagickMethod(CompositeImage)
#define CompositeLayers  PrependMagickMethod(CompositeLayers)
#define CompressImageColormap  PrependMagickMethod(CompressImageColormap)
#define ConcatenateColorComponent  PrependMagickMethod(ConcatenateColorComponent)
#define ConcatenateMagickString  PrependMagickMethod(ConcatenateMagickString)
#define ConcatenateStringInfo  PrependMagickMethod(ConcatenateStringInfo)
#define ConcatenateString  PrependMagickMethod(ConcatenateString)
#define ConfigureComponentGenesis  PrependMagickMethod(ConfigureComponentGenesis)
#define ConfigureComponentTerminus  PrependMagickMethod(ConfigureComponentTerminus)
#define ConfigureFileToStringInfo  PrependMagickMethod(ConfigureFileToStringInfo)
#define ConformMagickPixelPacket  PrependMagickMethod(ConformMagickPixelPacket)
#define ConnectedComponentsImage  PrependMagickMethod(ConnectedComponentsImage)
#define ConsolidateCMYKImages  PrependMagickMethod(ConsolidateCMYKImages)
#define ConstantString  PrependMagickMethod(ConstantString)
#define ConstituteComponentGenesis  PrependMagickMethod(ConstituteComponentGenesis)
#define ConstituteComponentTerminus  PrependMagickMethod(ConstituteComponentTerminus)
#define ConstituteImage  PrependMagickMethod(ConstituteImage)
#define ContinueTimer  PrependMagickMethod(ContinueTimer)
#define ContrastImage  PrependMagickMethod(ContrastImage)
#define ContrastStretchImageChannel  PrependMagickMethod(ContrastStretchImageChannel)
#define ContrastStretchImage  PrependMagickMethod(ContrastStretchImage)
#define ConvertHCLpToRGB  PrependMagickMethod(ConvertHCLpToRGB)
#define ConvertHCLToRGB  PrependMagickMethod(ConvertHCLToRGB)
#define ConvertHSBToRGB  PrependMagickMethod(ConvertHSBToRGB)
#define ConvertHSIToRGB  PrependMagickMethod(ConvertHSIToRGB)
#define ConvertHSLToRGB  PrependMagickMethod(ConvertHSLToRGB)
#define ConvertHSVToRGB  PrependMagickMethod(ConvertHSVToRGB)
#define ConvertHWBToRGB  PrependMagickMethod(ConvertHWBToRGB)
#define ConvertLCHabToRGB  PrependMagickMethod(ConvertLCHabToRGB)
#define ConvertLCHuvToRGB  PrependMagickMethod(ConvertLCHuvToRGB)
#define ConvertRGBToHCLp  PrependMagickMethod(ConvertRGBToHCLp)
#define ConvertRGBToHCL  PrependMagickMethod(ConvertRGBToHCL)
#define ConvertRGBToHSB  PrependMagickMethod(ConvertRGBToHSB)
#define ConvertRGBToHSI  PrependMagickMethod(ConvertRGBToHSI)
#define ConvertRGBToHSL  PrependMagickMethod(ConvertRGBToHSL)
#define ConvertRGBToHSV  PrependMagickMethod(ConvertRGBToHSV)
#define ConvertRGBToHWB  PrependMagickMethod(ConvertRGBToHWB)
#define ConvertRGBToLCHab  PrependMagickMethod(ConvertRGBToLCHab)
#define ConvertRGBToLCHuv  PrependMagickMethod(ConvertRGBToLCHuv)
#define ConvolveImageChannel  PrependMagickMethod(ConvolveImageChannel)
#define ConvolveImage  PrependMagickMethod(ConvolveImage)
#define CopyImagePixels  PrependMagickMethod(CopyImagePixels)
#define CopyMagickMemory  PrependMagickMethod(CopyMagickMemory)
#define CopyMagickString  PrependMagickMethod(CopyMagickString)
#define CreateMagickThreadKey  PrependMagickMethod(CreateMagickThreadKey)
#define CropImage  PrependMagickMethod(CropImage)
#define CropImageToTiles  PrependMagickMethod(CropImageToTiles)
#define CycleColormapImage  PrependMagickMethod(CycleColormapImage)
#define DecipherImage  PrependMagickMethod(DecipherImage)
#define DecodePixelGamma  PrependMagickMethod(DecodePixelGamma)
#define DeconstructImages  PrependMagickMethod(DeconstructImages)
#define DefineImageArtifact  PrependMagickMethod(DefineImageArtifact)
#define DefineImageOption  PrependMagickMethod(DefineImageOption)
#define DefineImageProperty  PrependMagickMethod(DefineImageProperty)
#define DefineImageRegistry  PrependMagickMethod(DefineImageRegistry)
#define DelegateComponentGenesis  PrependMagickMethod(DelegateComponentGenesis)
#define DelegateComponentTerminus  PrependMagickMethod(DelegateComponentTerminus)
#define DeleteImageArtifact  PrependMagickMethod(DeleteImageArtifact)
#define DeleteImageAttribute  PrependMagickMethod(DeleteImageAttribute)
#define DeleteImageFromList  PrependMagickMethod(DeleteImageFromList)
#define DeleteImageList  PrependMagickMethod(DeleteImageList)
#define DeleteImageOption  PrependMagickMethod(DeleteImageOption)
#define DeleteImageProfile  PrependMagickMethod(DeleteImageProfile)
#define DeleteImageProperty  PrependMagickMethod(DeleteImageProperty)
#define DeleteImageRegistry  PrependMagickMethod(DeleteImageRegistry)
#define DeleteImages  PrependMagickMethod(DeleteImages)
#define DeleteMagickRegistry  PrependMagickMethod(DeleteMagickRegistry)
#define DeleteMagickThreadKey  PrependMagickMethod(DeleteMagickThreadKey)
#define DeleteNodeByValueFromSplayTree  PrependMagickMethod(DeleteNodeByValueFromSplayTree)
#define DeleteNodeFromSplayTree  PrependMagickMethod(DeleteNodeFromSplayTree)
#define DescribeImage  PrependMagickMethod(DescribeImage)
#define DeskewImage  PrependMagickMethod(DeskewImage)
#define DespeckleImage  PrependMagickMethod(DespeckleImage)
#define DestroyBlob  PrependMagickMethod(DestroyBlob)
#define DestroyCacheView  PrependMagickMethod(DestroyCacheView)
#define DestroyConfigureOptions  PrependMagickMethod(DestroyConfigureOptions)
#define DestroyConstitute  PrependMagickMethod(DestroyConstitute)
#define DestroyDistributeCacheInfo  PrependMagickMethod(DestroyDistributeCacheInfo)
#define DestroyDrawInfo  PrependMagickMethod(DestroyDrawInfo)
#define DestroyExceptionInfo  PrependMagickMethod(DestroyExceptionInfo)
#define DestroyFxInfo  PrependMagickMethod(DestroyFxInfo)
#define DestroyHashmap  PrependMagickMethod(DestroyHashmap)
#define DestroyImageArtifacts  PrependMagickMethod(DestroyImageArtifacts)
#define DestroyImageAttributes  PrependMagickMethod(DestroyImageAttributes)
#define DestroyImageInfo  PrependMagickMethod(DestroyImageInfo)
#define DestroyImageList  PrependMagickMethod(DestroyImageList)
#define DestroyImageOptions  PrependMagickMethod(DestroyImageOptions)
#define DestroyImagePixels  PrependMagickMethod(DestroyImagePixels)
#define DestroyImage  PrependMagickMethod(DestroyImage)
#define DestroyImageProfiles  PrependMagickMethod(DestroyImageProfiles)
#define DestroyImageProperties  PrependMagickMethod(DestroyImageProperties)
#define DestroyImages  PrependMagickMethod(DestroyImages)
#define DestroyImageView  PrependMagickMethod(DestroyImageView)
#define DestroyKernelInfo  PrependMagickMethod(DestroyKernelInfo)
#define DestroyLinkedList  PrependMagickMethod(DestroyLinkedList)
#define DestroyLocaleOptions  PrependMagickMethod(DestroyLocaleOptions)
#define DestroyMagickMemory  PrependMagickMethod(DestroyMagickMemory)
#define DestroyMagick  PrependMagickMethod(DestroyMagick)
#define DestroyMagickRegistry  PrependMagickMethod(DestroyMagickRegistry)
#define DestroyMatrixInfo  PrependMagickMethod(DestroyMatrixInfo)
#define DestroyMontageInfo  PrependMagickMethod(DestroyMontageInfo)
#define DestroyPixelCacheNexus  PrependMagickMethod(DestroyPixelCacheNexus)
#define DestroyPixelCache  PrependMagickMethod(DestroyPixelCache)
#define DestroyQuantizeInfo  PrependMagickMethod(DestroyQuantizeInfo)
#define DestroyQuantumInfo  PrependMagickMethod(DestroyQuantumInfo)
#define DestroyRandomInfo  PrependMagickMethod(DestroyRandomInfo)
#define DestroyResampleFilter  PrependMagickMethod(DestroyResampleFilter)
#define DestroyResizeFilter  PrependMagickMethod(DestroyResizeFilter)
#define DestroySemaphoreInfo  PrependMagickMethod(DestroySemaphoreInfo)
#define DestroySignatureInfo  PrependMagickMethod(DestroySignatureInfo)
#define DestroySplayTree  PrependMagickMethod(DestroySplayTree)
#define DestroyStreamInfo  PrependMagickMethod(DestroyStreamInfo)
#define DestroyStringInfo  PrependMagickMethod(DestroyStringInfo)
#define DestroyStringList  PrependMagickMethod(DestroyStringList)
#define DestroyString  PrependMagickMethod(DestroyString)
#define DestroyThresholdMap  PrependMagickMethod(DestroyThresholdMap)
#define DestroyTimerInfo  PrependMagickMethod(DestroyTimerInfo)
#define DestroyTokenInfo  PrependMagickMethod(DestroyTokenInfo)
#define DestroyXMLTree  PrependMagickMethod(DestroyXMLTree)
#define DestroyXResources  PrependMagickMethod(DestroyXResources)
#define DestroyXWidget  PrependMagickMethod(DestroyXWidget)
#define DetachBlob  PrependMagickMethod(DetachBlob)
#define DisassociateBlob  PrependMagickMethod(DisassociateBlob)
#define DisassociateImageStream  PrependMagickMethod(DisassociateImageStream)
#define DiscardBlobBytes  PrependMagickMethod(DiscardBlobBytes)
#define DispatchImage  PrependMagickMethod(DispatchImage)
#define DisplayImages  PrependMagickMethod(DisplayImages)
#define DisposeImages  PrependMagickMethod(DisposeImages)
#define DistortImage  PrependMagickMethod(DistortImage)
#define DistortResizeImage  PrependMagickMethod(DistortResizeImage)
#define DistributePixelCacheServer  PrependMagickMethod(DistributePixelCacheServer)
#define DrawAffineImage  PrependMagickMethod(DrawAffineImage)
#define DrawClipPath  PrependMagickMethod(DrawClipPath)
#define DrawGradientImage  PrependMagickMethod(DrawGradientImage)
#define DrawImage  PrependMagickMethod(DrawImage)
#define DrawPatternPath  PrependMagickMethod(DrawPatternPath)
#define DrawPrimitive  PrependMagickMethod(DrawPrimitive)
#define DuplexTransferImageViewIterator  PrependMagickMethod(DuplexTransferImageViewIterator)
#define DuplicateBlob  PrependMagickMethod(DuplicateBlob)
#define DuplicateImages  PrependMagickMethod(DuplicateImages)
#define EdgeImage  PrependMagickMethod(EdgeImage)
#define EmbossImage  PrependMagickMethod(EmbossImage)
#define EncipherImage  PrependMagickMethod(EncipherImage)
#define EncodePixelGamma  PrependMagickMethod(EncodePixelGamma)
#define EnhanceImage  PrependMagickMethod(EnhanceImage)
#define EOFBlob  PrependMagickMethod(EOFBlob)
#define EqualizeImageChannel  PrependMagickMethod(EqualizeImageChannel)
#define EqualizeImage  PrependMagickMethod(EqualizeImage)
#define ErrorBlob  PrependMagickMethod(ErrorBlob)
#define EscapeString  PrependMagickMethod(EscapeString)
#define EvaluateImageChannel  PrependMagickMethod(EvaluateImageChannel)
#define EvaluateImage  PrependMagickMethod(EvaluateImage)
#define EvaluateImages  PrependMagickMethod(EvaluateImages)
#define ExceptionComponentGenesis  PrependMagickMethod(ExceptionComponentGenesis)
#define ExceptionComponentTerminus  PrependMagickMethod(ExceptionComponentTerminus)
#define ExcerptImage  PrependMagickMethod(ExcerptImage)
#define ExpandAffine  PrependMagickMethod(ExpandAffine)
#define ExpandFilename  PrependMagickMethod(ExpandFilename)
#define ExpandFilenames  PrependMagickMethod(ExpandFilenames)
#define ExportImagePixels  PrependMagickMethod(ExportImagePixels)
#define ExportQuantumPixels  PrependMagickMethod(ExportQuantumPixels)
#define ExtentImage  PrependMagickMethod(ExtentImage)
#define ExternalDelegateCommand  PrependMagickMethod(ExternalDelegateCommand)
#define ExtractSubimageFromImage  PrependMagickMethod(ExtractSubimageFromImage)
#define FileToBlob  PrependMagickMethod(FileToBlob)
#define FileToImage  PrependMagickMethod(FileToImage)
#define FileToStringInfo  PrependMagickMethod(FileToStringInfo)
#define FileToString  PrependMagickMethod(FileToString)
#define FileToXML  PrependMagickMethod(FileToXML)
#define FilterImageChannel  PrependMagickMethod(FilterImageChannel)
#define FilterImage  PrependMagickMethod(FilterImage)
#define FinalizeSignature  PrependMagickMethod(FinalizeSignature)
#define FlattenImages  PrependMagickMethod(FlattenImages)
#define FlipImage  PrependMagickMethod(FlipImage)
#define FloodfillPaintImage  PrependMagickMethod(FloodfillPaintImage)
#define FlopImage  PrependMagickMethod(FlopImage)
#define FormatImageAttributeList  PrependMagickMethod(FormatImageAttributeList)
#define FormatImageAttribute  PrependMagickMethod(FormatImageAttribute)
#define FormatImagePropertyList  PrependMagickMethod(FormatImagePropertyList)
#define FormatImageProperty  PrependMagickMethod(FormatImageProperty)
#define FormatLocaleFileList  PrependMagickMethod(FormatLocaleFileList)
#define FormatLocaleFile  PrependMagickMethod(FormatLocaleFile)
#define FormatLocaleStringList  PrependMagickMethod(FormatLocaleStringList)
#define FormatLocaleString  PrependMagickMethod(FormatLocaleString)
#define FormatMagickCaption  PrependMagickMethod(FormatMagickCaption)
#define FormatMagickSize  PrependMagickMethod(FormatMagickSize)
#define FormatMagickStringList  PrependMagickMethod(FormatMagickStringList)
#define FormatMagickString  PrependMagickMethod(FormatMagickString)
#define FormatMagickTime  PrependMagickMethod(FormatMagickTime)
#define FormatStringList  PrependMagickMethod(FormatStringList)
#define FormatString  PrependMagickMethod(FormatString)
#define ForwardFourierTransformImage  PrependMagickMethod(ForwardFourierTransformImage)
#define FrameImage  PrependMagickMethod(FrameImage)
#define FunctionImageChannel  PrependMagickMethod(FunctionImageChannel)
#define FunctionImage  PrependMagickMethod(FunctionImage)
#define FuzzyColorCompare  PrependMagickMethod(FuzzyColorCompare)
#define FuzzyColorMatch  PrependMagickMethod(FuzzyColorMatch)
#define FuzzyOpacityCompare  PrependMagickMethod(FuzzyOpacityCompare)
#define FxEvaluateChannelExpression  PrependMagickMethod(FxEvaluateChannelExpression)
#define FxEvaluateExpression  PrependMagickMethod(FxEvaluateExpression)
#define FxImageChannel  PrependMagickMethod(FxImageChannel)
#define FxImage  PrependMagickMethod(FxImage)
#define FxPreprocessExpression  PrependMagickMethod(FxPreprocessExpression)
#define GammaImageChannel  PrependMagickMethod(GammaImageChannel)
#define GammaImage  PrependMagickMethod(GammaImage)
#define GaussianBlurImageChannel  PrependMagickMethod(GaussianBlurImageChannel)
#define GaussianBlurImage  PrependMagickMethod(GaussianBlurImage)
#define GaussJordanElimination  PrependMagickMethod(GaussJordanElimination)
#define GenerateDifferentialNoise  PrependMagickMethod(GenerateDifferentialNoise)
#define GetAffineMatrix  PrependMagickMethod(GetAffineMatrix)
#define GetAuthenticIndexQueue  PrependMagickMethod(GetAuthenticIndexQueue)
#define GetAuthenticPixelCacheNexus  PrependMagickMethod(GetAuthenticPixelCacheNexus)
#define GetAuthenticPixelQueue  PrependMagickMethod(GetAuthenticPixelQueue)
#define GetAuthenticPixels  PrependMagickMethod(GetAuthenticPixels)
#define GetBlobError  PrependMagickMethod(GetBlobError)
#define GetBlobFileHandle  PrependMagickMethod(GetBlobFileHandle)
#define GetBlobInfo  PrependMagickMethod(GetBlobInfo)
#define GetBlobProperties  PrependMagickMethod(GetBlobProperties)
#define GetBlobSize  PrependMagickMethod(GetBlobSize)
#define GetBlobStreamData  PrependMagickMethod(GetBlobStreamData)
#define GetBlobStreamHandler  PrependMagickMethod(GetBlobStreamHandler)
#define GetCacheViewAuthenticIndexQueue  PrependMagickMethod(GetCacheViewAuthenticIndexQueue)
#define GetCacheViewAuthenticPixelQueue  PrependMagickMethod(GetCacheViewAuthenticPixelQueue)
#define GetCacheViewAuthenticPixels  PrependMagickMethod(GetCacheViewAuthenticPixels)
#define GetCacheViewChannels  PrependMagickMethod(GetCacheViewChannels)
#define GetCacheViewColorspace  PrependMagickMethod(GetCacheViewColorspace)
#define GetCacheViewException  PrependMagickMethod(GetCacheViewException)
#define GetCacheViewExtent  PrependMagickMethod(GetCacheViewExtent)
#define GetCacheViewIndexes  PrependMagickMethod(GetCacheViewIndexes)
#define GetCacheViewPixels  PrependMagickMethod(GetCacheViewPixels)
#define GetCacheView  PrependMagickMethod(GetCacheView)
#define GetCacheViewStorageClass  PrependMagickMethod(GetCacheViewStorageClass)
#define GetCacheViewVirtualIndexQueue  PrependMagickMethod(GetCacheViewVirtualIndexQueue)
#define GetCacheViewVirtualPixelQueue  PrependMagickMethod(GetCacheViewVirtualPixelQueue)
#define GetCacheViewVirtualPixels  PrependMagickMethod(GetCacheViewVirtualPixels)
#define GetClientName  PrependMagickMethod(GetClientName)
#define GetClientPath  PrependMagickMethod(GetClientPath)
#define GetCoderInfoList  PrependMagickMethod(GetCoderInfoList)
#define GetCoderInfo  PrependMagickMethod(GetCoderInfo)
#define GetCoderList  PrependMagickMethod(GetCoderList)
#define GetColorCompliance  PrependMagickMethod(GetColorCompliance)
#define GetColorInfoList  PrependMagickMethod(GetColorInfoList)
#define GetColorInfo  PrependMagickMethod(GetColorInfo)
#define GetColorList  PrependMagickMethod(GetColorList)
#define GetColorTuple  PrependMagickMethod(GetColorTuple)
#define GetCommandOptionFlags  PrependMagickMethod(GetCommandOptionFlags)
#define GetCommandOptions  PrependMagickMethod(GetCommandOptions)
#define GetConfigureBlob  PrependMagickMethod(GetConfigureBlob)
#define GetConfigureInfoList  PrependMagickMethod(GetConfigureInfoList)
#define GetConfigureInfo  PrependMagickMethod(GetConfigureInfo)
#define GetConfigureList  PrependMagickMethod(GetConfigureList)
#define GetConfigureOption  PrependMagickMethod(GetConfigureOption)
#define GetConfigureOptions  PrependMagickMethod(GetConfigureOptions)
#define GetConfigurePaths  PrependMagickMethod(GetConfigurePaths)
#define GetConfigureValue  PrependMagickMethod(GetConfigureValue)
#define GetDefaultOpenCLEnv  PrependMagickMethod(GetDefaultOpenCLEnv)
#define GetDelegateCommand  PrependMagickMethod(GetDelegateCommand)
#define GetDelegateCommands  PrependMagickMethod(GetDelegateCommands)
#define GetDelegateInfoList  PrependMagickMethod(GetDelegateInfoList)
#define GetDelegateInfo  PrependMagickMethod(GetDelegateInfo)
#define GetDelegateList  PrependMagickMethod(GetDelegateList)
#define GetDelegateMode  PrependMagickMethod(GetDelegateMode)
#define GetDelegateThreadSupport  PrependMagickMethod(GetDelegateThreadSupport)
#define GetDistributeCacheFile  PrependMagickMethod(GetDistributeCacheFile)
#define GetDistributeCacheHostname  PrependMagickMethod(GetDistributeCacheHostname)
#define GetDistributeCachePort  PrependMagickMethod(GetDistributeCachePort)
#define GetDrawInfo  PrependMagickMethod(GetDrawInfo)
#define GetElapsedTime  PrependMagickMethod(GetElapsedTime)
#define GetEnvironmentValue  PrependMagickMethod(GetEnvironmentValue)
#define GetExceptionInfo  PrependMagickMethod(GetExceptionInfo)
#define GetExceptionMessage  PrependMagickMethod(GetExceptionMessage)
#define GetExecutionPath  PrependMagickMethod(GetExecutionPath)
#define GetFirstImageInList  PrependMagickMethod(GetFirstImageInList)
#define GetGeometry  PrependMagickMethod(GetGeometry)
#define GetImageAlphaChannel  PrependMagickMethod(GetImageAlphaChannel)
#define GetImageArtifact  PrependMagickMethod(GetImageArtifact)
#define GetImageAttribute  PrependMagickMethod(GetImageAttribute)
#define GetImageBoundingBox  PrependMagickMethod(GetImageBoundingBox)
#define GetImageChannelDepth  PrependMagickMethod(GetImageChannelDepth)
#define GetImageChannelDistortion  PrependMagickMethod(GetImageChannelDistortion)
#define GetImageChannelDistortions  PrependMagickMethod(GetImageChannelDistortions)
#define GetImageChannelEntropy  PrependMagickMethod(GetImageChannelEntropy)
#define GetImageChannelExtrema  PrependMagickMethod(GetImageChannelExtrema)
#define GetImageChannelFeatures  PrependMagickMethod(GetImageChannelFeatures)
#define GetImageChannelKurtosis  PrependMagickMethod(GetImageChannelKurtosis)
#define GetImageChannelMean  PrependMagickMethod(GetImageChannelMean)
#define GetImageChannelMoments  PrependMagickMethod(GetImageChannelMoments)
#define GetImageChannelPerceptualHash  PrependMagickMethod(GetImageChannelPerceptualHash)
#define GetImageChannelRange  PrependMagickMethod(GetImageChannelRange)
#define GetImageChannels  PrependMagickMethod(GetImageChannels)
#define GetImageChannelStatistics  PrependMagickMethod(GetImageChannelStatistics)
#define GetImageClipMask  PrependMagickMethod(GetImageClipMask)
#define GetImageClippingPathAttribute  PrependMagickMethod(GetImageClippingPathAttribute)
#define GetImageColorspaceType  PrependMagickMethod(GetImageColorspaceType)
#define GetImageDecoder  PrependMagickMethod(GetImageDecoder)
#define GetImageDepth  PrependMagickMethod(GetImageDepth)
#define GetImageDistortion  PrependMagickMethod(GetImageDistortion)
#define GetImageDynamicThreshold  PrependMagickMethod(GetImageDynamicThreshold)
#define GetImageEncoder  PrependMagickMethod(GetImageEncoder)
#define GetImageEntropy  PrependMagickMethod(GetImageEntropy)
#define GetImageException  PrependMagickMethod(GetImageException)
#define GetImageExtent  PrependMagickMethod(GetImageExtent)
#define GetImageExtrema  PrependMagickMethod(GetImageExtrema)
#define GetImageFromList  PrependMagickMethod(GetImageFromList)
#define GetImageFromMagickRegistry  PrependMagickMethod(GetImageFromMagickRegistry)
#define GetImageGeometry  PrependMagickMethod(GetImageGeometry)
#define GetImageHistogram  PrependMagickMethod(GetImageHistogram)
#define GetImageIndexInList  PrependMagickMethod(GetImageIndexInList)
#define GetImageInfoFile  PrependMagickMethod(GetImageInfoFile)
#define GetImageInfo  PrependMagickMethod(GetImageInfo)
#define GetImageKurtosis  PrependMagickMethod(GetImageKurtosis)
#define GetImageListIndex  PrependMagickMethod(GetImageListIndex)
#define GetImageListLength  PrependMagickMethod(GetImageListLength)
#define GetImageList  PrependMagickMethod(GetImageList)
#define GetImageListSize  PrependMagickMethod(GetImageListSize)
#define GetImageMagick  PrependMagickMethod(GetImageMagick)
#define GetImageMask  PrependMagickMethod(GetImageMask)
#define GetImageMean  PrependMagickMethod(GetImageMean)
#define GetImageOption  PrependMagickMethod(GetImageOption)
#define GetImagePixelCacheType  PrependMagickMethod(GetImagePixelCacheType)
#define GetImagePixels  PrependMagickMethod(GetImagePixels)
#define GetImageProfile  PrependMagickMethod(GetImageProfile)
#define GetImageProperty  PrependMagickMethod(GetImageProperty)
#define GetImageQuantizeError  PrependMagickMethod(GetImageQuantizeError)
#define GetImageQuantumDepth  PrependMagickMethod(GetImageQuantumDepth)
#define GetImageRange  PrependMagickMethod(GetImageRange)
#define GetImageReferenceCount  PrependMagickMethod(GetImageReferenceCount)
#define GetImageRegistry  PrependMagickMethod(GetImageRegistry)
#define GetImageTotalInkDensity  PrependMagickMethod(GetImageTotalInkDensity)
#define GetImageType  PrependMagickMethod(GetImageType)
#define GetImageViewAuthenticIndexes  PrependMagickMethod(GetImageViewAuthenticIndexes)
#define GetImageViewAuthenticPixels  PrependMagickMethod(GetImageViewAuthenticPixels)
#define GetImageViewException  PrependMagickMethod(GetImageViewException)
#define GetImageViewExtent  PrependMagickMethod(GetImageViewExtent)
#define GetImageViewImage  PrependMagickMethod(GetImageViewImage)
#define GetImageViewIterator  PrependMagickMethod(GetImageViewIterator)
#define GetImageViewVirtualIndexes  PrependMagickMethod(GetImageViewVirtualIndexes)
#define GetImageViewVirtualPixels  PrependMagickMethod(GetImageViewVirtualPixels)
#define GetImageVirtualPixelMethod  PrependMagickMethod(GetImageVirtualPixelMethod)
#define GetIndexes  PrependMagickMethod(GetIndexes)
#define GetLastImageInList  PrependMagickMethod(GetLastImageInList)
#define GetLastValueInLinkedList  PrependMagickMethod(GetLastValueInLinkedList)
#define GetLocaleExceptionMessage  PrependMagickMethod(GetLocaleExceptionMessage)
#define GetLocaleInfoList  PrependMagickMethod(GetLocaleInfoList)
#define GetLocaleInfo_  PrependMagickMethod(GetLocaleInfo_)
#define GetLocaleList  PrependMagickMethod(GetLocaleList)
#define GetLocaleMessage  PrependMagickMethod(GetLocaleMessage)
#define GetLocaleOptions  PrependMagickMethod(GetLocaleOptions)
#define GetLocaleValue  PrependMagickMethod(GetLocaleValue)
#define GetLogInfoList  PrependMagickMethod(GetLogInfoList)
#define GetLogList  PrependMagickMethod(GetLogList)
#define GetLogName  PrependMagickMethod(GetLogName)
#define GetMagicInfoList  PrependMagickMethod(GetMagicInfoList)
#define GetMagicInfo  PrependMagickMethod(GetMagicInfo)
#define GetMagickAdjoin  PrependMagickMethod(GetMagickAdjoin)
#define GetMagickBlobSupport  PrependMagickMethod(GetMagickBlobSupport)
#define GetMagickCopyright  PrependMagickMethod(GetMagickCopyright)
#define GetMagickCoreSignature  PrependMagickMethod(GetMagickCoreSignature)
#define GetMagickDelegates  PrependMagickMethod(GetMagickDelegates)
#define GetMagickDescription  PrependMagickMethod(GetMagickDescription)
#define GetMagickEndianSupport  PrependMagickMethod(GetMagickEndianSupport)
#define GetMagickFeatures  PrependMagickMethod(GetMagickFeatures)
#define GetMagickGeometry  PrependMagickMethod(GetMagickGeometry)
#define GetMagickHomeURL  PrependMagickMethod(GetMagickHomeURL)
#define GetMagickInfoList  PrependMagickMethod(GetMagickInfoList)
#define GetMagickInfo  PrependMagickMethod(GetMagickInfo)
#define GetMagickLicense  PrependMagickMethod(GetMagickLicense)
#define GetMagickList  PrependMagickMethod(GetMagickList)
#define GetMagickMemoryMethods  PrependMagickMethod(GetMagickMemoryMethods)
#define GetMagickMimeType  PrependMagickMethod(GetMagickMimeType)
#define GetMagickOpenCLEnvParam  PrependMagickMethod(GetMagickOpenCLEnvParam)
#define GetMagickPackageName  PrependMagickMethod(GetMagickPackageName)
#define GetMagickPageSize  PrependMagickMethod(GetMagickPageSize)
#define GetMagickPixelIntensity  PrependMagickMethod(GetMagickPixelIntensity)
#define GetMagickPixelPacket  PrependMagickMethod(GetMagickPixelPacket)
#define GetMagickPrecision  PrependMagickMethod(GetMagickPrecision)
#define GetMagickProperty  PrependMagickMethod(GetMagickProperty)
#define GetMagickQuantumDepth  PrependMagickMethod(GetMagickQuantumDepth)
#define GetMagickQuantumRange  PrependMagickMethod(GetMagickQuantumRange)
#define GetMagickRawSupport  PrependMagickMethod(GetMagickRawSupport)
#define GetMagickRegistry  PrependMagickMethod(GetMagickRegistry)
#define GetMagickReleaseDate  PrependMagickMethod(GetMagickReleaseDate)
#define GetMagickResourceLimit  PrependMagickMethod(GetMagickResourceLimit)
#define GetMagickResource  PrependMagickMethod(GetMagickResource)
#define GetMagickSeekableStream  PrependMagickMethod(GetMagickSeekableStream)
#define GetMagickThreadSupport  PrependMagickMethod(GetMagickThreadSupport)
#define GetMagickThreadValue  PrependMagickMethod(GetMagickThreadValue)
#define GetMagickTime  PrependMagickMethod(GetMagickTime)
#define GetMagickToken  PrependMagickMethod(GetMagickToken)
#define GetMagickVersion  PrependMagickMethod(GetMagickVersion)
#define GetMagicList  PrependMagickMethod(GetMagicList)
#define GetMagicName  PrependMagickMethod(GetMagicName)
#define GetMatrixColumns  PrependMagickMethod(GetMatrixColumns)
#define GetMatrixElement  PrependMagickMethod(GetMatrixElement)
#define GetMatrixRows  PrependMagickMethod(GetMatrixRows)
#define GetMaxMemoryRequest  PrependMagickMethod(GetMaxMemoryRequest)
#define GetMimeDescription  PrependMagickMethod(GetMimeDescription)
#define GetMimeInfoList  PrependMagickMethod(GetMimeInfoList)
#define GetMimeInfo  PrependMagickMethod(GetMimeInfo)
#define GetMimeList  PrependMagickMethod(GetMimeList)
#define GetMimeType  PrependMagickMethod(GetMimeType)
#define GetMonitorHandler  PrependMagickMethod(GetMonitorHandler)
#define GetMontageInfo  PrependMagickMethod(GetMontageInfo)
#define GetMultilineTypeMetrics  PrependMagickMethod(GetMultilineTypeMetrics)
#define GetNextImageArtifact  PrependMagickMethod(GetNextImageArtifact)
#define GetNextImageAttribute  PrependMagickMethod(GetNextImageAttribute)
#define GetNextImageInList  PrependMagickMethod(GetNextImageInList)
#define GetNextImageOption  PrependMagickMethod(GetNextImageOption)
#define GetNextImage  PrependMagickMethod(GetNextImage)
#define GetNextImageProfile  PrependMagickMethod(GetNextImageProfile)
#define GetNextImageProperty  PrependMagickMethod(GetNextImageProperty)
#define GetNextImageRegistry  PrependMagickMethod(GetNextImageRegistry)
#define GetNextKeyInHashmap  PrependMagickMethod(GetNextKeyInHashmap)
#define GetNextKeyInSplayTree  PrependMagickMethod(GetNextKeyInSplayTree)
#define GetNextToken  PrependMagickMethod(GetNextToken)
#define GetNextValueInHashmap  PrependMagickMethod(GetNextValueInHashmap)
#define GetNextValueInLinkedList  PrependMagickMethod(GetNextValueInLinkedList)
#define GetNextValueInSplayTree  PrependMagickMethod(GetNextValueInSplayTree)
#define GetNextXMLTreeTag  PrependMagickMethod(GetNextXMLTreeTag)
#define GetNumberColors  PrependMagickMethod(GetNumberColors)
#define GetNumberOfElementsInLinkedList  PrependMagickMethod(GetNumberOfElementsInLinkedList)
#define GetNumberOfEntriesInHashmap  PrependMagickMethod(GetNumberOfEntriesInHashmap)
#define GetNumberOfNodesInSplayTree  PrependMagickMethod(GetNumberOfNodesInSplayTree)
#define GetNumberScenes  PrependMagickMethod(GetNumberScenes)
#define GetOneAuthenticPixel  PrependMagickMethod(GetOneAuthenticPixel)
#define GetOneCacheViewAuthenticPixel  PrependMagickMethod(GetOneCacheViewAuthenticPixel)
#define GetOneCacheViewVirtualMethodPixel  PrependMagickMethod(GetOneCacheViewVirtualMethodPixel)
#define GetOneCacheViewVirtualPixel  PrependMagickMethod(GetOneCacheViewVirtualPixel)
#define GetOnePixel  PrependMagickMethod(GetOnePixel)
#define GetOneVirtualMagickPixel  PrependMagickMethod(GetOneVirtualMagickPixel)
#define GetOneVirtualMethodPixel  PrependMagickMethod(GetOneVirtualMethodPixel)
#define GetOneVirtualPixel  PrependMagickMethod(GetOneVirtualPixel)
#define GetOptimalKernelWidth1D  PrependMagickMethod(GetOptimalKernelWidth1D)
#define GetOptimalKernelWidth2D  PrependMagickMethod(GetOptimalKernelWidth2D)
#define GetOptimalKernelWidth  PrependMagickMethod(GetOptimalKernelWidth)
#define GetPageGeometry  PrependMagickMethod(GetPageGeometry)
#define GetPathAttributes  PrependMagickMethod(GetPathAttributes)
#define GetPathComponent  PrependMagickMethod(GetPathComponent)
#define GetPathComponents  PrependMagickMethod(GetPathComponents)
#define GetPathTemplate  PrependMagickMethod(GetPathTemplate)
#define GetPixelCacheChannels  PrependMagickMethod(GetPixelCacheChannels)
#define GetPixelCacheColorspace  PrependMagickMethod(GetPixelCacheColorspace)
#define GetPixelCacheFilename  PrependMagickMethod(GetPixelCacheFilename)
#define GetPixelCacheMethods  PrependMagickMethod(GetPixelCacheMethods)
#define GetPixelCacheNexusExtent  PrependMagickMethod(GetPixelCacheNexusExtent)
#define GetPixelCachePixels  PrependMagickMethod(GetPixelCachePixels)
#define GetPixelCacheStorageClass  PrependMagickMethod(GetPixelCacheStorageClass)
#define GetPixelCacheTileSize  PrependMagickMethod(GetPixelCacheTileSize)
#define GetPixelCacheType  PrependMagickMethod(GetPixelCacheType)
#define GetPixelCacheVirtualMethod  PrependMagickMethod(GetPixelCacheVirtualMethod)
#define GetPixelIntensity  PrependMagickMethod(GetPixelIntensity)
#define GetPixels  PrependMagickMethod(GetPixels)
#define GetPolicyInfoList  PrependMagickMethod(GetPolicyInfoList)
#define GetPolicyList  PrependMagickMethod(GetPolicyList)
#define GetPolicyValue  PrependMagickMethod(GetPolicyValue)
#define GetPreviousImageInList  PrependMagickMethod(GetPreviousImageInList)
#define GetPreviousImage  PrependMagickMethod(GetPreviousImage)
#define GetPseudoRandomValue  PrependMagickMethod(GetPseudoRandomValue)
#define GetQuantizeInfo  PrependMagickMethod(GetQuantizeInfo)
#define GetQuantumEndian  PrependMagickMethod(GetQuantumEndian)
#define GetQuantumExtent  PrependMagickMethod(GetQuantumExtent)
#define GetQuantumFormat  PrependMagickMethod(GetQuantumFormat)
#define GetQuantumInfo  PrependMagickMethod(GetQuantumInfo)
#define GetQuantumPixels  PrependMagickMethod(GetQuantumPixels)
#define GetQuantumType  PrependMagickMethod(GetQuantumType)
#define GetRandomInfoNormalize  PrependMagickMethod(GetRandomInfoNormalize)
#define GetRandomInfoSeed  PrependMagickMethod(GetRandomInfoSeed)
#define GetRandomKey  PrependMagickMethod(GetRandomKey)
#define GetRandomSecretKey  PrependMagickMethod(GetRandomSecretKey)
#define GetRandomValue  PrependMagickMethod(GetRandomValue)
#define GetResizeFilterBlur  PrependMagickMethod(GetResizeFilterBlur)
#define GetResizeFilterCoefficient  PrependMagickMethod(GetResizeFilterCoefficient)
#define GetResizeFilterScale  PrependMagickMethod(GetResizeFilterScale)
#define GetResizeFilterSupport  PrependMagickMethod(GetResizeFilterSupport)
#define GetResizeFilterWeightingType  PrependMagickMethod(GetResizeFilterWeightingType)
#define GetResizeFilterWeight  PrependMagickMethod(GetResizeFilterWeight)
#define GetResizeFilterWindowSupport  PrependMagickMethod(GetResizeFilterWindowSupport)
#define GetResizeFilterWindowWeightingType  PrependMagickMethod(GetResizeFilterWindowWeightingType)
#define GetRootValueFromSplayTree  PrependMagickMethod(GetRootValueFromSplayTree)
#define GetSignatureBlocksize  PrependMagickMethod(GetSignatureBlocksize)
#define GetSignatureDigest  PrependMagickMethod(GetSignatureDigest)
#define GetSignatureDigestsize  PrependMagickMethod(GetSignatureDigestsize)
#define GetStreamInfoClientData  PrependMagickMethod(GetStreamInfoClientData)
#define GetStringInfoDatum  PrependMagickMethod(GetStringInfoDatum)
#define GetStringInfoLength  PrependMagickMethod(GetStringInfoLength)
#define GetStringInfoName  PrependMagickMethod(GetStringInfoName)
#define GetStringInfoPath  PrependMagickMethod(GetStringInfoPath)
#define GetThresholdMapFile  PrependMagickMethod(GetThresholdMapFile)
#define GetThresholdMap  PrependMagickMethod(GetThresholdMap)
#define GetTimerInfo  PrependMagickMethod(GetTimerInfo)
#define GetTypeInfoByFamily  PrependMagickMethod(GetTypeInfoByFamily)
#define GetTypeInfoList  PrependMagickMethod(GetTypeInfoList)
#define GetTypeInfo  PrependMagickMethod(GetTypeInfo)
#define GetTypeList  PrependMagickMethod(GetTypeList)
#define GetTypeMetrics  PrependMagickMethod(GetTypeMetrics)
#define GetUserTime  PrependMagickMethod(GetUserTime)
#define GetValueFromHashmap  PrependMagickMethod(GetValueFromHashmap)
#define GetValueFromLinkedList  PrependMagickMethod(GetValueFromLinkedList)
#define GetValueFromSplayTree  PrependMagickMethod(GetValueFromSplayTree)
#define GetVirtualIndexesFromNexus  PrependMagickMethod(GetVirtualIndexesFromNexus)
#define GetVirtualIndexQueue  PrependMagickMethod(GetVirtualIndexQueue)
#define GetVirtualMemoryBlob  PrependMagickMethod(GetVirtualMemoryBlob)
#define GetVirtualPixelCacheNexus  PrependMagickMethod(GetVirtualPixelCacheNexus)
#define GetVirtualPixelQueue  PrependMagickMethod(GetVirtualPixelQueue)
#define GetVirtualPixelsNexus  PrependMagickMethod(GetVirtualPixelsNexus)
#define GetVirtualPixels  PrependMagickMethod(GetVirtualPixels)
#define GetXMLTreeAttribute  PrependMagickMethod(GetXMLTreeAttribute)
#define GetXMLTreeAttributes  PrependMagickMethod(GetXMLTreeAttributes)
#define GetXMLTreeChild  PrependMagickMethod(GetXMLTreeChild)
#define GetXMLTreeContent  PrependMagickMethod(GetXMLTreeContent)
#define GetXMLTreeOrdered  PrependMagickMethod(GetXMLTreeOrdered)
#define GetXMLTreePath  PrependMagickMethod(GetXMLTreePath)
#define GetXMLTreeProcessingInstructions  PrependMagickMethod(GetXMLTreeProcessingInstructions)
#define GetXMLTreeSibling  PrependMagickMethod(GetXMLTreeSibling)
#define GetXMLTreeTag  PrependMagickMethod(GetXMLTreeTag)
#define GlobExpression  PrependMagickMethod(GlobExpression)
#define GradientImage  PrependMagickMethod(GradientImage)
#define GravityAdjustGeometry  PrependMagickMethod(GravityAdjustGeometry)
#define GrayscaleImage  PrependMagickMethod(GrayscaleImage)
#define HaldClutImageChannel  PrependMagickMethod(HaldClutImageChannel)
#define HaldClutImage  PrependMagickMethod(HaldClutImage)
#define HashPointerType  PrependMagickMethod(HashPointerType)
#define HashStringInfoType  PrependMagickMethod(HashStringInfoType)
#define HashStringType  PrependMagickMethod(HashStringType)
#define HoughLineImage  PrependMagickMethod(HoughLineImage)
#define HSLTransform  PrependMagickMethod(HSLTransform)
#define HuffmanDecodeImage  PrependMagickMethod(HuffmanDecodeImage)
#define HuffmanEncodeImage  PrependMagickMethod(HuffmanEncodeImage)
#define IdentifyImageGray  PrependMagickMethod(IdentifyImageGray)
#define IdentifyImageMonochrome  PrependMagickMethod(IdentifyImageMonochrome)
#define IdentifyImage  PrependMagickMethod(IdentifyImage)
#define IdentifyImageType  PrependMagickMethod(IdentifyImageType)
#define IdentifyPaletteImage  PrependMagickMethod(IdentifyPaletteImage)
#define IdentityAffine  PrependMagickMethod(IdentityAffine)
#define ImageListToArray  PrependMagickMethod(ImageListToArray)
#define ImagesToBlob  PrependMagickMethod(ImagesToBlob)
#define ImageToBlob  PrependMagickMethod(ImageToBlob)
#define ImageToFile  PrependMagickMethod(ImageToFile)
#define ImplodeImage  PrependMagickMethod(ImplodeImage)
#define ImportImagePixels  PrependMagickMethod(ImportImagePixels)
#define ImportQuantumPixels  PrependMagickMethod(ImportQuantumPixels)
#define InheritException  PrependMagickMethod(InheritException)
#define InitializeExceptionInfo  PrependMagickMethod(InitializeExceptionInfo)
#define InitializeMagick  PrependMagickMethod(InitializeMagick)
#define InitializeSignature  PrependMagickMethod(InitializeSignature)
#define InitImageMagickOpenCL  PrependMagickMethod(InitImageMagickOpenCL)
#define InitOpenCLEnv  PrependMagickMethod(InitOpenCLEnv)
#define InjectImageBlob  PrependMagickMethod(InjectImageBlob)
#define InsertImageInList  PrependMagickMethod(InsertImageInList)
#define InsertTagIntoXMLTree  PrependMagickMethod(InsertTagIntoXMLTree)
#define InsertValueInLinkedList  PrependMagickMethod(InsertValueInLinkedList)
#define InsertValueInSortedLinkedList  PrependMagickMethod(InsertValueInSortedLinkedList)
#define IntegralRotateImage  PrependMagickMethod(IntegralRotateImage)
#define InterpolateMagickPixelPacket  PrependMagickMethod(InterpolateMagickPixelPacket)
#define InterpolatePixelColor  PrependMagickMethod(InterpolatePixelColor)
#define InterpolativeResizeImage  PrependMagickMethod(InterpolativeResizeImage)
#define InterpretImageAttributes  PrependMagickMethod(InterpretImageAttributes)
#define InterpretImageFilename  PrependMagickMethod(InterpretImageFilename)
#define InterpretImageProperties  PrependMagickMethod(InterpretImageProperties)
#define InterpretLocaleValue  PrependMagickMethod(InterpretLocaleValue)
#define InterpretSiPrefixValue  PrependMagickMethod(InterpretSiPrefixValue)
#define InverseFourierTransformImage  PrependMagickMethod(InverseFourierTransformImage)
#define InversesRGBCompandor  PrependMagickMethod(InversesRGBCompandor)
#define InvokeDelegate  PrependMagickMethod(InvokeDelegate)
#define InvokeDynamicImageFilter  PrependMagickMethod(InvokeDynamicImageFilter)
#define IsBlobExempt  PrependMagickMethod(IsBlobExempt)
#define IsBlobSeekable  PrependMagickMethod(IsBlobSeekable)
#define IsBlobTemporary  PrependMagickMethod(IsBlobTemporary)
#define IsColorSimilar  PrependMagickMethod(IsColorSimilar)
#define IsCommandOption  PrependMagickMethod(IsCommandOption)
#define IsEventLogging  PrependMagickMethod(IsEventLogging)
#define IsGeometry  PrependMagickMethod(IsGeometry)
#define IsGlob  PrependMagickMethod(IsGlob)
#define IsGrayImage  PrependMagickMethod(IsGrayImage)
#define IsHashmapEmpty  PrependMagickMethod(IsHashmapEmpty)
#define IsHighDynamicRangeImage  PrependMagickMethod(IsHighDynamicRangeImage)
#define IsHistogramImage  PrependMagickMethod(IsHistogramImage)
#define IsImageObject  PrependMagickMethod(IsImageObject)
#define IsImagesEqual  PrependMagickMethod(IsImagesEqual)
#define IsImageSimilar  PrependMagickMethod(IsImageSimilar)
#define IsImageView  PrependMagickMethod(IsImageView)
#define IsIntensitySimilar  PrependMagickMethod(IsIntensitySimilar)
#define IsLinkedListEmpty  PrependMagickMethod(IsLinkedListEmpty)
#define IsMagickColorSimilar  PrependMagickMethod(IsMagickColorSimilar)
#define IsMagickConflict  PrependMagickMethod(IsMagickConflict)
#define IsMagickCoreInstantiated  PrependMagickMethod(IsMagickCoreInstantiated)
#define IsMagickInstantiated  PrependMagickMethod(IsMagickInstantiated)
#define IsMagickTrue  PrependMagickMethod(IsMagickTrue)
#define IsMonochromeImage  PrependMagickMethod(IsMonochromeImage)
#define IsOpacitySimilar  PrependMagickMethod(IsOpacitySimilar)
#define IsOpaqueImage  PrependMagickMethod(IsOpaqueImage)
#define IsOptionMember  PrependMagickMethod(IsOptionMember)
#define IsPaletteImage  PrependMagickMethod(IsPaletteImage)
#define IsPathAccessible  PrependMagickMethod(IsPathAccessible)
#define IsRightsAuthorized  PrependMagickMethod(IsRightsAuthorized)
#define IsSceneGeometry  PrependMagickMethod(IsSceneGeometry)
#define IsStringNotFalse  PrependMagickMethod(IsStringNotFalse)
#define IsStringTrue  PrependMagickMethod(IsStringTrue)
#define IsSubimage  PrependMagickMethod(IsSubimage)
#define IsTaintImage  PrependMagickMethod(IsTaintImage)
#define KuwaharaImageChannel  PrependMagickMethod(KuwaharaImageChannel)
#define KuwaharaImage  PrependMagickMethod(KuwaharaImage)
#define LeastSquaresAddTerms  PrependMagickMethod(LeastSquaresAddTerms)
#define LevelColorsImageChannel  PrependMagickMethod(LevelColorsImageChannel)
#define LevelColorsImage  PrependMagickMethod(LevelColorsImage)
#define LevelImageChannel  PrependMagickMethod(LevelImageChannel)
#define LevelImageColors  PrependMagickMethod(LevelImageColors)
#define LevelImage  PrependMagickMethod(LevelImage)
#define LevelizeImageChannel  PrependMagickMethod(LevelizeImageChannel)
#define LevelizeImage  PrependMagickMethod(LevelizeImage)
#define LiberateMemory  PrependMagickMethod(LiberateMemory)
#define LiberateSemaphoreInfo  PrependMagickMethod(LiberateSemaphoreInfo)
#define LinearStretchImage  PrependMagickMethod(LinearStretchImage)
#define LinkedListToArray  PrependMagickMethod(LinkedListToArray)
#define LiquidRescaleImage  PrependMagickMethod(LiquidRescaleImage)
#define ListCoderInfo  PrependMagickMethod(ListCoderInfo)
#define ListColorInfo  PrependMagickMethod(ListColorInfo)
#define ListCommandOptions  PrependMagickMethod(ListCommandOptions)
#define ListConfigureInfo  PrependMagickMethod(ListConfigureInfo)
#define ListDelegateInfo  PrependMagickMethod(ListDelegateInfo)
#define ListFiles  PrependMagickMethod(ListFiles)
#define ListLocaleInfo  PrependMagickMethod(ListLocaleInfo)
#define ListLogInfo  PrependMagickMethod(ListLogInfo)
#define ListMagicInfo  PrependMagickMethod(ListMagicInfo)
#define ListMagickInfo  PrependMagickMethod(ListMagickInfo)
#define ListMagickResourceInfo  PrependMagickMethod(ListMagickResourceInfo)
#define ListMagickVersion  PrependMagickMethod(ListMagickVersion)
#define ListMimeInfo  PrependMagickMethod(ListMimeInfo)
#define ListModuleInfo  PrependMagickMethod(ListModuleInfo)
#define ListPolicyInfo  PrependMagickMethod(ListPolicyInfo)
#define ListThresholdMapFile  PrependMagickMethod(ListThresholdMapFile)
#define ListThresholdMaps  PrependMagickMethod(ListThresholdMaps)
#define ListTypeInfo  PrependMagickMethod(ListTypeInfo)
#define LoadFontConfigFonts  PrependMagickMethod(LoadFontConfigFonts)
#define LoadMimeLists  PrependMagickMethod(LoadMimeLists)
#define LocalContrastImage  PrependMagickMethod(LocalContrastImage)
#define LocaleCompare  PrependMagickMethod(LocaleCompare)
#define LocaleComponentGenesis  PrependMagickMethod(LocaleComponentGenesis)
#define LocaleComponentTerminus  PrependMagickMethod(LocaleComponentTerminus)
#define LocaleToLowercase  PrependMagickMethod(LocaleToLowercase)
#define LocaleLower  PrependMagickMethod(LocaleLower)
#define LocaleNCompare  PrependMagickMethod(LocaleNCompare)
#define LocaleToUppercase  PrependMagickMethod(LocaleToUppercase)
#define LocaleUpper  PrependMagickMethod(LocaleUpper)
#define LockSemaphoreInfo  PrependMagickMethod(LockSemaphoreInfo)
#define LogComponentGenesis  PrependMagickMethod(LogComponentGenesis)
#define LogComponentTerminus  PrependMagickMethod(LogComponentTerminus)
#define LogMagickEventList  PrependMagickMethod(LogMagickEventList)
#define LogMagickEvent  PrependMagickMethod(LogMagickEvent)
#define LZWEncodeImage  PrependMagickMethod(LZWEncodeImage)
#define MagicComponentGenesis  PrependMagickMethod(MagicComponentGenesis)
#define MagicComponentTerminus  PrependMagickMethod(MagicComponentTerminus)
#define MagickComponentGenesis  PrependMagickMethod(MagickComponentGenesis)
#define MagickComponentTerminus  PrependMagickMethod(MagickComponentTerminus)
#define MagickCoreGenesis  PrependMagickMethod(MagickCoreGenesis)
#define MagickCoreTerminus  PrependMagickMethod(MagickCoreTerminus)
#define MagickCreateThreadKey  PrependMagickMethod(MagickCreateThreadKey)
#define MagickDelay  PrependMagickMethod(MagickDelay)
#define MagickDeleteThreadKey  PrependMagickMethod(MagickDeleteThreadKey)
#define MagickGetThreadValue  PrependMagickMethod(MagickGetThreadValue)
#define MagickIncarnate  PrependMagickMethod(MagickIncarnate)
#define MagickMonitor  PrependMagickMethod(MagickMonitor)
#define MagickSetThreadValue  PrependMagickMethod(MagickSetThreadValue)
#define MagickToMime  PrependMagickMethod(MagickToMime)
#define MagnifyImage  PrependMagickMethod(MagnifyImage)
#define MapBlob  PrependMagickMethod(MapBlob)
#define MapImage  PrependMagickMethod(MapImage)
#define MapImages  PrependMagickMethod(MapImages)
#define MatrixToImage  PrependMagickMethod(MatrixToImage)
#define MatteFloodfillImage  PrependMagickMethod(MatteFloodfillImage)
#define MaximumImages  PrependMagickMethod(MaximumImages)
#define MeanShiftImage  PrependMagickMethod(MeanShiftImage)
#define MedianFilterImage  PrependMagickMethod(MedianFilterImage)
#define MergeImageLayers  PrependMagickMethod(MergeImageLayers)
#define MimeComponentGenesis  PrependMagickMethod(MimeComponentGenesis)
#define MimeComponentTerminus  PrependMagickMethod(MimeComponentTerminus)
#define MinifyImage  PrependMagickMethod(MinifyImage)
#define MinimumImages  PrependMagickMethod(MinimumImages)
#define MinMaxStretchImage  PrependMagickMethod(MinMaxStretchImage)
#define ModeImage  PrependMagickMethod(ModeImage)
#define ModifyImage  PrependMagickMethod(ModifyImage)
#define ModulateImage  PrependMagickMethod(ModulateImage)
#define MonitorComponentGenesis  PrependMagickMethod(MonitorComponentGenesis)
#define MonitorComponentTerminus  PrependMagickMethod(MonitorComponentTerminus)
#define MontageImageList  PrependMagickMethod(MontageImageList)
#define MontageImages  PrependMagickMethod(MontageImages)
#define MorphImages  PrependMagickMethod(MorphImages)
#define MorphologyApply  PrependMagickMethod(MorphologyApply)
#define MorphologyImageChannel  PrependMagickMethod(MorphologyImageChannel)
#define MorphologyImage  PrependMagickMethod(MorphologyImage)
#define MosaicImages  PrependMagickMethod(MosaicImages)
#define MotionBlurImageChannel  PrependMagickMethod(MotionBlurImageChannel)
#define MotionBlurImage  PrependMagickMethod(MotionBlurImage)
#define MSBOrderLong  PrependMagickMethod(MSBOrderLong)
#define MSBOrderShort  PrependMagickMethod(MSBOrderShort)
#define MultilineCensus  PrependMagickMethod(MultilineCensus)
#define MVGMacroCompare  PrependMagickMethod(MVGMacroCompare)
#define NegateImageChannel  PrependMagickMethod(NegateImageChannel)
#define NegateImage  PrependMagickMethod(NegateImage)
#define NewHashmap  PrependMagickMethod(NewHashmap)
#define NewImageList  PrependMagickMethod(NewImageList)
#define NewImageView  PrependMagickMethod(NewImageView)
#define NewImageViewRegion  PrependMagickMethod(NewImageViewRegion)
#define NewLinkedList  PrependMagickMethod(NewLinkedList)
#define NewMagickImage  PrependMagickMethod(NewMagickImage)
#define NewSplayTree  PrependMagickMethod(NewSplayTree)
#define NewXMLTree  PrependMagickMethod(NewXMLTree)
#define NewXMLTreeTag  PrependMagickMethod(NewXMLTreeTag)
#define NormalizeImageChannel  PrependMagickMethod(NormalizeImageChannel)
#define NormalizeImage  PrependMagickMethod(NormalizeImage)
#define NullMatrix  PrependMagickMethod(NullMatrix)
#define OilPaintImage  PrependMagickMethod(OilPaintImage)
#define OpaqueImage  PrependMagickMethod(OpaqueImage)
#define OpaquePaintImageChannel  PrependMagickMethod(OpaquePaintImageChannel)
#define OpaquePaintImage  PrependMagickMethod(OpaquePaintImage)
#define OpenBlob  PrependMagickMethod(OpenBlob)
#define OpenCacheView  PrependMagickMethod(OpenCacheView)
#define OpenDistributePixelCache  PrependMagickMethod(OpenDistributePixelCache)
#define OpenMagickStream  PrependMagickMethod(OpenMagickStream)
#define OpenStream  PrependMagickMethod(OpenStream)
#define OptimizeImageLayers  PrependMagickMethod(OptimizeImageLayers)
#define OptimizeImageTransparency  PrependMagickMethod(OptimizeImageTransparency)
#define OptimizePlusImageLayers  PrependMagickMethod(OptimizePlusImageLayers)
#define OrderedDitherImageChannel  PrependMagickMethod(OrderedDitherImageChannel)
#define OrderedDitherImage  PrependMagickMethod(OrderedDitherImage)
#define OrderedPosterizeImageChannel  PrependMagickMethod(OrderedPosterizeImageChannel)
#define OrderedPosterizeImage  PrependMagickMethod(OrderedPosterizeImage)
#define PackbitsEncodeImage  PrependMagickMethod(PackbitsEncodeImage)
#define PaintFloodfillImage  PrependMagickMethod(PaintFloodfillImage)
#define PaintOpaqueImageChannel  PrependMagickMethod(PaintOpaqueImageChannel)
#define PaintOpaqueImage  PrependMagickMethod(PaintOpaqueImage)
#define PaintTransparentImage  PrependMagickMethod(PaintTransparentImage)
#define ParseAbsoluteGeometry  PrependMagickMethod(ParseAbsoluteGeometry)
#define ParseAffineGeometry  PrependMagickMethod(ParseAffineGeometry)
#define ParseChannelOption  PrependMagickMethod(ParseChannelOption)
#define ParseCommandOption  PrependMagickMethod(ParseCommandOption)
#define ParseGeometry  PrependMagickMethod(ParseGeometry)
#define ParseGravityGeometry  PrependMagickMethod(ParseGravityGeometry)
#define ParseImageGeometry  PrependMagickMethod(ParseImageGeometry)
#define ParseMetaGeometry  PrependMagickMethod(ParseMetaGeometry)
#define ParsePageGeometry  PrependMagickMethod(ParsePageGeometry)
#define ParseRegionGeometry  PrependMagickMethod(ParseRegionGeometry)
#define ParseSizeGeometry  PrependMagickMethod(ParseSizeGeometry)
#define PasskeyDecipherImage  PrependMagickMethod(PasskeyDecipherImage)
#define PasskeyEncipherImage  PrependMagickMethod(PasskeyEncipherImage)
#define PerceptibleImageChannel  PrependMagickMethod(PerceptibleImageChannel)
#define PerceptibleImage  PrependMagickMethod(PerceptibleImage)
#define PersistPixelCache  PrependMagickMethod(PersistPixelCache)
#define PingBlob  PrependMagickMethod(PingBlob)
#define PingImage  PrependMagickMethod(PingImage)
#define PingImages  PrependMagickMethod(PingImages)
#define PlasmaImage  PrependMagickMethod(PlasmaImage)
#define PlasmaImageProxy  PrependMagickMethod(PlasmaImageProxy)
#define PolaroidImage  PrependMagickMethod(PolaroidImage)
#define PolicyComponentGenesis  PrependMagickMethod(PolicyComponentGenesis)
#define PolicyComponentTerminus  PrependMagickMethod(PolicyComponentTerminus)
#define PolynomialImageChannel  PrependMagickMethod(PolynomialImageChannel)
#define PolynomialImage  PrependMagickMethod(PolynomialImage)
#define PopImageList  PrependMagickMethod(PopImageList)
#define PopImagePixels  PrependMagickMethod(PopImagePixels)
#define PosterizeImageChannel  PrependMagickMethod(PosterizeImageChannel)
#define PosterizeImage  PrependMagickMethod(PosterizeImage)
#define PostscriptGeometry  PrependMagickMethod(PostscriptGeometry)
#define PrependImageToList  PrependMagickMethod(PrependImageToList)
#define PreviewImage  PrependMagickMethod(PreviewImage)
#define PrintStringInfo  PrependMagickMethod(PrintStringInfo)
#define process_message  PrependMagickMethod(process_message)
#define ProfileImage  PrependMagickMethod(ProfileImage)
#define PruneTagFromXMLTree  PrependMagickMethod(PruneTagFromXMLTree)
#define PushImageList  PrependMagickMethod(PushImageList)
#define PushImagePixels  PrependMagickMethod(PushImagePixels)
#define PutEntryInHashmap  PrependMagickMethod(PutEntryInHashmap)
#define QuantizationError  PrependMagickMethod(QuantizationError)
#define QuantizeImage  PrependMagickMethod(QuantizeImage)
#define QuantizeImages  PrependMagickMethod(QuantizeImages)
#define QueryColorCompliance  PrependMagickMethod(QueryColorCompliance)
#define QueryColorDatabase  PrependMagickMethod(QueryColorDatabase)
#define QueryColorname  PrependMagickMethod(QueryColorname)
#define QueryMagickColorCompliance  PrependMagickMethod(QueryMagickColorCompliance)
#define QueryMagickColorname  PrependMagickMethod(QueryMagickColorname)
#define QueryMagickColor  PrependMagickMethod(QueryMagickColor)
#define QueueAuthenticPixelCacheNexus  PrependMagickMethod(QueueAuthenticPixelCacheNexus)
#define QueueAuthenticPixel  PrependMagickMethod(QueueAuthenticPixel)
#define QueueAuthenticPixels  PrependMagickMethod(QueueAuthenticPixels)
#define QueueCacheViewAuthenticPixels  PrependMagickMethod(QueueCacheViewAuthenticPixels)
#define RadialBlurImageChannel  PrependMagickMethod(RadialBlurImageChannel)
#define RadialBlurImage  PrependMagickMethod(RadialBlurImage)
#define RaiseImage  PrependMagickMethod(RaiseImage)
#define RandomChannelThresholdImage  PrependMagickMethod(RandomChannelThresholdImage)
#define RandomComponentGenesis  PrependMagickMethod(RandomComponentGenesis)
#define RandomComponentTerminus  PrependMagickMethod(RandomComponentTerminus)
#define RandomThresholdImageChannel  PrependMagickMethod(RandomThresholdImageChannel)
#define RandomThresholdImage  PrependMagickMethod(RandomThresholdImage)
#define ReacquireMemory  PrependMagickMethod(ReacquireMemory)
#define ReadBlobByte  PrependMagickMethod(ReadBlobByte)
#define ReadBlobDouble  PrependMagickMethod(ReadBlobDouble)
#define ReadBlobFloat  PrependMagickMethod(ReadBlobFloat)
#define ReadBlobLongLong  PrependMagickMethod(ReadBlobLongLong)
#define ReadBlobLong  PrependMagickMethod(ReadBlobLong)
#define ReadBlobLSBLong  PrependMagickMethod(ReadBlobLSBLong)
#define ReadBlobLSBShort  PrependMagickMethod(ReadBlobLSBShort)
#define ReadBlobLSBSignedLong  PrependMagickMethod(ReadBlobLSBSignedLong)
#define ReadBlobLSBSignedShort  PrependMagickMethod(ReadBlobLSBSignedShort)
#define ReadBlobMSBLongLong  PrependMagickMethod(ReadBlobMSBLongLong)
#define ReadBlobMSBLong  PrependMagickMethod(ReadBlobMSBLong)
#define ReadBlobMSBShort  PrependMagickMethod(ReadBlobMSBShort)
#define ReadBlobMSBSignedLong  PrependMagickMethod(ReadBlobMSBSignedLong)
#define ReadBlobMSBSignedShort  PrependMagickMethod(ReadBlobMSBSignedShort)
#define ReadBlob  PrependMagickMethod(ReadBlob)
#define ReadBlobShort  PrependMagickMethod(ReadBlobShort)
#define ReadBlobSignedLong  PrependMagickMethod(ReadBlobSignedLong)
#define ReadBlobSignedShort  PrependMagickMethod(ReadBlobSignedShort)
#define ReadBlobStream  PrependMagickMethod(ReadBlobStream)
#define ReadBlobString  PrependMagickMethod(ReadBlobString)
#define ReadDistributePixelCacheIndexes  PrependMagickMethod(ReadDistributePixelCacheIndexes)
#define ReadDistributePixelCachePixels  PrependMagickMethod(ReadDistributePixelCachePixels)
#define ReadImage  PrependMagickMethod(ReadImage)
#define ReadImages  PrependMagickMethod(ReadImages)
#define ReadInlineImage  PrependMagickMethod(ReadInlineImage)
#define ReadPSDLayers  PrependMagickMethod(ReadPSDLayers)
#define ReadStream  PrependMagickMethod(ReadStream)
#define RecolorImage  PrependMagickMethod(RecolorImage)
#define ReduceNoiseImage  PrependMagickMethod(ReduceNoiseImage)
#define ReferenceBlob  PrependMagickMethod(ReferenceBlob)
#define ReferenceImage  PrependMagickMethod(ReferenceImage)
#define ReferencePixelCache  PrependMagickMethod(ReferencePixelCache)
#define RegisterAAIImage  PrependMagickMethod(RegisterAAIImage)
#define RegisterARTImage  PrependMagickMethod(RegisterARTImage)
#define RegisterAVSImage  PrependMagickMethod(RegisterAVSImage)
#define RegisterBGRImage  PrependMagickMethod(RegisterBGRImage)
#define RegisterBMPImage  PrependMagickMethod(RegisterBMPImage)
#define RegisterBRAILLEImage  PrependMagickMethod(RegisterBRAILLEImage)
#define RegisterCALSImage  PrependMagickMethod(RegisterCALSImage)
#define RegisterCAPTIONImage  PrependMagickMethod(RegisterCAPTIONImage)
#define RegisterCINImage  PrependMagickMethod(RegisterCINImage)
#define RegisterCIPImage  PrependMagickMethod(RegisterCIPImage)
#define RegisterCLIPImage  PrependMagickMethod(RegisterCLIPImage)
#define RegisterCMYKImage  PrependMagickMethod(RegisterCMYKImage)
#define RegisterCUTImage  PrependMagickMethod(RegisterCUTImage)
#define RegisterDCMImage  PrependMagickMethod(RegisterDCMImage)
#define RegisterDDSImage  PrependMagickMethod(RegisterDDSImage)
#define RegisterDEBUGImage  PrependMagickMethod(RegisterDEBUGImage)
#define RegisterDIBImage  PrependMagickMethod(RegisterDIBImage)
#define RegisterDJVUImage  PrependMagickMethod(RegisterDJVUImage)
#define RegisterDNGImage  PrependMagickMethod(RegisterDNGImage)
#define RegisterDOTImage  PrependMagickMethod(RegisterDOTImage)
#define RegisterDPXImage  PrependMagickMethod(RegisterDPXImage)
#define RegisterEPTImage  PrependMagickMethod(RegisterEPTImage)
#define RegisterEXRImage  PrependMagickMethod(RegisterEXRImage)
#define RegisterFAXImage  PrependMagickMethod(RegisterFAXImage)
#define RegisterFITSImage  PrependMagickMethod(RegisterFITSImage)
#define RegisterGIFImage  PrependMagickMethod(RegisterGIFImage)
#define RegisterGRADIENTImage  PrependMagickMethod(RegisterGRADIENTImage)
#define RegisterGRAYImage  PrependMagickMethod(RegisterGRAYImage)
#define RegisterHALDImage  PrependMagickMethod(RegisterHALDImage)
#define RegisterHDRImage  PrependMagickMethod(RegisterHDRImage)
#define RegisterHEICImage  PrependMagickMethod(RegisterHEICImage)
#define RegisterHISTOGRAMImage  PrependMagickMethod(RegisterHISTOGRAMImage)
#define RegisterHRZImage  PrependMagickMethod(RegisterHRZImage)
#define RegisterHTMLImage  PrependMagickMethod(RegisterHTMLImage)
#define RegisterICONImage  PrependMagickMethod(RegisterICONImage)
#define RegisterINFOImage  PrependMagickMethod(RegisterINFOImage)
#define RegisterINLINEImage  PrependMagickMethod(RegisterINLINEImage)
#define RegisterIPLImage  PrependMagickMethod(RegisterIPLImage)
#define RegisterJBIGImage  PrependMagickMethod(RegisterJBIGImage)
#define RegisterJNXImage  PrependMagickMethod(RegisterJNXImage)
#define RegisterJP2Image  PrependMagickMethod(RegisterJP2Image)
#define RegisterJPEGImage  PrependMagickMethod(RegisterJPEGImage)
#define RegisterJSONImage  PrependMagickMethod(RegisterJSONImage)
#define RegisterLABELImage  PrependMagickMethod(RegisterLABELImage)
#define RegisterMACImage  PrependMagickMethod(RegisterMACImage)
#define RegisterMAGICKImage  PrependMagickMethod(RegisterMAGICKImage)
#define RegisterMagickInfo  PrependMagickMethod(RegisterMagickInfo)
#define RegisterMAPImage  PrependMagickMethod(RegisterMAPImage)
#define RegisterMASKImage  PrependMagickMethod(RegisterMASKImage)
#define RegisterMATImage  PrependMagickMethod(RegisterMATImage)
#define RegisterMATTEImage  PrependMagickMethod(RegisterMATTEImage)
#define RegisterMETAImage  PrependMagickMethod(RegisterMETAImage)
#define RegisterMIFFImage  PrependMagickMethod(RegisterMIFFImage)
#define RegisterMONOImage  PrependMagickMethod(RegisterMONOImage)
#define RegisterMPCImage  PrependMagickMethod(RegisterMPCImage)
#define RegisterMPRImage  PrependMagickMethod(RegisterMPRImage)
#define RegisterMSLImage  PrependMagickMethod(RegisterMSLImage)
#define RegisterMTVImage  PrependMagickMethod(RegisterMTVImage)
#define RegisterMVGImage  PrependMagickMethod(RegisterMVGImage)
#define RegisterNULLImage  PrependMagickMethod(RegisterNULLImage)
#define RegisterOTBImage  PrependMagickMethod(RegisterOTBImage)
#define RegisterPALMImage  PrependMagickMethod(RegisterPALMImage)
#define RegisterPANGOImage  PrependMagickMethod(RegisterPANGOImage)
#define RegisterPATTERNImage  PrependMagickMethod(RegisterPATTERNImage)
#define RegisterPCDImage  PrependMagickMethod(RegisterPCDImage)
#define RegisterPCLImage  PrependMagickMethod(RegisterPCLImage)
#define RegisterPCXImage  PrependMagickMethod(RegisterPCXImage)
#define RegisterPDBImage  PrependMagickMethod(RegisterPDBImage)
#define RegisterPDFImage  PrependMagickMethod(RegisterPDFImage)
#define RegisterPESImage  PrependMagickMethod(RegisterPESImage)
#define RegisterPGXImage  PrependMagickMethod(RegisterPGXImage)
#define RegisterPICTImage  PrependMagickMethod(RegisterPICTImage)
#define RegisterPIXImage  PrependMagickMethod(RegisterPIXImage)
#define RegisterPLASMAImage  PrependMagickMethod(RegisterPLASMAImage)
#define RegisterPNGImage  PrependMagickMethod(RegisterPNGImage)
#define RegisterPNMImage  PrependMagickMethod(RegisterPNMImage)
#define RegisterPREVIEWImage  PrependMagickMethod(RegisterPREVIEWImage)
#define RegisterPS2Image  PrependMagickMethod(RegisterPS2Image)
#define RegisterPS3Image  PrependMagickMethod(RegisterPS3Image)
#define RegisterPSDImage  PrependMagickMethod(RegisterPSDImage)
#define RegisterPSImage  PrependMagickMethod(RegisterPSImage)
#define RegisterPWPImage  PrependMagickMethod(RegisterPWPImage)
#define RegisterRAWImage  PrependMagickMethod(RegisterRAWImage)
#define RegisterRGBImage  PrependMagickMethod(RegisterRGBImage)
#define RegisterRGFImage  PrependMagickMethod(RegisterRGFImage)
#define RegisterRLAImage  PrependMagickMethod(RegisterRLAImage)
#define RegisterRLEImage  PrependMagickMethod(RegisterRLEImage)
#define RegisterSCREENSHOTImage  PrependMagickMethod(RegisterSCREENSHOTImage)
#define RegisterSCRImage  PrependMagickMethod(RegisterSCRImage)
#define RegisterSCTImage  PrependMagickMethod(RegisterSCTImage)
#define RegisterSFWImage  PrependMagickMethod(RegisterSFWImage)
#define RegisterSGIImage  PrependMagickMethod(RegisterSGIImage)
#define RegisterSIXELImage  PrependMagickMethod(RegisterSIXELImage)
#define RegisterStaticModule  PrependMagickMethod(RegisterStaticModule)
#define RegisterStaticModules  PrependMagickMethod(RegisterStaticModules)
#define RegisterSTEGANOImage  PrependMagickMethod(RegisterSTEGANOImage)
#define RegisterSUNImage  PrependMagickMethod(RegisterSUNImage)
#define RegisterSVGImage  PrependMagickMethod(RegisterSVGImage)
#define RegisterTGAImage  PrependMagickMethod(RegisterTGAImage)
#define RegisterTHUMBNAILImage  PrependMagickMethod(RegisterTHUMBNAILImage)
#define RegisterTIFFImage  PrependMagickMethod(RegisterTIFFImage)
#define RegisterTILEImage  PrependMagickMethod(RegisterTILEImage)
#define RegisterTIMImage  PrependMagickMethod(RegisterTIMImage)
#define RegisterTTFImage  PrependMagickMethod(RegisterTTFImage)
#define RegisterTXTImage  PrependMagickMethod(RegisterTXTImage)
#define RegisterUILImage  PrependMagickMethod(RegisterUILImage)
#define RegisterUndefinedImage  PrependMagickMethod(RegisterUndefinedImage)
#define RegisterURLImage  PrependMagickMethod(RegisterURLImage)
#define RegisterUYVYImage  PrependMagickMethod(RegisterUYVYImage)
#define RegisterVICARImage  PrependMagickMethod(RegisterVICARImage)
#define RegisterVIDImage  PrependMagickMethod(RegisterVIDImage)
#define RegisterVIFFImage  PrependMagickMethod(RegisterVIFFImage)
#define RegisterVIPSImage  PrependMagickMethod(RegisterVIPSImage)
#define RegisterWBMPImage  PrependMagickMethod(RegisterWBMPImage)
#define RegisterWEBPImage  PrependMagickMethod(RegisterWEBPImage)
#define RegisterWMFImage  PrependMagickMethod(RegisterWMFImage)
#define RegisterWPGImage  PrependMagickMethod(RegisterWPGImage)
#define RegisterXBMImage  PrependMagickMethod(RegisterXBMImage)
#define RegisterXCFImage  PrependMagickMethod(RegisterXCFImage)
#define RegisterXCImage  PrependMagickMethod(RegisterXCImage)
#define RegisterXImage  PrependMagickMethod(RegisterXImage)
#define RegisterXPMImage  PrependMagickMethod(RegisterXPMImage)
#define RegisterXPSImage  PrependMagickMethod(RegisterXPSImage)
#define RegisterXWDImage  PrependMagickMethod(RegisterXWDImage)
#define RegisterYCBCRImage  PrependMagickMethod(RegisterYCBCRImage)
#define RegisterYUVImage  PrependMagickMethod(RegisterYUVImage)
#define RegistryComponentGenesis  PrependMagickMethod(RegistryComponentGenesis)
#define RegistryComponentTerminus  PrependMagickMethod(RegistryComponentTerminus)
#define RelinquishAlignedMemory  PrependMagickMethod(RelinquishAlignedMemory)
#define RelinquishDistributePixelCache  PrependMagickMethod(RelinquishDistributePixelCache)
#define RelinquishMagickMatrix  PrependMagickMethod(RelinquishMagickMatrix)
#define RelinquishMagickMemory  PrependMagickMethod(RelinquishMagickMemory)
#define RelinquishMagickResource  PrependMagickMethod(RelinquishMagickResource)
#define RelinquishSemaphoreInfo  PrependMagickMethod(RelinquishSemaphoreInfo)
#define RelinquishUniqueFileResource  PrependMagickMethod(RelinquishUniqueFileResource)
#define RelinquishVirtualMemory  PrependMagickMethod(RelinquishVirtualMemory)
#define RemapImage  PrependMagickMethod(RemapImage)
#define RemapImages  PrependMagickMethod(RemapImages)
#define RemoteDisplayCommand  PrependMagickMethod(RemoteDisplayCommand)
#define RemoveDuplicateLayers  PrependMagickMethod(RemoveDuplicateLayers)
#define RemoveElementByValueFromLinkedList  PrependMagickMethod(RemoveElementByValueFromLinkedList)
#define RemoveElementFromLinkedList  PrependMagickMethod(RemoveElementFromLinkedList)
#define RemoveEntryFromHashmap  PrependMagickMethod(RemoveEntryFromHashmap)
#define RemoveFirstImageFromList  PrependMagickMethod(RemoveFirstImageFromList)
#define RemoveImageArtifact  PrependMagickMethod(RemoveImageArtifact)
#define RemoveImageFromList  PrependMagickMethod(RemoveImageFromList)
#define RemoveImageOption  PrependMagickMethod(RemoveImageOption)
#define RemoveImageProfile  PrependMagickMethod(RemoveImageProfile)
#define RemoveImageProperty  PrependMagickMethod(RemoveImageProperty)
#define RemoveImageRegistry  PrependMagickMethod(RemoveImageRegistry)
#define RemoveLastElementFromLinkedList  PrependMagickMethod(RemoveLastElementFromLinkedList)
#define RemoveLastImageFromList  PrependMagickMethod(RemoveLastImageFromList)
#define RemoveNodeByValueFromSplayTree  PrependMagickMethod(RemoveNodeByValueFromSplayTree)
#define RemoveNodeFromSplayTree  PrependMagickMethod(RemoveNodeFromSplayTree)
#define RemoveZeroDelayLayers  PrependMagickMethod(RemoveZeroDelayLayers)
#define ReplaceImageInList  PrependMagickMethod(ReplaceImageInList)
#define ReplaceImageInListReturnLast  PrependMagickMethod(ReplaceImageInListReturnLast)
#define ResampleImage  PrependMagickMethod(ResampleImage)
#define ResamplePixelColor  PrependMagickMethod(ResamplePixelColor)
#define ResetHashmapIterator  PrependMagickMethod(ResetHashmapIterator)
#define ResetImageArtifactIterator  PrependMagickMethod(ResetImageArtifactIterator)
#define ResetImageAttributeIterator  PrependMagickMethod(ResetImageAttributeIterator)
#define ResetImageOptionIterator  PrependMagickMethod(ResetImageOptionIterator)
#define ResetImageOptions  PrependMagickMethod(ResetImageOptions)
#define ResetImagePage  PrependMagickMethod(ResetImagePage)
#define ResetImagePixels  PrependMagickMethod(ResetImagePixels)
#define ResetImageProfileIterator  PrependMagickMethod(ResetImageProfileIterator)
#define ResetImagePropertyIterator  PrependMagickMethod(ResetImagePropertyIterator)
#define ResetImageRegistryIterator  PrependMagickMethod(ResetImageRegistryIterator)
#define ResetLinkedListIterator  PrependMagickMethod(ResetLinkedListIterator)
#define ResetMagickMemory  PrependMagickMethod(ResetMagickMemory)
#define ResetMaxMemoryRequest  PrependMagickMethod(ResetMaxMemoryRequest)
#define ResetPixelCacheEpoch  PrependMagickMethod(ResetPixelCacheEpoch)
#define ResetQuantumState  PrependMagickMethod(ResetQuantumState)
#define ResetSplayTreeIterator  PrependMagickMethod(ResetSplayTreeIterator)
#define ResetSplayTree  PrependMagickMethod(ResetSplayTree)
#define ResetStringInfo  PrependMagickMethod(ResetStringInfo)
#define ResetTimer  PrependMagickMethod(ResetTimer)
#define ResetVirtualAnonymousMemory  PrependMagickMethod(ResetVirtualAnonymousMemory)
#define ResizeImage  PrependMagickMethod(ResizeImage)
#define ResizeMagickMemory  PrependMagickMethod(ResizeMagickMemory)
#define ResizeQuantumMemory  PrependMagickMethod(ResizeQuantumMemory)
#define ResourceComponentGenesis  PrependMagickMethod(ResourceComponentGenesis)
#define ResourceComponentTerminus  PrependMagickMethod(ResourceComponentTerminus)
#define ReverseImageList  PrependMagickMethod(ReverseImageList)
#define RGBTransformImage  PrependMagickMethod(RGBTransformImage)
#define RollImage  PrependMagickMethod(RollImage)
#define RotateImage  PrependMagickMethod(RotateImage)
#define RotationalBlurImageChannel  PrependMagickMethod(RotationalBlurImageChannel)
#define RotationalBlurImage  PrependMagickMethod(RotationalBlurImage)
#define SampleImage  PrependMagickMethod(SampleImage)
#define SanitizeString  PrependMagickMethod(SanitizeString)
#define ScaleGeometryKernelInfo  PrependMagickMethod(ScaleGeometryKernelInfo)
#define ScaleImage  PrependMagickMethod(ScaleImage)
#define ScaleKernelInfo  PrependMagickMethod(ScaleKernelInfo)
#define ScaleResampleFilter  PrependMagickMethod(ScaleResampleFilter)
#define SeedPseudoRandomGenerator  PrependMagickMethod(SeedPseudoRandomGenerator)
#define SeekBlob  PrependMagickMethod(SeekBlob)
#define SegmentImage  PrependMagickMethod(SegmentImage)
#define SelectiveBlurImageChannel  PrependMagickMethod(SelectiveBlurImageChannel)
#define SelectiveBlurImage  PrependMagickMethod(SelectiveBlurImage)
#define SemaphoreComponentGenesis  PrependMagickMethod(SemaphoreComponentGenesis)
#define SemaphoreComponentTerminus  PrependMagickMethod(SemaphoreComponentTerminus)
#define SeparateImageChannel  PrependMagickMethod(SeparateImageChannel)
#define SeparateImage  PrependMagickMethod(SeparateImage)
#define SeparateImages  PrependMagickMethod(SeparateImages)
#define SepiaToneImage  PrependMagickMethod(SepiaToneImage)
#define SetBlobExempt  PrependMagickMethod(SetBlobExempt)
#define SetBlobExtent  PrependMagickMethod(SetBlobExtent)
#define SetCacheThreshold  PrependMagickMethod(SetCacheThreshold)
#define SetCacheViewPixels  PrependMagickMethod(SetCacheViewPixels)
#define SetCacheViewStorageClass  PrependMagickMethod(SetCacheViewStorageClass)
#define SetCacheViewVirtualPixelMethod  PrependMagickMethod(SetCacheViewVirtualPixelMethod)
#define SetClientName  PrependMagickMethod(SetClientName)
#define SetClientPath  PrependMagickMethod(SetClientPath)
#define SetErrorHandler  PrependMagickMethod(SetErrorHandler)
#define SetExceptionInfo  PrependMagickMethod(SetExceptionInfo)
#define SetFatalErrorHandler  PrependMagickMethod(SetFatalErrorHandler)
#define SetGeometryInfo  PrependMagickMethod(SetGeometryInfo)
#define SetGeometry  PrependMagickMethod(SetGeometry)
#define SetImageAlphaChannel  PrependMagickMethod(SetImageAlphaChannel)
#define SetImageArtifact  PrependMagickMethod(SetImageArtifact)
#define SetImageAttribute  PrependMagickMethod(SetImageAttribute)
#define SetImageBackgroundColor  PrependMagickMethod(SetImageBackgroundColor)
#define SetImageChannelDepth  PrependMagickMethod(SetImageChannelDepth)
#define SetImageChannels  PrependMagickMethod(SetImageChannels)
#define SetImageClipMask  PrependMagickMethod(SetImageClipMask)
#define SetImageColor  PrependMagickMethod(SetImageColor)
#define SetImageColorspace  PrependMagickMethod(SetImageColorspace)
#define SetImageDepth  PrependMagickMethod(SetImageDepth)
#define SetImageExtent  PrependMagickMethod(SetImageExtent)
#define SetImageGray  PrependMagickMethod(SetImageGray)
#define SetImageInfoBlob  PrependMagickMethod(SetImageInfoBlob)
#define SetImageInfoFile  PrependMagickMethod(SetImageInfoFile)
#define SetImageInfo  PrependMagickMethod(SetImageInfo)
#define SetImageInfoProgressMonitor  PrependMagickMethod(SetImageInfoProgressMonitor)
#define SetImageList  PrependMagickMethod(SetImageList)
#define SetImageMask  PrependMagickMethod(SetImageMask)
#define SetImageMonochrome  PrependMagickMethod(SetImageMonochrome)
#define SetImageOpacity  PrependMagickMethod(SetImageOpacity)
#define SetImageOption  PrependMagickMethod(SetImageOption)
#define SetImagePixels  PrependMagickMethod(SetImagePixels)
#define SetImage  PrependMagickMethod(SetImage)
#define SetImageProfile  PrependMagickMethod(SetImageProfile)
#define SetImageProgressMonitor  PrependMagickMethod(SetImageProgressMonitor)
#define SetImageProgress  PrependMagickMethod(SetImageProgress)
#define SetImageProperty  PrependMagickMethod(SetImageProperty)
#define SetImageRegistry  PrependMagickMethod(SetImageRegistry)
#define SetImageStorageClass  PrependMagickMethod(SetImageStorageClass)
#define SetImageType  PrependMagickMethod(SetImageType)
#define SetImageViewDescription  PrependMagickMethod(SetImageViewDescription)
#define SetImageViewIterator  PrependMagickMethod(SetImageViewIterator)
#define SetImageViewThreads  PrependMagickMethod(SetImageViewThreads)
#define SetImageVirtualPixelMethod  PrependMagickMethod(SetImageVirtualPixelMethod)
#define SetLogEventMask  PrependMagickMethod(SetLogEventMask)
#define SetLogFormat  PrependMagickMethod(SetLogFormat)
#define SetLogMethod  PrependMagickMethod(SetLogMethod)
#define SetLogName  PrependMagickMethod(SetLogName)
#define SetMagickAlignedMemoryMethods  PrependMagickMethod(SetMagickAlignedMemoryMethods)
#define SetMagickInfo  PrependMagickMethod(SetMagickInfo)
#define SetMagickMemoryMethods  PrependMagickMethod(SetMagickMemoryMethods)
#define SetMagickOpenCLEnvParam  PrependMagickMethod(SetMagickOpenCLEnvParam)
#define SetMagickPrecision  PrependMagickMethod(SetMagickPrecision)
#define SetMagickRegistry  PrependMagickMethod(SetMagickRegistry)
#define SetMagickResourceLimit  PrependMagickMethod(SetMagickResourceLimit)
#define SetMagickSecurityPolicy  PrependMagickMethod(SetMagickSecurityPolicy)
#define SetMagickThreadValue  PrependMagickMethod(SetMagickThreadValue)
#define SetMatrixElement  PrependMagickMethod(SetMatrixElement)
#define SetMonitorHandler  PrependMagickMethod(SetMonitorHandler)
#define SetPixelCacheMethods  PrependMagickMethod(SetPixelCacheMethods)
#define SetPixelCacheVirtualMethod  PrependMagickMethod(SetPixelCacheVirtualMethod)
#define SetQuantumAlphaType  PrependMagickMethod(SetQuantumAlphaType)
#define SetQuantumDepth  PrependMagickMethod(SetQuantumDepth)
#define SetQuantumEndian  PrependMagickMethod(SetQuantumEndian)
#define SetQuantumFormat  PrependMagickMethod(SetQuantumFormat)
#define SetQuantumImageType  PrependMagickMethod(SetQuantumImageType)
#define SetQuantumMinIsWhite  PrependMagickMethod(SetQuantumMinIsWhite)
#define SetQuantumPack  PrependMagickMethod(SetQuantumPack)
#define SetQuantumPad  PrependMagickMethod(SetQuantumPad)
#define SetQuantumQuantum  PrependMagickMethod(SetQuantumQuantum)
#define SetQuantumScale  PrependMagickMethod(SetQuantumScale)
#define SetRandomKey  PrependMagickMethod(SetRandomKey)
#define SetRandomSecretKey  PrependMagickMethod(SetRandomSecretKey)
#define SetRandomTrueRandom  PrependMagickMethod(SetRandomTrueRandom)
#define SetResampleFilterInterpolateMethod  PrependMagickMethod(SetResampleFilterInterpolateMethod)
#define SetResampleFilter  PrependMagickMethod(SetResampleFilter)
#define SetResampleFilterVirtualPixelMethod  PrependMagickMethod(SetResampleFilterVirtualPixelMethod)
#define SetSignatureDigest  PrependMagickMethod(SetSignatureDigest)
#define SetStreamInfoClientData  PrependMagickMethod(SetStreamInfoClientData)
#define SetStreamInfoMap  PrependMagickMethod(SetStreamInfoMap)
#define SetStreamInfoStorageType  PrependMagickMethod(SetStreamInfoStorageType)
#define SetStringInfoDatum  PrependMagickMethod(SetStringInfoDatum)
#define SetStringInfoLength  PrependMagickMethod(SetStringInfoLength)
#define SetStringInfoName  PrependMagickMethod(SetStringInfoName)
#define SetStringInfoPath  PrependMagickMethod(SetStringInfoPath)
#define SetStringInfo  PrependMagickMethod(SetStringInfo)
#define SetWarningHandler  PrependMagickMethod(SetWarningHandler)
#define SetXMLTreeAttribute  PrependMagickMethod(SetXMLTreeAttribute)
#define SetXMLTreeContent  PrependMagickMethod(SetXMLTreeContent)
#define ShadeImage  PrependMagickMethod(ShadeImage)
#define ShadowImage  PrependMagickMethod(ShadowImage)
#define SharpenImageChannel  PrependMagickMethod(SharpenImageChannel)
#define SharpenImage  PrependMagickMethod(SharpenImage)
#define ShaveImage  PrependMagickMethod(ShaveImage)
#define ShearImage  PrependMagickMethod(ShearImage)
#define ShearRotateImage  PrependMagickMethod(ShearRotateImage)
#define ShiftImageList  PrependMagickMethod(ShiftImageList)
#define ShowKernelInfo  PrependMagickMethod(ShowKernelInfo)
#define ShredFile  PrependMagickMethod(ShredFile)
#define SigmoidalContrastImageChannel  PrependMagickMethod(SigmoidalContrastImageChannel)
#define SigmoidalContrastImage  PrependMagickMethod(SigmoidalContrastImage)
#define SignatureImage  PrependMagickMethod(SignatureImage)
#define SimilarityImage  PrependMagickMethod(SimilarityImage)
#define SimilarityMetricImage  PrependMagickMethod(SimilarityMetricImage)
#define sixel_decode  PrependMagickMethod(sixel_decode)
#define sixel_output_create  PrependMagickMethod(sixel_output_create)
#define SizeBlob  PrependMagickMethod(SizeBlob)
#define SketchImage  PrependMagickMethod(SketchImage)
#define SmushImages  PrependMagickMethod(SmushImages)
#define SolarizeImageChannel  PrependMagickMethod(SolarizeImageChannel)
#define SolarizeImage  PrependMagickMethod(SolarizeImage)
#define SortColormapByIntensity  PrependMagickMethod(SortColormapByIntensity)
#define SparseColorImage  PrependMagickMethod(SparseColorImage)
#define SpliceImageIntoList  PrependMagickMethod(SpliceImageIntoList)
#define SpliceImageList  PrependMagickMethod(SpliceImageList)
#define SpliceImage  PrependMagickMethod(SpliceImage)
#define SplitImageList  PrependMagickMethod(SplitImageList)
#define SplitStringInfo  PrependMagickMethod(SplitStringInfo)
#define SpreadImage  PrependMagickMethod(SpreadImage)
#define sRGBCompandor  PrependMagickMethod(sRGBCompandor)
#define StartTimer  PrependMagickMethod(StartTimer)
#define StatisticImageChannel  PrependMagickMethod(StatisticImageChannel)
#define StatisticImage  PrependMagickMethod(StatisticImage)
#define SteganoImage  PrependMagickMethod(SteganoImage)
#define StereoAnaglyphImage  PrependMagickMethod(StereoAnaglyphImage)
#define StereoImage  PrependMagickMethod(StereoImage)
#define StreamImage  PrependMagickMethod(StreamImage)
#define StringInfoToHexString  PrependMagickMethod(StringInfoToHexString)
#define StringInfoToString  PrependMagickMethod(StringInfoToString)
#define StringToArgv  PrependMagickMethod(StringToArgv)
#define StringToArrayOfDoubles  PrependMagickMethod(StringToArrayOfDoubles)
#define StringToken  PrependMagickMethod(StringToken)
#define StringToList  PrependMagickMethod(StringToList)
#define StringToStringInfo  PrependMagickMethod(StringToStringInfo)
#define StringToStrings  PrependMagickMethod(StringToStrings)
#define StripImage  PrependMagickMethod(StripImage)
#define Strip  PrependMagickMethod(Strip)
#define StripString  PrependMagickMethod(StripString)
#define SubstituteString  PrependMagickMethod(SubstituteString)
#define SwirlImage  PrependMagickMethod(SwirlImage)
#define SyncAuthenticPixelCacheNexus  PrependMagickMethod(SyncAuthenticPixelCacheNexus)
#define SyncAuthenticPixels  PrependMagickMethod(SyncAuthenticPixels)
#define SyncCacheViewAuthenticPixels  PrependMagickMethod(SyncCacheViewAuthenticPixels)
#define SyncCacheViewPixels  PrependMagickMethod(SyncCacheViewPixels)
#define SyncCacheView  PrependMagickMethod(SyncCacheView)
#define SyncImageList  PrependMagickMethod(SyncImageList)
#define SyncImagePixelCache  PrependMagickMethod(SyncImagePixelCache)
#define SyncImagePixels  PrependMagickMethod(SyncImagePixels)
#define SyncImage  PrependMagickMethod(SyncImage)
#define SyncImageProfiles  PrependMagickMethod(SyncImageProfiles)
#define SyncImageSettings  PrependMagickMethod(SyncImageSettings)
#define SyncImagesSettings  PrependMagickMethod(SyncImagesSettings)
#define SyncNextImageInList  PrependMagickMethod(SyncNextImageInList)
#define SystemCommand  PrependMagickMethod(SystemCommand)
#define TellBlob  PrependMagickMethod(TellBlob)
#define TemporaryFilename  PrependMagickMethod(TemporaryFilename)
#define TextureImage  PrependMagickMethod(TextureImage)
#define ThresholdImageChannel  PrependMagickMethod(ThresholdImageChannel)
#define ThresholdImage  PrependMagickMethod(ThresholdImage)
#define ThrowMagickExceptionList  PrependMagickMethod(ThrowMagickExceptionList)
#define ThrowMagickException  PrependMagickMethod(ThrowMagickException)
#define ThumbnailImage  PrependMagickMethod(ThumbnailImage)
#define TintImage  PrependMagickMethod(TintImage)
#define Tokenizer  PrependMagickMethod(Tokenizer)
#define TransferImageViewIterator  PrependMagickMethod(TransferImageViewIterator)
#define TransformColorspace  PrependMagickMethod(TransformColorspace)
#define TransformHSL  PrependMagickMethod(TransformHSL)
#define TransformImageColorspace  PrependMagickMethod(TransformImageColorspace)
#define TransformImage  PrependMagickMethod(TransformImage)
#define TransformImages  PrependMagickMethod(TransformImages)
#define TransformRGBImage  PrependMagickMethod(TransformRGBImage)
#define TranslateText  PrependMagickMethod(TranslateText)
#define TransparentImage  PrependMagickMethod(TransparentImage)
#define TransparentPaintImageChroma  PrependMagickMethod(TransparentPaintImageChroma)
#define TransparentPaintImage  PrependMagickMethod(TransparentPaintImage)
#define TransposeImage  PrependMagickMethod(TransposeImage)
#define TransverseImage  PrependMagickMethod(TransverseImage)
#define TrimImage  PrependMagickMethod(TrimImage)
#define TypeComponentGenesis  PrependMagickMethod(TypeComponentGenesis)
#define TypeComponentTerminus  PrependMagickMethod(TypeComponentTerminus)
#define UniqueImageColors  PrependMagickMethod(UniqueImageColors)
#define UnityAddKernelInfo  PrependMagickMethod(UnityAddKernelInfo)
#define UnlockSemaphoreInfo  PrependMagickMethod(UnlockSemaphoreInfo)
#define UnmapBlob  PrependMagickMethod(UnmapBlob)
#define UnregisterAAIImage  PrependMagickMethod(UnregisterAAIImage)
#define UnregisterARTImage  PrependMagickMethod(UnregisterARTImage)
#define UnregisterAVSImage  PrependMagickMethod(UnregisterAVSImage)
#define UnregisterBGRImage  PrependMagickMethod(UnregisterBGRImage)
#define UnregisterBMPImage  PrependMagickMethod(UnregisterBMPImage)
#define UnregisterBRAILLEImage  PrependMagickMethod(UnregisterBRAILLEImage)
#define UnregisterCALSImage  PrependMagickMethod(UnregisterCALSImage)
#define UnregisterCAPTIONImage  PrependMagickMethod(UnregisterCAPTIONImage)
#define UnregisterCINImage  PrependMagickMethod(UnregisterCINImage)
#define UnregisterCIPImage  PrependMagickMethod(UnregisterCIPImage)
#define UnregisterCLIPImage  PrependMagickMethod(UnregisterCLIPImage)
#define UnregisterCMYKImage  PrependMagickMethod(UnregisterCMYKImage)
#define UnregisterCUTImage  PrependMagickMethod(UnregisterCUTImage)
#define UnregisterDCMImage  PrependMagickMethod(UnregisterDCMImage)
#define UnregisterDDSImage  PrependMagickMethod(UnregisterDDSImage)
#define UnregisterDEBUGImage  PrependMagickMethod(UnregisterDEBUGImage)
#define UnregisterDIBImage  PrependMagickMethod(UnregisterDIBImage)
#define UnregisterDJVUImage  PrependMagickMethod(UnregisterDJVUImage)
#define UnregisterDNGImage  PrependMagickMethod(UnregisterDNGImage)
#define UnregisterDOTImage  PrependMagickMethod(UnregisterDOTImage)
#define UnregisterDPXImage  PrependMagickMethod(UnregisterDPXImage)
#define UnregisterEPTImage  PrependMagickMethod(UnregisterEPTImage)
#define UnregisterEXRImage  PrependMagickMethod(UnregisterEXRImage)
#define UnregisterFAXImage  PrependMagickMethod(UnregisterFAXImage)
#define UnregisterFITSImage  PrependMagickMethod(UnregisterFITSImage)
#define UnregisterGIFImage  PrependMagickMethod(UnregisterGIFImage)
#define UnregisterGRADIENTImage  PrependMagickMethod(UnregisterGRADIENTImage)
#define UnregisterGRAYImage  PrependMagickMethod(UnregisterGRAYImage)
#define UnregisterHALDImage  PrependMagickMethod(UnregisterHALDImage)
#define UnregisterHDRImage  PrependMagickMethod(UnregisterHDRImage)
#define UnregisterHEICImage  PrependMagickMethod(UnregisterHEICImage)
#define UnregisterHISTOGRAMImage  PrependMagickMethod(UnregisterHISTOGRAMImage)
#define UnregisterHRZImage  PrependMagickMethod(UnregisterHRZImage)
#define UnregisterHTMLImage  PrependMagickMethod(UnregisterHTMLImage)
#define UnregisterICONImage  PrependMagickMethod(UnregisterICONImage)
#define UnregisterINFOImage  PrependMagickMethod(UnregisterINFOImage)
#define UnregisterINLINEImage  PrependMagickMethod(UnregisterINLINEImage)
#define UnregisterIPLImage  PrependMagickMethod(UnregisterIPLImage)
#define UnregisterJBIGImage  PrependMagickMethod(UnregisterJBIGImage)
#define UnregisterJNXImage  PrependMagickMethod(UnregisterJNXImage)
#define UnregisterJP2Image  PrependMagickMethod(UnregisterJP2Image)
#define UnregisterJPEGImage  PrependMagickMethod(UnregisterJPEGImage)
#define UnregisterJSONImage  PrependMagickMethod(UnregisterJSONImage)
#define UnregisterLABELImage  PrependMagickMethod(UnregisterLABELImage)
#define UnregisterMACImage  PrependMagickMethod(UnregisterMACImage)
#define UnregisterMAGICKImage  PrependMagickMethod(UnregisterMAGICKImage)
#define UnregisterMagickInfo  PrependMagickMethod(UnregisterMagickInfo)
#define UnregisterMAPImage  PrependMagickMethod(UnregisterMAPImage)
#define UnregisterMASKImage  PrependMagickMethod(UnregisterMASKImage)
#define UnregisterMATImage  PrependMagickMethod(UnregisterMATImage)
#define UnregisterMATTEImage  PrependMagickMethod(UnregisterMATTEImage)
#define UnregisterMETAImage  PrependMagickMethod(UnregisterMETAImage)
#define UnregisterMIFFImage  PrependMagickMethod(UnregisterMIFFImage)
#define UnregisterMONOImage  PrependMagickMethod(UnregisterMONOImage)
#define UnregisterMPCImage  PrependMagickMethod(UnregisterMPCImage)
#define UnregisterMPRImage  PrependMagickMethod(UnregisterMPRImage)
#define UnregisterMSLImage  PrependMagickMethod(UnregisterMSLImage)
#define UnregisterMTVImage  PrependMagickMethod(UnregisterMTVImage)
#define UnregisterMVGImage  PrependMagickMethod(UnregisterMVGImage)
#define UnregisterNULLImage  PrependMagickMethod(UnregisterNULLImage)
#define UnregisterOTBImage  PrependMagickMethod(UnregisterOTBImage)
#define UnregisterPALMImage  PrependMagickMethod(UnregisterPALMImage)
#define UnregisterPANGOImage  PrependMagickMethod(UnregisterPANGOImage)
#define UnregisterPATTERNImage  PrependMagickMethod(UnregisterPATTERNImage)
#define UnregisterPCDImage  PrependMagickMethod(UnregisterPCDImage)
#define UnregisterPCLImage  PrependMagickMethod(UnregisterPCLImage)
#define UnregisterPCXImage  PrependMagickMethod(UnregisterPCXImage)
#define UnregisterPDBImage  PrependMagickMethod(UnregisterPDBImage)
#define UnregisterPDFImage  PrependMagickMethod(UnregisterPDFImage)
#define UnregisterPESImage  PrependMagickMethod(UnregisterPESImage)
#define UnregisterPGXImage  PrependMagickMethod(UnregisterPGXImage)
#define UnregisterPICTImage  PrependMagickMethod(UnregisterPICTImage)
#define UnregisterPIXImage  PrependMagickMethod(UnregisterPIXImage)
#define UnregisterPLASMAImage  PrependMagickMethod(UnregisterPLASMAImage)
#define UnregisterPNGImage  PrependMagickMethod(UnregisterPNGImage)
#define UnregisterPNMImage  PrependMagickMethod(UnregisterPNMImage)
#define UnregisterPREVIEWImage  PrependMagickMethod(UnregisterPREVIEWImage)
#define UnregisterPS2Image  PrependMagickMethod(UnregisterPS2Image)
#define UnregisterPS3Image  PrependMagickMethod(UnregisterPS3Image)
#define UnregisterPSDImage  PrependMagickMethod(UnregisterPSDImage)
#define UnregisterPSImage  PrependMagickMethod(UnregisterPSImage)
#define UnregisterPWPImage  PrependMagickMethod(UnregisterPWPImage)
#define UnregisterRAWImage  PrependMagickMethod(UnregisterRAWImage)
#define UnregisterRGBImage  PrependMagickMethod(UnregisterRGBImage)
#define UnregisterRGFImage  PrependMagickMethod(UnregisterRGFImage)
#define UnregisterRLAImage  PrependMagickMethod(UnregisterRLAImage)
#define UnregisterRLEImage  PrependMagickMethod(UnregisterRLEImage)
#define UnregisterSCREENSHOTImage  PrependMagickMethod(UnregisterSCREENSHOTImage)
#define UnregisterSCRImage  PrependMagickMethod(UnregisterSCRImage)
#define UnregisterSCTImage  PrependMagickMethod(UnregisterSCTImage)
#define UnregisterSFWImage  PrependMagickMethod(UnregisterSFWImage)
#define UnregisterSGIImage  PrependMagickMethod(UnregisterSGIImage)
#define UnregisterSIXELImage  PrependMagickMethod(UnregisterSIXELImage)
#define UnregisterStaticModule  PrependMagickMethod(UnregisterStaticModule)
#define UnregisterStaticModules  PrependMagickMethod(UnregisterStaticModules)
#define UnregisterSTEGANOImage  PrependMagickMethod(UnregisterSTEGANOImage)
#define UnregisterSUNImage  PrependMagickMethod(UnregisterSUNImage)
#define UnregisterSVGImage  PrependMagickMethod(UnregisterSVGImage)
#define UnregisterTGAImage  PrependMagickMethod(UnregisterTGAImage)
#define UnregisterTHUMBNAILImage  PrependMagickMethod(UnregisterTHUMBNAILImage)
#define UnregisterTIFFImage  PrependMagickMethod(UnregisterTIFFImage)
#define UnregisterTILEImage  PrependMagickMethod(UnregisterTILEImage)
#define UnregisterTIMImage  PrependMagickMethod(UnregisterTIMImage)
#define UnregisterTTFImage  PrependMagickMethod(UnregisterTTFImage)
#define UnregisterTXTImage  PrependMagickMethod(UnregisterTXTImage)
#define UnregisterUILImage  PrependMagickMethod(UnregisterUILImage)
#define UnregisterUndefinedImage  PrependMagickMethod(UnregisterUndefinedImage)
#define UnregisterURLImage  PrependMagickMethod(UnregisterURLImage)
#define UnregisterUYVYImage  PrependMagickMethod(UnregisterUYVYImage)
#define UnregisterVICARImage  PrependMagickMethod(UnregisterVICARImage)
#define UnregisterVIDImage  PrependMagickMethod(UnregisterVIDImage)
#define UnregisterVIFFImage  PrependMagickMethod(UnregisterVIFFImage)
#define UnregisterVIPSImage  PrependMagickMethod(UnregisterVIPSImage)
#define UnregisterWBMPImage  PrependMagickMethod(UnregisterWBMPImage)
#define UnregisterWEBPImage  PrependMagickMethod(UnregisterWEBPImage)
#define UnregisterWMFImage  PrependMagickMethod(UnregisterWMFImage)
#define UnregisterWPGImage  PrependMagickMethod(UnregisterWPGImage)
#define UnregisterXBMImage  PrependMagickMethod(UnregisterXBMImage)
#define UnregisterXCFImage  PrependMagickMethod(UnregisterXCFImage)
#define UnregisterXCImage  PrependMagickMethod(UnregisterXCImage)
#define UnregisterXImage  PrependMagickMethod(UnregisterXImage)
#define UnregisterXPMImage  PrependMagickMethod(UnregisterXPMImage)
#define UnregisterXPSImage  PrependMagickMethod(UnregisterXPSImage)
#define UnregisterXWDImage  PrependMagickMethod(UnregisterXWDImage)
#define UnregisterYCBCRImage  PrependMagickMethod(UnregisterYCBCRImage)
#define UnregisterYUVImage  PrependMagickMethod(UnregisterYUVImage)
#define UnsharpMaskImageChannel  PrependMagickMethod(UnsharpMaskImageChannel)
#define UnsharpMaskImage  PrependMagickMethod(UnsharpMaskImage)
#define UnshiftImageList  PrependMagickMethod(UnshiftImageList)
#define UpdateImageViewIterator  PrependMagickMethod(UpdateImageViewIterator)
#define UpdateSignature  PrependMagickMethod(UpdateSignature)
#define ValidateColormapIndex  PrependMagickMethod(ValidateColormapIndex)
#define VignetteImage  PrependMagickMethod(VignetteImage)
#define WaveImage  PrependMagickMethod(WaveImage)
#define WaveletDenoiseImage  PrependMagickMethod(WaveletDenoiseImage)
#define WhiteThresholdImageChannel  PrependMagickMethod(WhiteThresholdImageChannel)
#define WhiteThresholdImage  PrependMagickMethod(WhiteThresholdImage)
#define WriteBlobByte  PrependMagickMethod(WriteBlobByte)
#define WriteBlobFloat  PrependMagickMethod(WriteBlobFloat)
#define WriteBlobLong  PrependMagickMethod(WriteBlobLong)
#define WriteBlobLSBLong  PrependMagickMethod(WriteBlobLSBLong)
#define WriteBlobLSBShort  PrependMagickMethod(WriteBlobLSBShort)
#define WriteBlobLSBSignedLong  PrependMagickMethod(WriteBlobLSBSignedLong)
#define WriteBlobLSBSignedShort  PrependMagickMethod(WriteBlobLSBSignedShort)
#define WriteBlobMSBLongLong  PrependMagickMethod(WriteBlobMSBLongLong)
#define WriteBlobMSBLong  PrependMagickMethod(WriteBlobMSBLong)
#define WriteBlobMSBShort  PrependMagickMethod(WriteBlobMSBShort)
#define WriteBlobMSBSignedLong  PrependMagickMethod(WriteBlobMSBSignedLong)
#define WriteBlobMSBSignedShort  PrependMagickMethod(WriteBlobMSBSignedShort)
#define WriteBlob  PrependMagickMethod(WriteBlob)
#define WriteBlobShort  PrependMagickMethod(WriteBlobShort)
#define WriteBlobString  PrependMagickMethod(WriteBlobString)
#define WriteDistributePixelCacheIndexes  PrependMagickMethod(WriteDistributePixelCacheIndexes)
#define WriteDistributePixelCachePixels  PrependMagickMethod(WriteDistributePixelCachePixels)
#define WriteImage  PrependMagickMethod(WriteImage)
#define WriteImages  PrependMagickMethod(WriteImages)
#define WriteStream  PrependMagickMethod(WriteStream)
#define XAnimateBackgroundImage  PrependMagickMethod(XAnimateBackgroundImage)
#define XAnimateImages  PrependMagickMethod(XAnimateImages)
#define XAnnotateImage  PrependMagickMethod(XAnnotateImage)
#define XBestFont  PrependMagickMethod(XBestFont)
#define XBestIconSize  PrependMagickMethod(XBestIconSize)
#define XBestPixel  PrependMagickMethod(XBestPixel)
#define XBestVisualInfo  PrependMagickMethod(XBestVisualInfo)
#define XCheckDefineCursor  PrependMagickMethod(XCheckDefineCursor)
#define XCheckRefreshWindows  PrependMagickMethod(XCheckRefreshWindows)
#define XClientMessage  PrependMagickMethod(XClientMessage)
#define XColorBrowserWidget  PrependMagickMethod(XColorBrowserWidget)
#define XCommandWidget  PrependMagickMethod(XCommandWidget)
#define XComponentGenesis  PrependMagickMethod(XComponentGenesis)
#define XComponentTerminus  PrependMagickMethod(XComponentTerminus)
#define XConfigureImageColormap  PrependMagickMethod(XConfigureImageColormap)
#define XConfirmWidget  PrependMagickMethod(XConfirmWidget)
#define XConstrainWindowPosition  PrependMagickMethod(XConstrainWindowPosition)
#define XDelay  PrependMagickMethod(XDelay)
#define XDestroyResourceInfo  PrependMagickMethod(XDestroyResourceInfo)
#define XDestroyWindowColors  PrependMagickMethod(XDestroyWindowColors)
#define XDialogWidget  PrependMagickMethod(XDialogWidget)
#define XDisplayBackgroundImage  PrependMagickMethod(XDisplayBackgroundImage)
#define XDisplayImageInfo  PrependMagickMethod(XDisplayImageInfo)
#define XDisplayImage  PrependMagickMethod(XDisplayImage)
#define XDrawImage  PrependMagickMethod(XDrawImage)
#define XError  PrependMagickMethod(XError)
#define XFileBrowserWidget  PrependMagickMethod(XFileBrowserWidget)
#define XFontBrowserWidget  PrependMagickMethod(XFontBrowserWidget)
#define XFreeResources  PrependMagickMethod(XFreeResources)
#define XFreeStandardColormap  PrependMagickMethod(XFreeStandardColormap)
#define XGetAnnotateInfo  PrependMagickMethod(XGetAnnotateInfo)
#define XGetImportInfo  PrependMagickMethod(XGetImportInfo)
#define XGetMapInfo  PrependMagickMethod(XGetMapInfo)
#define XGetPixelPacket  PrependMagickMethod(XGetPixelPacket)
#define XGetResourceClass  PrependMagickMethod(XGetResourceClass)
#define XGetResourceDatabase  PrependMagickMethod(XGetResourceDatabase)
#define XGetResourceInfo  PrependMagickMethod(XGetResourceInfo)
#define XGetResourceInstance  PrependMagickMethod(XGetResourceInstance)
#define XGetScreenDensity  PrependMagickMethod(XGetScreenDensity)
#define XGetWindowColor  PrependMagickMethod(XGetWindowColor)
#define XGetWindowInfo  PrependMagickMethod(XGetWindowInfo)
#define XHighlightEllipse  PrependMagickMethod(XHighlightEllipse)
#define XHighlightLine  PrependMagickMethod(XHighlightLine)
#define XHighlightRectangle  PrependMagickMethod(XHighlightRectangle)
#define XImportImage  PrependMagickMethod(XImportImage)
#define XInfoWidget  PrependMagickMethod(XInfoWidget)
#define XInitializeWindows  PrependMagickMethod(XInitializeWindows)
#define XListBrowserWidget  PrependMagickMethod(XListBrowserWidget)
#define XMagickProgressMonitor  PrependMagickMethod(XMagickProgressMonitor)
#define XMakeCursor  PrependMagickMethod(XMakeCursor)
#define XMakeImage  PrependMagickMethod(XMakeImage)
#define XMakeMagnifyImage  PrependMagickMethod(XMakeMagnifyImage)
#define XMakeStandardColormap  PrependMagickMethod(XMakeStandardColormap)
#define XMakeWindow  PrependMagickMethod(XMakeWindow)
#define XMenuWidget  PrependMagickMethod(XMenuWidget)
#define XMLTreeInfoToXML  PrependMagickMethod(XMLTreeInfoToXML)
#define XNoticeWidget  PrependMagickMethod(XNoticeWidget)
#define XPreferencesWidget  PrependMagickMethod(XPreferencesWidget)
#define XProgressMonitorWidget  PrependMagickMethod(XProgressMonitorWidget)
#define XQueryColorDatabase  PrependMagickMethod(XQueryColorDatabase)
#define XQueryPosition  PrependMagickMethod(XQueryPosition)
#define XRefreshWindow  PrependMagickMethod(XRefreshWindow)
#define XRemoteCommand  PrependMagickMethod(XRemoteCommand)
#define XRenderImage  PrependMagickMethod(XRenderImage)
#define XRetainWindowColors  PrependMagickMethod(XRetainWindowColors)
#define XSetCursorState  PrependMagickMethod(XSetCursorState)
#define XSetWindows  PrependMagickMethod(XSetWindows)
#define XTextViewWidget  PrependMagickMethod(XTextViewWidget)
#define XUserPreferences  PrependMagickMethod(XUserPreferences)
#define XWarning  PrependMagickMethod(XWarning)
#define XWindowByID  PrependMagickMethod(XWindowByID)
#define XWindowByName  PrependMagickMethod(XWindowByName)
#define XWindowByProperty  PrependMagickMethod(XWindowByProperty)
#define ZeroKernelNans  PrependMagickMethod(ZeroKernelNans)
#define ZLIBEncodeImage  PrependMagickMethod(ZLIBEncodeImage)
#define ZoomImage  PrependMagickMethod(ZoomImage)
#endif

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
