"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getDataStreams = getDataStreams;
exports.getIndexToDataStreamMapping = getIndexToDataStreamMapping;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class DataStreamService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getDataStreams", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const client = this.osDriver.asScoped(request);
        const [dataStreams, apiAccessible, errMsg] = await getDataStreams(client, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              dataStreams: dataStreams,
              totalDataStreams: dataStreams.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - DataStreamService - getDataStreams:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }

}

exports.default = DataStreamService;

async function getDataStreams({
  callAsCurrentUser: callWithRequest
}, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const dataStreamsResponse = await callWithRequest("transport.request", {
    path: `/_data_stream/${searchPattern}`,
    method: "GET"
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        data_streams: []
      };
    }

    throw e;
  });
  return [dataStreamsResponse["data_streams"], accessible, errMsg];
}

async function getIndexToDataStreamMapping({
  callAsCurrentUser: callWithRequest
}) {
  const [dataStreams] = await getDataStreams({
    callAsCurrentUser: callWithRequest
  });
  const mapping = {};
  dataStreams.forEach(dataStream => {
    dataStream.indices.forEach(index => {
      mapping[index.index_name] = dataStream.name;
    });
  });
  return mapping;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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