/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.resource.cached.CachedItem;
import org.gradle.internal.serialize.Serializer;

public abstract class AbstractCachedIndex<K, V extends CachedItem> {
    private final String persistentCacheName;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final ArtifactCacheLockingManager artifactCacheLockingManager;
    private final FileAccessTracker fileAccessTracker;
    private PersistentIndexedCache<K, V> persistentCache;

    public AbstractCachedIndex(String persistentCacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer, ArtifactCacheLockingManager artifactCacheLockingManager, FileAccessTracker fileAccessTracker) {
        this.persistentCacheName = persistentCacheName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.artifactCacheLockingManager = artifactCacheLockingManager;
        this.fileAccessTracker = fileAccessTracker;
    }

    private PersistentIndexedCache<K, V> getPersistentCache() {
        if (this.persistentCache == null) {
            this.persistentCache = this.initPersistentCache();
        }
        return this.persistentCache;
    }

    private PersistentIndexedCache<K, V> initPersistentCache() {
        return this.artifactCacheLockingManager.createCache(this.persistentCacheName, this.keySerializer, this.valueSerializer);
    }

    public V lookup(K key) {
        this.assertKeyNotNull(key);
        CachedItem result = (CachedItem)this.artifactCacheLockingManager.useCache(() -> {
            CachedItem found = (CachedItem)this.getPersistentCache().get(key);
            if (found == null) {
                return null;
            }
            if (found.isMissing() || found.getCachedFile().exists()) {
                return found;
            }
            this.clear(key);
            return null;
        });
        if (result != null && result.getCachedFile() != null) {
            this.fileAccessTracker.markAccessed(result.getCachedFile());
        }
        return (V)result;
    }

    protected void storeInternal(K key, V entry) {
        this.artifactCacheLockingManager.useCache(() -> this.getPersistentCache().put(key, (Object)entry));
    }

    protected void assertKeyNotNull(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
    }

    protected void assertArtifactFileNotNull(File artifactFile) {
        if (artifactFile == null) {
            throw new IllegalArgumentException("artifactFile cannot be null");
        }
    }

    public void clear(K key) {
        this.assertKeyNotNull(key);
        this.artifactCacheLockingManager.useCache(() -> this.getPersistentCache().remove(key));
    }
}

