/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

public class SingleProjectTaskReportModel
implements TaskReportModel {
    private final SetMultimap<String, TaskDetails> groups = TreeMultimap.create(String::compareToIgnoreCase, Comparator.comparing(TaskDetails::getPath));
    private final TaskDetailsFactory factory;

    public SingleProjectTaskReportModel(TaskDetailsFactory factory) {
        this.factory = factory;
    }

    public void build(Collection<? extends Task> tasks) {
        for (Task task : tasks) {
            String group = GUtil.isTrue((Object)task.getGroup()) ? task.getGroup() : "";
            this.groups.put((Object)group, (Object)new TaskDetailsImpl(task, this.factory.create(task)));
        }
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        if (!this.groups.containsKey((Object)group)) {
            throw new IllegalArgumentException(String.format("Unknown group '%s'", group));
        }
        return this.groups.get((Object)group);
    }

    private static class TaskDetailsImpl
    implements TaskDetails {
        private final Task task;
        private final TaskDetails details;

        public TaskDetailsImpl(Task task, TaskDetails details) {
            this.task = task;
            this.details = details;
        }

        @Override
        public Path getPath() {
            return this.details.getPath();
        }

        @Override
        public String getDescription() {
            return this.details.getDescription();
        }

        public String toString() {
            return this.task.toString();
        }

        public Task getTask() {
            return this.task;
        }
    }
}

